package software.amazon.awscdk.services.cleanrooms;

/**
 * Provides information to create the ID namespace association.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnIdNamespaceAssociation cfnIdNamespaceAssociation = CfnIdNamespaceAssociation.Builder.create(this, "MyCfnIdNamespaceAssociation")
 *         .inputReferenceConfig(IdNamespaceAssociationInputReferenceConfigProperty.builder()
 *                 .inputReferenceArn("inputReferenceArn")
 *                 .manageResourcePolicies(false)
 *                 .build())
 *         .membershipIdentifier("membershipIdentifier")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .idMappingConfig(IdMappingConfigProperty.builder()
 *                 .allowUseAsDimensionColumn(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:13.891Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation")
public class CfnIdNamespaceAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnIdNamespaceAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdNamespaceAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdNamespaceAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCollaborationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCollaborationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the collaboration that contains this ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCollaborationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrCollaborationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the ID namespace association that you want to retrieve.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdNamespaceAssociationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrIdNamespaceAssociationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrInputReferenceProperties() {
        return software.amazon.jsii.Kernel.get(this, "attrInputReferenceProperties", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMembershipArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMembershipArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The input reference configuration for the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputReferenceConfig() {
        return software.amazon.jsii.Kernel.get(this, "inputReferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The input reference configuration for the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputReferenceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputReferenceConfig", java.util.Objects.requireNonNull(value, "inputReferenceConfig is required"));
    }

    /**
     * The input reference configuration for the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputReferenceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation.IdNamespaceAssociationInputReferenceConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputReferenceConfig", java.util.Objects.requireNonNull(value, "inputReferenceConfig is required"));
    }

    /**
     * The unique identifier of the membership that contains the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the membership that contains the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMembershipIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "membershipIdentifier", java.util.Objects.requireNonNull(value, "membershipIdentifier is required"));
    }

    /**
     * The name of this ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The description of the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the ID namespace association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The configuration settings for the ID mapping table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdMappingConfig() {
        return software.amazon.jsii.Kernel.get(this, "idMappingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for the ID mapping table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "idMappingConfig", value);
    }

    /**
     * The configuration settings for the ID mapping table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation.IdMappingConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "idMappingConfig", value);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The configuration settings for the ID mapping table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * IdMappingConfigProperty idMappingConfigProperty = IdMappingConfigProperty.builder()
     *         .allowUseAsDimensionColumn(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idmappingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idmappingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation.IdMappingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IdMappingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdMappingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An indicator as to whether you can use your column as a dimension column in the ID mapping table ( <code>TRUE</code> ) or not ( <code>FALSE</code> ).
         * <p>
         * Default is <code>FALSE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idmappingconfig.html#cfn-cleanrooms-idnamespaceassociation-idmappingconfig-allowuseasdimensioncolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idmappingconfig.html#cfn-cleanrooms-idnamespaceassociation-idmappingconfig-allowuseasdimensioncolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowUseAsDimensionColumn();

        /**
         * @return a {@link Builder} of {@link IdMappingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdMappingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdMappingConfigProperty> {
            java.lang.Object allowUseAsDimensionColumn;

            /**
             * Sets the value of {@link IdMappingConfigProperty#getAllowUseAsDimensionColumn}
             * @param allowUseAsDimensionColumn An indicator as to whether you can use your column as a dimension column in the ID mapping table ( <code>TRUE</code> ) or not ( <code>FALSE</code> ). This parameter is required.
             *                                  Default is <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowUseAsDimensionColumn(java.lang.Boolean allowUseAsDimensionColumn) {
                this.allowUseAsDimensionColumn = allowUseAsDimensionColumn;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingConfigProperty#getAllowUseAsDimensionColumn}
             * @param allowUseAsDimensionColumn An indicator as to whether you can use your column as a dimension column in the ID mapping table ( <code>TRUE</code> ) or not ( <code>FALSE</code> ). This parameter is required.
             *                                  Default is <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowUseAsDimensionColumn(software.amazon.awscdk.IResolvable allowUseAsDimensionColumn) {
                this.allowUseAsDimensionColumn = allowUseAsDimensionColumn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdMappingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdMappingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdMappingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingConfigProperty {
            private final java.lang.Object allowUseAsDimensionColumn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowUseAsDimensionColumn = software.amazon.jsii.Kernel.get(this, "allowUseAsDimensionColumn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowUseAsDimensionColumn = java.util.Objects.requireNonNull(builder.allowUseAsDimensionColumn, "allowUseAsDimensionColumn is required");
            }

            @Override
            public final java.lang.Object getAllowUseAsDimensionColumn() {
                return this.allowUseAsDimensionColumn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowUseAsDimensionColumn", om.valueToTree(this.getAllowUseAsDimensionColumn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation.IdMappingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdMappingConfigProperty.Jsii$Proxy that = (IdMappingConfigProperty.Jsii$Proxy) o;

                return this.allowUseAsDimensionColumn.equals(that.allowUseAsDimensionColumn);
            }

            @Override
            public final int hashCode() {
                int result = this.allowUseAsDimensionColumn.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides the information for the ID namespace association input reference configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * IdNamespaceAssociationInputReferenceConfigProperty idNamespaceAssociationInputReferenceConfigProperty = IdNamespaceAssociationInputReferenceConfigProperty.builder()
     *         .inputReferenceArn("inputReferenceArn")
     *         .manageResourcePolicies(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation.IdNamespaceAssociationInputReferenceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IdNamespaceAssociationInputReferenceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdNamespaceAssociationInputReferenceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS Entity Resolution resource that is being associated to the collaboration.
         * <p>
         * Valid resource ARNs are from the ID namespaces that you own.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig-inputreferencearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig-inputreferencearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputReferenceArn();

        /**
         * When <code>TRUE</code> , AWS Clean Rooms manages permissions for the ID namespace association resource.
         * <p>
         * When <code>FALSE</code> , the resource owner manages permissions for the ID namespace association resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig-manageresourcepolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceconfig-manageresourcepolicies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getManageResourcePolicies();

        /**
         * @return a {@link Builder} of {@link IdNamespaceAssociationInputReferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdNamespaceAssociationInputReferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdNamespaceAssociationInputReferenceConfigProperty> {
            java.lang.String inputReferenceArn;
            java.lang.Object manageResourcePolicies;

            /**
             * Sets the value of {@link IdNamespaceAssociationInputReferenceConfigProperty#getInputReferenceArn}
             * @param inputReferenceArn The Amazon Resource Name (ARN) of the AWS Entity Resolution resource that is being associated to the collaboration. This parameter is required.
             *                          Valid resource ARNs are from the ID namespaces that you own.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputReferenceArn(java.lang.String inputReferenceArn) {
                this.inputReferenceArn = inputReferenceArn;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceAssociationInputReferenceConfigProperty#getManageResourcePolicies}
             * @param manageResourcePolicies When <code>TRUE</code> , AWS Clean Rooms manages permissions for the ID namespace association resource. This parameter is required.
             *                               When <code>FALSE</code> , the resource owner manages permissions for the ID namespace association resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manageResourcePolicies(java.lang.Boolean manageResourcePolicies) {
                this.manageResourcePolicies = manageResourcePolicies;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceAssociationInputReferenceConfigProperty#getManageResourcePolicies}
             * @param manageResourcePolicies When <code>TRUE</code> , AWS Clean Rooms manages permissions for the ID namespace association resource. This parameter is required.
             *                               When <code>FALSE</code> , the resource owner manages permissions for the ID namespace association resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manageResourcePolicies(software.amazon.awscdk.IResolvable manageResourcePolicies) {
                this.manageResourcePolicies = manageResourcePolicies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdNamespaceAssociationInputReferenceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdNamespaceAssociationInputReferenceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdNamespaceAssociationInputReferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdNamespaceAssociationInputReferenceConfigProperty {
            private final java.lang.String inputReferenceArn;
            private final java.lang.Object manageResourcePolicies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputReferenceArn = software.amazon.jsii.Kernel.get(this, "inputReferenceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manageResourcePolicies = software.amazon.jsii.Kernel.get(this, "manageResourcePolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputReferenceArn = java.util.Objects.requireNonNull(builder.inputReferenceArn, "inputReferenceArn is required");
                this.manageResourcePolicies = java.util.Objects.requireNonNull(builder.manageResourcePolicies, "manageResourcePolicies is required");
            }

            @Override
            public final java.lang.String getInputReferenceArn() {
                return this.inputReferenceArn;
            }

            @Override
            public final java.lang.Object getManageResourcePolicies() {
                return this.manageResourcePolicies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputReferenceArn", om.valueToTree(this.getInputReferenceArn()));
                data.set("manageResourcePolicies", om.valueToTree(this.getManageResourcePolicies()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation.IdNamespaceAssociationInputReferenceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdNamespaceAssociationInputReferenceConfigProperty.Jsii$Proxy that = (IdNamespaceAssociationInputReferenceConfigProperty.Jsii$Proxy) o;

                if (!inputReferenceArn.equals(that.inputReferenceArn)) return false;
                return this.manageResourcePolicies.equals(that.manageResourcePolicies);
            }

            @Override
            public final int hashCode() {
                int result = this.inputReferenceArn.hashCode();
                result = 31 * result + (this.manageResourcePolicies.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides the information for the ID namespace association input reference properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * Object idMappingWorkflowsSupported;
     * IdNamespaceAssociationInputReferencePropertiesProperty idNamespaceAssociationInputReferencePropertiesProperty = IdNamespaceAssociationInputReferencePropertiesProperty.builder()
     *         .idMappingWorkflowsSupported(List.of(idMappingWorkflowsSupported))
     *         .idNamespaceType("idNamespaceType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation.IdNamespaceAssociationInputReferencePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(IdNamespaceAssociationInputReferencePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdNamespaceAssociationInputReferencePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines how ID mapping workflows are supported for this ID namespace association.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties-idmappingworkflowssupported">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties-idmappingworkflowssupported</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdMappingWorkflowsSupported() {
            return null;
        }

        /**
         * The ID namespace type for this ID namespace association.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties-idnamespacetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties.html#cfn-cleanrooms-idnamespaceassociation-idnamespaceassociationinputreferenceproperties-idnamespacetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdNamespaceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdNamespaceAssociationInputReferencePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdNamespaceAssociationInputReferencePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdNamespaceAssociationInputReferencePropertiesProperty> {
            java.lang.Object idMappingWorkflowsSupported;
            java.lang.String idNamespaceType;

            /**
             * Sets the value of {@link IdNamespaceAssociationInputReferencePropertiesProperty#getIdMappingWorkflowsSupported}
             * @param idMappingWorkflowsSupported Defines how ID mapping workflows are supported for this ID namespace association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idMappingWorkflowsSupported(java.util.List<? extends java.lang.Object> idMappingWorkflowsSupported) {
                this.idMappingWorkflowsSupported = idMappingWorkflowsSupported;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceAssociationInputReferencePropertiesProperty#getIdMappingWorkflowsSupported}
             * @param idMappingWorkflowsSupported Defines how ID mapping workflows are supported for this ID namespace association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idMappingWorkflowsSupported(software.amazon.awscdk.IResolvable idMappingWorkflowsSupported) {
                this.idMappingWorkflowsSupported = idMappingWorkflowsSupported;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceAssociationInputReferencePropertiesProperty#getIdNamespaceType}
             * @param idNamespaceType The ID namespace type for this ID namespace association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idNamespaceType(java.lang.String idNamespaceType) {
                this.idNamespaceType = idNamespaceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdNamespaceAssociationInputReferencePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdNamespaceAssociationInputReferencePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdNamespaceAssociationInputReferencePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdNamespaceAssociationInputReferencePropertiesProperty {
            private final java.lang.Object idMappingWorkflowsSupported;
            private final java.lang.String idNamespaceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idMappingWorkflowsSupported = software.amazon.jsii.Kernel.get(this, "idMappingWorkflowsSupported", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idNamespaceType = software.amazon.jsii.Kernel.get(this, "idNamespaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idMappingWorkflowsSupported = builder.idMappingWorkflowsSupported;
                this.idNamespaceType = builder.idNamespaceType;
            }

            @Override
            public final java.lang.Object getIdMappingWorkflowsSupported() {
                return this.idMappingWorkflowsSupported;
            }

            @Override
            public final java.lang.String getIdNamespaceType() {
                return this.idNamespaceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdMappingWorkflowsSupported() != null) {
                    data.set("idMappingWorkflowsSupported", om.valueToTree(this.getIdMappingWorkflowsSupported()));
                }
                if (this.getIdNamespaceType() != null) {
                    data.set("idNamespaceType", om.valueToTree(this.getIdNamespaceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnIdNamespaceAssociation.IdNamespaceAssociationInputReferencePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdNamespaceAssociationInputReferencePropertiesProperty.Jsii$Proxy that = (IdNamespaceAssociationInputReferencePropertiesProperty.Jsii$Proxy) o;

                if (this.idMappingWorkflowsSupported != null ? !this.idMappingWorkflowsSupported.equals(that.idMappingWorkflowsSupported) : that.idMappingWorkflowsSupported != null) return false;
                return this.idNamespaceType != null ? this.idNamespaceType.equals(that.idNamespaceType) : that.idNamespaceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idMappingWorkflowsSupported != null ? this.idMappingWorkflowsSupported.hashCode() : 0;
                result = 31 * result + (this.idNamespaceType != null ? this.idNamespaceType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociationProps.Builder();
        }

        /**
         * The input reference configuration for the ID namespace association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-inputreferenceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-inputreferenceconfig</a>
         * @param inputReferenceConfig The input reference configuration for the ID namespace association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputReferenceConfig(final software.amazon.awscdk.IResolvable inputReferenceConfig) {
            this.props.inputReferenceConfig(inputReferenceConfig);
            return this;
        }
        /**
         * The input reference configuration for the ID namespace association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-inputreferenceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-inputreferenceconfig</a>
         * @param inputReferenceConfig The input reference configuration for the ID namespace association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputReferenceConfig(final software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation.IdNamespaceAssociationInputReferenceConfigProperty inputReferenceConfig) {
            this.props.inputReferenceConfig(inputReferenceConfig);
            return this;
        }

        /**
         * The unique identifier of the membership that contains the ID namespace association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-membershipidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-membershipidentifier</a>
         * @param membershipIdentifier The unique identifier of the membership that contains the ID namespace association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(final java.lang.String membershipIdentifier) {
            this.props.membershipIdentifier(membershipIdentifier);
            return this;
        }

        /**
         * The name of this ID namespace association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-name</a>
         * @param name The name of this ID namespace association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The description of the ID namespace association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-description</a>
         * @param description The description of the ID namespace association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The configuration settings for the ID mapping table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-idmappingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-idmappingconfig</a>
         * @param idMappingConfig The configuration settings for the ID mapping table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingConfig(final software.amazon.awscdk.IResolvable idMappingConfig) {
            this.props.idMappingConfig(idMappingConfig);
            return this;
        }
        /**
         * The configuration settings for the ID mapping table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-idmappingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-idmappingconfig</a>
         * @param idMappingConfig The configuration settings for the ID mapping table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingConfig(final software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation.IdMappingConfigProperty idMappingConfig) {
            this.props.idMappingConfig(idMappingConfig);
            return this;
        }

        /**
         * An optional label that you can assign to a resource when you create it.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-idnamespaceassociation.html#cfn-cleanrooms-idnamespaceassociation-tags</a>
         * @param tags An optional label that you can assign to a resource when you create it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation build() {
            return new software.amazon.awscdk.services.cleanrooms.CfnIdNamespaceAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
