package software.amazon.awscdk.services.cloudfront;

/**
 * A monitoring subscription.
 * <p>
 * This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnMonitoringSubscription cfnMonitoringSubscription = CfnMonitoringSubscription.Builder.create(this, "MyCfnMonitoringSubscription")
 *         .distributionId("distributionId")
 *         .monitoringSubscription(MonitoringSubscriptionProperty.builder()
 *                 .realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfigProperty.builder()
 *                         .realtimeMetricsSubscriptionStatus("realtimeMetricsSubscriptionStatus")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.080Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscription")
public class CfnMonitoringSubscription extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMonitoringSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitoringSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMonitoringSubscription(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the distribution that you are enabling metrics for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionId() {
        return software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the distribution that you are enabling metrics for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distributionId", java.util.Objects.requireNonNull(value, "distributionId is required"));
    }

    /**
     * A subscription configuration for additional CloudWatch metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringSubscription() {
        return software.amazon.jsii.Kernel.get(this, "monitoringSubscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A subscription configuration for additional CloudWatch metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "monitoringSubscription", java.util.Objects.requireNonNull(value, "monitoringSubscription is required"));
    }

    /**
     * A subscription configuration for additional CloudWatch metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription.MonitoringSubscriptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "monitoringSubscription", java.util.Objects.requireNonNull(value, "monitoringSubscription is required"));
    }
    /**
     * A monitoring subscription.
     * <p>
     * This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * MonitoringSubscriptionProperty monitoringSubscriptionProperty = MonitoringSubscriptionProperty.builder()
     *         .realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfigProperty.builder()
     *                 .realtimeMetricsSubscriptionStatus("realtimeMetricsSubscriptionStatus")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-monitoringsubscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-monitoringsubscription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscription.MonitoringSubscriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringSubscriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringSubscriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A subscription configuration for additional CloudWatch metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription-realtimemetricssubscriptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription-realtimemetricssubscriptionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRealtimeMetricsSubscriptionConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringSubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringSubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringSubscriptionProperty> {
            java.lang.Object realtimeMetricsSubscriptionConfig;

            /**
             * Sets the value of {@link MonitoringSubscriptionProperty#getRealtimeMetricsSubscriptionConfig}
             * @param realtimeMetricsSubscriptionConfig A subscription configuration for additional CloudWatch metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeMetricsSubscriptionConfig(software.amazon.awscdk.IResolvable realtimeMetricsSubscriptionConfig) {
                this.realtimeMetricsSubscriptionConfig = realtimeMetricsSubscriptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringSubscriptionProperty#getRealtimeMetricsSubscriptionConfig}
             * @param realtimeMetricsSubscriptionConfig A subscription configuration for additional CloudWatch metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeMetricsSubscriptionConfig(software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription.RealtimeMetricsSubscriptionConfigProperty realtimeMetricsSubscriptionConfig) {
                this.realtimeMetricsSubscriptionConfig = realtimeMetricsSubscriptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringSubscriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringSubscriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringSubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringSubscriptionProperty {
            private final java.lang.Object realtimeMetricsSubscriptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.realtimeMetricsSubscriptionConfig = software.amazon.jsii.Kernel.get(this, "realtimeMetricsSubscriptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.realtimeMetricsSubscriptionConfig = builder.realtimeMetricsSubscriptionConfig;
            }

            @Override
            public final java.lang.Object getRealtimeMetricsSubscriptionConfig() {
                return this.realtimeMetricsSubscriptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRealtimeMetricsSubscriptionConfig() != null) {
                    data.set("realtimeMetricsSubscriptionConfig", om.valueToTree(this.getRealtimeMetricsSubscriptionConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscription.MonitoringSubscriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringSubscriptionProperty.Jsii$Proxy that = (MonitoringSubscriptionProperty.Jsii$Proxy) o;

                return this.realtimeMetricsSubscriptionConfig != null ? this.realtimeMetricsSubscriptionConfig.equals(that.realtimeMetricsSubscriptionConfig) : that.realtimeMetricsSubscriptionConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.realtimeMetricsSubscriptionConfig != null ? this.realtimeMetricsSubscriptionConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A subscription configuration for additional CloudWatch metrics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * RealtimeMetricsSubscriptionConfigProperty realtimeMetricsSubscriptionConfigProperty = RealtimeMetricsSubscriptionConfigProperty.builder()
     *         .realtimeMetricsSubscriptionStatus("realtimeMetricsSubscriptionStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-realtimemetricssubscriptionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-realtimemetricssubscriptionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscription.RealtimeMetricsSubscriptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RealtimeMetricsSubscriptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RealtimeMetricsSubscriptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-realtimemetricssubscriptionconfig.html#cfn-cloudfront-monitoringsubscription-realtimemetricssubscriptionconfig-realtimemetricssubscriptionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-monitoringsubscription-realtimemetricssubscriptionconfig.html#cfn-cloudfront-monitoringsubscription-realtimemetricssubscriptionconfig-realtimemetricssubscriptionstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRealtimeMetricsSubscriptionStatus();

        /**
         * @return a {@link Builder} of {@link RealtimeMetricsSubscriptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RealtimeMetricsSubscriptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RealtimeMetricsSubscriptionConfigProperty> {
            java.lang.String realtimeMetricsSubscriptionStatus;

            /**
             * Sets the value of {@link RealtimeMetricsSubscriptionConfigProperty#getRealtimeMetricsSubscriptionStatus}
             * @param realtimeMetricsSubscriptionStatus A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeMetricsSubscriptionStatus(java.lang.String realtimeMetricsSubscriptionStatus) {
                this.realtimeMetricsSubscriptionStatus = realtimeMetricsSubscriptionStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RealtimeMetricsSubscriptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RealtimeMetricsSubscriptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RealtimeMetricsSubscriptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RealtimeMetricsSubscriptionConfigProperty {
            private final java.lang.String realtimeMetricsSubscriptionStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.realtimeMetricsSubscriptionStatus = software.amazon.jsii.Kernel.get(this, "realtimeMetricsSubscriptionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.realtimeMetricsSubscriptionStatus = java.util.Objects.requireNonNull(builder.realtimeMetricsSubscriptionStatus, "realtimeMetricsSubscriptionStatus is required");
            }

            @Override
            public final java.lang.String getRealtimeMetricsSubscriptionStatus() {
                return this.realtimeMetricsSubscriptionStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("realtimeMetricsSubscriptionStatus", om.valueToTree(this.getRealtimeMetricsSubscriptionStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscription.RealtimeMetricsSubscriptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RealtimeMetricsSubscriptionConfigProperty.Jsii$Proxy that = (RealtimeMetricsSubscriptionConfigProperty.Jsii$Proxy) o;

                return this.realtimeMetricsSubscriptionStatus.equals(that.realtimeMetricsSubscriptionStatus);
            }

            @Override
            public final int hashCode() {
                int result = this.realtimeMetricsSubscriptionStatus.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscriptionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscriptionProps.Builder();
        }

        /**
         * The ID of the distribution that you are enabling metrics for.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-distributionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-distributionid</a>
         * @param distributionId The ID of the distribution that you are enabling metrics for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionId(final java.lang.String distributionId) {
            this.props.distributionId(distributionId);
            return this;
        }

        /**
         * A subscription configuration for additional CloudWatch metrics.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription</a>
         * @param monitoringSubscription A subscription configuration for additional CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringSubscription(final software.amazon.awscdk.IResolvable monitoringSubscription) {
            this.props.monitoringSubscription(monitoringSubscription);
            return this;
        }
        /**
         * A subscription configuration for additional CloudWatch metrics.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription</a>
         * @param monitoringSubscription A subscription configuration for additional CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringSubscription(final software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription.MonitoringSubscriptionProperty monitoringSubscription) {
            this.props.monitoringSubscription(monitoringSubscription);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription build() {
            return new software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
