package software.amazon.awscdk.services.cloudfront;

/**
 * An import source from an S3 object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * Key key;
 * ILocalBundling localBundling;
 * ImportSource s3ImportSource = S3ImportSource.fromAsset("path", AssetOptions.builder()
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .network("network")
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .platform("platform")
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .volumesFrom(List.of("volumesFrom"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .deployTime(false)
 *         .displayName("displayName")
 *         .exclude(List.of("exclude"))
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .sourceKMSKey(key)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.182Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.S3ImportSource")
public class S3ImportSource extends software.amazon.awscdk.services.cloudfront.ImportSource {

    protected S3ImportSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3ImportSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket the S3 bucket that contains the data. This parameter is required.
     * @param key the key within the S3 bucket that contains the data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3ImportSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * the S3 bucket that contains the data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * the key within the S3 bucket that contains the data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
