package software.amazon.awscdk.services.cloudfront;

/**
 * VPC origin endpoint configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * VpcOriginOptions vpcOriginOptions = VpcOriginOptions.builder()
 *         .httpPort(123)
 *         .httpsPort(123)
 *         .originSslProtocols(List.of(OriginSslPolicy.SSL_V3))
 *         .protocolPolicy(OriginProtocolPolicy.HTTP_ONLY)
 *         .vpcOriginName("vpcOriginName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.189Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.VpcOriginOptions")
@software.amazon.jsii.Jsii.Proxy(VpcOriginOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcOriginOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP port for the CloudFront VPC origin endpoint configuration.
     * <p>
     * Default: 80
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
        return null;
    }

    /**
     * The HTTPS port of the CloudFront VPC origin endpoint configuration.
     * <p>
     * Default: 443
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
        return null;
    }

    /**
     * A list that contains allowed SSL/TLS protocols for this distribution.
     * <p>
     * Default: - TLSv1.2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getOriginSslProtocols() {
        return null;
    }

    /**
     * The origin protocol policy for the CloudFront VPC origin endpoint configuration.
     * <p>
     * Default: OriginProtocolPolicy.MATCH_VIEWER
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getProtocolPolicy() {
        return null;
    }

    /**
     * The name of the CloudFront VPC origin endpoint configuration.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcOriginName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcOriginOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcOriginOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcOriginOptions> {
        java.lang.Number httpPort;
        java.lang.Number httpsPort;
        java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols;
        software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy;
        java.lang.String vpcOriginName;

        /**
         * Sets the value of {@link VpcOriginOptions#getHttpPort}
         * @param httpPort The HTTP port for the CloudFront VPC origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPort(java.lang.Number httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginOptions#getHttpsPort}
         * @param httpsPort The HTTPS port of the CloudFront VPC origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsPort(java.lang.Number httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginOptions#getOriginSslProtocols}
         * @param originSslProtocols A list that contains allowed SSL/TLS protocols for this distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder originSslProtocols(java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.originSslProtocols = (java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy>)originSslProtocols;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginOptions#getProtocolPolicy}
         * @param protocolPolicy The origin protocol policy for the CloudFront VPC origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolPolicy(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginOptions#getVpcOriginName}
         * @param vpcOriginName The name of the CloudFront VPC origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOriginName(java.lang.String vpcOriginName) {
            this.vpcOriginName = vpcOriginName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcOriginOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcOriginOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcOriginOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcOriginOptions {
        private final java.lang.Number httpPort;
        private final java.lang.Number httpsPort;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols;
        private final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy;
        private final java.lang.String vpcOriginName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginSslPolicy.class)));
            this.protocolPolicy = software.amazon.jsii.Kernel.get(this, "protocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy.class));
            this.vpcOriginName = software.amazon.jsii.Kernel.get(this, "vpcOriginName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpPort = builder.httpPort;
            this.httpsPort = builder.httpsPort;
            this.originSslProtocols = (java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy>)builder.originSslProtocols;
            this.protocolPolicy = builder.protocolPolicy;
            this.vpcOriginName = builder.vpcOriginName;
        }

        @Override
        public final java.lang.Number getHttpPort() {
            return this.httpPort;
        }

        @Override
        public final java.lang.Number getHttpsPort() {
            return this.httpsPort;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getOriginSslProtocols() {
            return this.originSslProtocols;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getProtocolPolicy() {
            return this.protocolPolicy;
        }

        @Override
        public final java.lang.String getVpcOriginName() {
            return this.vpcOriginName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHttpPort() != null) {
                data.set("httpPort", om.valueToTree(this.getHttpPort()));
            }
            if (this.getHttpsPort() != null) {
                data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
            }
            if (this.getOriginSslProtocols() != null) {
                data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
            }
            if (this.getProtocolPolicy() != null) {
                data.set("protocolPolicy", om.valueToTree(this.getProtocolPolicy()));
            }
            if (this.getVpcOriginName() != null) {
                data.set("vpcOriginName", om.valueToTree(this.getVpcOriginName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.VpcOriginOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcOriginOptions.Jsii$Proxy that = (VpcOriginOptions.Jsii$Proxy) o;

            if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
            if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
            if (this.originSslProtocols != null ? !this.originSslProtocols.equals(that.originSslProtocols) : that.originSslProtocols != null) return false;
            if (this.protocolPolicy != null ? !this.protocolPolicy.equals(that.protocolPolicy) : that.protocolPolicy != null) return false;
            return this.vpcOriginName != null ? this.vpcOriginName.equals(that.vpcOriginName) : that.vpcOriginName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpPort != null ? this.httpPort.hashCode() : 0;
            result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
            result = 31 * result + (this.originSslProtocols != null ? this.originSslProtocols.hashCode() : 0);
            result = 31 * result + (this.protocolPolicy != null ? this.protocolPolicy.hashCode() : 0);
            result = 31 * result + (this.vpcOriginName != null ? this.vpcOriginName.hashCode() : 0);
            return result;
        }
    }
}
