package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for <code>CodeCommitSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codecommit.*;
 * Repository repo;
 * Bucket bucket;
 * Project project = Project.Builder.create(this, "MyProject")
 *         .secondarySources(List.of(Source.codeCommit(CodeCommitSourceProps.builder()
 *                 .identifier("source2")
 *                 .repository(repo)
 *                 .build())))
 *         .secondaryArtifacts(List.of(Artifacts.s3(S3ArtifactsProps.builder()
 *                 .identifier("artifact2")
 *                 .bucket(bucket)
 *                 .path("some/path")
 *                 .name("file.zip")
 *                 .build())))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.489Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CodeCommitSourceProps")
@software.amazon.jsii.Jsii.Proxy(CodeCommitSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeCommitSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.SourceProps {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository getRepository();

    /**
     * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
     * <p>
     * Default: the default branch's HEAD commit ID is used
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "mybranch";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranchOrRef() {
        return null;
    }

    /**
     * The depth of history to download.
     * <p>
     * Minimum value is 0.
     * If this value is 0, greater than 25, or not provided,
     * then the full history is downloaded with each build of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCloneDepth() {
        return null;
    }

    /**
     * Whether to fetch submodules while cloning git repo.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFetchSubmodules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeCommitSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeCommitSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeCommitSourceProps> {
        software.amazon.awscdk.services.codecommit.IRepository repository;
        java.lang.String branchOrRef;
        java.lang.Number cloneDepth;
        java.lang.Boolean fetchSubmodules;
        java.lang.String identifier;

        /**
         * Sets the value of {@link CodeCommitSourceProps#getRepository}
         * @param repository the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(software.amazon.awscdk.services.codecommit.IRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getBranchOrRef}
         * @param branchOrRef The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchOrRef(java.lang.String branchOrRef) {
            this.branchOrRef = branchOrRef;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getCloneDepth}
         * @param cloneDepth The depth of history to download.
         *                   Minimum value is 0.
         *                   If this value is 0, greater than 25, or not provided,
         *                   then the full history is downloaded with each build of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneDepth(java.lang.Number cloneDepth) {
            this.cloneDepth = cloneDepth;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getFetchSubmodules}
         * @param fetchSubmodules Whether to fetch submodules while cloning git repo.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fetchSubmodules(java.lang.Boolean fetchSubmodules) {
            this.fetchSubmodules = fetchSubmodules;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getIdentifier}
         * @param identifier The source identifier.
         *                   This property is required on secondary sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeCommitSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeCommitSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeCommitSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeCommitSourceProps {
        private final software.amazon.awscdk.services.codecommit.IRepository repository;
        private final java.lang.String branchOrRef;
        private final java.lang.Number cloneDepth;
        private final java.lang.Boolean fetchSubmodules;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class));
            this.branchOrRef = software.amazon.jsii.Kernel.get(this, "branchOrRef", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloneDepth = software.amazon.jsii.Kernel.get(this, "cloneDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fetchSubmodules = software.amazon.jsii.Kernel.get(this, "fetchSubmodules", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
            this.branchOrRef = builder.branchOrRef;
            this.cloneDepth = builder.cloneDepth;
            this.fetchSubmodules = builder.fetchSubmodules;
            this.identifier = builder.identifier;
        }

        @Override
        public final software.amazon.awscdk.services.codecommit.IRepository getRepository() {
            return this.repository;
        }

        @Override
        public final java.lang.String getBranchOrRef() {
            return this.branchOrRef;
        }

        @Override
        public final java.lang.Number getCloneDepth() {
            return this.cloneDepth;
        }

        @Override
        public final java.lang.Boolean getFetchSubmodules() {
            return this.fetchSubmodules;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repository", om.valueToTree(this.getRepository()));
            if (this.getBranchOrRef() != null) {
                data.set("branchOrRef", om.valueToTree(this.getBranchOrRef()));
            }
            if (this.getCloneDepth() != null) {
                data.set("cloneDepth", om.valueToTree(this.getCloneDepth()));
            }
            if (this.getFetchSubmodules() != null) {
                data.set("fetchSubmodules", om.valueToTree(this.getFetchSubmodules()));
            }
            if (this.getIdentifier() != null) {
                data.set("identifier", om.valueToTree(this.getIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CodeCommitSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeCommitSourceProps.Jsii$Proxy that = (CodeCommitSourceProps.Jsii$Proxy) o;

            if (!repository.equals(that.repository)) return false;
            if (this.branchOrRef != null ? !this.branchOrRef.equals(that.branchOrRef) : that.branchOrRef != null) return false;
            if (this.cloneDepth != null ? !this.cloneDepth.equals(that.cloneDepth) : that.cloneDepth != null) return false;
            if (this.fetchSubmodules != null ? !this.fetchSubmodules.equals(that.fetchSubmodules) : that.fetchSubmodules != null) return false;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repository.hashCode();
            result = 31 * result + (this.branchOrRef != null ? this.branchOrRef.hashCode() : 0);
            result = 31 * result + (this.cloneDepth != null ? this.cloneDepth.hashCode() : 0);
            result = 31 * result + (this.fetchSubmodules != null ? this.fetchSubmodules.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }
    }
}
