package software.amazon.awscdk.services.codebuild;

/**
 * Fleet build machine compute type. Subset of Fleet compatible {@link ComputeType} values.
 * <p>
 * The allocated memory, vCPU count and disk space of the build machine for a
 * given compute type are dependent on the environment type.
 * Some compute types may also not be available for all environment types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Fleet fleet = Fleet.Builder.create(this, "Fleet")
 *         .computeType(FleetComputeType.MEDIUM)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .baseCapacity(1)
 *         .build();
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .fleet(fleet)
 *                 .buildImage(LinuxBuildImage.STANDARD_7_0)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.506Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.FleetComputeType")
public enum FleetComputeType {
    /**
     * Small compute type.
     * <p>
     * May not be available for all environment types, see
     * {@link https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types docs}
     * for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMALL,
    /**
     * Medium compute type.
     * <p>
     * May not be available for all environment types, see
     * {@link https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types docs}
     * for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * Large compute type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LARGE,
    /**
     * Extra Large compute type.
     * <p>
     * May not be available for all environment types, see
     * {@link https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types docs}
     * for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X_LARGE,
    /**
     * Extra, Extra Large compute type.
     * <p>
     * May not be available for all environment types, see
     * {@link https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types docs}
     * for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2_LARGE,
    /**
     * Specify the amount of vCPUs, memory, disk space, and the type of machine.
     * <p>
     * AWS CodeBuild will select the cheapest instance that satisfies your specified attributes from <code>computeConfiguration</code>.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ATTRIBUTE_BASED,
}
