package software.amazon.awscdk.services.codebuild;

/**
 * Represents a Docker image used for the CodeBuild Project builds.
 * <p>
 * Use the concrete subclasses, either:
 * <code>LinuxBuildImage</code> or <code>WindowsBuildImage</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.512Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.IBuildImage")
@software.amazon.jsii.Jsii.Proxy(IBuildImage.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IBuildImage extends software.amazon.jsii.JsiiSerializable {

    /**
     * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType();

    /**
     * The Docker image identifier that the build environment uses.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageId();

    /**
     * The type of build environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     * <p>
     * Default: ImagePullPrincipalType.SERVICE_ROLE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return null;
    }

    /**
     * An optional ECR repository that the image is hosted in.
     * <p>
     * Default: no repository
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return null;
    }

    /**
     * The secretsManagerCredentials for access to a private registry.
     * <p>
     * Default: no credentials will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return null;
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint);

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param buildEnvironment the current build environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
            return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
        }

        /**
         * The Docker image identifier that the build environment uses.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
            return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of build environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of principal that CodeBuild will use to pull this build Docker image.
         * <p>
         * Default: ImagePullPrincipalType.SERVICE_ROLE
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
            return software.amazon.jsii.Kernel.get(this, "imagePullPrincipalType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class));
        }

        /**
         * An optional ECR repository that the image is hosted in.
         * <p>
         * Default: no repository
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
            return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
        }

        /**
         * The secretsManagerCredentials for access to a private registry.
         * <p>
         * Default: no credentials will be used
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
            return software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * Make a buildspec to run the indicated script.
         * <p>
         * @param entrypoint This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
            return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
        }

        /**
         * Allows the image a chance to validate whether the passed configuration is correct.
         * <p>
         * @param buildEnvironment the current build environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
        }
    }

    /**
     * Internal default implementation for {@link IBuildImage}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IBuildImage {

        /**
         * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
            return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
        }

        /**
         * The Docker image identifier that the build environment uses.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
            return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of build environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of principal that CodeBuild will use to pull this build Docker image.
         * <p>
         * Default: ImagePullPrincipalType.SERVICE_ROLE
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
            return software.amazon.jsii.Kernel.get(this, "imagePullPrincipalType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class));
        }

        /**
         * An optional ECR repository that the image is hosted in.
         * <p>
         * Default: no repository
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
            return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
        }

        /**
         * The secretsManagerCredentials for access to a private registry.
         * <p>
         * Default: no credentials will be used
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
            return software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * Make a buildspec to run the indicated script.
         * <p>
         * @param entrypoint This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
            return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
        }

        /**
         * Allows the image a chance to validate whether the passed configuration is correct.
         * <p>
         * @param buildEnvironment the current build environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
        }
    }
}
