package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>S3SourceAction S3 source Action</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket sourceBucket;
 * // later:
 * PipelineProject project;
 * String key = "some/key.zip";
 * Artifact sourceOutput = new Artifact();
 * S3SourceAction sourceAction = S3SourceAction.Builder.create()
 *         .actionName("S3Source")
 *         .bucketKey(key)
 *         .bucket(sourceBucket)
 *         .output(sourceOutput)
 *         .variablesNamespace("MyNamespace")
 *         .build();
 * CodeBuildAction.Builder.create()
 *         .actionName("CodeBuild")
 *         .project(project)
 *         .input(sourceOutput)
 *         .environmentVariables(Map.of(
 *                 "VERSION_ID", BuildEnvironmentVariable.builder()
 *                         .value(sourceAction.getVariables().getVersionId())
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.867Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.S3SourceActionProps")
@software.amazon.jsii.Jsii.Proxy(S3SourceActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3SourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The Amazon S3 bucket that stores the source code.
     * <p>
     * If you import an encrypted bucket in your stack, please specify
     * the encryption key at import time by using <code>Bucket.fromBucketAttributes()</code> method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * The key within the S3 bucket that stores the source code.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "path/to/file.zip";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketKey();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getOutput();

    /**
     * How should CodePipeline detect source changes for this Action.
     * <p>
     * Note that if this is S3Trigger.EVENTS, you need to make sure to include the source Bucket in a CloudTrail Trail,
     * as otherwise the CloudWatch Events will not be emitted.
     * <p>
     * Default: S3Trigger.POLL
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.S3Trigger getTrigger() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3SourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3SourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3SourceActionProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String bucketKey;
        software.amazon.awscdk.services.codepipeline.Artifact output;
        software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link S3SourceActionProps#getBucket}
         * @param bucket The Amazon S3 bucket that stores the source code. This parameter is required.
         *               If you import an encrypted bucket in your stack, please specify
         *               the encryption key at import time by using <code>Bucket.fromBucketAttributes()</code> method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getBucketKey}
         * @param bucketKey The key within the S3 bucket that stores the source code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketKey(java.lang.String bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getOutput}
         * @param output the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getTrigger}
         * @param trigger How should CodePipeline detect source changes for this Action.
         *                Note that if this is S3Trigger.EVENTS, you need to make sure to include the source Bucket in a CloudTrail Trail,
         *                as otherwise the CloudWatch Events will not be emitted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trigger(software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3SourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3SourceActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3SourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourceActionProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketKey;
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.bucketKey = software.amazon.jsii.Kernel.get(this, "bucketKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.S3Trigger.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.bucketKey = java.util.Objects.requireNonNull(builder.bucketKey, "bucketKey is required");
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
            this.trigger = builder.trigger;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketKey() {
            return this.bucketKey;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.S3Trigger getTrigger() {
            return this.trigger;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("bucketKey", om.valueToTree(this.getBucketKey()));
            data.set("output", om.valueToTree(this.getOutput()));
            if (this.getTrigger() != null) {
                data.set("trigger", om.valueToTree(this.getTrigger()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.S3SourceActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3SourceActionProps.Jsii$Proxy that = (S3SourceActionProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!bucketKey.equals(that.bucketKey)) return false;
            if (!output.equals(that.output)) return false;
            if (this.trigger != null ? !this.trigger.equals(that.trigger) : that.trigger != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.bucketKey.hashCode());
            result = 31 * result + (this.output.hashCode());
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
