package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnIdentityPoolRoleAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object roles;
 * CfnIdentityPoolRoleAttachmentProps cfnIdentityPoolRoleAttachmentProps = CfnIdentityPoolRoleAttachmentProps.builder()
 *         .identityPoolId("identityPoolId")
 *         // the properties below are optional
 *         .roleMappings(Map.of(
 *                 "roleMappingsKey", RoleMappingProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .ambiguousRoleResolution("ambiguousRoleResolution")
 *                         .identityProvider("identityProvider")
 *                         .rulesConfiguration(RulesConfigurationTypeProperty.builder()
 *                                 .rules(List.of(MappingRuleProperty.builder()
 *                                         .claim("claim")
 *                                         .matchType("matchType")
 *                                         .roleArn("roleArn")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .build()))
 *         .roles(roles)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.933Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityPoolRoleAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityPoolRoleAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An identity pool ID in the format <code>REGION:GUID</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId();

    /**
     * How users for a specific identity provider are mapped to roles.
     * <p>
     * This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
     * <p>
     * If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoleMappings() {
        return null;
    }

    /**
     * The map of the roles associated with this pool.
     * <p>
     * For a given role, the key is either "authenticated" or "unauthenticated". The value is the role ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoles() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityPoolRoleAttachmentProps> {
        java.lang.String identityPoolId;
        java.lang.Object roleMappings;
        java.lang.Object roles;

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getIdentityPoolId}
         * @param identityPoolId An identity pool ID in the format <code>REGION:GUID</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolId(java.lang.String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getRoleMappings}
         * @param roleMappings How users for a specific identity provider are mapped to roles.
         *                     This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
         *                     <p>
         *                     If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
         *                     <p>
         *                     For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(software.amazon.awscdk.IResolvable roleMappings) {
            this.roleMappings = roleMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getRoleMappings}
         * @param roleMappings How users for a specific identity provider are mapped to roles.
         *                     This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
         *                     <p>
         *                     If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
         *                     <p>
         *                     For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(java.util.Map<java.lang.String, ? extends java.lang.Object> roleMappings) {
            this.roleMappings = roleMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getRoles}
         * @param roles The map of the roles associated with this pool.
         *              For a given role, the key is either "authenticated" or "unauthenticated". The value is the role ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(java.lang.Object roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityPoolRoleAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityPoolRoleAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityPoolRoleAttachmentProps {
        private final java.lang.String identityPoolId;
        private final java.lang.Object roleMappings;
        private final java.lang.Object roles;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleMappings = software.amazon.jsii.Kernel.get(this, "roleMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roles = software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityPoolId = java.util.Objects.requireNonNull(builder.identityPoolId, "identityPoolId is required");
            this.roleMappings = builder.roleMappings;
            this.roles = builder.roles;
        }

        @Override
        public final java.lang.String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final java.lang.Object getRoleMappings() {
            return this.roleMappings;
        }

        @Override
        public final java.lang.Object getRoles() {
            return this.roles;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
            if (this.getRoleMappings() != null) {
                data.set("roleMappings", om.valueToTree(this.getRoleMappings()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityPoolRoleAttachmentProps.Jsii$Proxy that = (CfnIdentityPoolRoleAttachmentProps.Jsii$Proxy) o;

            if (!identityPoolId.equals(that.identityPoolId)) return false;
            if (this.roleMappings != null ? !this.roleMappings.equals(that.roleMappings) : that.roleMappings != null) return false;
            return this.roles != null ? this.roles.equals(that.roles) : that.roles == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identityPoolId.hashCode();
            result = 31 * result + (this.roleMappings != null ? this.roleMappings.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            return result;
        }
    }
}
