package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnLogDeliveryConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnLogDeliveryConfigurationProps cfnLogDeliveryConfigurationProps = CfnLogDeliveryConfigurationProps.builder()
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .logConfigurations(List.of(LogConfigurationProperty.builder()
 *                 .cloudWatchLogsConfiguration(CloudWatchLogsConfigurationProperty.builder()
 *                         .logGroupArn("logGroupArn")
 *                         .build())
 *                 .eventSource("eventSource")
 *                 .firehoseConfiguration(FirehoseConfigurationProperty.builder()
 *                         .streamArn("streamArn")
 *                         .build())
 *                 .logLevel("logLevel")
 *                 .s3Configuration(S3ConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-logdeliveryconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-logdeliveryconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:14.947Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnLogDeliveryConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnLogDeliveryConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLogDeliveryConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the user pool where you configured logging.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-logdeliveryconfiguration.html#cfn-cognito-logdeliveryconfiguration-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-logdeliveryconfiguration.html#cfn-cognito-logdeliveryconfiguration-userpoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * A logging destination of a user pool.
     * <p>
     * User pools can have multiple logging destinations for message-delivery and user-activity logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-logdeliveryconfiguration.html#cfn-cognito-logdeliveryconfiguration-logconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-logdeliveryconfiguration.html#cfn-cognito-logdeliveryconfiguration-logconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLogDeliveryConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLogDeliveryConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLogDeliveryConfigurationProps> {
        java.lang.String userPoolId;
        java.lang.Object logConfigurations;

        /**
         * Sets the value of {@link CfnLogDeliveryConfigurationProps#getUserPoolId}
         * @param userPoolId The ID of the user pool where you configured logging. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogDeliveryConfigurationProps#getLogConfigurations}
         * @param logConfigurations A logging destination of a user pool.
         *                          User pools can have multiple logging destinations for message-delivery and user-activity logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfigurations(software.amazon.awscdk.IResolvable logConfigurations) {
            this.logConfigurations = logConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogDeliveryConfigurationProps#getLogConfigurations}
         * @param logConfigurations A logging destination of a user pool.
         *                          User pools can have multiple logging destinations for message-delivery and user-activity logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfigurations(java.util.List<? extends java.lang.Object> logConfigurations) {
            this.logConfigurations = logConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLogDeliveryConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLogDeliveryConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLogDeliveryConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLogDeliveryConfigurationProps {
        private final java.lang.String userPoolId;
        private final java.lang.Object logConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logConfigurations = software.amazon.jsii.Kernel.get(this, "logConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.logConfigurations = builder.logConfigurations;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getLogConfigurations() {
            return this.logConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getLogConfigurations() != null) {
                data.set("logConfigurations", om.valueToTree(this.getLogConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnLogDeliveryConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLogDeliveryConfigurationProps.Jsii$Proxy that = (CfnLogDeliveryConfigurationProps.Jsii$Proxy) o;

            if (!userPoolId.equals(that.userPoolId)) return false;
            return this.logConfigurations != null ? this.logConfigurations.equals(that.logConfigurations) : that.logConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPoolId.hashCode();
            result = 31 * result + (this.logConfigurations != null ? this.logConfigurations.hashCode() : 0);
            return result;
        }
    }
}
