package software.amazon.awscdk.services.cognito;

/**
 * User pool configuration when administrators sign users up.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .userInvitation(UserInvitationConfig.builder()
 *                 .emailSubject("Invite to join our awesome app!")
 *                 .emailBody("Hello {username}, you have been invited to join our awesome app! Your temporary password is {####}")
 *                 .smsMessage("Hello {username}, your temporary password for our awesome app is {####}")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:15.052Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserInvitationConfig")
@software.amazon.jsii.Jsii.Proxy(UserInvitationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserInvitationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The template to the email body that is sent to the user when an administrator signs them up to the user pool.
     * <p>
     * Default: 'Your username is {username} and temporary password is {####}.'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailBody() {
        return null;
    }

    /**
     * The template to the email subject that is sent to the user when an administrator signs them up to the user pool.
     * <p>
     * Default: 'Your temporary password'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailSubject() {
        return null;
    }

    /**
     * The template to the SMS message that is sent to the user when an administrator signs them up to the user pool.
     * <p>
     * Default: 'Your username is {username} and temporary password is {####}'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsMessage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserInvitationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserInvitationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserInvitationConfig> {
        java.lang.String emailBody;
        java.lang.String emailSubject;
        java.lang.String smsMessage;

        /**
         * Sets the value of {@link UserInvitationConfig#getEmailBody}
         * @param emailBody The template to the email body that is sent to the user when an administrator signs them up to the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailBody(java.lang.String emailBody) {
            this.emailBody = emailBody;
            return this;
        }

        /**
         * Sets the value of {@link UserInvitationConfig#getEmailSubject}
         * @param emailSubject The template to the email subject that is sent to the user when an administrator signs them up to the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailSubject(java.lang.String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        /**
         * Sets the value of {@link UserInvitationConfig#getSmsMessage}
         * @param smsMessage The template to the SMS message that is sent to the user when an administrator signs them up to the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsMessage(java.lang.String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserInvitationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserInvitationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserInvitationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserInvitationConfig {
        private final java.lang.String emailBody;
        private final java.lang.String emailSubject;
        private final java.lang.String smsMessage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emailBody = software.amazon.jsii.Kernel.get(this, "emailBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailSubject = software.amazon.jsii.Kernel.get(this, "emailSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.smsMessage = software.amazon.jsii.Kernel.get(this, "smsMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emailBody = builder.emailBody;
            this.emailSubject = builder.emailSubject;
            this.smsMessage = builder.smsMessage;
        }

        @Override
        public final java.lang.String getEmailBody() {
            return this.emailBody;
        }

        @Override
        public final java.lang.String getEmailSubject() {
            return this.emailSubject;
        }

        @Override
        public final java.lang.String getSmsMessage() {
            return this.smsMessage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEmailBody() != null) {
                data.set("emailBody", om.valueToTree(this.getEmailBody()));
            }
            if (this.getEmailSubject() != null) {
                data.set("emailSubject", om.valueToTree(this.getEmailSubject()));
            }
            if (this.getSmsMessage() != null) {
                data.set("smsMessage", om.valueToTree(this.getSmsMessage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserInvitationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserInvitationConfig.Jsii$Proxy that = (UserInvitationConfig.Jsii$Proxy) o;

            if (this.emailBody != null ? !this.emailBody.equals(that.emailBody) : that.emailBody != null) return false;
            if (this.emailSubject != null ? !this.emailSubject.equals(that.emailSubject) : that.emailSubject != null) return false;
            return this.smsMessage != null ? this.smsMessage.equals(that.smsMessage) : that.smsMessage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.emailBody != null ? this.emailBody.hashCode() : 0;
            result = 31 * result + (this.emailSubject != null ? this.emailSubject.hashCode() : 0);
            result = 31 * result + (this.smsMessage != null ? this.smsMessage.hashCode() : 0);
            return result;
        }
    }
}
