package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * Object assignContactCategoryActions;
 * Object emptyValue;
 * Object endAssociatedTasksActions;
 * CfnRuleProps cfnRuleProps = CfnRuleProps.builder()
 *         .actions(ActionsProperty.builder()
 *                 .assignContactCategoryActions(List.of(assignContactCategoryActions))
 *                 .createCaseActions(List.of(CreateCaseActionProperty.builder()
 *                         .fields(List.of(FieldProperty.builder()
 *                                 .id("id")
 *                                 .value(FieldValueProperty.builder()
 *                                         .booleanValue(false)
 *                                         .doubleValue(123)
 *                                         .emptyValue(emptyValue)
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build()))
 *                         .templateId("templateId")
 *                         .build()))
 *                 .endAssociatedTasksActions(List.of(endAssociatedTasksActions))
 *                 .eventBridgeActions(List.of(EventBridgeActionProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .sendNotificationActions(List.of(SendNotificationActionProperty.builder()
 *                         .content("content")
 *                         .contentType("contentType")
 *                         .deliveryMethod("deliveryMethod")
 *                         .recipient(NotificationRecipientTypeProperty.builder()
 *                                 .userArns(List.of("userArns"))
 *                                 .userTags(Map.of(
 *                                         "userTagsKey", "userTags"))
 *                                 .build())
 *                         // the properties below are optional
 *                         .subject("subject")
 *                         .build()))
 *                 .submitAutoEvaluationActions(List.of(SubmitAutoEvaluationActionProperty.builder()
 *                         .evaluationFormArn("evaluationFormArn")
 *                         .build()))
 *                 .taskActions(List.of(TaskActionProperty.builder()
 *                         .contactFlowArn("contactFlowArn")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .references(Map.of(
 *                                 "referencesKey", ReferenceProperty.builder()
 *                                         .type("type")
 *                                         .value("value")
 *                                         .build()))
 *                         .build()))
 *                 .updateCaseActions(List.of(UpdateCaseActionProperty.builder()
 *                         .fields(List.of(FieldProperty.builder()
 *                                 .id("id")
 *                                 .value(FieldValueProperty.builder()
 *                                         .booleanValue(false)
 *                                         .doubleValue(123)
 *                                         .emptyValue(emptyValue)
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .function("function")
 *         .instanceArn("instanceArn")
 *         .name("name")
 *         .publishStatus("publishStatus")
 *         .triggerEventSource(RuleTriggerEventSourceProperty.builder()
 *                 .eventSourceName("eventSourceName")
 *                 // the properties below are optional
 *                 .integrationAssociationArn("integrationAssociationArn")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:15.285Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of actions to be run when the rule is triggered.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * The conditions of the rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-function">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-function</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunction();

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * The name of the rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The publish status of the rule.
     * <p>
     * <em>Allowed values</em> : <code>DRAFT</code> | <code>PUBLISHED</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-publishstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-publishstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublishStatus();

    /**
     * The event source to trigger the rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-triggereventsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-triggereventsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTriggerEventSource();

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-rule.html#cfn-connect-rule-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuleProps> {
        java.lang.Object actions;
        java.lang.String function;
        java.lang.String instanceArn;
        java.lang.String name;
        java.lang.String publishStatus;
        java.lang.Object triggerEventSource;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRuleProps#getActions}
         * @param actions A list of actions to be run when the rule is triggered. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getActions}
         * @param actions A list of actions to be run when the rule is triggered. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.services.connect.CfnRule.ActionsProperty actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getFunction}
         * @param function The conditions of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder function(java.lang.String function) {
            this.function = function;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getInstanceArn}
         * @param instanceArn The Amazon Resource Name (ARN) of the instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getName}
         * @param name The name of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getPublishStatus}
         * @param publishStatus The publish status of the rule. This parameter is required.
         *                      <em>Allowed values</em> : <code>DRAFT</code> | <code>PUBLISHED</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishStatus(java.lang.String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getTriggerEventSource}
         * @param triggerEventSource The event source to trigger the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerEventSource(software.amazon.awscdk.IResolvable triggerEventSource) {
            this.triggerEventSource = triggerEventSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getTriggerEventSource}
         * @param triggerEventSource The event source to trigger the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerEventSource(software.amazon.awscdk.services.connect.CfnRule.RuleTriggerEventSourceProperty triggerEventSource) {
            this.triggerEventSource = triggerEventSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleProps {
        private final java.lang.Object actions;
        private final java.lang.String function;
        private final java.lang.String instanceArn;
        private final java.lang.String name;
        private final java.lang.String publishStatus;
        private final java.lang.Object triggerEventSource;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishStatus = software.amazon.jsii.Kernel.get(this, "publishStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.triggerEventSource = software.amazon.jsii.Kernel.get(this, "triggerEventSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.function = java.util.Objects.requireNonNull(builder.function, "function is required");
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.publishStatus = java.util.Objects.requireNonNull(builder.publishStatus, "publishStatus is required");
            this.triggerEventSource = java.util.Objects.requireNonNull(builder.triggerEventSource, "triggerEventSource is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.String getFunction() {
            return this.function;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPublishStatus() {
            return this.publishStatus;
        }

        @Override
        public final java.lang.Object getTriggerEventSource() {
            return this.triggerEventSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("function", om.valueToTree(this.getFunction()));
            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("publishStatus", om.valueToTree(this.getPublishStatus()));
            data.set("triggerEventSource", om.valueToTree(this.getTriggerEventSource()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleProps.Jsii$Proxy that = (CfnRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!function.equals(that.function)) return false;
            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!name.equals(that.name)) return false;
            if (!publishStatus.equals(that.publishStatus)) return false;
            if (!triggerEventSource.equals(that.triggerEventSource)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.function.hashCode());
            result = 31 * result + (this.instanceArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.publishStatus.hashCode());
            result = 31 * result + (this.triggerEventSource.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
