package software.amazon.awscdk.services.dms;

/**
 * Provides information that defines a migration project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnMigrationProject cfnMigrationProject = CfnMigrationProject.Builder.create(this, "MyCfnMigrationProject")
 *         .description("description")
 *         .instanceProfileArn("instanceProfileArn")
 *         .instanceProfileIdentifier("instanceProfileIdentifier")
 *         .instanceProfileName("instanceProfileName")
 *         .migrationProjectCreationTime("migrationProjectCreationTime")
 *         .migrationProjectIdentifier("migrationProjectIdentifier")
 *         .migrationProjectName("migrationProjectName")
 *         .schemaConversionApplicationAttributes(SchemaConversionApplicationAttributesProperty.builder()
 *                 .s3BucketPath("s3BucketPath")
 *                 .s3BucketRoleArn("s3BucketRoleArn")
 *                 .build())
 *         .sourceDataProviderDescriptors(List.of(DataProviderDescriptorProperty.builder()
 *                 .dataProviderArn("dataProviderArn")
 *                 .dataProviderIdentifier("dataProviderIdentifier")
 *                 .dataProviderName("dataProviderName")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetDataProviderDescriptors(List.of(DataProviderDescriptorProperty.builder()
 *                 .dataProviderArn("dataProviderArn")
 *                 .dataProviderIdentifier("dataProviderIdentifier")
 *                 .dataProviderName("dataProviderName")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build()))
 *         .transformationRules("transformationRules")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:15.825Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnMigrationProject")
public class CfnMigrationProject extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMigrationProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMigrationProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnMigrationProject.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMigrationProject(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnMigrationProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMigrationProject(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN string that uniquely identifies the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMigrationProjectArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMigrationProjectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A user-friendly description of the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-friendly description of the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the instance profile for your migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance profile for your migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceProfileArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceProfileArn", value);
    }

    /**
     * The identifier of the instance profile for your migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the instance profile for your migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceProfileIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceProfileIdentifier", value);
    }

    /**
     * The name of the associated instance profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileName() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the associated instance profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceProfileName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceProfileName", value);
    }

    /**
     * (deprecated) The property describes a creating time of the migration project.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getMigrationProjectCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "migrationProjectCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) The property describes a creating time of the migration project.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setMigrationProjectCreationTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "migrationProjectCreationTime", value);
    }

    /**
     * The identifier of the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMigrationProjectIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "migrationProjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMigrationProjectIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "migrationProjectIdentifier", value);
    }

    /**
     * The name of the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMigrationProjectName() {
        return software.amazon.jsii.Kernel.get(this, "migrationProjectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMigrationProjectName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "migrationProjectName", value);
    }

    /**
     * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchemaConversionApplicationAttributes() {
        return software.amazon.jsii.Kernel.get(this, "schemaConversionApplicationAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaConversionApplicationAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schemaConversionApplicationAttributes", value);
    }

    /**
     * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaConversionApplicationAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnMigrationProject.SchemaConversionApplicationAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "schemaConversionApplicationAttributes", value);
    }

    /**
     * Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceDataProviderDescriptors() {
        return software.amazon.jsii.Kernel.get(this, "sourceDataProviderDescriptors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDataProviderDescriptors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceDataProviderDescriptors", value);
    }

    /**
     * Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDataProviderDescriptors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dms.CfnMigrationProject.DataProviderDescriptorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dms.CfnMigrationProject.DataProviderDescriptorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sourceDataProviderDescriptors", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetDataProviderDescriptors() {
        return software.amazon.jsii.Kernel.get(this, "targetDataProviderDescriptors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetDataProviderDescriptors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetDataProviderDescriptors", value);
    }

    /**
     * Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetDataProviderDescriptors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dms.CfnMigrationProject.DataProviderDescriptorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dms.CfnMigrationProject.DataProviderDescriptorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "targetDataProviderDescriptors", value);
    }

    /**
     * The settings in JSON format for migration rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransformationRules() {
        return software.amazon.jsii.Kernel.get(this, "transformationRules", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The settings in JSON format for migration rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformationRules(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transformationRules", value);
    }
    /**
     * Information about a data provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DataProviderDescriptorProperty dataProviderDescriptorProperty = DataProviderDescriptorProperty.builder()
     *         .dataProviderArn("dataProviderArn")
     *         .dataProviderIdentifier("dataProviderIdentifier")
     *         .dataProviderName("dataProviderName")
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnMigrationProject.DataProviderDescriptorProperty")
    @software.amazon.jsii.Jsii.Proxy(DataProviderDescriptorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataProviderDescriptorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the data provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-dataproviderarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-dataproviderarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataProviderArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-dataprovideridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-dataprovideridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataProviderIdentifier() {
            return null;
        }

        /**
         * The user-friendly name of the data provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-dataprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-dataprovidername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataProviderName() {
            return null;
        }

        /**
         * The ARN of the role used to access AWS Secrets Manager.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-dataproviderdescriptor.html#cfn-dms-migrationproject-dataproviderdescriptor-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataProviderDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataProviderDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataProviderDescriptorProperty> {
            java.lang.String dataProviderArn;
            java.lang.String dataProviderIdentifier;
            java.lang.String dataProviderName;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link DataProviderDescriptorProperty#getDataProviderArn}
             * @param dataProviderArn The Amazon Resource Name (ARN) of the data provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataProviderArn(java.lang.String dataProviderArn) {
                this.dataProviderArn = dataProviderArn;
                return this;
            }

            /**
             * Sets the value of {@link DataProviderDescriptorProperty#getDataProviderIdentifier}
             * @param dataProviderIdentifier the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataProviderIdentifier(java.lang.String dataProviderIdentifier) {
                this.dataProviderIdentifier = dataProviderIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link DataProviderDescriptorProperty#getDataProviderName}
             * @param dataProviderName The user-friendly name of the data provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataProviderName(java.lang.String dataProviderName) {
                this.dataProviderName = dataProviderName;
                return this;
            }

            /**
             * Sets the value of {@link DataProviderDescriptorProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The ARN of the role used to access AWS Secrets Manager.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link DataProviderDescriptorProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataProviderDescriptorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataProviderDescriptorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataProviderDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProviderDescriptorProperty {
            private final java.lang.String dataProviderArn;
            private final java.lang.String dataProviderIdentifier;
            private final java.lang.String dataProviderName;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataProviderArn = software.amazon.jsii.Kernel.get(this, "dataProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataProviderIdentifier = software.amazon.jsii.Kernel.get(this, "dataProviderIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataProviderName = software.amazon.jsii.Kernel.get(this, "dataProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataProviderArn = builder.dataProviderArn;
                this.dataProviderIdentifier = builder.dataProviderIdentifier;
                this.dataProviderName = builder.dataProviderName;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getDataProviderArn() {
                return this.dataProviderArn;
            }

            @Override
            public final java.lang.String getDataProviderIdentifier() {
                return this.dataProviderIdentifier;
            }

            @Override
            public final java.lang.String getDataProviderName() {
                return this.dataProviderName;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataProviderArn() != null) {
                    data.set("dataProviderArn", om.valueToTree(this.getDataProviderArn()));
                }
                if (this.getDataProviderIdentifier() != null) {
                    data.set("dataProviderIdentifier", om.valueToTree(this.getDataProviderIdentifier()));
                }
                if (this.getDataProviderName() != null) {
                    data.set("dataProviderName", om.valueToTree(this.getDataProviderName()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnMigrationProject.DataProviderDescriptorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataProviderDescriptorProperty.Jsii$Proxy that = (DataProviderDescriptorProperty.Jsii$Proxy) o;

                if (this.dataProviderArn != null ? !this.dataProviderArn.equals(that.dataProviderArn) : that.dataProviderArn != null) return false;
                if (this.dataProviderIdentifier != null ? !this.dataProviderIdentifier.equals(that.dataProviderIdentifier) : that.dataProviderIdentifier != null) return false;
                if (this.dataProviderName != null ? !this.dataProviderName.equals(that.dataProviderName) : that.dataProviderName != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataProviderArn != null ? this.dataProviderArn.hashCode() : 0;
                result = 31 * result + (this.dataProviderIdentifier != null ? this.dataProviderIdentifier.hashCode() : 0);
                result = 31 * result + (this.dataProviderName != null ? this.dataProviderName.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The property describes schema conversion application attributes for the migration project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * SchemaConversionApplicationAttributesProperty schemaConversionApplicationAttributesProperty = SchemaConversionApplicationAttributesProperty.builder()
     *         .s3BucketPath("s3BucketPath")
     *         .s3BucketRoleArn("s3BucketRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-schemaconversionapplicationattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-schemaconversionapplicationattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnMigrationProject.SchemaConversionApplicationAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaConversionApplicationAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaConversionApplicationAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-schemaconversionapplicationattributes.html#cfn-dms-migrationproject-schemaconversionapplicationattributes-s3bucketpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-schemaconversionapplicationattributes.html#cfn-dms-migrationproject-schemaconversionapplicationattributes-s3bucketpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketPath() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-schemaconversionapplicationattributes.html#cfn-dms-migrationproject-schemaconversionapplicationattributes-s3bucketrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-migrationproject-schemaconversionapplicationattributes.html#cfn-dms-migrationproject-schemaconversionapplicationattributes-s3bucketrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaConversionApplicationAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaConversionApplicationAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaConversionApplicationAttributesProperty> {
            java.lang.String s3BucketPath;
            java.lang.String s3BucketRoleArn;

            /**
             * Sets the value of {@link SchemaConversionApplicationAttributesProperty#getS3BucketPath}
             * @param s3BucketPath the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketPath(java.lang.String s3BucketPath) {
                this.s3BucketPath = s3BucketPath;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConversionApplicationAttributesProperty#getS3BucketRoleArn}
             * @param s3BucketRoleArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketRoleArn(java.lang.String s3BucketRoleArn) {
                this.s3BucketRoleArn = s3BucketRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaConversionApplicationAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaConversionApplicationAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaConversionApplicationAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaConversionApplicationAttributesProperty {
            private final java.lang.String s3BucketPath;
            private final java.lang.String s3BucketRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketPath = software.amazon.jsii.Kernel.get(this, "s3BucketPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketRoleArn = software.amazon.jsii.Kernel.get(this, "s3BucketRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketPath = builder.s3BucketPath;
                this.s3BucketRoleArn = builder.s3BucketRoleArn;
            }

            @Override
            public final java.lang.String getS3BucketPath() {
                return this.s3BucketPath;
            }

            @Override
            public final java.lang.String getS3BucketRoleArn() {
                return this.s3BucketRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3BucketPath() != null) {
                    data.set("s3BucketPath", om.valueToTree(this.getS3BucketPath()));
                }
                if (this.getS3BucketRoleArn() != null) {
                    data.set("s3BucketRoleArn", om.valueToTree(this.getS3BucketRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnMigrationProject.SchemaConversionApplicationAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaConversionApplicationAttributesProperty.Jsii$Proxy that = (SchemaConversionApplicationAttributesProperty.Jsii$Proxy) o;

                if (this.s3BucketPath != null ? !this.s3BucketPath.equals(that.s3BucketPath) : that.s3BucketPath != null) return false;
                return this.s3BucketRoleArn != null ? this.s3BucketRoleArn.equals(that.s3BucketRoleArn) : that.s3BucketRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketPath != null ? this.s3BucketPath.hashCode() : 0;
                result = 31 * result + (this.s3BucketRoleArn != null ? this.s3BucketRoleArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnMigrationProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnMigrationProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.dms.CfnMigrationProjectProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A user-friendly description of the migration project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-description</a>
         * @param description A user-friendly description of the migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the instance profile for your migration project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilearn</a>
         * @param instanceProfileArn The Amazon Resource Name (ARN) of the instance profile for your migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileArn(final java.lang.String instanceProfileArn) {
            this.props().instanceProfileArn(instanceProfileArn);
            return this;
        }

        /**
         * The identifier of the instance profile for your migration project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofileidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofileidentifier</a>
         * @param instanceProfileIdentifier The identifier of the instance profile for your migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileIdentifier(final java.lang.String instanceProfileIdentifier) {
            this.props().instanceProfileIdentifier(instanceProfileIdentifier);
            return this;
        }

        /**
         * The name of the associated instance profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilename</a>
         * @param instanceProfileName The name of the associated instance profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileName(final java.lang.String instanceProfileName) {
            this.props().instanceProfileName(instanceProfileName);
            return this;
        }

        /**
         * (deprecated) The property describes a creating time of the migration project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectcreationtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectcreationtime</a>
         * @deprecated this property has been deprecated
         * @param migrationProjectCreationTime The property describes a creating time of the migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder migrationProjectCreationTime(final java.lang.String migrationProjectCreationTime) {
            this.props().migrationProjectCreationTime(migrationProjectCreationTime);
            return this;
        }

        /**
         * The identifier of the migration project.
         * <p>
         * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectidentifier</a>
         * @param migrationProjectIdentifier The identifier of the migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationProjectIdentifier(final java.lang.String migrationProjectIdentifier) {
            this.props().migrationProjectIdentifier(migrationProjectIdentifier);
            return this;
        }

        /**
         * The name of the migration project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectname</a>
         * @param migrationProjectName The name of the migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationProjectName(final java.lang.String migrationProjectName) {
            this.props().migrationProjectName(migrationProjectName);
            return this;
        }

        /**
         * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-schemaconversionapplicationattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-schemaconversionapplicationattributes</a>
         * @param schemaConversionApplicationAttributes The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaConversionApplicationAttributes(final software.amazon.awscdk.IResolvable schemaConversionApplicationAttributes) {
            this.props().schemaConversionApplicationAttributes(schemaConversionApplicationAttributes);
            return this;
        }
        /**
         * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-schemaconversionapplicationattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-schemaconversionapplicationattributes</a>
         * @param schemaConversionApplicationAttributes The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaConversionApplicationAttributes(final software.amazon.awscdk.services.dms.CfnMigrationProject.SchemaConversionApplicationAttributesProperty schemaConversionApplicationAttributes) {
            this.props().schemaConversionApplicationAttributes(schemaConversionApplicationAttributes);
            return this;
        }

        /**
         * Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-sourcedataproviderdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-sourcedataproviderdescriptors</a>
         * @param sourceDataProviderDescriptors Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataProviderDescriptors(final software.amazon.awscdk.IResolvable sourceDataProviderDescriptors) {
            this.props().sourceDataProviderDescriptors(sourceDataProviderDescriptors);
            return this;
        }
        /**
         * Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-sourcedataproviderdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-sourcedataproviderdescriptors</a>
         * @param sourceDataProviderDescriptors Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataProviderDescriptors(final java.util.List<? extends java.lang.Object> sourceDataProviderDescriptors) {
            this.props().sourceDataProviderDescriptors(sourceDataProviderDescriptors);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-targetdataproviderdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-targetdataproviderdescriptors</a>
         * @param targetDataProviderDescriptors Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetDataProviderDescriptors(final software.amazon.awscdk.IResolvable targetDataProviderDescriptors) {
            this.props().targetDataProviderDescriptors(targetDataProviderDescriptors);
            return this;
        }
        /**
         * Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-targetdataproviderdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-targetdataproviderdescriptors</a>
         * @param targetDataProviderDescriptors Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetDataProviderDescriptors(final java.util.List<? extends java.lang.Object> targetDataProviderDescriptors) {
            this.props().targetDataProviderDescriptors(targetDataProviderDescriptors);
            return this;
        }

        /**
         * The settings in JSON format for migration rules.
         * <p>
         * Migration rules make it possible for you to change the object names according to the rules that you specify. For example, you can change an object name to lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-transformationrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-transformationrules</a>
         * @param transformationRules The settings in JSON format for migration rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformationRules(final java.lang.String transformationRules) {
            this.props().transformationRules(transformationRules);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dms.CfnMigrationProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnMigrationProject build() {
            return new software.amazon.awscdk.services.dms.CfnMigrationProject(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.dms.CfnMigrationProjectProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.dms.CfnMigrationProjectProps.Builder();
            }
            return this.props;
        }
    }
}
