package software.amazon.awscdk.services.dynamodb;

/**
 * The format of the source data.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * IBucket bucket;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * Table.Builder.create(stack, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .importSource(ImportSourceSpecification.builder()
 *                 .compressionType(InputCompressionType.GZIP)
 *                 .inputFormat(InputFormat.dynamoDBJson())
 *                 .bucket(bucket)
 *                 .keyPrefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:15.977Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.InputFormat")
public abstract class InputFormat extends software.amazon.jsii.JsiiObject {

    protected InputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected InputFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * CSV format.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.InputFormat csv(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CsvOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.InputFormat.class, "csv", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.InputFormat.class), new Object[] { options });
    }

    /**
     * CSV format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.InputFormat csv() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.InputFormat.class, "csv", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.InputFormat.class));
    }

    /**
     * DynamoDB JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.InputFormat dynamoDBJson() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.InputFormat.class, "dynamoDBJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.InputFormat.class));
    }

    /**
     * Amazon Ion format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.InputFormat ion() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.InputFormat.class, "ion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.InputFormat.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.dynamodb.InputFormat {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
