package software.amazon.awscdk.services.ec2;

/**
 * IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts throughout your AWS Organization.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
 * <p>
 * There are AWS Identity and Access Management (IAM) permissions required to fully manage an IPAM in CloudFormation. For more information, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/iam-ipam-policy-examples.html">Example policy</a> in the <em>Amazon VPC IPAM User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnIPAM cfnIPAM = CfnIPAM.Builder.create(this, "MyCfnIPAM")
 *         .defaultResourceDiscoveryOrganizationalUnitExclusions(List.of(IpamOrganizationalUnitExclusionProperty.builder()
 *                 .organizationsEntityPath("organizationsEntityPath")
 *                 .build()))
 *         .description("description")
 *         .enablePrivateGua(false)
 *         .operatingRegions(List.of(IpamOperatingRegionProperty.builder()
 *                 .regionName("regionName")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tier("tier")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:16.169Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnIPAM")
public class CfnIPAM extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnIPAM(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIPAM(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnIPAM.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIPAM(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnIPAMProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIPAM(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the default resource discovery association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDefaultResourceDiscoveryAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "attrDefaultResourceDiscoveryAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the default resource discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDefaultResourceDiscoveryId() {
        return software.amazon.jsii.Kernel.get(this, "attrDefaultResourceDiscoveryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamId() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the default private scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrivateDefaultScopeId() {
        return software.amazon.jsii.Kernel.get(this, "attrPrivateDefaultScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the default public scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPublicDefaultScopeId() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicDefaultScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of resource discovery associations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrResourceDiscoveryAssociationCount() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceDiscoveryAssociationCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of scopes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrScopeCount() {
        return software.amazon.jsii.Kernel.get(this, "attrScopeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceDiscoveryOrganizationalUnitExclusions() {
        return software.amazon.jsii.Kernel.get(this, "defaultResourceDiscoveryOrganizationalUnitExclusions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultResourceDiscoveryOrganizationalUnitExclusions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultResourceDiscoveryOrganizationalUnitExclusions", value);
    }

    /**
     * If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultResourceDiscoveryOrganizationalUnitExclusions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnIPAM.IpamOrganizationalUnitExclusionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnIPAM.IpamOrganizationalUnitExclusionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "defaultResourceDiscoveryOrganizationalUnitExclusions", value);
    }

    /**
     * The description for the IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for the IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Enable this option to use your own GUA ranges as private IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnablePrivateGua() {
        return software.amazon.jsii.Kernel.get(this, "enablePrivateGua", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enable this option to use your own GUA ranges as private IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePrivateGua(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enablePrivateGua", value);
    }

    /**
     * Enable this option to use your own GUA ranges as private IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePrivateGua(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enablePrivateGua", value);
    }

    /**
     * The operating Regions for an IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOperatingRegions() {
        return software.amazon.jsii.Kernel.get(this, "operatingRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The operating Regions for an IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperatingRegions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "operatingRegions", value);
    }

    /**
     * The operating Regions for an IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperatingRegions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnIPAM.IpamOperatingRegionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnIPAM.IpamOperatingRegionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "operatingRegions", value);
    }

    /**
     * The key/value combination of a tag assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The key/value combination of a tag assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * IPAM is offered in a Free Tier and an Advanced Tier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTier() {
        return software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * IPAM is offered in a Free Tier and an Advanced Tier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tier", value);
    }
    /**
     * The operating Regions for an IPAM.
     * <p>
     * Operating Regions are AWS Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the AWS Regions you select as operating Regions.
     * <p>
     * For more information about operating Regions, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IpamOperatingRegionProperty ipamOperatingRegionProperty = IpamOperatingRegionProperty.builder()
     *         .regionName("regionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamoperatingregion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamoperatingregion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnIPAM.IpamOperatingRegionProperty")
    @software.amazon.jsii.Jsii.Proxy(IpamOperatingRegionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IpamOperatingRegionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the operating Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamoperatingregion.html#cfn-ec2-ipam-ipamoperatingregion-regionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamoperatingregion.html#cfn-ec2-ipam-ipamoperatingregion-regionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegionName();

        /**
         * @return a {@link Builder} of {@link IpamOperatingRegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IpamOperatingRegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IpamOperatingRegionProperty> {
            java.lang.String regionName;

            /**
             * Sets the value of {@link IpamOperatingRegionProperty#getRegionName}
             * @param regionName The name of the operating Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionName(java.lang.String regionName) {
                this.regionName = regionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IpamOperatingRegionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IpamOperatingRegionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IpamOperatingRegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpamOperatingRegionProperty {
            private final java.lang.String regionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.regionName = software.amazon.jsii.Kernel.get(this, "regionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.regionName = java.util.Objects.requireNonNull(builder.regionName, "regionName is required");
            }

            @Override
            public final java.lang.String getRegionName() {
                return this.regionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("regionName", om.valueToTree(this.getRegionName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnIPAM.IpamOperatingRegionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IpamOperatingRegionProperty.Jsii$Proxy that = (IpamOperatingRegionProperty.Jsii$Proxy) o;

                return this.regionName.equals(that.regionName);
            }

            @Override
            public final int hashCode() {
                int result = this.regionName.hashCode();
                return result;
            }
        }
    }
    /**
     * If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IpamOrganizationalUnitExclusionProperty ipamOrganizationalUnitExclusionProperty = IpamOrganizationalUnitExclusionProperty.builder()
     *         .organizationsEntityPath("organizationsEntityPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamorganizationalunitexclusion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamorganizationalunitexclusion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnIPAM.IpamOrganizationalUnitExclusionProperty")
    @software.amazon.jsii.Jsii.Proxy(IpamOrganizationalUnitExclusionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IpamOrganizationalUnitExclusionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS Organizations entity path.
         * <p>
         * For more information on the entity path, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path">Understand the AWS Organizations entity path</a> in the <em>AWS Identity and Access Management User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamorganizationalunitexclusion.html#cfn-ec2-ipam-ipamorganizationalunitexclusion-organizationsentitypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipam-ipamorganizationalunitexclusion.html#cfn-ec2-ipam-ipamorganizationalunitexclusion-organizationsentitypath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOrganizationsEntityPath();

        /**
         * @return a {@link Builder} of {@link IpamOrganizationalUnitExclusionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IpamOrganizationalUnitExclusionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IpamOrganizationalUnitExclusionProperty> {
            java.lang.String organizationsEntityPath;

            /**
             * Sets the value of {@link IpamOrganizationalUnitExclusionProperty#getOrganizationsEntityPath}
             * @param organizationsEntityPath An AWS Organizations entity path. This parameter is required.
             *                                For more information on the entity path, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path">Understand the AWS Organizations entity path</a> in the <em>AWS Identity and Access Management User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationsEntityPath(java.lang.String organizationsEntityPath) {
                this.organizationsEntityPath = organizationsEntityPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IpamOrganizationalUnitExclusionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IpamOrganizationalUnitExclusionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IpamOrganizationalUnitExclusionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpamOrganizationalUnitExclusionProperty {
            private final java.lang.String organizationsEntityPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.organizationsEntityPath = software.amazon.jsii.Kernel.get(this, "organizationsEntityPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.organizationsEntityPath = java.util.Objects.requireNonNull(builder.organizationsEntityPath, "organizationsEntityPath is required");
            }

            @Override
            public final java.lang.String getOrganizationsEntityPath() {
                return this.organizationsEntityPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("organizationsEntityPath", om.valueToTree(this.getOrganizationsEntityPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnIPAM.IpamOrganizationalUnitExclusionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IpamOrganizationalUnitExclusionProperty.Jsii$Proxy that = (IpamOrganizationalUnitExclusionProperty.Jsii$Proxy) o;

                return this.organizationsEntityPath.equals(that.organizationsEntityPath);
            }

            @Override
            public final int hashCode() {
                int result = this.organizationsEntityPath.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnIPAM}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnIPAM> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnIPAMProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-defaultresourcediscoveryorganizationalunitexclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-defaultresourcediscoveryorganizationalunitexclusions</a>
         * @param defaultResourceDiscoveryOrganizationalUnitExclusions If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResourceDiscoveryOrganizationalUnitExclusions(final software.amazon.awscdk.IResolvable defaultResourceDiscoveryOrganizationalUnitExclusions) {
            this.props().defaultResourceDiscoveryOrganizationalUnitExclusions(defaultResourceDiscoveryOrganizationalUnitExclusions);
            return this;
        }
        /**
         * If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-defaultresourcediscoveryorganizationalunitexclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-defaultresourcediscoveryorganizationalunitexclusions</a>
         * @param defaultResourceDiscoveryOrganizationalUnitExclusions If your IPAM is integrated with AWS Organizations, you can exclude an <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#organizationalunit">organizational unit (OU)</a> from being managed by IPAM. When you exclude an OU, IPAM will not manage the IP addresses in accounts in that OU. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html">Exclude organizational units from IPAM</a> in the <em>Amazon Virtual Private Cloud IP Address Manager User Guide</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResourceDiscoveryOrganizationalUnitExclusions(final java.util.List<? extends java.lang.Object> defaultResourceDiscoveryOrganizationalUnitExclusions) {
            this.props().defaultResourceDiscoveryOrganizationalUnitExclusions(defaultResourceDiscoveryOrganizationalUnitExclusions);
            return this;
        }

        /**
         * The description for the IPAM.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-description</a>
         * @param description The description for the IPAM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Enable this option to use your own GUA ranges as private IPv6 addresses.
         * <p>
         * This option is disabled by default.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-enableprivategua">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-enableprivategua</a>
         * @param enablePrivateGua Enable this option to use your own GUA ranges as private IPv6 addresses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePrivateGua(final java.lang.Boolean enablePrivateGua) {
            this.props().enablePrivateGua(enablePrivateGua);
            return this;
        }
        /**
         * Enable this option to use your own GUA ranges as private IPv6 addresses.
         * <p>
         * This option is disabled by default.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-enableprivategua">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-enableprivategua</a>
         * @param enablePrivateGua Enable this option to use your own GUA ranges as private IPv6 addresses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePrivateGua(final software.amazon.awscdk.IResolvable enablePrivateGua) {
            this.props().enablePrivateGua(enablePrivateGua);
            return this;
        }

        /**
         * The operating Regions for an IPAM.
         * <p>
         * Operating Regions are AWS Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the AWS Regions you select as operating Regions.
         * <p>
         * For more information about operating Regions, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-operatingregions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-operatingregions</a>
         * @param operatingRegions The operating Regions for an IPAM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingRegions(final software.amazon.awscdk.IResolvable operatingRegions) {
            this.props().operatingRegions(operatingRegions);
            return this;
        }
        /**
         * The operating Regions for an IPAM.
         * <p>
         * Operating Regions are AWS Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the AWS Regions you select as operating Regions.
         * <p>
         * For more information about operating Regions, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-operatingregions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-operatingregions</a>
         * @param operatingRegions The operating Regions for an IPAM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingRegions(final java.util.List<? extends java.lang.Object> operatingRegions) {
            this.props().operatingRegions(operatingRegions);
            return this;
        }

        /**
         * The key/value combination of a tag assigned to the resource.
         * <p>
         * Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code> , specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-tags</a>
         * @param tags The key/value combination of a tag assigned to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * IPAM is offered in a Free Tier and an Advanced Tier.
         * <p>
         * For more information about the features available in each tier and the costs associated with the tiers, see the <a href="https://docs.aws.amazon.com//vpc/pricing/">VPC IPAM product pricing page</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipam.html#cfn-ec2-ipam-tier</a>
         * @param tier IPAM is offered in a Free Tier and an Advanced Tier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(final java.lang.String tier) {
            this.props().tier(tier);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnIPAM}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnIPAM build() {
            return new software.amazon.awscdk.services.ec2.CfnIPAM(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnIPAMProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnIPAMProps.Builder();
            }
            return this.props;
        }
    }
}
