package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVerifiedAccessEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVerifiedAccessEndpointProps cfnVerifiedAccessEndpointProps = CfnVerifiedAccessEndpointProps.builder()
 *         .attachmentType("attachmentType")
 *         .endpointType("endpointType")
 *         .verifiedAccessGroupId("verifiedAccessGroupId")
 *         // the properties below are optional
 *         .applicationDomain("applicationDomain")
 *         .cidrOptions(CidrOptionsProperty.builder()
 *                 .cidr("cidr")
 *                 .portRanges(List.of(PortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build()))
 *                 .protocol("protocol")
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .description("description")
 *         .domainCertificateArn("domainCertificateArn")
 *         .endpointDomainPrefix("endpointDomainPrefix")
 *         .loadBalancerOptions(LoadBalancerOptionsProperty.builder()
 *                 .loadBalancerArn("loadBalancerArn")
 *                 .port(123)
 *                 .portRanges(List.of(PortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build()))
 *                 .protocol("protocol")
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .networkInterfaceOptions(NetworkInterfaceOptionsProperty.builder()
 *                 .networkInterfaceId("networkInterfaceId")
 *                 .port(123)
 *                 .portRanges(List.of(PortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build()))
 *                 .protocol("protocol")
 *                 .build())
 *         .policyDocument("policyDocument")
 *         .policyEnabled(false)
 *         .rdsOptions(RdsOptionsProperty.builder()
 *                 .port(123)
 *                 .protocol("protocol")
 *                 .rdsDbClusterArn("rdsDbClusterArn")
 *                 .rdsDbInstanceArn("rdsDbInstanceArn")
 *                 .rdsDbProxyArn("rdsDbProxyArn")
 *                 .rdsEndpoint("rdsEndpoint")
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .sseSpecification(SseSpecificationProperty.builder()
 *                 .customerManagedKeyEnabled(false)
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:16.518Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVerifiedAccessEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnVerifiedAccessEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVerifiedAccessEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of attachment used to provide connectivity between the AWS Verified Access endpoint and the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-attachmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-attachmenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAttachmentType();

    /**
     * The type of AWS Verified Access endpoint.
     * <p>
     * Incoming application requests will be sent to an IP address, load balancer or a network interface depending on the endpoint type specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-endpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-endpointtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointType();

    /**
     * The ID of the AWS Verified Access group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-verifiedaccessgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-verifiedaccessgroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVerifiedAccessGroupId();

    /**
     * The DNS name for users to reach your application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-applicationdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-applicationdomain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationDomain() {
        return null;
    }

    /**
     * The options for a CIDR endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-cidroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-cidroptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCidrOptions() {
        return null;
    }

    /**
     * A description for the AWS Verified Access endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ARN of a public TLS/SSL certificate imported into or created with ACM.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-domaincertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-domaincertificatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainCertificateArn() {
        return null;
    }

    /**
     * A custom identifier that is prepended to the DNS name that is generated for the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-endpointdomainprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-endpointdomainprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointDomainPrefix() {
        return null;
    }

    /**
     * The load balancer details if creating the AWS Verified Access endpoint as <code>load-balancer</code> type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-loadbalanceroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-loadbalanceroptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerOptions() {
        return null;
    }

    /**
     * The options for network-interface type endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-networkinterfaceoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-networkinterfaceoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceOptions() {
        return null;
    }

    /**
     * The Verified Access policy document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-policydocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyDocument() {
        return null;
    }

    /**
     * The status of the Verified Access policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-policyenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-policyenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyEnabled() {
        return null;
    }

    /**
     * The options for an RDS endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-rdsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-rdsoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRdsOptions() {
        return null;
    }

    /**
     * The IDs of the security groups for the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The options for additional server side encryption.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-ssespecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * The tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessendpoint.html#cfn-ec2-verifiedaccessendpoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVerifiedAccessEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVerifiedAccessEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVerifiedAccessEndpointProps> {
        java.lang.String attachmentType;
        java.lang.String endpointType;
        java.lang.String verifiedAccessGroupId;
        java.lang.String applicationDomain;
        java.lang.Object cidrOptions;
        java.lang.String description;
        java.lang.String domainCertificateArn;
        java.lang.String endpointDomainPrefix;
        java.lang.Object loadBalancerOptions;
        java.lang.Object networkInterfaceOptions;
        java.lang.String policyDocument;
        java.lang.Object policyEnabled;
        java.lang.Object rdsOptions;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.Object sseSpecification;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getAttachmentType}
         * @param attachmentType The type of attachment used to provide connectivity between the AWS Verified Access endpoint and the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachmentType(java.lang.String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getEndpointType}
         * @param endpointType The type of AWS Verified Access endpoint. This parameter is required.
         *                     Incoming application requests will be sent to an IP address, load balancer or a network interface depending on the endpoint type specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(java.lang.String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getVerifiedAccessGroupId}
         * @param verifiedAccessGroupId The ID of the AWS Verified Access group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessGroupId(java.lang.String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getApplicationDomain}
         * @param applicationDomain The DNS name for users to reach your application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationDomain(java.lang.String applicationDomain) {
            this.applicationDomain = applicationDomain;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getCidrOptions}
         * @param cidrOptions The options for a CIDR endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrOptions(software.amazon.awscdk.IResolvable cidrOptions) {
            this.cidrOptions = cidrOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getCidrOptions}
         * @param cidrOptions The options for a CIDR endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrOptions(software.amazon.awscdk.services.ec2.CfnVerifiedAccessEndpoint.CidrOptionsProperty cidrOptions) {
            this.cidrOptions = cidrOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getDescription}
         * @param description A description for the AWS Verified Access endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getDomainCertificateArn}
         * @param domainCertificateArn The ARN of a public TLS/SSL certificate imported into or created with ACM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainCertificateArn(java.lang.String domainCertificateArn) {
            this.domainCertificateArn = domainCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getEndpointDomainPrefix}
         * @param endpointDomainPrefix A custom identifier that is prepended to the DNS name that is generated for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDomainPrefix(java.lang.String endpointDomainPrefix) {
            this.endpointDomainPrefix = endpointDomainPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getLoadBalancerOptions}
         * @param loadBalancerOptions The load balancer details if creating the AWS Verified Access endpoint as <code>load-balancer</code> type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerOptions(software.amazon.awscdk.IResolvable loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getLoadBalancerOptions}
         * @param loadBalancerOptions The load balancer details if creating the AWS Verified Access endpoint as <code>load-balancer</code> type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerOptions(software.amazon.awscdk.services.ec2.CfnVerifiedAccessEndpoint.LoadBalancerOptionsProperty loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getNetworkInterfaceOptions}
         * @param networkInterfaceOptions The options for network-interface type endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceOptions(software.amazon.awscdk.IResolvable networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getNetworkInterfaceOptions}
         * @param networkInterfaceOptions The options for network-interface type endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceOptions(software.amazon.awscdk.services.ec2.CfnVerifiedAccessEndpoint.NetworkInterfaceOptionsProperty networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getPolicyDocument}
         * @param policyDocument The Verified Access policy document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getPolicyEnabled}
         * @param policyEnabled The status of the Verified Access policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyEnabled(java.lang.Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getPolicyEnabled}
         * @param policyEnabled The status of the Verified Access policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyEnabled(software.amazon.awscdk.IResolvable policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getRdsOptions}
         * @param rdsOptions The options for an RDS endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsOptions(software.amazon.awscdk.IResolvable rdsOptions) {
            this.rdsOptions = rdsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getRdsOptions}
         * @param rdsOptions The options for an RDS endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsOptions(software.amazon.awscdk.services.ec2.CfnVerifiedAccessEndpoint.RdsOptionsProperty rdsOptions) {
            this.rdsOptions = rdsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds The IDs of the security groups for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getSseSpecification}
         * @param sseSpecification The options for additional server side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getSseSpecification}
         * @param sseSpecification The options for additional server side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.services.ec2.CfnVerifiedAccessEndpoint.SseSpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessEndpointProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVerifiedAccessEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVerifiedAccessEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVerifiedAccessEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVerifiedAccessEndpointProps {
        private final java.lang.String attachmentType;
        private final java.lang.String endpointType;
        private final java.lang.String verifiedAccessGroupId;
        private final java.lang.String applicationDomain;
        private final java.lang.Object cidrOptions;
        private final java.lang.String description;
        private final java.lang.String domainCertificateArn;
        private final java.lang.String endpointDomainPrefix;
        private final java.lang.Object loadBalancerOptions;
        private final java.lang.Object networkInterfaceOptions;
        private final java.lang.String policyDocument;
        private final java.lang.Object policyEnabled;
        private final java.lang.Object rdsOptions;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.Object sseSpecification;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attachmentType = software.amazon.jsii.Kernel.get(this, "attachmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.verifiedAccessGroupId = software.amazon.jsii.Kernel.get(this, "verifiedAccessGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationDomain = software.amazon.jsii.Kernel.get(this, "applicationDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrOptions = software.amazon.jsii.Kernel.get(this, "cidrOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainCertificateArn = software.amazon.jsii.Kernel.get(this, "domainCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointDomainPrefix = software.amazon.jsii.Kernel.get(this, "endpointDomainPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerOptions = software.amazon.jsii.Kernel.get(this, "loadBalancerOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkInterfaceOptions = software.amazon.jsii.Kernel.get(this, "networkInterfaceOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyEnabled = software.amazon.jsii.Kernel.get(this, "policyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rdsOptions = software.amazon.jsii.Kernel.get(this, "rdsOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attachmentType = java.util.Objects.requireNonNull(builder.attachmentType, "attachmentType is required");
            this.endpointType = java.util.Objects.requireNonNull(builder.endpointType, "endpointType is required");
            this.verifiedAccessGroupId = java.util.Objects.requireNonNull(builder.verifiedAccessGroupId, "verifiedAccessGroupId is required");
            this.applicationDomain = builder.applicationDomain;
            this.cidrOptions = builder.cidrOptions;
            this.description = builder.description;
            this.domainCertificateArn = builder.domainCertificateArn;
            this.endpointDomainPrefix = builder.endpointDomainPrefix;
            this.loadBalancerOptions = builder.loadBalancerOptions;
            this.networkInterfaceOptions = builder.networkInterfaceOptions;
            this.policyDocument = builder.policyDocument;
            this.policyEnabled = builder.policyEnabled;
            this.rdsOptions = builder.rdsOptions;
            this.securityGroupIds = builder.securityGroupIds;
            this.sseSpecification = builder.sseSpecification;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAttachmentType() {
            return this.attachmentType;
        }

        @Override
        public final java.lang.String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final java.lang.String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        @Override
        public final java.lang.String getApplicationDomain() {
            return this.applicationDomain;
        }

        @Override
        public final java.lang.Object getCidrOptions() {
            return this.cidrOptions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDomainCertificateArn() {
            return this.domainCertificateArn;
        }

        @Override
        public final java.lang.String getEndpointDomainPrefix() {
            return this.endpointDomainPrefix;
        }

        @Override
        public final java.lang.Object getLoadBalancerOptions() {
            return this.loadBalancerOptions;
        }

        @Override
        public final java.lang.Object getNetworkInterfaceOptions() {
            return this.networkInterfaceOptions;
        }

        @Override
        public final java.lang.String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final java.lang.Object getPolicyEnabled() {
            return this.policyEnabled;
        }

        @Override
        public final java.lang.Object getRdsOptions() {
            return this.rdsOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attachmentType", om.valueToTree(this.getAttachmentType()));
            data.set("endpointType", om.valueToTree(this.getEndpointType()));
            data.set("verifiedAccessGroupId", om.valueToTree(this.getVerifiedAccessGroupId()));
            if (this.getApplicationDomain() != null) {
                data.set("applicationDomain", om.valueToTree(this.getApplicationDomain()));
            }
            if (this.getCidrOptions() != null) {
                data.set("cidrOptions", om.valueToTree(this.getCidrOptions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDomainCertificateArn() != null) {
                data.set("domainCertificateArn", om.valueToTree(this.getDomainCertificateArn()));
            }
            if (this.getEndpointDomainPrefix() != null) {
                data.set("endpointDomainPrefix", om.valueToTree(this.getEndpointDomainPrefix()));
            }
            if (this.getLoadBalancerOptions() != null) {
                data.set("loadBalancerOptions", om.valueToTree(this.getLoadBalancerOptions()));
            }
            if (this.getNetworkInterfaceOptions() != null) {
                data.set("networkInterfaceOptions", om.valueToTree(this.getNetworkInterfaceOptions()));
            }
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }
            if (this.getPolicyEnabled() != null) {
                data.set("policyEnabled", om.valueToTree(this.getPolicyEnabled()));
            }
            if (this.getRdsOptions() != null) {
                data.set("rdsOptions", om.valueToTree(this.getRdsOptions()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVerifiedAccessEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVerifiedAccessEndpointProps.Jsii$Proxy that = (CfnVerifiedAccessEndpointProps.Jsii$Proxy) o;

            if (!attachmentType.equals(that.attachmentType)) return false;
            if (!endpointType.equals(that.endpointType)) return false;
            if (!verifiedAccessGroupId.equals(that.verifiedAccessGroupId)) return false;
            if (this.applicationDomain != null ? !this.applicationDomain.equals(that.applicationDomain) : that.applicationDomain != null) return false;
            if (this.cidrOptions != null ? !this.cidrOptions.equals(that.cidrOptions) : that.cidrOptions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.domainCertificateArn != null ? !this.domainCertificateArn.equals(that.domainCertificateArn) : that.domainCertificateArn != null) return false;
            if (this.endpointDomainPrefix != null ? !this.endpointDomainPrefix.equals(that.endpointDomainPrefix) : that.endpointDomainPrefix != null) return false;
            if (this.loadBalancerOptions != null ? !this.loadBalancerOptions.equals(that.loadBalancerOptions) : that.loadBalancerOptions != null) return false;
            if (this.networkInterfaceOptions != null ? !this.networkInterfaceOptions.equals(that.networkInterfaceOptions) : that.networkInterfaceOptions != null) return false;
            if (this.policyDocument != null ? !this.policyDocument.equals(that.policyDocument) : that.policyDocument != null) return false;
            if (this.policyEnabled != null ? !this.policyEnabled.equals(that.policyEnabled) : that.policyEnabled != null) return false;
            if (this.rdsOptions != null ? !this.rdsOptions.equals(that.rdsOptions) : that.rdsOptions != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attachmentType.hashCode();
            result = 31 * result + (this.endpointType.hashCode());
            result = 31 * result + (this.verifiedAccessGroupId.hashCode());
            result = 31 * result + (this.applicationDomain != null ? this.applicationDomain.hashCode() : 0);
            result = 31 * result + (this.cidrOptions != null ? this.cidrOptions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.domainCertificateArn != null ? this.domainCertificateArn.hashCode() : 0);
            result = 31 * result + (this.endpointDomainPrefix != null ? this.endpointDomainPrefix.hashCode() : 0);
            result = 31 * result + (this.loadBalancerOptions != null ? this.loadBalancerOptions.hashCode() : 0);
            result = 31 * result + (this.networkInterfaceOptions != null ? this.networkInterfaceOptions.hashCode() : 0);
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            result = 31 * result + (this.policyEnabled != null ? this.policyEnabled.hashCode() : 0);
            result = 31 * result + (this.rdsOptions != null ? this.rdsOptions.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
