package software.amazon.awscdk.services.ec2;

/**
 * Properties for a ClientVpnRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * ClientVpnEndpoint clientVpnEndpoint;
 * ClientVpnRouteTarget clientVpnRouteTarget;
 * ClientVpnRouteProps clientVpnRouteProps = ClientVpnRouteProps.builder()
 *         .cidr("cidr")
 *         .target(clientVpnRouteTarget)
 *         // the properties below are optional
 *         .clientVpnEndpoint(clientVpnEndpoint)
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:16.549Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ClientVpnRouteProps")
@software.amazon.jsii.Jsii.Proxy(ClientVpnRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClientVpnRouteProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.ClientVpnRouteOptions {

    /**
     * The client VPN endpoint to which to add the route.
     * <p>
     * Default: clientVpnEndpoint is required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndpoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClientVpnRouteProps> {
        software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint;
        java.lang.String cidr;
        software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target;
        java.lang.String description;

        /**
         * Sets the value of {@link ClientVpnRouteProps#getClientVpnEndpoint}
         * @param clientVpnEndpoint The client VPN endpoint to which to add the route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientVpnEndpoint(software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint) {
            this.clientVpnEndpoint = clientVpnEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnRouteProps#getCidr}
         * @param cidr The IPv4 address range, in CIDR notation, of the route destination. This parameter is required.
         *             For example:
         *             <p>
         *             <ul>
         *             <li>To add a route for Internet access, enter 0.0.0.0/0</li>
         *             <li>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</li>
         *             <li>To add a route for an on-premises network, enter the AWS Site-to-Site VPN
         *             connection's IPv4 CIDR range</li>
         *             <li>To add a route for the local network, enter the client CIDR range</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnRouteProps#getTarget}
         * @param target The target for the route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnRouteProps#getDescription}
         * @param description A brief description of the authorization rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientVpnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClientVpnRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientVpnRouteProps {
        private final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint;
        private final java.lang.String cidr;
        private final software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientVpnEndpoint = software.amazon.jsii.Kernel.get(this, "clientVpnEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IClientVpnEndpoint.class));
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientVpnEndpoint = builder.clientVpnEndpoint;
            this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.description = builder.description;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndpoint() {
            return this.clientVpnEndpoint;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ClientVpnRouteTarget getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClientVpnEndpoint() != null) {
                data.set("clientVpnEndpoint", om.valueToTree(this.getClientVpnEndpoint()));
            }
            data.set("cidr", om.valueToTree(this.getCidr()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.ClientVpnRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientVpnRouteProps.Jsii$Proxy that = (ClientVpnRouteProps.Jsii$Proxy) o;

            if (this.clientVpnEndpoint != null ? !this.clientVpnEndpoint.equals(that.clientVpnEndpoint) : that.clientVpnEndpoint != null) return false;
            if (!cidr.equals(that.cidr)) return false;
            if (!target.equals(that.target)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientVpnEndpoint != null ? this.clientVpnEndpoint.hashCode() : 0;
            result = 31 * result + (this.cidr.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
