package software.amazon.awscdk.services.ec2;

/**
 * The base class for all classes which can be used as <code>MultipartUserData</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * MultipartUserData multipartUserData = new MultipartUserData();
 * UserData commandsUserData = UserData.forLinux();
 * multipartUserData.addUserDataPart(commandsUserData, MultipartBody.SHELL_SCRIPT, true);
 * // Adding commands to the multipartUserData adds them to commandsUserData, and vice-versa.
 * multipartUserData.addCommands("touch /root/multi.txt");
 * commandsUserData.addCommands("touch /root/userdata.txt");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:16.679Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.MultipartBody")
public abstract class MultipartBody extends software.amazon.jsii.JsiiObject {

    protected MultipartBody(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MultipartBody(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CLOUD_BOOTHOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.MultipartBody.class, "CLOUD_BOOTHOOK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SHELL_SCRIPT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.MultipartBody.class, "SHELL_SCRIPT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected MultipartBody() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Constructs the raw <code>MultipartBody</code> using specified body, content type and transfer encoding.
     * <p>
     * When transfer encoding is specified (typically as Base64), it's caller responsibility to convert body to
     * Base64 either by wrapping with <code>Fn.base64</code> or by converting it by other converters.
     * <p>
     * @param opts This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MultipartBody fromRawBody(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MultipartBodyOptions opts) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MultipartBody.class, "fromRawBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MultipartBody.class), new Object[] { java.util.Objects.requireNonNull(opts, "opts is required") });
    }

    /**
     * Constructs the new <code>MultipartBody</code> wrapping existing <code>UserData</code>. Modification to <code>UserData</code> are reflected in subsequent renders of the part.
     * <p>
     * For more information about content types see <code>MultipartBodyOptions.contentType</code>.
     * <p>
     * @param userData user data to wrap into body part. This parameter is required.
     * @param contentType optional content type, if default one should not be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MultipartBody fromUserData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData userData, final @org.jetbrains.annotations.Nullable java.lang.String contentType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MultipartBody.class, "fromUserData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MultipartBody.class), new Object[] { java.util.Objects.requireNonNull(userData, "userData is required"), contentType });
    }

    /**
     * Constructs the new <code>MultipartBody</code> wrapping existing <code>UserData</code>. Modification to <code>UserData</code> are reflected in subsequent renders of the part.
     * <p>
     * For more information about content types see <code>MultipartBodyOptions.contentType</code>.
     * <p>
     * @param userData user data to wrap into body part. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MultipartBody fromUserData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData userData) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MultipartBody.class, "fromUserData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MultipartBody.class), new Object[] { java.util.Objects.requireNonNull(userData, "userData is required") });
    }

    /**
     * Render body part as the string.
     * <p>
     * Subclasses should not add leading nor trailing new line characters (\r \n)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> renderBodyPart();

    /**
     * Content type for boot hooks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUD_BOOTHOOK;

    /**
     * Content type for shell scripts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SHELL_SCRIPT;

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.MultipartBody {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Render body part as the string.
         * <p>
         * Subclasses should not add leading nor trailing new line characters (\r \n)
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> renderBodyPart() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "renderBodyPart", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }
    }
}
