package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the base ApplicationLoadBalancedEc2Service or ApplicationLoadBalancedFargateService service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.route53.*;
 * import software.amazon.awscdk.services.servicediscovery.*;
 * ApplicationLoadBalancer applicationLoadBalancer;
 * Certificate certificate;
 * Cluster cluster;
 * ContainerDefinition containerDefinition;
 * ContainerImage containerImage;
 * HostedZone hostedZone;
 * LogDriver logDriver;
 * INamespace namespace;
 * Role role;
 * Secret secret;
 * Vpc vpc;
 * ApplicationLoadBalancedServiceBaseProps applicationLoadBalancedServiceBaseProps = ApplicationLoadBalancedServiceBaseProps.builder()
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider("capacityProvider")
 *                 // the properties below are optional
 *                 .base(123)
 *                 .weight(123)
 *                 .build()))
 *         .certificate(certificate)
 *         .circuitBreaker(DeploymentCircuitBreaker.builder()
 *                 .enable(false)
 *                 .rollback(false)
 *                 .build())
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 .cloudMapNamespace(namespace)
 *                 .container(containerDefinition)
 *                 .containerPort(123)
 *                 .dnsRecordType(DnsRecordType.A)
 *                 .dnsTtl(Duration.minutes(30))
 *                 .failureThreshold(123)
 *                 .name("name")
 *                 .build())
 *         .cluster(cluster)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.ECS)
 *                 .build())
 *         .desiredCount(123)
 *         .domainName("domainName")
 *         .domainZone(hostedZone)
 *         .enableECSManagedTags(false)
 *         .enableExecuteCommand(false)
 *         .healthCheckGracePeriod(Duration.minutes(30))
 *         .idleTimeout(Duration.minutes(30))
 *         .ipAddressType(IpAddressType.IPV4)
 *         .listenerPort(123)
 *         .loadBalancer(applicationLoadBalancer)
 *         .loadBalancerName("loadBalancerName")
 *         .maxHealthyPercent(123)
 *         .minHealthyPercent(123)
 *         .openListener(false)
 *         .propagateTags(PropagatedTagSource.SERVICE)
 *         .protocol(ApplicationProtocol.HTTP)
 *         .protocolVersion(ApplicationProtocolVersion.GRPC)
 *         .publicLoadBalancer(false)
 *         .recordType(ApplicationLoadBalancedServiceRecordType.ALIAS)
 *         .redirectHTTP(false)
 *         .serviceName("serviceName")
 *         .sslPolicy(SslPolicy.RECOMMENDED_TLS)
 *         .targetProtocol(ApplicationProtocol.HTTP)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(containerImage)
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .containerName("containerName")
 *                 .containerPort(123)
 *                 .dockerLabels(Map.of(
 *                         "dockerLabelsKey", "dockerLabels"))
 *                 .enableLogging(false)
 *                 .entryPoint(List.of("entryPoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .executionRole(role)
 *                 .family("family")
 *                 .logDriver(logDriver)
 *                 .secrets(Map.of(
 *                         "secretsKey", secret))
 *                 .taskRole(role)
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:17.152Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedServiceBaseProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancedServiceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancedServiceBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of Capacity Provider strategies used to place a service.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
        return null;
    }

    /**
     * Certificate Manager certificate to associate with the load balancer.
     * <p>
     * Setting this option will set the load balancer protocol to HTTPS.
     * <p>
     * Default: - No certificate associated with the load balancer, if using
     * the HTTP protocol. For HTTPS, a DNS-validated certificate will be
     * created for the load balancer's specified domain name if a domain name
     * and domain zone are specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * Whether to enable the deployment circuit breaker.
     * <p>
     * If this property is defined, circuit breaker will be implicitly
     * enabled.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
        return null;
    }

    /**
     * The options for configuring an Amazon ECS service to use service discovery.
     * <p>
     * Default: - AWS Cloud Map service discovery is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
        return null;
    }

    /**
     * The name of the cluster that hosts the service.
     * <p>
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     * <p>
     * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * Specifies which deployment controller to use for the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
     * <p>
     * Default: - Rolling update (ECS)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
        return null;
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The minimum value is 1
     * <p>
     * Default: - The default is 1 for all new services and uses the existing service's desired count
     * when updating an existing service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCount() {
        return null;
    }

    /**
     * The domain name for the service, e.g. "api.example.com.".
     * <p>
     * Default: - No domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The Route53 hosted zone for the domain, e.g. "example.com.".
     * <p>
     * Default: - No Route53 hosted domain zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
        return null;
    }

    /**
     * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableECSManagedTags() {
        return null;
    }

    /**
     * Whether ECS Exec should be enabled.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableExecuteCommand() {
        return null;
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     * <p>
     * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getHealthCheckGracePeriod() {
        return null;
    }

    /**
     * The load balancer idle timeout, in seconds.
     * <p>
     * Can be between 1 and 4000 seconds
     * <p>
     * Default: - CloudFormation sets idle timeout to 60 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getIdleTimeout() {
        return null;
    }

    /**
     * The type of IP address to use.
     * <p>
     * Default: - IpAddressType.IPV4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
        return null;
    }

    /**
     * Listener port of the application load balancer that will serve traffic to the service.
     * <p>
     * Default: - The default listener port is determined from the protocol (port 80 for HTTP,
     * port 443 for HTTPS). A domain name and zone must be also be specified if using HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getListenerPort() {
        return null;
    }

    /**
     * The application load balancer that will serve traffic to the service.
     * <p>
     * The VPC attribute of a load balancer must be specified for it to be used
     * to create a new service with this pattern.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - a new load balancer will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
        return null;
    }

    /**
     * Name of the load balancer.
     * <p>
     * Default: - Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerName() {
        return null;
    }

    /**
     * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     * <p>
     * Default: - 100 if daemon, otherwise 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxHealthyPercent() {
        return null;
    }

    /**
     * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     * <p>
     * Default: - 0 if daemon, otherwise 50
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinHealthyPercent() {
        return null;
    }

    /**
     * Determines whether or not the Security Group for the Load Balancer's Listener will be open to all traffic by default.
     * <p>
     * Default: true -- The security group allows ingress from all IP addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOpenListener() {
        return null;
    }

    /**
     * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * Tags can only be propagated to the tasks within the service during service creation.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
        return null;
    }

    /**
     * The protocol for connections from clients to the load balancer.
     * <p>
     * The load balancer port is determined from the protocol (port 80 for
     * HTTP, port 443 for HTTPS).  If HTTPS, either a certificate or domain
     * name and domain zone must also be specified.
     * <p>
     * Default: HTTP. If a certificate is specified, the protocol will be
     * set by default to HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
        return null;
    }

    /**
     * The protocol version to use.
     * <p>
     * Default: ApplicationProtocolVersion.HTTP1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion getProtocolVersion() {
        return null;
    }

    /**
     * Determines whether the Load Balancer will be internet-facing.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicLoadBalancer() {
        return null;
    }

    /**
     * Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
     * <p>
     * This is useful if you need to work with DNS systems that do not support alias records.
     * <p>
     * Default: ApplicationLoadBalancedServiceRecordType.ALIAS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType getRecordType() {
        return null;
    }

    /**
     * Specifies whether the load balancer should redirect traffic on port 80 to port 443 to support HTTP-&gt;HTTPS redirects This is only valid if the protocol of the ALB is HTTPS.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRedirectHTTP() {
        return null;
    }

    /**
     * The name of the service.
     * <p>
     * Default: - CloudFormation-generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * The security policy that defines which ciphers and protocols are supported by the ALB Listener.
     * <p>
     * Default: - The recommended elastic load balancing security policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
        return null;
    }

    /**
     * The protocol for connections from the load balancer to the ECS tasks.
     * <p>
     * The default target port is determined from the protocol (port 80 for
     * HTTP, port 443 for HTTPS).
     * <p>
     * Default: HTTP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getTargetProtocol() {
        return null;
    }

    /**
     * The properties required to create a new task definition.
     * <p>
     * TaskDefinition or TaskImageOptions must be specified, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions getTaskImageOptions() {
        return null;
    }

    /**
     * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     * <p>
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     * <p>
     * Default: - uses the VPC defined in the cluster or creates a new VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationLoadBalancedServiceBaseProps> {
        java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        software.amazon.awscdk.services.ecs.ICluster cluster;
        software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        java.lang.Number desiredCount;
        java.lang.String domainName;
        software.amazon.awscdk.services.route53.IHostedZone domainZone;
        java.lang.Boolean enableEcsManagedTags;
        java.lang.Boolean enableExecuteCommand;
        software.amazon.awscdk.Duration healthCheckGracePeriod;
        software.amazon.awscdk.Duration idleTimeout;
        software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType;
        java.lang.Number listenerPort;
        software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer;
        java.lang.String loadBalancerName;
        java.lang.Number maxHealthyPercent;
        java.lang.Number minHealthyPercent;
        java.lang.Boolean openListener;
        software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion protocolVersion;
        java.lang.Boolean publicLoadBalancer;
        software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType recordType;
        java.lang.Boolean redirectHttp;
        java.lang.String serviceName;
        software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;
        software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol;
        software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCapacityProviderStrategies}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder capacityProviderStrategies(java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)capacityProviderStrategies;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCertificate}
         * @param certificate Certificate Manager certificate to associate with the load balancer.
         *                    Setting this option will set the load balancer protocol to HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCircuitBreaker}
         * @param circuitBreaker Whether to enable the deployment circuit breaker.
         *                       If this property is defined, circuit breaker will be implicitly
         *                       enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDeploymentController}
         * @param deploymentController Specifies which deployment controller to use for the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         *                     The minimum value is 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDomainName}
         * @param domainName The domain name for the service, e.g. "api.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDomainZone}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainZone(software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getEnableExecuteCommand}
         * @param enableExecuteCommand Whether ECS Exec should be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getIdleTimeout}
         * @param idleTimeout The load balancer idle timeout, in seconds.
         *                    Can be between 1 and 4000 seconds
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(software.amazon.awscdk.Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getIpAddressType}
         * @param ipAddressType The type of IP address to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getListenerPort}
         * @param listenerPort Listener port of the application load balancer that will serve traffic to the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getLoadBalancer}
         * @param loadBalancer The application load balancer that will serve traffic to the service.
         *                     The VPC attribute of a load balancer must be specified for it to be used
         *                     to create a new service with this pattern.
         *                     <p>
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getLoadBalancerName}
         * @param loadBalancerName Name of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getOpenListener}
         * @param openListener Determines whether or not the Security Group for the Load Balancer's Listener will be open to all traffic by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openListener(java.lang.Boolean openListener) {
            this.openListener = openListener;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getProtocol}
         * @param protocol The protocol for connections from clients to the load balancer.
         *                 The load balancer port is determined from the protocol (port 80 for
         *                 HTTP, port 443 for HTTPS).  If HTTPS, either a certificate or domain
         *                 name and domain zone must also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getProtocolVersion}
         * @param protocolVersion The protocol version to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolVersion(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getPublicLoadBalancer}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicLoadBalancer(java.lang.Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getRecordType}
         * @param recordType Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
         *                   This is useful if you need to work with DNS systems that do not support alias records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordType(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getRedirectHttp}
         * @param redirectHttp Specifies whether the load balancer should redirect traffic on port 80 to port 443 to support HTTP-&gt;HTTPS redirects This is only valid if the protocol of the ALB is HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redirectHttp(java.lang.Boolean redirectHttp) {
            this.redirectHttp = redirectHttp;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getSslPolicy}
         * @param sslPolicy The security policy that defines which ciphers and protocols are supported by the ALB Listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getTargetProtocol}
         * @param targetProtocol The protocol for connections from the load balancer to the ECS tasks.
         *                       The default target port is determined from the protocol (port 80 for
         *                       HTTP, port 443 for HTTPS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetProtocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol) {
            this.targetProtocol = targetProtocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getTaskImageOptions}
         * @param taskImageOptions The properties required to create a new task definition.
         *                         TaskDefinition or TaskImageOptions must be specified, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancedServiceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationLoadBalancedServiceBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancedServiceBaseProps {
        private final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private final java.lang.Number desiredCount;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableExecuteCommand;
        private final software.amazon.awscdk.Duration healthCheckGracePeriod;
        private final software.amazon.awscdk.Duration idleTimeout;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType;
        private final java.lang.Number listenerPort;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer;
        private final java.lang.String loadBalancerName;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number minHealthyPercent;
        private final java.lang.Boolean openListener;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion protocolVersion;
        private final java.lang.Boolean publicLoadBalancer;
        private final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType recordType;
        private final java.lang.Boolean redirectHttp;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol;
        private final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacityProviderStrategies = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CapacityProviderStrategy.class)));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.circuitBreaker = software.amazon.jsii.Kernel.get(this, "circuitBreaker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker.class));
            this.cloudMapOptions = software.amazon.jsii.Kernel.get(this, "cloudMapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CloudMapOptions.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.deploymentController = software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentController.class));
            this.desiredCount = software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainZone = software.amazon.jsii.Kernel.get(this, "domainZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthCheckGracePeriod = software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.idleTimeout = software.amazon.jsii.Kernel.get(this, "idleTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class));
            this.listenerPort = software.amazon.jsii.Kernel.get(this, "listenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.loadBalancer = software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class));
            this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxHealthyPercent = software.amazon.jsii.Kernel.get(this, "maxHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minHealthyPercent = software.amazon.jsii.Kernel.get(this, "minHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.openListener = software.amazon.jsii.Kernel.get(this, "openListener", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class));
            this.protocolVersion = software.amazon.jsii.Kernel.get(this, "protocolVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion.class));
            this.publicLoadBalancer = software.amazon.jsii.Kernel.get(this, "publicLoadBalancer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.recordType = software.amazon.jsii.Kernel.get(this, "recordType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType.class));
            this.redirectHttp = software.amazon.jsii.Kernel.get(this, "redirectHTTP", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sslPolicy = software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class));
            this.targetProtocol = software.amazon.jsii.Kernel.get(this, "targetProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class));
            this.taskImageOptions = software.amazon.jsii.Kernel.get(this, "taskImageOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)builder.capacityProviderStrategies;
            this.certificate = builder.certificate;
            this.circuitBreaker = builder.circuitBreaker;
            this.cloudMapOptions = builder.cloudMapOptions;
            this.cluster = builder.cluster;
            this.deploymentController = builder.deploymentController;
            this.desiredCount = builder.desiredCount;
            this.domainName = builder.domainName;
            this.domainZone = builder.domainZone;
            this.enableEcsManagedTags = builder.enableEcsManagedTags;
            this.enableExecuteCommand = builder.enableExecuteCommand;
            this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
            this.idleTimeout = builder.idleTimeout;
            this.ipAddressType = builder.ipAddressType;
            this.listenerPort = builder.listenerPort;
            this.loadBalancer = builder.loadBalancer;
            this.loadBalancerName = builder.loadBalancerName;
            this.maxHealthyPercent = builder.maxHealthyPercent;
            this.minHealthyPercent = builder.minHealthyPercent;
            this.openListener = builder.openListener;
            this.propagateTags = builder.propagateTags;
            this.protocol = builder.protocol;
            this.protocolVersion = builder.protocolVersion;
            this.publicLoadBalancer = builder.publicLoadBalancer;
            this.recordType = builder.recordType;
            this.redirectHttp = builder.redirectHttp;
            this.serviceName = builder.serviceName;
            this.sslPolicy = builder.sslPolicy;
            this.targetProtocol = builder.targetProtocol;
            this.taskImageOptions = builder.taskImageOptions;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
            return this.capacityProviderStrategies;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
            return this.deploymentController;
        }

        @Override
        public final java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.domainZone;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final software.amazon.awscdk.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final software.amazon.awscdk.Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public final java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public final java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public final java.lang.Boolean getOpenListener() {
            return this.openListener;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        public final java.lang.Boolean getPublicLoadBalancer() {
            return this.publicLoadBalancer;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType getRecordType() {
            return this.recordType;
        }

        @Override
        public final java.lang.Boolean getRedirectHTTP() {
            return this.redirectHttp;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getTargetProtocol() {
            return this.targetProtocol;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions getTaskImageOptions() {
            return this.taskImageOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCapacityProviderStrategies() != null) {
                data.set("capacityProviderStrategies", om.valueToTree(this.getCapacityProviderStrategies()));
            }
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getCircuitBreaker() != null) {
                data.set("circuitBreaker", om.valueToTree(this.getCircuitBreaker()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDeploymentController() != null) {
                data.set("deploymentController", om.valueToTree(this.getDeploymentController()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainZone() != null) {
                data.set("domainZone", om.valueToTree(this.getDomainZone()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getEnableExecuteCommand() != null) {
                data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getIdleTimeout() != null) {
                data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getListenerPort() != null) {
                data.set("listenerPort", om.valueToTree(this.getListenerPort()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getLoadBalancerName() != null) {
                data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getOpenListener() != null) {
                data.set("openListener", om.valueToTree(this.getOpenListener()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getProtocolVersion() != null) {
                data.set("protocolVersion", om.valueToTree(this.getProtocolVersion()));
            }
            if (this.getPublicLoadBalancer() != null) {
                data.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
            }
            if (this.getRecordType() != null) {
                data.set("recordType", om.valueToTree(this.getRecordType()));
            }
            if (this.getRedirectHTTP() != null) {
                data.set("redirectHTTP", om.valueToTree(this.getRedirectHTTP()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getSslPolicy() != null) {
                data.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }
            if (this.getTargetProtocol() != null) {
                data.set("targetProtocol", om.valueToTree(this.getTargetProtocol()));
            }
            if (this.getTaskImageOptions() != null) {
                data.set("taskImageOptions", om.valueToTree(this.getTaskImageOptions()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedServiceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancedServiceBaseProps.Jsii$Proxy that = (ApplicationLoadBalancedServiceBaseProps.Jsii$Proxy) o;

            if (this.capacityProviderStrategies != null ? !this.capacityProviderStrategies.equals(that.capacityProviderStrategies) : that.capacityProviderStrategies != null) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.circuitBreaker != null ? !this.circuitBreaker.equals(that.circuitBreaker) : that.circuitBreaker != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.deploymentController != null ? !this.deploymentController.equals(that.deploymentController) : that.deploymentController != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainZone != null ? !this.domainZone.equals(that.domainZone) : that.domainZone != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.listenerPort != null ? !this.listenerPort.equals(that.listenerPort) : that.listenerPort != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.openListener != null ? !this.openListener.equals(that.openListener) : that.openListener != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.protocolVersion != null ? !this.protocolVersion.equals(that.protocolVersion) : that.protocolVersion != null) return false;
            if (this.publicLoadBalancer != null ? !this.publicLoadBalancer.equals(that.publicLoadBalancer) : that.publicLoadBalancer != null) return false;
            if (this.recordType != null ? !this.recordType.equals(that.recordType) : that.recordType != null) return false;
            if (this.redirectHttp != null ? !this.redirectHttp.equals(that.redirectHttp) : that.redirectHttp != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.sslPolicy != null ? !this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy != null) return false;
            if (this.targetProtocol != null ? !this.targetProtocol.equals(that.targetProtocol) : that.targetProtocol != null) return false;
            if (this.taskImageOptions != null ? !this.taskImageOptions.equals(that.taskImageOptions) : that.taskImageOptions != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacityProviderStrategies != null ? this.capacityProviderStrategies.hashCode() : 0;
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.circuitBreaker != null ? this.circuitBreaker.hashCode() : 0);
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.deploymentController != null ? this.deploymentController.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.domainZone != null ? this.domainZone.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.idleTimeout != null ? this.idleTimeout.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.listenerPort != null ? this.listenerPort.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.openListener != null ? this.openListener.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.protocolVersion != null ? this.protocolVersion.hashCode() : 0);
            result = 31 * result + (this.publicLoadBalancer != null ? this.publicLoadBalancer.hashCode() : 0);
            result = 31 * result + (this.recordType != null ? this.recordType.hashCode() : 0);
            result = 31 * result + (this.redirectHttp != null ? this.redirectHttp.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            result = 31 * result + (this.targetProtocol != null ? this.targetProtocol.hashCode() : 0);
            result = 31 * result + (this.taskImageOptions != null ? this.taskImageOptions.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
