package software.amazon.awscdk.services.efs;

/**
 * Options to create an AccessPoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * fileSystem.addAccessPoint("MyAccessPoint", AccessPointOptions.builder()
 *         // create a unique access point via an optional client token
 *         .clientToken("client-token")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:17.243Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.AccessPointOptions")
@software.amazon.jsii.Jsii.Proxy(AccessPointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessPointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The opaque string specified in the request to ensure idempotent creation.
     * <p>
     * Default: - No client token
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.
     * <p>
     * If the
     * root directory specified by <code>path</code> does not exist, EFS creates the root directory and applies the
     * permissions specified here. If the specified <code>path</code> does not exist, you must specify <code>createAcl</code>.
     * <p>
     * Default: - None. The directory specified by `path` must exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.Acl getCreateAcl() {
        return null;
    }

    /**
     * Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
     * <p>
     * Default: '/'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.
     * <p>
     * Specify this to enforce a user identity using an access point.
     * <p>
     * Default: - user identity not enforced
     * <p>
     * @see <a href=" - [Enforcing a User Identity Using an Access Point](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)"> - [Enforcing a User Identity Using an Access Point](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.PosixUser getPosixUser() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AccessPointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPointOptions> {
        java.lang.String clientToken;
        software.amazon.awscdk.services.efs.Acl createAcl;
        java.lang.String path;
        software.amazon.awscdk.services.efs.PosixUser posixUser;

        /**
         * Sets the value of {@link AccessPointOptions#getClientToken}
         * @param clientToken The opaque string specified in the request to ensure idempotent creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointOptions#getCreateAcl}
         * @param createAcl Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.
         *                  If the
         *                  root directory specified by <code>path</code> does not exist, EFS creates the root directory and applies the
         *                  permissions specified here. If the specified <code>path</code> does not exist, you must specify <code>createAcl</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAcl(software.amazon.awscdk.services.efs.Acl createAcl) {
            this.createAcl = createAcl;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointOptions#getPath}
         * @param path Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointOptions#getPosixUser}
         * @param posixUser The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.
         *                  Specify this to enforce a user identity using an access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixUser(software.amazon.awscdk.services.efs.PosixUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessPointOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPointOptions {
        private final java.lang.String clientToken;
        private final software.amazon.awscdk.services.efs.Acl createAcl;
        private final java.lang.String path;
        private final software.amazon.awscdk.services.efs.PosixUser posixUser;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createAcl = software.amazon.jsii.Kernel.get(this, "createAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.Acl.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.posixUser = software.amazon.jsii.Kernel.get(this, "posixUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.PosixUser.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientToken = builder.clientToken;
            this.createAcl = builder.createAcl;
            this.path = builder.path;
            this.posixUser = builder.posixUser;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final software.amazon.awscdk.services.efs.Acl getCreateAcl() {
            return this.createAcl;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final software.amazon.awscdk.services.efs.PosixUser getPosixUser() {
            return this.posixUser;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getCreateAcl() != null) {
                data.set("createAcl", om.valueToTree(this.getCreateAcl()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPosixUser() != null) {
                data.set("posixUser", om.valueToTree(this.getPosixUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.AccessPointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPointOptions.Jsii$Proxy that = (AccessPointOptions.Jsii$Proxy) o;

            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.createAcl != null ? !this.createAcl.equals(that.createAcl) : that.createAcl != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            return this.posixUser != null ? this.posixUser.equals(that.posixUser) : that.posixUser == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientToken != null ? this.clientToken.hashCode() : 0;
            result = 31 * result + (this.createAcl != null ? this.createAcl.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.posixUser != null ? this.posixUser.hashCode() : 0);
            return result;
        }
    }
}
