package software.amazon.awscdk.services.eks;

/**
 * Represents an Amazon EKS Access Policy that implements the IAccessPolicy interface.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // AmazonEKSClusterAdminPolicy with `cluster` scope
 * AccessPolicy.fromAccessPolicyName("AmazonEKSClusterAdminPolicy", AccessPolicyNameOptions.builder()
 *         .accessScopeType(AccessScopeType.CLUSTER)
 *         .build());
 * // AmazonEKSAdminPolicy with `namespace` scope
 * AccessPolicy.fromAccessPolicyName("AmazonEKSAdminPolicy", AccessPolicyNameOptions.builder()
 *         .accessScopeType(AccessScopeType.NAMESPACE)
 *         .namespaces(List.of("foo", "bar"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:17.309Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessPolicy")
public class AccessPolicy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.eks.IAccessPolicy {

    protected AccessPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the AccessPolicy class.
     * <p>
     * @param props <ul><li>The properties for configuring the access policy.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import AccessPolicy by name.
     * <p>
     * @param policyName This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.IAccessPolicy fromAccessPolicyName(final @org.jetbrains.annotations.NotNull java.lang.String policyName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessPolicyNameOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AccessPolicy.class, "fromAccessPolicyName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IAccessPolicy.class), new Object[] { java.util.Objects.requireNonNull(policyName, "policyName is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The scope of the access policy, which determines the level of access granted.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessScope getAccessScope() {
        return software.amazon.jsii.Kernel.get(this, "accessScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessScope.class));
    }

    /**
     * The access policy itself, which defines the specific permissions.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.AccessPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.AccessPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.eks.AccessPolicyProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.eks.AccessPolicyProps.Builder();
        }

        /**
         * The scope of the access policy, which determines the level of access granted.
         * <p>
         * @return {@code this}
         * @param accessScope The scope of the access policy, which determines the level of access granted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessScope(final software.amazon.awscdk.services.eks.AccessScope accessScope) {
            this.props.accessScope(accessScope);
            return this;
        }

        /**
         * The access policy itself, which defines the specific permissions.
         * <p>
         * @return {@code this}
         * @param policy The access policy itself, which defines the specific permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.eks.AccessPolicyArn policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.AccessPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.AccessPolicy build() {
            return new software.amazon.awscdk.services.eks.AccessPolicy(
                this.props.build()
            );
        }
    }
}
