package software.amazon.awscdk.services.eks;

/**
 * Properties for creating an Amazon EKS Add-On.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * Addon.Builder.create(this, "Addon")
 *         .cluster(cluster)
 *         .addonName("aws-guardduty-agent")
 *         .addonVersion("v1.6.1")
 *         // whether to preserve the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
 *         .preserveOnDelete(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:17.313Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AddonProps")
@software.amazon.jsii.Jsii.Proxy(AddonProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddonProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the Add-On.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddonName();

    /**
     * The EKS cluster the Add-On is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * Version of the Add-On.
     * <p>
     * You can check all available versions with describe-addon-versions.
     * For example, this lists all available versions for the <code>eks-pod-identity-agent</code> addon:
     * $ aws eks describe-addon-versions --addon-name eks-pod-identity-agent \
     * --query 'addons[<em>].addonVersions[</em>].addonVersion'
     * <p>
     * Default: the latest version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddonVersion() {
        return null;
    }

    /**
     * Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
     * <p>
     * If an IAM account is associated with the add-on, it isn't removed.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveOnDelete() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddonProps> {
        java.lang.String addonName;
        software.amazon.awscdk.services.eks.ICluster cluster;
        java.lang.String addonVersion;
        java.lang.Boolean preserveOnDelete;

        /**
         * Sets the value of {@link AddonProps#getAddonName}
         * @param addonName Name of the Add-On. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonName(java.lang.String addonName) {
            this.addonName = addonName;
            return this;
        }

        /**
         * Sets the value of {@link AddonProps#getCluster}
         * @param cluster The EKS cluster the Add-On is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link AddonProps#getAddonVersion}
         * @param addonVersion Version of the Add-On.
         *                     You can check all available versions with describe-addon-versions.
         *                     For example, this lists all available versions for the <code>eks-pod-identity-agent</code> addon:
         *                     $ aws eks describe-addon-versions --addon-name eks-pod-identity-agent \
         *                     --query 'addons[<em>].addonVersions[</em>].addonVersion'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonVersion(java.lang.String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        /**
         * Sets the value of {@link AddonProps#getPreserveOnDelete}
         * @param preserveOnDelete Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
         *                         If an IAM account is associated with the add-on, it isn't removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveOnDelete(java.lang.Boolean preserveOnDelete) {
            this.preserveOnDelete = preserveOnDelete;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddonProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddonProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddonProps {
        private final java.lang.String addonName;
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final java.lang.String addonVersion;
        private final java.lang.Boolean preserveOnDelete;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addonName = software.amazon.jsii.Kernel.get(this, "addonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.addonVersion = software.amazon.jsii.Kernel.get(this, "addonVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preserveOnDelete = software.amazon.jsii.Kernel.get(this, "preserveOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addonName = java.util.Objects.requireNonNull(builder.addonName, "addonName is required");
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.addonVersion = builder.addonVersion;
            this.preserveOnDelete = builder.preserveOnDelete;
        }

        @Override
        public final java.lang.String getAddonName() {
            return this.addonName;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getAddonVersion() {
            return this.addonVersion;
        }

        @Override
        public final java.lang.Boolean getPreserveOnDelete() {
            return this.preserveOnDelete;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addonName", om.valueToTree(this.getAddonName()));
            data.set("cluster", om.valueToTree(this.getCluster()));
            if (this.getAddonVersion() != null) {
                data.set("addonVersion", om.valueToTree(this.getAddonVersion()));
            }
            if (this.getPreserveOnDelete() != null) {
                data.set("preserveOnDelete", om.valueToTree(this.getPreserveOnDelete()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AddonProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddonProps.Jsii$Proxy that = (AddonProps.Jsii$Proxy) o;

            if (!addonName.equals(that.addonName)) return false;
            if (!cluster.equals(that.cluster)) return false;
            if (this.addonVersion != null ? !this.addonVersion.equals(that.addonVersion) : that.addonVersion != null) return false;
            return this.preserveOnDelete != null ? this.preserveOnDelete.equals(that.preserveOnDelete) : that.preserveOnDelete == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addonName.hashCode();
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.addonVersion != null ? this.addonVersion.hashCode() : 0);
            result = 31 * result + (this.preserveOnDelete != null ? this.preserveOnDelete.hashCode() : 0);
            return result;
        }
    }
}
