package software.amazon.awscdk.services.eks;

/**
 * A Cluster represents a managed Kubernetes Service (EKS).
 * <p>
 * This is a fully managed cluster of API Servers (control-plane)
 * The user is still required to create the worker nodes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v32.KubectlV32Layer;
 * // or
 * Vpc vpc;
 * Cluster.Builder.create(this, "MyCluster")
 *         .kubectlMemory(Size.gibibytes(4))
 *         .version(KubernetesVersion.V1_32)
 *         .kubectlLayer(new KubectlV32Layer(this, "kubectl"))
 *         .build();
 * Cluster.fromClusterAttributes(this, "MyCluster", ClusterAttributes.builder()
 *         .kubectlMemory(Size.gibibytes(4))
 *         .vpc(vpc)
 *         .clusterName("cluster-name")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:17.379Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.Cluster")
public class Cluster extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.eks.ICluster {

    protected Cluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initiates an EKS Cluster with the supplied arguments.
     * <p>
     * @param scope a Construct, most likely a cdk.Stack created. This parameter is required.
     * @param id the id of the Construct to create. This parameter is required.
     * @param props properties in the IClusterProps interface. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Cluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing cluster.
     * <p>
     * @param scope the construct scope, in most cases 'this'. This parameter is required.
     * @param id the id or name to import as. This parameter is required.
     * @param attrs the cluster properties to use for importing information. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster fromClusterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ClusterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.Cluster.class, "fromClusterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add nodes to this EKS cluster.
     * <p>
     * The nodes will automatically be configured with the right VPC and AMI
     * for the instance type and Kubernetes version.
     * <p>
     * Note that if you specify <code>updateType: RollingUpdate</code> or <code>updateType: ReplacingUpdate</code>, your nodes might be replaced at deploy
     * time without notice in case the recommended AMI for your machine image type has been updated by AWS.
     * The default behavior for <code>updateType</code> is <code>None</code>, which means only new instances will be launched using the new AMI.
     * <p>
     * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
     * In addition, the <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
     * daemon will be installed on all spot instances to handle
     * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup addAutoScalingGroupCapacity(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AutoScalingGroupCapacityOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addAutoScalingGroupCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Defines a CDK8s chart in this cluster.
     * <p>
     * @return a <code>KubernetesManifest</code> construct representing the chart.
     * @param id logical id of this chart. This parameter is required.
     * @param chart the cdk8s chart. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.KubernetesManifestOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addCdk8sChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(chart, "chart is required"), options });
    }

    /**
     * Defines a CDK8s chart in this cluster.
     * <p>
     * @return a <code>KubernetesManifest</code> construct representing the chart.
     * @param id logical id of this chart. This parameter is required.
     * @param chart the cdk8s chart. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart) {
        return software.amazon.jsii.Kernel.call(this, "addCdk8sChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(chart, "chart is required") });
    }

    /**
     * Adds a Fargate profile to this cluster.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html">https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html</a>
     * @param id the id of this profile. This parameter is required.
     * @param options profile options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateProfile addFargateProfile(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateProfileOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addFargateProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.FargateProfile.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Defines a Helm chart in this cluster.
     * <p>
     * @return a <code>HelmChart</code> construct
     * @param id logical id of this chart. This parameter is required.
     * @param options options of this chart. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChart addHelmChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChartOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addHelmChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.HelmChart.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Defines a Kubernetes resource in this cluster.
     * <p>
     * The manifest will be applied/deleted using kubectl as needed.
     * <p>
     * @return a <code>KubernetesResource</code> object.
     * @param id logical id of this manifest. This parameter is required.
     * @param manifest a list of Kubernetes resource specifications. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addManifest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object>... manifest) {
        return software.amazon.jsii.Kernel.call(this, "addManifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(id, "id is required") }), java.util.Arrays.<Object>stream(manifest)).toArray(Object[]::new));
    }

    /**
     * Add managed nodegroup to this Amazon EKS cluster.
     * <p>
     * This method will create a new managed nodegroup and add into the capacity.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html</a>
     * @param id The ID of the nodegroup. This parameter is required.
     * @param options options for creating a new nodegroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.Nodegroup addNodegroupCapacity(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.NodegroupOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addNodegroupCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.Nodegroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Add managed nodegroup to this Amazon EKS cluster.
     * <p>
     * This method will create a new managed nodegroup and add into the capacity.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html</a>
     * @param id The ID of the nodegroup. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.Nodegroup addNodegroupCapacity(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addNodegroupCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.Nodegroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a new service account with corresponding IAM Role (IRSA).
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.ServiceAccountOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addServiceAccount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Creates a new service account with corresponding IAM Role (IRSA).
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addServiceAccount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Connect capacity in the form of an existing AutoScalingGroup to the EKS cluster.
     * <p>
     * The AutoScalingGroup must be running an EKS-optimized AMI containing the
     * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
     * add the right policies to the instance role, apply the right tags, and add
     * the required user data to the instance's launch configuration.
     * <p>
     * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
     * If kubectl is enabled, the
     * <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
     * daemon will be installed on all spot instances to handle
     * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
     * <p>
     * Prefer to use <code>addAutoScalingGroupCapacity</code> if possible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html</a>
     * @param autoScalingGroup [disable-awslint:ref-via-interface]. This parameter is required.
     * @param options options for adding auto scaling groups, like customizing the bootstrap script. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void connectAutoScalingGroupCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AutoScalingGroupOptions options) {
        software.amazon.jsii.Kernel.call(this, "connectAutoScalingGroupCapacity", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Fetch the load balancer address of an ingress backed by a load balancer.
     * <p>
     * @param ingressName The name of the ingress. This parameter is required.
     * @param options Additional operation options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIngressLoadBalancerAddress(final @org.jetbrains.annotations.NotNull java.lang.String ingressName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IngressLoadBalancerAddressOptions options) {
        return software.amazon.jsii.Kernel.call(this, "getIngressLoadBalancerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(ingressName, "ingressName is required"), options });
    }

    /**
     * Fetch the load balancer address of an ingress backed by a load balancer.
     * <p>
     * @param ingressName The name of the ingress. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIngressLoadBalancerAddress(final @org.jetbrains.annotations.NotNull java.lang.String ingressName) {
        return software.amazon.jsii.Kernel.call(this, "getIngressLoadBalancerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(ingressName, "ingressName is required") });
    }

    /**
     * Fetch the load balancer address of a service of type 'LoadBalancer'.
     * <p>
     * @param serviceName The name of the service. This parameter is required.
     * @param options Additional operation options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceLoadBalancerAddress(final @org.jetbrains.annotations.NotNull java.lang.String serviceName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.ServiceLoadBalancerAddressOptions options) {
        return software.amazon.jsii.Kernel.call(this, "getServiceLoadBalancerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required"), options });
    }

    /**
     * Fetch the load balancer address of a service of type 'LoadBalancer'.
     * <p>
     * @param serviceName The name of the service. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceLoadBalancerAddress(final @org.jetbrains.annotations.NotNull java.lang.String serviceName) {
        return software.amazon.jsii.Kernel.call(this, "getServiceLoadBalancerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required") });
    }

    /**
     * Grants the specified IAM principal access to the EKS cluster based on the provided access policies.
     * <p>
     * This method creates an <code>AccessEntry</code> construct that grants the specified IAM principal the access permissions
     * defined by the provided <code>IAccessPolicy</code> array. This allows the IAM principal to perform the actions permitted
     * by the access policies within the EKS cluster.
     * <p>
     * @param id <ul><li>The ID of the <code>AccessEntry</code> construct to be created.</li></ul> This parameter is required.
     * @param principal <ul><li>The IAM principal (role or user) to be granted access to the EKS cluster.</li></ul> This parameter is required.
     * @param accessPolicies <ul><li>An array of <code>IAccessPolicy</code> objects that define the access permissions to be granted to the IAM principal.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void grantAccess(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String principal, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy> accessPolicies) {
        software.amazon.jsii.Kernel.call(this, "grantAccess", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(principal, "principal is required"), java.util.Objects.requireNonNull(accessPolicies, "accessPolicies is required") });
    }

    /**
     * An IAM role with administrative permissions to create or update the cluster.
     * <p>
     * This role also has <code>systems:master</code> permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Role getAdminRole() {
        return software.amazon.jsii.Kernel.get(this, "adminRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Role.class));
    }

    /**
     * Lazily creates the AwsAuth resource, which manages AWS authentication mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AwsAuth getAwsAuth() {
        return software.amazon.jsii.Kernel.get(this, "awsAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AwsAuth.class));
    }

    /**
     * The AWS generated ARN for the Cluster resource.
     * <p>
     * For example, <code>arn:aws:eks:us-west-2:666666666666:cluster/prod</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The certificate-authority-data for your cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterCertificateAuthorityData() {
        return software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterEncryptionConfigKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "clusterEncryptionConfigKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint URL for the Cluster.
     * <p>
     * This is the URL inside the kubeconfig file to use with kubectl
     * <p>
     * For example, <code>https://5E1D0CEXAMPLEA591B746AFC5AB30262.yl4.us-west-2.eks.amazonaws.com</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Name of the created EKS Cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this cluster is kubectl-enabled, returns the OpenID Connect issuer.
     * <p>
     * This is because the values is only be retrieved by the API and not exposed
     * by CloudFormation. If this cluster is not kubectl-enabled (i.e. uses the
     * stock <code>CfnCluster</code>), this is <code>undefined</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterOpenIdConnectIssuer() {
        return software.amazon.jsii.Kernel.get(this, "clusterOpenIdConnectIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this cluster is kubectl-enabled, returns the OpenID Connect issuer url.
     * <p>
     * This is because the values is only be retrieved by the API and not exposed
     * by CloudFormation. If this cluster is not kubectl-enabled (i.e. uses the
     * stock <code>CfnCluster</code>), this is <code>undefined</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterOpenIdConnectIssuerUrl() {
        return software.amazon.jsii.Kernel.get(this, "clusterOpenIdConnectIssuerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cluster security group that was created by Amazon EKS for the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getClusterSecurityGroup() {
        return software.amazon.jsii.Kernel.get(this, "clusterSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
    }

    /**
     * The id of the cluster security group that was created by Amazon EKS for the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterSecurityGroupId() {
        return software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Manages connection rules (Security Group Rules) for the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * An <code>OpenIdConnectProvider</code> resource associated with this cluster, and which can be used to link this cluster to AWS IAM.
     * <p>
     * A provider will only be defined if this property is accessed (lazy initialization).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
        return software.amazon.jsii.Kernel.get(this, "openIdConnectProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class));
    }

    /**
     * Determines if Kubernetes resources can be pruned automatically.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getPrune() {
        return software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * IAM role assumed by the EKS Control Plane.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The VPC in which this Cluster was created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * The ALB Controller construct defined for this cluster.
     * <p>
     * Will be undefined if <code>albController</code> wasn't configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.AlbController getAlbController() {
        return software.amazon.jsii.Kernel.get(this, "albController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbController.class));
    }

    /**
     * The authentication mode for the Amazon EKS cluster.
     * <p>
     * The authentication mode determines how users and applications authenticate to the Kubernetes API server.
     * <p>
     * Default: CONFIG_MAP.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.AuthenticationMode getAuthenticationMode() {
        return software.amazon.jsii.Kernel.get(this, "authenticationMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AuthenticationMode.class));
    }

    /**
     * An AWS Lambda layer that contains the <code>aws</code> CLI.
     * <p>
     * If not defined, a default layer will be used containing the AWS CLI 1.x.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getAwscliLayer() {
        return software.amazon.jsii.Kernel.get(this, "awscliLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
    }

    /**
     * A security group to associate with the Cluster Handler's Lambdas.
     * <p>
     * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
     * <p>
     * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
     * <p>
     * Default: - No security group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getClusterHandlerSecurityGroup() {
        return software.amazon.jsii.Kernel.get(this, "clusterHandlerSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
    }

    /**
     * The auto scaling group that hosts the default capacity for this cluster.
     * <p>
     * This will be <code>undefined</code> if the <code>defaultCapacityType</code> is not <code>EC2</code> or
     * <code>defaultCapacityType</code> is <code>EC2</code> but default capacity is set to 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.AutoScalingGroup getDefaultCapacity() {
        return software.amazon.jsii.Kernel.get(this, "defaultCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class));
    }

    /**
     * The node group that hosts the default capacity for this cluster.
     * <p>
     * This will be <code>undefined</code> if the <code>defaultCapacityType</code> is <code>EC2</code> or
     * <code>defaultCapacityType</code> is <code>NODEGROUP</code> but default capacity is set to 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.Nodegroup getDefaultNodegroup() {
        return software.amazon.jsii.Kernel.get(this, "defaultNodegroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.Nodegroup.class));
    }

    /**
     * Retrieves the EKS Pod Identity Agent addon for the EKS cluster.
     * <p>
     * The EKS Pod Identity Agent is responsible for managing the temporary credentials
     * used by pods in the cluster to access AWS resources. It runs as a DaemonSet on
     * each node and provides the necessary credentials to the pods based on their
     * associated service account.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IAddon getEksPodIdentityAgent() {
        return software.amazon.jsii.Kernel.get(this, "eksPodIdentityAgent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IAddon.class));
    }

    /**
     * Specify which IP family is used to assign Kubernetes pod and service IP addresses.
     * <p>
     * Default: - IpFamily.IP_V4
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IpFamily getIpFamily() {
        return software.amazon.jsii.Kernel.get(this, "ipFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IpFamily.class));
    }

    /**
     * Custom environment variables when running <code>kubectl</code> against this cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * An IAM role that can perform kubectl operations against this cluster.
     * <p>
     * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
     * <p>
     * This role is directly passed to the lambda handler that sends Kube Ctl commands to the cluster.
     * <p>
     * Default: - if not specified, the default role created by a lambda function will
     * be used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlLambdaRole() {
        return software.amazon.jsii.Kernel.get(this, "kubectlLambdaRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * An AWS Lambda layer that includes <code>kubectl</code> and <code>helm</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
        return software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
    }

    /**
     * The amount of memory allocated to the kubectl provider's lambda function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getKubectlMemory() {
        return software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * Subnets to host the <code>kubectl</code> compute resources.
     * <p>
     * Default: - If not specified, the k8s endpoint is expected to be accessible
     * publicly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getKubectlPrivateSubnets() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)(software.amazon.jsii.Kernel.get(this, "kubectlPrivateSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An IAM role that can perform kubectl operations against this cluster.
     * <p>
     * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlRole() {
        return software.amazon.jsii.Kernel.get(this, "kubectlRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A security group to use for <code>kubectl</code> execution.
     * <p>
     * Default: - If not specified, the k8s endpoint is expected to be accessible
     * publicly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getKubectlSecurityGroup() {
        return software.amazon.jsii.Kernel.get(this, "kubectlSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
    }

    /**
     * The AWS Lambda layer that contains the NPM dependency <code>proxy-agent</code>.
     * <p>
     * If
     * undefined, a SAR app that contains this layer will be used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
        return software.amazon.jsii.Kernel.get(this, "onEventLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.Cluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.Cluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope a Construct, most likely a cdk.Stack created. This parameter is required.
         * @param id the id of the Construct to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.ClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.ClusterProps.Builder();
        }

        /**
         * The Kubernetes version to run in the cluster.
         * <p>
         * @return {@code this}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final software.amazon.awscdk.services.eks.KubernetesVersion version) {
            this.props.version(version);
            return this;
        }

        /**
         * Name for the cluster.
         * <p>
         * Default: - Automatically generated name
         * <p>
         * @return {@code this}
         * @param clusterName Name for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputClusterName(final java.lang.Boolean outputClusterName) {
            this.props.outputClusterName(outputClusterName);
            return this;
        }

        /**
         * Determines whether a CloudFormation output with the <code>aws eks update-kubeconfig</code> command will be synthesized.
         * <p>
         * This command will include
         * the cluster name and, if applicable, the ARN of the masters IAM role.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param outputConfigCommand Determines whether a CloudFormation output with the <code>aws eks update-kubeconfig</code> command will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConfigCommand(final java.lang.Boolean outputConfigCommand) {
            this.props.outputConfigCommand(outputConfigCommand);
            return this;
        }

        /**
         * Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security Group to use for Control Plane ENIs.
         * <p>
         * Default: - A security group is automatically created
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to use for Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * The VPC in which to create the Cluster.
         * <p>
         * Default: - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which to create the Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place EKS Control Plane ENIs.
         * <p>
         * For example, to only select private subnets, supply the following:
         * <p>
         * <code>vpcSubnets: [{ subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS }]</code>
         * <p>
         * Default: - All public and private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place EKS Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * An AWS Lambda Layer which includes <code>kubectl</code> and Helm.
         * <p>
         * This layer is used by the kubectl handler to apply manifests and install
         * helm charts. You must pick an appropriate releases of one of the
         * <code>&#64;aws-cdk/layer-kubectl-vXX</code> packages, that works with the version of
         * Kubernetes you have chosen.
         * <p>
         * The handler expects the layer to include the following executables:
         * <p>
         * <blockquote><pre>
         * /opt/helm/helm
         * /opt/kubectl/kubectl
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param kubectlLayer An AWS Lambda Layer which includes <code>kubectl</code> and Helm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlLayer(final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.props.kubectlLayer(kubectlLayer);
            return this;
        }

        /**
         * Install the AWS Load Balancer Controller onto the cluster.
         * <p>
         * Default: - The controller is not installed.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes-sigs.github.io/aws-load-balancer-controller">https://kubernetes-sigs.github.io/aws-load-balancer-controller</a>
         * @param albController Install the AWS Load Balancer Controller onto the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder albController(final software.amazon.awscdk.services.eks.AlbControllerOptions albController) {
            this.props.albController(albController);
            return this;
        }

        /**
         * The desired authentication mode for the cluster.
         * <p>
         * Default: AuthenticationMode.CONFIG_MAP
         * <p>
         * @return {@code this}
         * @param authenticationMode The desired authentication mode for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationMode(final software.amazon.awscdk.services.eks.AuthenticationMode authenticationMode) {
            this.props.authenticationMode(authenticationMode);
            return this;
        }

        /**
         * An AWS Lambda layer that contains the <code>aws</code> CLI.
         * <p>
         * The handler expects the layer to include the following executables:
         * <p>
         * <blockquote><pre>
         * /opt/awscli/aws
         * </pre></blockquote>
         * <p>
         * Default: - a default layer with the AWS CLI 1.x
         * <p>
         * @return {@code this}
         * @param awscliLayer An AWS Lambda layer that contains the <code>aws</code> CLI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awscliLayer(final software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer) {
            this.props.awscliLayer(awscliLayer);
            return this;
        }

        /**
         * Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param clusterHandlerEnvironment Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerEnvironment(final java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment) {
            this.props.clusterHandlerEnvironment(clusterHandlerEnvironment);
            return this;
        }

        /**
         * A security group to associate with the Cluster Handler's Lambdas.
         * <p>
         * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         * <p>
         * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
         * <p>
         * Default: - No security group.
         * <p>
         * @return {@code this}
         * @param clusterHandlerSecurityGroup A security group to associate with the Cluster Handler's Lambdas. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup clusterHandlerSecurityGroup) {
            this.props.clusterHandlerSecurityGroup(clusterHandlerSecurityGroup);
            return this;
        }

        /**
         * The cluster log types which you want to enable.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param clusterLogging The cluster log types which you want to enable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterLogging(final java.util.List<? extends software.amazon.awscdk.services.eks.ClusterLoggingTypes> clusterLogging) {
            this.props.clusterLogging(clusterLogging);
            return this;
        }

        /**
         * Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS.
         * <p>
         * Default: CoreDnsComputeType.EC2 (for `FargateCluster` the default is FARGATE)
         * <p>
         * @return {@code this}
         * @param coreDnsComputeType Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDnsComputeType(final software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType) {
            this.props.coreDnsComputeType(coreDnsComputeType);
            return this;
        }

        /**
         * Configure access to the Kubernetes API server endpoint..
         * <p>
         * Default: EndpointAccess.PUBLIC_AND_PRIVATE
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html</a>
         * @param endpointAccess Configure access to the Kubernetes API server endpoint.. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointAccess(final software.amazon.awscdk.services.eks.EndpointAccess endpointAccess) {
            this.props.endpointAccess(endpointAccess);
            return this;
        }

        /**
         * Specify which IP family is used to assign Kubernetes pod and service IP addresses.
         * <p>
         * Default: - IpFamily.IP_V4
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily</a>
         * @param ipFamily Specify which IP family is used to assign Kubernetes pod and service IP addresses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipFamily(final software.amazon.awscdk.services.eks.IpFamily ipFamily) {
            this.props.ipFamily(ipFamily);
            return this;
        }

        /**
         * Environment variables for the kubectl execution.
         * <p>
         * Only relevant for kubectl enabled clusters.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param kubectlEnvironment Environment variables for the kubectl execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlEnvironment(final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.props.kubectlEnvironment(kubectlEnvironment);
            return this;
        }

        /**
         * Amount of memory to allocate to the provider's lambda function.
         * <p>
         * Default: Size.gibibytes(1)
         * <p>
         * @return {@code this}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlMemory(final software.amazon.awscdk.Size kubectlMemory) {
            this.props.kubectlMemory(kubectlMemory);
            return this;
        }

        /**
         * An IAM role that will be added to the <code>system:masters</code> Kubernetes RBAC group.
         * <p>
         * Default: - no masters role.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings">https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings</a>
         * @param mastersRole An IAM role that will be added to the <code>system:masters</code> Kubernetes RBAC group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mastersRole(final software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.props.mastersRole(mastersRole);
            return this;
        }

        /**
         * An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>.
         * <p>
         * This layer
         * is used by the onEvent handler to route AWS SDK requests through a proxy.
         * <p>
         * By default, the provider will use the layer included in the
         * "aws-lambda-layer-node-proxy-agent" SAR application which is available in all
         * commercial regions.
         * <p>
         * To deploy the layer locally define it in your app as follows:
         * <p>
         * <blockquote><pre>
         * LayerVersion layer = LayerVersion.Builder.create(this, "proxy-agent-layer")
         *         .code(Code.fromAsset(String.format("%s/layer.zip", __dirname)))
         *         .compatibleRuntimes(List.of(Runtime.NODEJS_LATEST))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - a layer bundled with this module.
         * <p>
         * @return {@code this}
         * @param onEventLayer An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventLayer(final software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer) {
            this.props.onEventLayer(onEventLayer);
            return this;
        }

        /**
         * Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if <code>mastersRole</code> is specified).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if <code>mastersRole</code> is specified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputMastersRoleArn(final java.lang.Boolean outputMastersRoleArn) {
            this.props.outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        /**
         * If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the <code>vpcSubnets</code> selection strategy.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param placeClusterHandlerInVpc If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the <code>vpcSubnets</code> selection strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placeClusterHandlerInVpc(final java.lang.Boolean placeClusterHandlerInVpc) {
            this.props.placeClusterHandlerInVpc(placeClusterHandlerInVpc);
            return this;
        }

        /**
         * Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned.
         * <p>
         * When this is enabled (default), prune labels will be
         * allocated and injected to each resource. These labels will then be used
         * when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param prune Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(final java.lang.Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        /**
         * IPv4 CIDR blocks defining the expected address range of hybrid nodes that will join the cluster.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param remoteNodeNetworks IPv4 CIDR blocks defining the expected address range of hybrid nodes that will join the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteNodeNetworks(final java.util.List<? extends software.amazon.awscdk.services.eks.RemoteNodeNetwork> remoteNodeNetworks) {
            this.props.remoteNodeNetworks(remoteNodeNetworks);
            return this;
        }

        /**
         * IPv4 CIDR blocks for Pods running Kubernetes webhooks on hybrid nodes.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param remotePodNetworks IPv4 CIDR blocks for Pods running Kubernetes webhooks on hybrid nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remotePodNetworks(final java.util.List<? extends software.amazon.awscdk.services.eks.RemotePodNetwork> remotePodNetworks) {
            this.props.remotePodNetworks(remotePodNetworks);
            return this;
        }

        /**
         * KMS secret for envelope encryption for Kubernetes secrets.
         * <p>
         * Default: - By default, Kubernetes stores all secret object data within etcd and
         *   all etcd volumes used by Amazon EKS are encrypted at the disk-level
         *   using AWS-Managed encryption keys.
         * <p>
         * @return {@code this}
         * @param secretsEncryptionKey KMS secret for envelope encryption for Kubernetes secrets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretsEncryptionKey(final software.amazon.awscdk.services.kms.IKey secretsEncryptionKey) {
            this.props.secretsEncryptionKey(secretsEncryptionKey);
            return this;
        }

        /**
         * The CIDR block to assign Kubernetes service IP addresses from.
         * <p>
         * Default: - Kubernetes assigns addresses from either the
         *   10.100.0.0/16 or 172.20.0.0/16 CIDR blocks
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-serviceIpv4Cidr">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-serviceIpv4Cidr</a>
         * @param serviceIpv4Cidr The CIDR block to assign Kubernetes service IP addresses from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIpv4Cidr(final java.lang.String serviceIpv4Cidr) {
            this.props.serviceIpv4Cidr(serviceIpv4Cidr);
            return this;
        }

        /**
         * Whether or not IAM principal of the cluster creator was set as a cluster admin access entry during cluster creation time.
         * <p>
         * Changing this value after the cluster has been created will result in the cluster being replaced.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param bootstrapClusterCreatorAdminPermissions Whether or not IAM principal of the cluster creator was set as a cluster admin access entry during cluster creation time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapClusterCreatorAdminPermissions(final java.lang.Boolean bootstrapClusterCreatorAdminPermissions) {
            this.props.bootstrapClusterCreatorAdminPermissions(bootstrapClusterCreatorAdminPermissions);
            return this;
        }

        /**
         * Number of instances to allocate as an initial capacity for this cluster.
         * <p>
         * Instance type can be configured through <code>defaultCapacityInstanceType</code>,
         * which defaults to <code>m5.large</code>.
         * <p>
         * Use <code>cluster.addAutoScalingGroupCapacity</code> to add additional customized capacity. Set this
         * to <code>0</code> is you wish to avoid the initial capacity allocation.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param defaultCapacity Number of instances to allocate as an initial capacity for this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacity(final java.lang.Number defaultCapacity) {
            this.props.defaultCapacity(defaultCapacity);
            return this;
        }

        /**
         * The instance type to use for the default capacity.
         * <p>
         * This will only be taken
         * into account if <code>defaultCapacity</code> is &gt; 0.
         * <p>
         * Default: m5.large
         * <p>
         * @return {@code this}
         * @param defaultCapacityInstance The instance type to use for the default capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityInstance(final software.amazon.awscdk.services.ec2.InstanceType defaultCapacityInstance) {
            this.props.defaultCapacityInstance(defaultCapacityInstance);
            return this;
        }

        /**
         * The default capacity type for the cluster.
         * <p>
         * Default: NODEGROUP
         * <p>
         * @return {@code this}
         * @param defaultCapacityType The default capacity type for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityType(final software.amazon.awscdk.services.eks.DefaultCapacityType defaultCapacityType) {
            this.props.defaultCapacityType(defaultCapacityType);
            return this;
        }

        /**
         * The IAM role to pass to the Kubectl Lambda Handler.
         * <p>
         * Default: - Default Lambda IAM Execution Role
         * <p>
         * @return {@code this}
         * @param kubectlLambdaRole The IAM role to pass to the Kubectl Lambda Handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlLambdaRole(final software.amazon.awscdk.services.iam.IRole kubectlLambdaRole) {
            this.props.kubectlLambdaRole(kubectlLambdaRole);
            return this;
        }

        /**
         * The tags assigned to the EKS cluster.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param tags The tags assigned to the EKS cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.Cluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.Cluster build() {
            return new software.amazon.awscdk.services.eks.Cluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
