package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a new action to a listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationListener listener;
 * listener.addAction("Fixed", AddApplicationActionProps.builder()
 *         .priority(10)
 *         .conditions(List.of(ListenerCondition.pathPatterns(List.of("/ok"))))
 *         .action(ListenerAction.fixedResponse(200, FixedResponseOptions.builder()
 *                 .contentType("text/plain")
 *                 .messageBody("OK")
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:17.781Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.AddApplicationActionProps")
@software.amazon.jsii.Jsii.Proxy(AddApplicationActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddApplicationActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {

    /**
     * Action to perform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getAction();

    /**
     * <code>ListenerRule</code>s have a <code>Rule</code> suffix on their logicalId by default. This allows you to remove that suffix.
     * <p>
     * Legacy behavior of the <code>addTargetGroups()</code> convenience method did not include the <code>Rule</code> suffix on the logicalId of the generated <code>ListenerRule</code>.
     * At some point, increasing complexity of requirements can require users to switch from the <code>addTargetGroups()</code> method
     * to the <code>addAction()</code> method.
     * When migrating <code>ListenerRule</code>s deployed by a legacy version of <code>addTargetGroups()</code>,
     * you will need to enable this flag to avoid changing the logicalId of your resource.
     * Otherwise Cfn will attempt to replace the <code>ListenerRule</code> and fail.
     * <p>
     * Default: - use standard logicalId with the `Rule` suffix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRemoveSuffix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddApplicationActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddApplicationActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddApplicationActionProps> {
        software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        java.lang.Boolean removeSuffix;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        java.lang.Number priority;

        /**
         * Sets the value of {@link AddApplicationActionProps#getAction}
         * @param action Action to perform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationActionProps#getRemoveSuffix}
         * @param removeSuffix <code>ListenerRule</code>s have a <code>Rule</code> suffix on their logicalId by default. This allows you to remove that suffix.
         *                     Legacy behavior of the <code>addTargetGroups()</code> convenience method did not include the <code>Rule</code> suffix on the logicalId of the generated <code>ListenerRule</code>.
         *                     At some point, increasing complexity of requirements can require users to switch from the <code>addTargetGroups()</code> method
         *                     to the <code>addAction()</code> method.
         *                     When migrating <code>ListenerRule</code>s deployed by a legacy version of <code>addTargetGroups()</code>,
         *                     you will need to enable this flag to avoid changing the logicalId of your resource.
         *                     Otherwise Cfn will attempt to replace the <code>ListenerRule</code> and fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeSuffix(java.lang.Boolean removeSuffix) {
            this.removeSuffix = removeSuffix;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationActionProps#getConditions}
         * @param conditions Rule applies if matches the conditions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)conditions;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationActionProps#getPriority}
         * @param priority Priority of this target group.
         *                 The rule with the lowest priority will be used for every request.
         *                 If priority is not given, these target groups will be added as
         *                 defaults, and must not have conditions.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddApplicationActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddApplicationActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddApplicationActionProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        private final java.lang.Boolean removeSuffix;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
            this.removeSuffix = software.amazon.jsii.Kernel.get(this, "removeSuffix", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition.class)));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.removeSuffix = builder.removeSuffix;
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)builder.conditions;
            this.priority = builder.priority;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getAction() {
            return this.action;
        }

        @Override
        public final java.lang.Boolean getRemoveSuffix() {
            return this.removeSuffix;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            if (this.getRemoveSuffix() != null) {
                data.set("removeSuffix", om.valueToTree(this.getRemoveSuffix()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.AddApplicationActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddApplicationActionProps.Jsii$Proxy that = (AddApplicationActionProps.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (this.removeSuffix != null ? !this.removeSuffix.equals(that.removeSuffix) : that.removeSuffix != null) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.removeSuffix != null ? this.removeSuffix.hashCode() : 0);
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
