package software.amazon.awscdk.services.events.targets;

/**
 * Use an AppSync GraphQL API as a target for Amazon EventBridge rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.appsync.*;
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .definition(Definition.fromFile("schema.graphql"))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder().authorizationType(AuthorizationType.IAM).build())
 *                 .build())
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(AppSync.Builder.create(api)
 *         .graphQLOperation("mutation Publish($message: String!){ publish(message: $message) { message } }")
 *         .variables(RuleTargetInput.fromObject(Map.of(
 *                 "message", "hello world")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:18.865Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.AppSync")
public class AppSync extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected AppSync(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSync(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param appsyncApi This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppSync(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi appsyncApi, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.AppSyncGraphQLApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(appsyncApi, "appsyncApi is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this AppSync GraphQL API as a result from an EventBridge event.
     * <p>
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this AppSync GraphQL API as a result from an EventBridge event.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.AppSync}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.AppSync> {
        /**
         * @return a new instance of {@link Builder}.
         * @param appsyncApi This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.appsync.IGraphqlApi appsyncApi) {
            return new Builder(appsyncApi);
        }

        private final software.amazon.awscdk.services.appsync.IGraphqlApi appsyncApi;
        private final software.amazon.awscdk.services.events.targets.AppSyncGraphQLApiProps.Builder props;

        private Builder(final software.amazon.awscdk.services.appsync.IGraphqlApi appsyncApi) {
            this.appsyncApi = appsyncApi;
            this.props = new software.amazon.awscdk.services.events.targets.AppSyncGraphQLApiProps.Builder();
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The GraphQL operation;
         * <p>
         * that is, the query, mutation, or subscription
         * to be parsed and executed by the GraphQL service.
         * <p>
         * @return {@code this}
         * @param graphQlOperation The GraphQL operation;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder graphQlOperation(final java.lang.String graphQlOperation) {
            this.props.graphQlOperation(graphQlOperation);
            return this;
        }

        /**
         * The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
         * <p>
         * Default: - a new role with permissions to access mutations will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.props.eventRole(eventRole);
            return this;
        }

        /**
         * The variables that are include in the GraphQL operation.
         * <p>
         * Default: - The entire event is used
         * <p>
         * @return {@code this}
         * @param variables The variables that are include in the GraphQL operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final software.amazon.awscdk.services.events.RuleTargetInput variables) {
            this.props.variables(variables);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.AppSync}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.AppSync build() {
            return new software.amazon.awscdk.services.events.targets.AppSync(
                this.appsyncApi,
                this.props.build()
            );
        }
    }
}
