package software.amazon.awscdk.services.events.targets;

/**
 * Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .build();
 * Queue dlq = new Queue(this, "DeadLetterQueue");
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("events.amazonaws.com"))
 *         .build();
 * StateMachine stateMachine = StateMachine.Builder.create(this, "SM")
 *         .definition(Wait.Builder.create(this, "Hello").time(WaitTime.duration(Duration.seconds(10))).build())
 *         .build();
 * rule.addTarget(SfnStateMachine.Builder.create(stateMachine)
 *         .input(RuleTargetInput.fromObject(Map.of("SomeParam", "SomeValue")))
 *         .deadLetterQueue(dlq)
 *         .role(role)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:18.943Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.SfnStateMachine")
public class SfnStateMachine extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected SfnStateMachine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SfnStateMachine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param machine This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SfnStateMachine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine machine, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.SfnStateMachineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(machine, "machine is required"), props });
    }

    /**
     * @param machine This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SfnStateMachine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine machine) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(machine, "machine is required") });
    }

    /**
     * Returns a properties that are used in an Rule to trigger this State Machine.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions">https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions</a>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns a properties that are used in an Rule to trigger this State Machine.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions">https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions</a>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine getMachine() {
        return software.amazon.jsii.Kernel.get(this, "machine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IStateMachine.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.SfnStateMachine}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.SfnStateMachine> {
        /**
         * @return a new instance of {@link Builder}.
         * @param machine This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.stepfunctions.IStateMachine machine) {
            return new Builder(machine);
        }

        private final software.amazon.awscdk.services.stepfunctions.IStateMachine machine;
        private software.amazon.awscdk.services.events.targets.SfnStateMachineProps.Builder props;

        private Builder(final software.amazon.awscdk.services.stepfunctions.IStateMachine machine) {
            this.machine = machine;
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The input to the state machine execution.
         * <p>
         * Default: the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param input The input to the state machine execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.events.RuleTargetInput input) {
            this.props().input(input);
            return this;
        }

        /**
         * The IAM role to be assumed to execute the State Machine.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role to be assumed to execute the State Machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.SfnStateMachine}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.SfnStateMachine build() {
            return new software.amazon.awscdk.services.events.targets.SfnStateMachine(
                this.machine,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.SfnStateMachineProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.SfnStateMachineProps.Builder();
            }
            return this.props;
        }
    }
}
