package software.amazon.awscdk.services.fsx;

/**
 * Properties for defining a <code>CfnFileSystem</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnFileSystemProps cfnFileSystemProps = CfnFileSystemProps.builder()
 *         .fileSystemType("fileSystemType")
 *         .subnetIds(List.of("subnetIds"))
 *         // the properties below are optional
 *         .backupId("backupId")
 *         .fileSystemTypeVersion("fileSystemTypeVersion")
 *         .kmsKeyId("kmsKeyId")
 *         .lustreConfiguration(LustreConfigurationProperty.builder()
 *                 .autoImportPolicy("autoImportPolicy")
 *                 .automaticBackupRetentionDays(123)
 *                 .copyTagsToBackups(false)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .dataCompressionType("dataCompressionType")
 *                 .deploymentType("deploymentType")
 *                 .driveCacheType("driveCacheType")
 *                 .efaEnabled(false)
 *                 .exportPath("exportPath")
 *                 .importedFileChunkSize(123)
 *                 .importPath("importPath")
 *                 .metadataConfiguration(MetadataConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .perUnitStorageThroughput(123)
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .ontapConfiguration(OntapConfigurationProperty.builder()
 *                 .deploymentType("deploymentType")
 *                 // the properties below are optional
 *                 .automaticBackupRetentionDays(123)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .endpointIpAddressRange("endpointIpAddressRange")
 *                 .fsxAdminPassword("fsxAdminPassword")
 *                 .haPairs(123)
 *                 .preferredSubnetId("preferredSubnetId")
 *                 .routeTableIds(List.of("routeTableIds"))
 *                 .throughputCapacity(123)
 *                 .throughputCapacityPerHaPair(123)
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .openZfsConfiguration(OpenZFSConfigurationProperty.builder()
 *                 .deploymentType("deploymentType")
 *                 // the properties below are optional
 *                 .automaticBackupRetentionDays(123)
 *                 .copyTagsToBackups(false)
 *                 .copyTagsToVolumes(false)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .endpointIpAddressRange("endpointIpAddressRange")
 *                 .options(List.of("options"))
 *                 .preferredSubnetId("preferredSubnetId")
 *                 .readCacheConfiguration(ReadCacheConfigurationProperty.builder()
 *                         .sizeGiB(123)
 *                         .sizingMode("sizingMode")
 *                         .build())
 *                 .rootVolumeConfiguration(RootVolumeConfigurationProperty.builder()
 *                         .copyTagsToSnapshots(false)
 *                         .dataCompressionType("dataCompressionType")
 *                         .nfsExports(List.of(NfsExportsProperty.builder()
 *                                 .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
 *                                         .clients("clients")
 *                                         .options(List.of("options"))
 *                                         .build()))
 *                                 .build()))
 *                         .readOnly(false)
 *                         .recordSizeKiB(123)
 *                         .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
 *                                 .id(123)
 *                                 .storageCapacityQuotaGiB(123)
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .routeTableIds(List.of("routeTableIds"))
 *                 .throughputCapacity(123)
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .storageCapacity(123)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .windowsConfiguration(WindowsConfigurationProperty.builder()
 *                 .throughputCapacity(123)
 *                 // the properties below are optional
 *                 .activeDirectoryId("activeDirectoryId")
 *                 .aliases(List.of("aliases"))
 *                 .auditLogConfiguration(AuditLogConfigurationProperty.builder()
 *                         .fileAccessAuditLogLevel("fileAccessAuditLogLevel")
 *                         .fileShareAccessAuditLogLevel("fileShareAccessAuditLogLevel")
 *                         // the properties below are optional
 *                         .auditLogDestination("auditLogDestination")
 *                         .build())
 *                 .automaticBackupRetentionDays(123)
 *                 .copyTagsToBackups(false)
 *                 .dailyAutomaticBackupStartTime("dailyAutomaticBackupStartTime")
 *                 .deploymentType("deploymentType")
 *                 .diskIopsConfiguration(DiskIopsConfigurationProperty.builder()
 *                         .iops(123)
 *                         .mode("mode")
 *                         .build())
 *                 .preferredSubnetId("preferredSubnetId")
 *                 .selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty.builder()
 *                         .dnsIps(List.of("dnsIps"))
 *                         .domainName("domainName")
 *                         .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
 *                         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
 *                         .password("password")
 *                         .userName("userName")
 *                         .build())
 *                 .weeklyMaintenanceStartTime("weeklyMaintenanceStartTime")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:19.220Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystemProps")
@software.amazon.jsii.Jsii.Proxy(CfnFileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of Amazon FSx file system, which can be <code>LUSTRE</code> , <code>WINDOWS</code> , <code>ONTAP</code> , or <code>OPENZFS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemType();

    /**
     * Specifies the IDs of the subnets that the file system will be accessible from.
     * <p>
     * For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <em>Amazon FSx for Windows User Guide</em> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">Availability and durability</a> in the <em>Amazon FSx for ONTAP User Guide</em> .
     * <p>
     * For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * The ID of the file system backup that you are using to create a file system.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemFromBackup.html">CreateFileSystemFromBackup</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return null;
    }

    /**
     * For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating.
     * <p>
     * Valid values are <code>2.10</code> , <code>2.12</code> , and <code>2.15</code> :
     * <p>
     * <ul>
     * <li><code>2.10</code> is supported by the Scratch and Persistent_1 Lustre deployment types.</li>
     * <li><code>2.12</code> is supported by all Lustre deployment types, except for <code>PERSISTENT_2</code> with a metadata configuration mode.</li>
     * <li><code>2.15</code> is supported by all Lustre deployment types and is recommended for all new file systems.</li>
     * </ul>
     * <p>
     * Default value is <code>2.10</code> , except for the following deployments:
     * <p>
     * <ul>
     * <li>Default value is <code>2.12</code> when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code> without a metadata configuration mode.</li>
     * <li>Default value is <code>2.15</code> when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code> with a metadata configuration mode.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtypeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtypeversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemTypeVersion() {
        return null;
    }

    /**
     * The ID of the AWS Key Management Service ( AWS KMS ) key used to encrypt Amazon FSx file system data.
     * <p>
     * Used as follows with Amazon FSx file system types:
     * <p>
     * <ul>
     * <li>Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types only.</li>
     * </ul>
     * <p>
     * <code>SCRATCH_1</code> and <code>SCRATCH_2</code> types are encrypted using the Amazon FSx service AWS KMS key for your account.
     * <p>
     * <ul>
     * <li>Amazon FSx for NetApp ONTAP</li>
     * <li>Amazon FSx for OpenZFS</li>
     * <li>Amazon FSx for Windows File Server</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The Lustre configuration for the file system being created.
     * <p>
     * <blockquote>
     * <p>
     * The following parameters are not supported when creating Lustre file systems with a data repository association.
     * <p>
     * <ul>
     * <li><code>AutoImportPolicy</code></li>
     * <li><code>ExportPath</code></li>
     * <li><code>ImportedChunkSize</code></li>
     * <li><code>ImportPath</code></li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLustreConfiguration() {
        return null;
    }

    /**
     * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-ontapconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOntapConfiguration() {
        return null;
    }

    /**
     * The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-openzfsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenZfsConfiguration() {
        return null;
    }

    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for file system access.
     * <p>
     * This list isn't returned in later requests to describe the file system.
     * <p>
     * <blockquote>
     * <p>
     * You must specify a security group if you are creating a Multi-AZ FSx for ONTAP file system in a VPC subnet that has been shared with you.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * Sets the storage capacity of the file system that you're creating.
     * <p>
     * <code>StorageCapacity</code> is required if you are creating a new file system. It is not required if you are creating a file system by restoring a backup.
     * <p>
     * <em>FSx for Lustre file systems</em> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code> , as follows:
     * <p>
     * <ul>
     * <li>For <code>SCRATCH_2</code> , <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</li>
     * <li>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</li>
     * <li>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</li>
     * </ul>
     * <p>
     * <em>FSx for ONTAP file systems</em> - The amount of SSD storage capacity that you can configure depends on the value of the <code>HAPairs</code> property. The minimum value is calculated as 1,024 GiB * HAPairs and the maximum is calculated as 524,288 GiB * HAPairs, up to a maximum amount of SSD storage capacity of 1,048,576 GiB (1 pebibyte).
     * <p>
     * <em>FSx for OpenZFS file systems</em> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB). If you are creating a file system from a backup, you can specify a storage capacity equal to or greater than the original file system's storage capacity.
     * <p>
     * <em>FSx for Windows File Server file systems</em> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:
     * <p>
     * <ul>
     * <li>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</li>
     * <li>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacity() {
        return null;
    }

    /**
     * Sets the storage class for the file system that you're creating.
     * <p>
     * Valid values are <code>SSD</code> , <code>HDD</code> , and <code>INTELLIGENT_TIERING</code> .
     * <p>
     * <ul>
     * <li>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</li>
     * <li>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types.</li>
     * <li>Set to <code>INTELLIGENT_TIERING</code> to use fully elastic, intelligently-tiered storage. Intelligent-Tiering is only available for OpenZFS file systems with the Multi-AZ deployment type.</li>
     * </ul>
     * <p>
     * Default value is <code>SSD</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">Storage type options</a> in the <em>FSx for Windows File Server User Guide</em> , <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple storage options</a> in the <em>FSx for Lustre User Guide</em> , and <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance-intelligent-tiering">Working with Intelligent-Tiering</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return null;
    }

    /**
     * The tags to associate with the file system.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/tag-resources.html">Tagging your Amazon FSx resources</a> in the <em>Amazon FSx for Lustre User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The configuration object for the Microsoft Windows file system you are creating.
     * <p>
     * This value is required if <code>FileSystemType</code> is set to <code>WINDOWS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWindowsConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFileSystemProps> {
        java.lang.String fileSystemType;
        java.util.List<java.lang.String> subnetIds;
        java.lang.String backupId;
        java.lang.String fileSystemTypeVersion;
        java.lang.String kmsKeyId;
        java.lang.Object lustreConfiguration;
        java.lang.Object ontapConfiguration;
        java.lang.Object openZfsConfiguration;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.Number storageCapacity;
        java.lang.String storageType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object windowsConfiguration;

        /**
         * Sets the value of {@link CfnFileSystemProps#getFileSystemType}
         * @param fileSystemType The type of Amazon FSx file system, which can be <code>LUSTRE</code> , <code>WINDOWS</code> , <code>ONTAP</code> , or <code>OPENZFS</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemType(java.lang.String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getSubnetIds}
         * @param subnetIds Specifies the IDs of the subnets that the file system will be accessible from. This parameter is required.
         *                  For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <em>Amazon FSx for Windows User Guide</em> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">Availability and durability</a> in the <em>Amazon FSx for ONTAP User Guide</em> .
         *                  <p>
         *                  For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getBackupId}
         * @param backupId The ID of the file system backup that you are using to create a file system.
         *                 For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemFromBackup.html">CreateFileSystemFromBackup</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(java.lang.String backupId) {
            this.backupId = backupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getFileSystemTypeVersion}
         * @param fileSystemTypeVersion For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating.
         *                              Valid values are <code>2.10</code> , <code>2.12</code> , and <code>2.15</code> :
         *                              <p>
         *                              <ul>
         *                              <li><code>2.10</code> is supported by the Scratch and Persistent_1 Lustre deployment types.</li>
         *                              <li><code>2.12</code> is supported by all Lustre deployment types, except for <code>PERSISTENT_2</code> with a metadata configuration mode.</li>
         *                              <li><code>2.15</code> is supported by all Lustre deployment types and is recommended for all new file systems.</li>
         *                              </ul>
         *                              <p>
         *                              Default value is <code>2.10</code> , except for the following deployments:
         *                              <p>
         *                              <ul>
         *                              <li>Default value is <code>2.12</code> when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code> without a metadata configuration mode.</li>
         *                              <li>Default value is <code>2.15</code> when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code> with a metadata configuration mode.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemTypeVersion(java.lang.String fileSystemTypeVersion) {
            this.fileSystemTypeVersion = fileSystemTypeVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getKmsKeyId}
         * @param kmsKeyId The ID of the AWS Key Management Service ( AWS KMS ) key used to encrypt Amazon FSx file system data.
         *                 Used as follows with Amazon FSx file system types:
         *                 <p>
         *                 <ul>
         *                 <li>Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types only.</li>
         *                 </ul>
         *                 <p>
         *                 <code>SCRATCH_1</code> and <code>SCRATCH_2</code> types are encrypted using the Amazon FSx service AWS KMS key for your account.
         *                 <p>
         *                 <ul>
         *                 <li>Amazon FSx for NetApp ONTAP</li>
         *                 <li>Amazon FSx for OpenZFS</li>
         *                 <li>Amazon FSx for Windows File Server</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getLustreConfiguration}
         * @param lustreConfiguration The Lustre configuration for the file system being created.
         *                            <blockquote>
         *                            <p>
         *                            The following parameters are not supported when creating Lustre file systems with a data repository association.
         *                            <p>
         *                            <ul>
         *                            <li><code>AutoImportPolicy</code></li>
         *                            <li><code>ExportPath</code></li>
         *                            <li><code>ImportedChunkSize</code></li>
         *                            <li><code>ImportPath</code></li>
         *                            </ul>
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(software.amazon.awscdk.IResolvable lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getLustreConfiguration}
         * @param lustreConfiguration The Lustre configuration for the file system being created.
         *                            <blockquote>
         *                            <p>
         *                            The following parameters are not supported when creating Lustre file systems with a data repository association.
         *                            <p>
         *                            <ul>
         *                            <li><code>AutoImportPolicy</code></li>
         *                            <li><code>ExportPath</code></li>
         *                            <li><code>ImportedChunkSize</code></li>
         *                            <li><code>ImportPath</code></li>
         *                            </ul>
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.LustreConfigurationProperty lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getOntapConfiguration}
         * @param ontapConfiguration The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(software.amazon.awscdk.IResolvable ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getOntapConfiguration}
         * @param ontapConfiguration The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.OntapConfigurationProperty ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getOpenZfsConfiguration}
         * @param openZfsConfiguration The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(software.amazon.awscdk.IResolvable openZfsConfiguration) {
            this.openZfsConfiguration = openZfsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getOpenZfsConfiguration}
         * @param openZfsConfiguration The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.OpenZFSConfigurationProperty openZfsConfiguration) {
            this.openZfsConfiguration = openZfsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getSecurityGroupIds}
         * @param securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for file system access.
         *                         This list isn't returned in later requests to describe the file system.
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         You must specify a security group if you are creating a Multi-AZ FSx for ONTAP file system in a VPC subnet that has been shared with you.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getStorageCapacity}
         * @param storageCapacity Sets the storage capacity of the file system that you're creating.
         *                        <code>StorageCapacity</code> is required if you are creating a new file system. It is not required if you are creating a file system by restoring a backup.
         *                        <p>
         *                        <em>FSx for Lustre file systems</em> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code> , as follows:
         *                        <p>
         *                        <ul>
         *                        <li>For <code>SCRATCH_2</code> , <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</li>
         *                        <li>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</li>
         *                        <li>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</li>
         *                        </ul>
         *                        <p>
         *                        <em>FSx for ONTAP file systems</em> - The amount of SSD storage capacity that you can configure depends on the value of the <code>HAPairs</code> property. The minimum value is calculated as 1,024 GiB * HAPairs and the maximum is calculated as 524,288 GiB * HAPairs, up to a maximum amount of SSD storage capacity of 1,048,576 GiB (1 pebibyte).
         *                        <p>
         *                        <em>FSx for OpenZFS file systems</em> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB). If you are creating a file system from a backup, you can specify a storage capacity equal to or greater than the original file system's storage capacity.
         *                        <p>
         *                        <em>FSx for Windows File Server file systems</em> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:
         *                        <p>
         *                        <ul>
         *                        <li>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</li>
         *                        <li>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacity(java.lang.Number storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getStorageType}
         * @param storageType Sets the storage class for the file system that you're creating.
         *                    Valid values are <code>SSD</code> , <code>HDD</code> , and <code>INTELLIGENT_TIERING</code> .
         *                    <p>
         *                    <ul>
         *                    <li>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</li>
         *                    <li>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types.</li>
         *                    <li>Set to <code>INTELLIGENT_TIERING</code> to use fully elastic, intelligently-tiered storage. Intelligent-Tiering is only available for OpenZFS file systems with the Multi-AZ deployment type.</li>
         *                    </ul>
         *                    <p>
         *                    Default value is <code>SSD</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">Storage type options</a> in the <em>FSx for Windows File Server User Guide</em> , <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple storage options</a> in the <em>FSx for Lustre User Guide</em> , and <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance-intelligent-tiering">Working with Intelligent-Tiering</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getTags}
         * @param tags The tags to associate with the file system.
         *             For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/tag-resources.html">Tagging your Amazon FSx resources</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getWindowsConfiguration}
         * @param windowsConfiguration The configuration object for the Microsoft Windows file system you are creating.
         *                             This value is required if <code>FileSystemType</code> is set to <code>WINDOWS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsConfiguration(software.amazon.awscdk.IResolvable windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getWindowsConfiguration}
         * @param windowsConfiguration The configuration object for the Microsoft Windows file system you are creating.
         *                             This value is required if <code>FileSystemType</code> is set to <code>WINDOWS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.WindowsConfigurationProperty windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFileSystemProps {
        private final java.lang.String fileSystemType;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String backupId;
        private final java.lang.String fileSystemTypeVersion;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object lustreConfiguration;
        private final java.lang.Object ontapConfiguration;
        private final java.lang.Object openZfsConfiguration;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.Number storageCapacity;
        private final java.lang.String storageType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object windowsConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemType = software.amazon.jsii.Kernel.get(this, "fileSystemType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.backupId = software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemTypeVersion = software.amazon.jsii.Kernel.get(this, "fileSystemTypeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lustreConfiguration = software.amazon.jsii.Kernel.get(this, "lustreConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ontapConfiguration = software.amazon.jsii.Kernel.get(this, "ontapConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.openZfsConfiguration = software.amazon.jsii.Kernel.get(this, "openZfsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.storageCapacity = software.amazon.jsii.Kernel.get(this, "storageCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.windowsConfiguration = software.amazon.jsii.Kernel.get(this, "windowsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemType = java.util.Objects.requireNonNull(builder.fileSystemType, "fileSystemType is required");
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.backupId = builder.backupId;
            this.fileSystemTypeVersion = builder.fileSystemTypeVersion;
            this.kmsKeyId = builder.kmsKeyId;
            this.lustreConfiguration = builder.lustreConfiguration;
            this.ontapConfiguration = builder.ontapConfiguration;
            this.openZfsConfiguration = builder.openZfsConfiguration;
            this.securityGroupIds = builder.securityGroupIds;
            this.storageCapacity = builder.storageCapacity;
            this.storageType = builder.storageType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.windowsConfiguration = builder.windowsConfiguration;
        }

        @Override
        public final java.lang.String getFileSystemType() {
            return this.fileSystemType;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.lang.String getBackupId() {
            return this.backupId;
        }

        @Override
        public final java.lang.String getFileSystemTypeVersion() {
            return this.fileSystemTypeVersion;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getLustreConfiguration() {
            return this.lustreConfiguration;
        }

        @Override
        public final java.lang.Object getOntapConfiguration() {
            return this.ontapConfiguration;
        }

        @Override
        public final java.lang.Object getOpenZfsConfiguration() {
            return this.openZfsConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.Number getStorageCapacity() {
            return this.storageCapacity;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWindowsConfiguration() {
            return this.windowsConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemType", om.valueToTree(this.getFileSystemType()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            if (this.getBackupId() != null) {
                data.set("backupId", om.valueToTree(this.getBackupId()));
            }
            if (this.getFileSystemTypeVersion() != null) {
                data.set("fileSystemTypeVersion", om.valueToTree(this.getFileSystemTypeVersion()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLustreConfiguration() != null) {
                data.set("lustreConfiguration", om.valueToTree(this.getLustreConfiguration()));
            }
            if (this.getOntapConfiguration() != null) {
                data.set("ontapConfiguration", om.valueToTree(this.getOntapConfiguration()));
            }
            if (this.getOpenZfsConfiguration() != null) {
                data.set("openZfsConfiguration", om.valueToTree(this.getOpenZfsConfiguration()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getStorageCapacity() != null) {
                data.set("storageCapacity", om.valueToTree(this.getStorageCapacity()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWindowsConfiguration() != null) {
                data.set("windowsConfiguration", om.valueToTree(this.getWindowsConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFileSystemProps.Jsii$Proxy that = (CfnFileSystemProps.Jsii$Proxy) o;

            if (!fileSystemType.equals(that.fileSystemType)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            if (this.backupId != null ? !this.backupId.equals(that.backupId) : that.backupId != null) return false;
            if (this.fileSystemTypeVersion != null ? !this.fileSystemTypeVersion.equals(that.fileSystemTypeVersion) : that.fileSystemTypeVersion != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.lustreConfiguration != null ? !this.lustreConfiguration.equals(that.lustreConfiguration) : that.lustreConfiguration != null) return false;
            if (this.ontapConfiguration != null ? !this.ontapConfiguration.equals(that.ontapConfiguration) : that.ontapConfiguration != null) return false;
            if (this.openZfsConfiguration != null ? !this.openZfsConfiguration.equals(that.openZfsConfiguration) : that.openZfsConfiguration != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.storageCapacity != null ? !this.storageCapacity.equals(that.storageCapacity) : that.storageCapacity != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.windowsConfiguration != null ? this.windowsConfiguration.equals(that.windowsConfiguration) : that.windowsConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystemType.hashCode();
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.backupId != null ? this.backupId.hashCode() : 0);
            result = 31 * result + (this.fileSystemTypeVersion != null ? this.fileSystemTypeVersion.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.lustreConfiguration != null ? this.lustreConfiguration.hashCode() : 0);
            result = 31 * result + (this.ontapConfiguration != null ? this.ontapConfiguration.hashCode() : 0);
            result = 31 * result + (this.openZfsConfiguration != null ? this.openZfsConfiguration.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.storageCapacity != null ? this.storageCapacity.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.windowsConfiguration != null ? this.windowsConfiguration.hashCode() : 0);
            return result;
        }
    }
}
