package software.amazon.awscdk.services.fsx;

/**
 * The different kinds of file system deployments used by Lustre.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * Vpc vpc;
 * Bucket bucket;
 * Map&lt;String, Object&gt; lustreConfiguration = Map.of(
 *         "deploymentType", LustreDeploymentType.SCRATCH_2,
 *         "exportPath", bucket.s3UrlForObject(),
 *         "importPath", bucket.s3UrlForObject(),
 *         "autoImportPolicy", LustreAutoImportPolicy.NEW_CHANGED_DELETED);
 * LustreFileSystem fs = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .storageCapacityGiB(1200)
 *         .lustreConfiguration(lustreConfiguration)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:19.253Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreDeploymentType")
public enum LustreDeploymentType {
    /**
     * Original type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCRATCH_1,
    /**
     * Newer type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     * Provides better support for spiky workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCRATCH_2,
    /**
     * Long term storage.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERSISTENT_1,
    /**
     * Newer type of long term storage with higher throughput tiers.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERSISTENT_2,
}
