package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnTableOptimizer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnTableOptimizerProps cfnTableOptimizerProps = CfnTableOptimizerProps.builder()
 *         .catalogId("catalogId")
 *         .databaseName("databaseName")
 *         .tableName("tableName")
 *         .tableOptimizerConfiguration(TableOptimizerConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .orphanFileDeletionConfiguration(OrphanFileDeletionConfigurationProperty.builder()
 *                         .icebergConfiguration(IcebergConfigurationProperty.builder()
 *                                 .location("location")
 *                                 .orphanFileRetentionPeriodInDays(123)
 *                                 .build())
 *                         .build())
 *                 .retentionConfiguration(RetentionConfigurationProperty.builder()
 *                         .icebergConfiguration(IcebergConfigurationProperty.builder()
 *                                 .location("location")
 *                                 .orphanFileRetentionPeriodInDays(123)
 *                                 .build())
 *                         .build())
 *                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                         .glueConnectionName("glueConnectionName")
 *                         .build())
 *                 .build())
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:19.520Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableOptimizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableOptimizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The catalog ID of the table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-catalogid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

    /**
     * The name of the database.
     * <p>
     * For Hive compatibility, this is folded to lowercase when it is stored.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * The table name.
     * <p>
     * For Hive compatibility, this must be entirely lowercase.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tablename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * Specifies configuration details of a table optimizer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTableOptimizerConfiguration();

    /**
     * The type of table optimizer.
     * <p>
     * Currently, the only valid value is compaction.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * @return a {@link Builder} of {@link CfnTableOptimizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableOptimizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableOptimizerProps> {
        java.lang.String catalogId;
        java.lang.String databaseName;
        java.lang.String tableName;
        java.lang.Object tableOptimizerConfiguration;
        java.lang.String type;

        /**
         * Sets the value of {@link CfnTableOptimizerProps#getCatalogId}
         * @param catalogId The catalog ID of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(java.lang.String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableOptimizerProps#getDatabaseName}
         * @param databaseName The name of the database. This parameter is required.
         *                     For Hive compatibility, this is folded to lowercase when it is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableOptimizerProps#getTableName}
         * @param tableName The table name. This parameter is required.
         *                  For Hive compatibility, this must be entirely lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableOptimizerProps#getTableOptimizerConfiguration}
         * @param tableOptimizerConfiguration Specifies configuration details of a table optimizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableOptimizerConfiguration(software.amazon.awscdk.IResolvable tableOptimizerConfiguration) {
            this.tableOptimizerConfiguration = tableOptimizerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableOptimizerProps#getTableOptimizerConfiguration}
         * @param tableOptimizerConfiguration Specifies configuration details of a table optimizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableOptimizerConfiguration(software.amazon.awscdk.services.glue.CfnTableOptimizer.TableOptimizerConfigurationProperty tableOptimizerConfiguration) {
            this.tableOptimizerConfiguration = tableOptimizerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableOptimizerProps#getType}
         * @param type The type of table optimizer. This parameter is required.
         *             Currently, the only valid value is compaction.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableOptimizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableOptimizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableOptimizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableOptimizerProps {
        private final java.lang.String catalogId;
        private final java.lang.String databaseName;
        private final java.lang.String tableName;
        private final java.lang.Object tableOptimizerConfiguration;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableOptimizerConfiguration = software.amazon.jsii.Kernel.get(this, "tableOptimizerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            this.tableOptimizerConfiguration = java.util.Objects.requireNonNull(builder.tableOptimizerConfiguration, "tableOptimizerConfiguration is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
        }

        @Override
        public final java.lang.String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.lang.Object getTableOptimizerConfiguration() {
            return this.tableOptimizerConfiguration;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("catalogId", om.valueToTree(this.getCatalogId()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            data.set("tableOptimizerConfiguration", om.valueToTree(this.getTableOptimizerConfiguration()));
            data.set("type", om.valueToTree(this.getType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableOptimizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableOptimizerProps.Jsii$Proxy that = (CfnTableOptimizerProps.Jsii$Proxy) o;

            if (!catalogId.equals(that.catalogId)) return false;
            if (!databaseName.equals(that.databaseName)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (!tableOptimizerConfiguration.equals(that.tableOptimizerConfiguration)) return false;
            return this.type.equals(that.type);
        }

        @Override
        public final int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + (this.databaseName.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.tableOptimizerConfiguration.hashCode());
            result = 31 * result + (this.type.hashCode());
            return result;
        }
    }
}
