package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnThingGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThingGroupProps cfnThingGroupProps = CfnThingGroupProps.builder()
 *         .parentGroupName("parentGroupName")
 *         .queryString("queryString")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thingGroupName("thingGroupName")
 *         .thingGroupProperties(ThingGroupPropertiesProperty.builder()
 *                 .attributePayload(AttributePayloadProperty.builder()
 *                         .attributes(Map.of(
 *                                 "attributesKey", "attributes"))
 *                         .build())
 *                 .thingGroupDescription("thingGroupDescription")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.055Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnThingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnThingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The parent thing group name.
     * <p>
     * A Dynamic Thing Group does not have <code>parentGroupName</code> defined.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-parentgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-parentgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getParentGroupName() {
        return null;
    }

    /**
     * The dynamic thing group search query string.
     * <p>
     * The <code>queryString</code> attribute <em>is</em> required for <code>CreateDynamicThingGroup</code> . The <code>queryString</code> attribute <em>is not</em> required for <code>CreateThingGroup</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-querystring</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueryString() {
        return null;
    }

    /**
     * Metadata which can be used to manage the thing group or dynamic thing group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The thing group name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-thinggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-thinggroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThingGroupName() {
        return null;
    }

    /**
     * Thing group properties.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-thinggroupproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thinggroup.html#cfn-iot-thinggroup-thinggroupproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getThingGroupProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnThingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnThingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnThingGroupProps> {
        java.lang.String parentGroupName;
        java.lang.String queryString;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String thingGroupName;
        java.lang.Object thingGroupProperties;

        /**
         * Sets the value of {@link CfnThingGroupProps#getParentGroupName}
         * @param parentGroupName The parent thing group name.
         *                        A Dynamic Thing Group does not have <code>parentGroupName</code> defined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentGroupName(java.lang.String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingGroupProps#getQueryString}
         * @param queryString The dynamic thing group search query string.
         *                    The <code>queryString</code> attribute <em>is</em> required for <code>CreateDynamicThingGroup</code> . The <code>queryString</code> attribute <em>is not</em> required for <code>CreateThingGroup</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(java.lang.String queryString) {
            this.queryString = queryString;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingGroupProps#getTags}
         * @param tags Metadata which can be used to manage the thing group or dynamic thing group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingGroupProps#getThingGroupName}
         * @param thingGroupName The thing group name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingGroupName(java.lang.String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingGroupProps#getThingGroupProperties}
         * @param thingGroupProperties Thing group properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingGroupProperties(software.amazon.awscdk.IResolvable thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingGroupProps#getThingGroupProperties}
         * @param thingGroupProperties Thing group properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingGroupProperties(software.amazon.awscdk.services.iot.CfnThingGroup.ThingGroupPropertiesProperty thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnThingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnThingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnThingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnThingGroupProps {
        private final java.lang.String parentGroupName;
        private final java.lang.String queryString;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String thingGroupName;
        private final java.lang.Object thingGroupProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parentGroupName = software.amazon.jsii.Kernel.get(this, "parentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.thingGroupName = software.amazon.jsii.Kernel.get(this, "thingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingGroupProperties = software.amazon.jsii.Kernel.get(this, "thingGroupProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parentGroupName = builder.parentGroupName;
            this.queryString = builder.queryString;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.thingGroupName = builder.thingGroupName;
            this.thingGroupProperties = builder.thingGroupProperties;
        }

        @Override
        public final java.lang.String getParentGroupName() {
            return this.parentGroupName;
        }

        @Override
        public final java.lang.String getQueryString() {
            return this.queryString;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final java.lang.Object getThingGroupProperties() {
            return this.thingGroupProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getParentGroupName() != null) {
                data.set("parentGroupName", om.valueToTree(this.getParentGroupName()));
            }
            if (this.getQueryString() != null) {
                data.set("queryString", om.valueToTree(this.getQueryString()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThingGroupName() != null) {
                data.set("thingGroupName", om.valueToTree(this.getThingGroupName()));
            }
            if (this.getThingGroupProperties() != null) {
                data.set("thingGroupProperties", om.valueToTree(this.getThingGroupProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnThingGroupProps.Jsii$Proxy that = (CfnThingGroupProps.Jsii$Proxy) o;

            if (this.parentGroupName != null ? !this.parentGroupName.equals(that.parentGroupName) : that.parentGroupName != null) return false;
            if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.thingGroupName != null ? !this.thingGroupName.equals(that.thingGroupName) : that.thingGroupName != null) return false;
            return this.thingGroupProperties != null ? this.thingGroupProperties.equals(that.thingGroupProperties) : that.thingGroupProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parentGroupName != null ? this.parentGroupName.hashCode() : 0;
            result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.thingGroupName != null ? this.thingGroupName.hashCode() : 0);
            result = 31 * result + (this.thingGroupProperties != null ? this.thingGroupProperties.hashCode() : 0);
            return result;
        }
    }
}
