package software.amazon.awscdk.services.iotanalytics;

/**
 * The AWS::IoTAnalytics::Dataset resource stores data retrieved from a data store by applying a <code>queryAction</code> (an SQL query) or a <code>containerAction</code> (executing a containerized application).
 * <p>
 * The data set can be populated manually by calling <code>CreateDatasetContent</code> or automatically according to a <code>trigger</code> you specify. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/welcome.html#aws-iot-analytics-how">How to Use AWS IoT Analytics</a> in the <em>AWS IoT Analytics User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * CfnDataset cfnDataset = CfnDataset.Builder.create(this, "MyCfnDataset")
 *         .actions(List.of(ActionProperty.builder()
 *                 .actionName("actionName")
 *                 // the properties below are optional
 *                 .containerAction(ContainerActionProperty.builder()
 *                         .executionRoleArn("executionRoleArn")
 *                         .image("image")
 *                         .resourceConfiguration(ResourceConfigurationProperty.builder()
 *                                 .computeType("computeType")
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .variables(List.of(VariableProperty.builder()
 *                                 .variableName("variableName")
 *                                 // the properties below are optional
 *                                 .datasetContentVersionValue(DatasetContentVersionValueProperty.builder()
 *                                         .datasetName("datasetName")
 *                                         .build())
 *                                 .doubleValue(123)
 *                                 .outputFileUriValue(OutputFileUriValueProperty.builder()
 *                                         .fileName("fileName")
 *                                         .build())
 *                                 .stringValue("stringValue")
 *                                 .build()))
 *                         .build())
 *                 .queryAction(QueryActionProperty.builder()
 *                         .sqlQuery("sqlQuery")
 *                         // the properties below are optional
 *                         .filters(List.of(FilterProperty.builder()
 *                                 .deltaTime(DeltaTimeProperty.builder()
 *                                         .offsetSeconds(123)
 *                                         .timeExpression("timeExpression")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .contentDeliveryRules(List.of(DatasetContentDeliveryRuleProperty.builder()
 *                 .destination(DatasetContentDeliveryRuleDestinationProperty.builder()
 *                         .iotEventsDestinationConfiguration(IotEventsDestinationConfigurationProperty.builder()
 *                                 .inputName("inputName")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .glueConfiguration(GlueConfigurationProperty.builder()
 *                                         .databaseName("databaseName")
 *                                         .tableName("tableName")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .entryName("entryName")
 *                 .build()))
 *         .datasetName("datasetName")
 *         .lateDataRules(List.of(LateDataRuleProperty.builder()
 *                 .ruleConfiguration(LateDataRuleConfigurationProperty.builder()
 *                         .deltaTimeSessionWindowConfiguration(DeltaTimeSessionWindowConfigurationProperty.builder()
 *                                 .timeoutInMinutes(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .ruleName("ruleName")
 *                 .build()))
 *         .retentionPeriod(RetentionPeriodProperty.builder()
 *                 .numberOfDays(123)
 *                 .unlimited(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggers(List.of(TriggerProperty.builder()
 *                 .schedule(ScheduleProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         .build())
 *                 .triggeringDataset(TriggeringDatasetProperty.builder()
 *                         .datasetName("datasetName")
 *                         .build())
 *                 .build()))
 *         .versioningConfiguration(VersioningConfigurationProperty.builder()
 *                 .maxVersions(123)
 *                 .unlimited(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.107Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset")
public class CfnDataset extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDataset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotanalytics.CfnDataset.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotanalytics.CfnDatasetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The <code>DatasetAction</code> objects that automatically create the dataset contents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>DatasetAction</code> objects that automatically create the dataset contents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * The <code>DatasetAction</code> objects that automatically create the dataset contents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotanalytics.CfnDataset.ActionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotanalytics.CfnDataset.ActionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * When dataset contents are created they are delivered to destinations specified here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContentDeliveryRules() {
        return software.amazon.jsii.Kernel.get(this, "contentDeliveryRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When dataset contents are created they are delivered to destinations specified here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentDeliveryRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contentDeliveryRules", value);
    }

    /**
     * When dataset contents are created they are delivered to destinations specified here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentDeliveryRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotanalytics.CfnDataset.DatasetContentDeliveryRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotanalytics.CfnDataset.DatasetContentDeliveryRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "contentDeliveryRules", value);
    }

    /**
     * The name of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatasetName() {
        return software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetName", value);
    }

    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLateDataRules() {
        return software.amazon.jsii.Kernel.get(this, "lateDataRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLateDataRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lateDataRules", value);
    }

    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLateDataRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotanalytics.CfnDataset.LateDataRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotanalytics.CfnDataset.LateDataRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "lateDataRules", value);
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDataset.RetentionPeriodProperty value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * Metadata which can be used to manage the data set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata which can be used to manage the data set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotanalytics.CfnDataset.TriggerProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotanalytics.CfnDataset.TriggerProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVersioningConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "versioningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "versioningConfiguration", value);
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersioningConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotanalytics.CfnDataset.VersioningConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "versioningConfiguration", value);
    }
    /**
     * Information needed to run the "containerAction" to produce data set contents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .actionName("actionName")
     *         // the properties below are optional
     *         .containerAction(ContainerActionProperty.builder()
     *                 .executionRoleArn("executionRoleArn")
     *                 .image("image")
     *                 .resourceConfiguration(ResourceConfigurationProperty.builder()
     *                         .computeType("computeType")
     *                         .volumeSizeInGb(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .variables(List.of(VariableProperty.builder()
     *                         .variableName("variableName")
     *                         // the properties below are optional
     *                         .datasetContentVersionValue(DatasetContentVersionValueProperty.builder()
     *                                 .datasetName("datasetName")
     *                                 .build())
     *                         .doubleValue(123)
     *                         .outputFileUriValue(OutputFileUriValueProperty.builder()
     *                                 .fileName("fileName")
     *                                 .build())
     *                         .stringValue("stringValue")
     *                         .build()))
     *                 .build())
     *         .queryAction(QueryActionProperty.builder()
     *                 .sqlQuery("sqlQuery")
     *                 // the properties below are optional
     *                 .filters(List.of(FilterProperty.builder()
     *                         .deltaTime(DeltaTimeProperty.builder()
     *                                 .offsetSeconds(123)
     *                                 .timeExpression("timeExpression")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the data set action by which data set contents are automatically created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-actionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-actionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionName();

        /**
         * Information which allows the system to run a containerized application in order to create the data set contents.
         * <p>
         * The application must be in a Docker container along with any needed support libraries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-containeraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-containeraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerAction() {
            return null;
        }

        /**
         * An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-queryaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-queryaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.String actionName;
            java.lang.Object containerAction;
            java.lang.Object queryAction;

            /**
             * Sets the value of {@link ActionProperty#getActionName}
             * @param actionName The name of the data set action by which data set contents are automatically created. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionName(java.lang.String actionName) {
                this.actionName = actionName;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getContainerAction}
             * @param containerAction Information which allows the system to run a containerized application in order to create the data set contents.
             *                        The application must be in a Docker container along with any needed support libraries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerAction(software.amazon.awscdk.IResolvable containerAction) {
                this.containerAction = containerAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getContainerAction}
             * @param containerAction Information which allows the system to run a containerized application in order to create the data set contents.
             *                        The application must be in a Docker container along with any needed support libraries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerAction(software.amazon.awscdk.services.iotanalytics.CfnDataset.ContainerActionProperty containerAction) {
                this.containerAction = containerAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getQueryAction}
             * @param queryAction An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryAction(software.amazon.awscdk.IResolvable queryAction) {
                this.queryAction = queryAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getQueryAction}
             * @param queryAction An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryAction(software.amazon.awscdk.services.iotanalytics.CfnDataset.QueryActionProperty queryAction) {
                this.queryAction = queryAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String actionName;
            private final java.lang.Object containerAction;
            private final java.lang.Object queryAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerAction = software.amazon.jsii.Kernel.get(this, "containerAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryAction = software.amazon.jsii.Kernel.get(this, "queryAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
                this.containerAction = builder.containerAction;
                this.queryAction = builder.queryAction;
            }

            @Override
            public final java.lang.String getActionName() {
                return this.actionName;
            }

            @Override
            public final java.lang.Object getContainerAction() {
                return this.containerAction;
            }

            @Override
            public final java.lang.Object getQueryAction() {
                return this.queryAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionName", om.valueToTree(this.getActionName()));
                if (this.getContainerAction() != null) {
                    data.set("containerAction", om.valueToTree(this.getContainerAction()));
                }
                if (this.getQueryAction() != null) {
                    data.set("queryAction", om.valueToTree(this.getQueryAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!actionName.equals(that.actionName)) return false;
                if (this.containerAction != null ? !this.containerAction.equals(that.containerAction) : that.containerAction != null) return false;
                return this.queryAction != null ? this.queryAction.equals(that.queryAction) : that.queryAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionName.hashCode();
                result = 31 * result + (this.containerAction != null ? this.containerAction.hashCode() : 0);
                result = 31 * result + (this.queryAction != null ? this.queryAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information needed to run the "containerAction" to produce data set contents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ContainerActionProperty containerActionProperty = ContainerActionProperty.builder()
     *         .executionRoleArn("executionRoleArn")
     *         .image("image")
     *         .resourceConfiguration(ResourceConfigurationProperty.builder()
     *                 .computeType("computeType")
     *                 .volumeSizeInGb(123)
     *                 .build())
     *         // the properties below are optional
     *         .variables(List.of(VariableProperty.builder()
     *                 .variableName("variableName")
     *                 // the properties below are optional
     *                 .datasetContentVersionValue(DatasetContentVersionValueProperty.builder()
     *                         .datasetName("datasetName")
     *                         .build())
     *                 .doubleValue(123)
     *                 .outputFileUriValue(OutputFileUriValueProperty.builder()
     *                         .fileName("fileName")
     *                         .build())
     *                 .stringValue("stringValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.ContainerActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the role which gives permission to the system to access needed resources in order to run the "containerAction".
         * <p>
         * This includes, at minimum, permission to retrieve the data set contents which are the input to the containerized application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-executionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

        /**
         * The ARN of the Docker container stored in your account.
         * <p>
         * The Docker container contains an application and needed support libraries and is used to generate data set contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * Configuration of the resource which executes the "containerAction".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-resourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-resourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getResourceConfiguration();

        /**
         * The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application).
         * <p>
         * Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-variables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerActionProperty> {
            java.lang.String executionRoleArn;
            java.lang.String image;
            java.lang.Object resourceConfiguration;
            java.lang.Object variables;

            /**
             * Sets the value of {@link ContainerActionProperty#getExecutionRoleArn}
             * @param executionRoleArn The ARN of the role which gives permission to the system to access needed resources in order to run the "containerAction". This parameter is required.
             *                         This includes, at minimum, permission to retrieve the data set contents which are the input to the containerized application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerActionProperty#getImage}
             * @param image The ARN of the Docker container stored in your account. This parameter is required.
             *              The Docker container contains an application and needed support libraries and is used to generate data set contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ContainerActionProperty#getResourceConfiguration}
             * @param resourceConfiguration Configuration of the resource which executes the "containerAction". This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceConfiguration(software.amazon.awscdk.IResolvable resourceConfiguration) {
                this.resourceConfiguration = resourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerActionProperty#getResourceConfiguration}
             * @param resourceConfiguration Configuration of the resource which executes the "containerAction". This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.ResourceConfigurationProperty resourceConfiguration) {
                this.resourceConfiguration = resourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerActionProperty#getVariables}
             * @param variables The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application).
             *                  Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link ContainerActionProperty#getVariables}
             * @param variables The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application).
             *                  Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.List<? extends java.lang.Object> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerActionProperty {
            private final java.lang.String executionRoleArn;
            private final java.lang.String image;
            private final java.lang.Object resourceConfiguration;
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceConfiguration = software.amazon.jsii.Kernel.get(this, "resourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.resourceConfiguration = java.util.Objects.requireNonNull(builder.resourceConfiguration, "resourceConfiguration is required");
                this.variables = builder.variables;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.lang.Object getResourceConfiguration() {
                return this.resourceConfiguration;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                data.set("image", om.valueToTree(this.getImage()));
                data.set("resourceConfiguration", om.valueToTree(this.getResourceConfiguration()));
                if (this.getVariables() != null) {
                    data.set("variables", om.valueToTree(this.getVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.ContainerActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerActionProperty.Jsii$Proxy that = (ContainerActionProperty.Jsii$Proxy) o;

                if (!executionRoleArn.equals(that.executionRoleArn)) return false;
                if (!image.equals(that.image)) return false;
                if (!resourceConfiguration.equals(that.resourceConfiguration)) return false;
                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionRoleArn.hashCode();
                result = 31 * result + (this.image.hashCode());
                result = 31 * result + (this.resourceConfiguration.hashCode());
                result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The destination to which dataset contents are delivered.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DatasetContentDeliveryRuleDestinationProperty datasetContentDeliveryRuleDestinationProperty = DatasetContentDeliveryRuleDestinationProperty.builder()
     *         .iotEventsDestinationConfiguration(IotEventsDestinationConfigurationProperty.builder()
     *                 .inputName("inputName")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .glueConfiguration(GlueConfigurationProperty.builder()
     *                         .databaseName("databaseName")
     *                         .tableName("tableName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.DatasetContentDeliveryRuleDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetContentDeliveryRuleDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetContentDeliveryRuleDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration information for delivery of dataset contents to AWS IoT Events .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html#cfn-iotanalytics-dataset-datasetcontentdeliveryruledestination-ioteventsdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html#cfn-iotanalytics-dataset-datasetcontentdeliveryruledestination-ioteventsdestinationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotEventsDestinationConfiguration() {
            return null;
        }

        /**
         * Configuration information for delivery of dataset contents to Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html#cfn-iotanalytics-dataset-datasetcontentdeliveryruledestination-s3destinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html#cfn-iotanalytics-dataset-datasetcontentdeliveryruledestination-s3destinationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3DestinationConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetContentDeliveryRuleDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetContentDeliveryRuleDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetContentDeliveryRuleDestinationProperty> {
            java.lang.Object iotEventsDestinationConfiguration;
            java.lang.Object s3DestinationConfiguration;

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleDestinationProperty#getIotEventsDestinationConfiguration}
             * @param iotEventsDestinationConfiguration Configuration information for delivery of dataset contents to AWS IoT Events .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEventsDestinationConfiguration(software.amazon.awscdk.IResolvable iotEventsDestinationConfiguration) {
                this.iotEventsDestinationConfiguration = iotEventsDestinationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleDestinationProperty#getIotEventsDestinationConfiguration}
             * @param iotEventsDestinationConfiguration Configuration information for delivery of dataset contents to AWS IoT Events .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEventsDestinationConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.IotEventsDestinationConfigurationProperty iotEventsDestinationConfiguration) {
                this.iotEventsDestinationConfiguration = iotEventsDestinationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleDestinationProperty#getS3DestinationConfiguration}
             * @param s3DestinationConfiguration Configuration information for delivery of dataset contents to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DestinationConfiguration(software.amazon.awscdk.IResolvable s3DestinationConfiguration) {
                this.s3DestinationConfiguration = s3DestinationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleDestinationProperty#getS3DestinationConfiguration}
             * @param s3DestinationConfiguration Configuration information for delivery of dataset contents to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DestinationConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.S3DestinationConfigurationProperty s3DestinationConfiguration) {
                this.s3DestinationConfiguration = s3DestinationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetContentDeliveryRuleDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetContentDeliveryRuleDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetContentDeliveryRuleDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetContentDeliveryRuleDestinationProperty {
            private final java.lang.Object iotEventsDestinationConfiguration;
            private final java.lang.Object s3DestinationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iotEventsDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "iotEventsDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3DestinationConfiguration = software.amazon.jsii.Kernel.get(this, "s3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iotEventsDestinationConfiguration = builder.iotEventsDestinationConfiguration;
                this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
            }

            @Override
            public final java.lang.Object getIotEventsDestinationConfiguration() {
                return this.iotEventsDestinationConfiguration;
            }

            @Override
            public final java.lang.Object getS3DestinationConfiguration() {
                return this.s3DestinationConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIotEventsDestinationConfiguration() != null) {
                    data.set("iotEventsDestinationConfiguration", om.valueToTree(this.getIotEventsDestinationConfiguration()));
                }
                if (this.getS3DestinationConfiguration() != null) {
                    data.set("s3DestinationConfiguration", om.valueToTree(this.getS3DestinationConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.DatasetContentDeliveryRuleDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetContentDeliveryRuleDestinationProperty.Jsii$Proxy that = (DatasetContentDeliveryRuleDestinationProperty.Jsii$Proxy) o;

                if (this.iotEventsDestinationConfiguration != null ? !this.iotEventsDestinationConfiguration.equals(that.iotEventsDestinationConfiguration) : that.iotEventsDestinationConfiguration != null) return false;
                return this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.equals(that.s3DestinationConfiguration) : that.s3DestinationConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iotEventsDestinationConfiguration != null ? this.iotEventsDestinationConfiguration.hashCode() : 0;
                result = 31 * result + (this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When dataset contents are created, they are delivered to destination specified here.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DatasetContentDeliveryRuleProperty datasetContentDeliveryRuleProperty = DatasetContentDeliveryRuleProperty.builder()
     *         .destination(DatasetContentDeliveryRuleDestinationProperty.builder()
     *                 .iotEventsDestinationConfiguration(IotEventsDestinationConfigurationProperty.builder()
     *                         .inputName("inputName")
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .glueConfiguration(GlueConfigurationProperty.builder()
     *                                 .databaseName("databaseName")
     *                                 .tableName("tableName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .entryName("entryName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.DatasetContentDeliveryRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetContentDeliveryRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetContentDeliveryRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination to which dataset contents are delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html#cfn-iotanalytics-dataset-datasetcontentdeliveryrule-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html#cfn-iotanalytics-dataset-datasetcontentdeliveryrule-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * The name of the dataset content delivery rules entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html#cfn-iotanalytics-dataset-datasetcontentdeliveryrule-entryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html#cfn-iotanalytics-dataset-datasetcontentdeliveryrule-entryname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntryName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetContentDeliveryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetContentDeliveryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetContentDeliveryRuleProperty> {
            java.lang.Object destination;
            java.lang.String entryName;

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleProperty#getDestination}
             * @param destination The destination to which dataset contents are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleProperty#getDestination}
             * @param destination The destination to which dataset contents are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.iotanalytics.CfnDataset.DatasetContentDeliveryRuleDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DatasetContentDeliveryRuleProperty#getEntryName}
             * @param entryName The name of the dataset content delivery rules entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryName(java.lang.String entryName) {
                this.entryName = entryName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetContentDeliveryRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetContentDeliveryRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetContentDeliveryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetContentDeliveryRuleProperty {
            private final java.lang.Object destination;
            private final java.lang.String entryName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.entryName = software.amazon.jsii.Kernel.get(this, "entryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.entryName = builder.entryName;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getEntryName() {
                return this.entryName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                if (this.getEntryName() != null) {
                    data.set("entryName", om.valueToTree(this.getEntryName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.DatasetContentDeliveryRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetContentDeliveryRuleProperty.Jsii$Proxy that = (DatasetContentDeliveryRuleProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.entryName != null ? this.entryName.equals(that.entryName) : that.entryName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.entryName != null ? this.entryName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The dataset whose latest contents are used as input to the notebook or application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DatasetContentVersionValueProperty datasetContentVersionValueProperty = DatasetContentVersionValueProperty.builder()
     *         .datasetName("datasetName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentversionvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentversionvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.DatasetContentVersionValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetContentVersionValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetContentVersionValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dataset whose latest contents are used as input to the notebook or application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentversionvalue.html#cfn-iotanalytics-dataset-datasetcontentversionvalue-datasetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentversionvalue.html#cfn-iotanalytics-dataset-datasetcontentversionvalue-datasetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatasetName();

        /**
         * @return a {@link Builder} of {@link DatasetContentVersionValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetContentVersionValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetContentVersionValueProperty> {
            java.lang.String datasetName;

            /**
             * Sets the value of {@link DatasetContentVersionValueProperty#getDatasetName}
             * @param datasetName The name of the dataset whose latest contents are used as input to the notebook or application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetName(java.lang.String datasetName) {
                this.datasetName = datasetName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetContentVersionValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetContentVersionValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetContentVersionValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetContentVersionValueProperty {
            private final java.lang.String datasetName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datasetName = software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datasetName = java.util.Objects.requireNonNull(builder.datasetName, "datasetName is required");
            }

            @Override
            public final java.lang.String getDatasetName() {
                return this.datasetName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("datasetName", om.valueToTree(this.getDatasetName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.DatasetContentVersionValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetContentVersionValueProperty.Jsii$Proxy that = (DatasetContentVersionValueProperty.Jsii$Proxy) o;

                return this.datasetName.equals(that.datasetName);
            }

            @Override
            public final int hashCode() {
                int result = this.datasetName.hashCode();
                return result;
            }
        }
    }
    /**
     * Used to limit data to that which has arrived since the last execution of the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DeltaTimeProperty deltaTimeProperty = DeltaTimeProperty.builder()
     *         .offsetSeconds(123)
     *         .timeExpression("timeExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.DeltaTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(DeltaTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeltaTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of seconds of estimated in-flight lag time of message data.
         * <p>
         * When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html#cfn-iotanalytics-dataset-deltatime-offsetseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html#cfn-iotanalytics-dataset-deltatime-offsetseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getOffsetSeconds();

        /**
         * An expression by which the time of the message data might be determined.
         * <p>
         * This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html#cfn-iotanalytics-dataset-deltatime-timeexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html#cfn-iotanalytics-dataset-deltatime-timeexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeExpression();

        /**
         * @return a {@link Builder} of {@link DeltaTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeltaTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeltaTimeProperty> {
            java.lang.Number offsetSeconds;
            java.lang.String timeExpression;

            /**
             * Sets the value of {@link DeltaTimeProperty#getOffsetSeconds}
             * @param offsetSeconds The number of seconds of estimated in-flight lag time of message data. This parameter is required.
             *                      When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offsetSeconds(java.lang.Number offsetSeconds) {
                this.offsetSeconds = offsetSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DeltaTimeProperty#getTimeExpression}
             * @param timeExpression An expression by which the time of the message data might be determined. This parameter is required.
             *                       This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeExpression(java.lang.String timeExpression) {
                this.timeExpression = timeExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeltaTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeltaTimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeltaTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeltaTimeProperty {
            private final java.lang.Number offsetSeconds;
            private final java.lang.String timeExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.offsetSeconds = software.amazon.jsii.Kernel.get(this, "offsetSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeExpression = software.amazon.jsii.Kernel.get(this, "timeExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.offsetSeconds = java.util.Objects.requireNonNull(builder.offsetSeconds, "offsetSeconds is required");
                this.timeExpression = java.util.Objects.requireNonNull(builder.timeExpression, "timeExpression is required");
            }

            @Override
            public final java.lang.Number getOffsetSeconds() {
                return this.offsetSeconds;
            }

            @Override
            public final java.lang.String getTimeExpression() {
                return this.timeExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("offsetSeconds", om.valueToTree(this.getOffsetSeconds()));
                data.set("timeExpression", om.valueToTree(this.getTimeExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.DeltaTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeltaTimeProperty.Jsii$Proxy that = (DeltaTimeProperty.Jsii$Proxy) o;

                if (!offsetSeconds.equals(that.offsetSeconds)) return false;
                return this.timeExpression.equals(that.timeExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.offsetSeconds.hashCode();
                result = 31 * result + (this.timeExpression.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that contains the configuration information of a delta time session window.
     * <p>
     * <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html"><code>DeltaTime</code></a> specifies a time interval. You can use <code>DeltaTime</code> to create dataset contents with data that has arrived in the data store since the last execution. For an example of <code>DeltaTime</code> , see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6">Creating a SQL dataset with a delta window (CLI)</a> in the <em>AWS IoT Analytics User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DeltaTimeSessionWindowConfigurationProperty deltaTimeSessionWindowConfigurationProperty = DeltaTimeSessionWindowConfigurationProperty.builder()
     *         .timeoutInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatimesessionwindowconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatimesessionwindowconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.DeltaTimeSessionWindowConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeltaTimeSessionWindowConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeltaTimeSessionWindowConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A time interval.
         * <p>
         * You can use <code>timeoutInMinutes</code> so that AWS IoT Analytics can batch up late data notifications that have been generated since the last execution. AWS IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.
         * <p>
         * For more information about how to write a timestamp expression, see <a href="https://docs.aws.amazon.com/https://prestodb.io/docs/current/functions/datetime.html">Date and Time Functions and Operators</a> , in the <em>Presto 0.172 Documentation</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatimesessionwindowconfiguration.html#cfn-iotanalytics-dataset-deltatimesessionwindowconfiguration-timeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatimesessionwindowconfiguration.html#cfn-iotanalytics-dataset-deltatimesessionwindowconfiguration-timeoutinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutInMinutes();

        /**
         * @return a {@link Builder} of {@link DeltaTimeSessionWindowConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeltaTimeSessionWindowConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeltaTimeSessionWindowConfigurationProperty> {
            java.lang.Number timeoutInMinutes;

            /**
             * Sets the value of {@link DeltaTimeSessionWindowConfigurationProperty#getTimeoutInMinutes}
             * @param timeoutInMinutes A time interval. This parameter is required.
             *                         You can use <code>timeoutInMinutes</code> so that AWS IoT Analytics can batch up late data notifications that have been generated since the last execution. AWS IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.
             *                         <p>
             *                         For more information about how to write a timestamp expression, see <a href="https://docs.aws.amazon.com/https://prestodb.io/docs/current/functions/datetime.html">Date and Time Functions and Operators</a> , in the <em>Presto 0.172 Documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMinutes(java.lang.Number timeoutInMinutes) {
                this.timeoutInMinutes = timeoutInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeltaTimeSessionWindowConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeltaTimeSessionWindowConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeltaTimeSessionWindowConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeltaTimeSessionWindowConfigurationProperty {
            private final java.lang.Number timeoutInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeoutInMinutes = software.amazon.jsii.Kernel.get(this, "timeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeoutInMinutes = java.util.Objects.requireNonNull(builder.timeoutInMinutes, "timeoutInMinutes is required");
            }

            @Override
            public final java.lang.Number getTimeoutInMinutes() {
                return this.timeoutInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeoutInMinutes", om.valueToTree(this.getTimeoutInMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.DeltaTimeSessionWindowConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeltaTimeSessionWindowConfigurationProperty.Jsii$Proxy that = (DeltaTimeSessionWindowConfigurationProperty.Jsii$Proxy) o;

                return this.timeoutInMinutes.equals(that.timeoutInMinutes);
            }

            @Override
            public final int hashCode() {
                int result = this.timeoutInMinutes.hashCode();
                return result;
            }
        }
    }
    /**
     * Information which is used to filter message data, to segregate it according to the time frame in which it arrives.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .deltaTime(DeltaTimeProperty.builder()
     *                 .offsetSeconds(123)
     *                 .timeExpression("timeExpression")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-filter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-filter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Used to limit data to that which has arrived since the last execution of the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-filter.html#cfn-iotanalytics-dataset-filter-deltatime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-filter.html#cfn-iotanalytics-dataset-filter-deltatime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeltaTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.Object deltaTime;

            /**
             * Sets the value of {@link FilterProperty#getDeltaTime}
             * @param deltaTime Used to limit data to that which has arrived since the last execution of the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTime(software.amazon.awscdk.IResolvable deltaTime) {
                this.deltaTime = deltaTime;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getDeltaTime}
             * @param deltaTime Used to limit data to that which has arrived since the last execution of the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTime(software.amazon.awscdk.services.iotanalytics.CfnDataset.DeltaTimeProperty deltaTime) {
                this.deltaTime = deltaTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.Object deltaTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deltaTime = software.amazon.jsii.Kernel.get(this, "deltaTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deltaTime = builder.deltaTime;
            }

            @Override
            public final java.lang.Object getDeltaTime() {
                return this.deltaTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeltaTime() != null) {
                    data.set("deltaTime", om.valueToTree(this.getDeltaTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                return this.deltaTime != null ? this.deltaTime.equals(that.deltaTime) : that.deltaTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deltaTime != null ? this.deltaTime.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * GlueConfigurationProperty glueConfigurationProperty = GlueConfigurationProperty.builder()
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.GlueConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the database in your AWS Glue Data Catalog in which the table is located.
         * <p>
         * An AWS Glue Data Catalog database contains metadata tables.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html#cfn-iotanalytics-dataset-glueconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html#cfn-iotanalytics-dataset-glueconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The name of the table in your AWS Glue Data Catalog that is used to perform the ETL operations.
         * <p>
         * An AWS Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html#cfn-iotanalytics-dataset-glueconfiguration-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html#cfn-iotanalytics-dataset-glueconfiguration-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link GlueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueConfigurationProperty> {
            java.lang.String databaseName;
            java.lang.String tableName;

            /**
             * Sets the value of {@link GlueConfigurationProperty#getDatabaseName}
             * @param databaseName The name of the database in your AWS Glue Data Catalog in which the table is located. This parameter is required.
             *                     An AWS Glue Data Catalog database contains metadata tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link GlueConfigurationProperty#getTableName}
             * @param tableName The name of the table in your AWS Glue Data Catalog that is used to perform the ETL operations. This parameter is required.
             *                  An AWS Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueConfigurationProperty {
            private final java.lang.String databaseName;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.GlueConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueConfigurationProperty.Jsii$Proxy that = (GlueConfigurationProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration information for delivery of dataset contents to AWS IoT Events .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * IotEventsDestinationConfigurationProperty iotEventsDestinationConfigurationProperty = IotEventsDestinationConfigurationProperty.builder()
     *         .inputName("inputName")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.IotEventsDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IotEventsDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotEventsDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS IoT Events input to which dataset contents are delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html#cfn-iotanalytics-dataset-ioteventsdestinationconfiguration-inputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html#cfn-iotanalytics-dataset-ioteventsdestinationconfiguration-inputname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputName();

        /**
         * The ARN of the role that grants AWS IoT Analytics permission to deliver dataset contents to an AWS IoT Events input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html#cfn-iotanalytics-dataset-ioteventsdestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html#cfn-iotanalytics-dataset-ioteventsdestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link IotEventsDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotEventsDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotEventsDestinationConfigurationProperty> {
            java.lang.String inputName;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link IotEventsDestinationConfigurationProperty#getInputName}
             * @param inputName The name of the AWS IoT Events input to which dataset contents are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputName(java.lang.String inputName) {
                this.inputName = inputName;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the role that grants AWS IoT Analytics permission to deliver dataset contents to an AWS IoT Events input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotEventsDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotEventsDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotEventsDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotEventsDestinationConfigurationProperty {
            private final java.lang.String inputName;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputName = java.util.Objects.requireNonNull(builder.inputName, "inputName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getInputName() {
                return this.inputName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputName", om.valueToTree(this.getInputName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.IotEventsDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotEventsDestinationConfigurationProperty.Jsii$Proxy that = (IotEventsDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!inputName.equals(that.inputName)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.inputName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The information needed to configure a delta time session window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * LateDataRuleConfigurationProperty lateDataRuleConfigurationProperty = LateDataRuleConfigurationProperty.builder()
     *         .deltaTimeSessionWindowConfiguration(DeltaTimeSessionWindowConfigurationProperty.builder()
     *                 .timeoutInMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedataruleconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedataruleconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.LateDataRuleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LateDataRuleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LateDataRuleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The information needed to configure a delta time session window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedataruleconfiguration.html#cfn-iotanalytics-dataset-latedataruleconfiguration-deltatimesessionwindowconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedataruleconfiguration.html#cfn-iotanalytics-dataset-latedataruleconfiguration-deltatimesessionwindowconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeltaTimeSessionWindowConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LateDataRuleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LateDataRuleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LateDataRuleConfigurationProperty> {
            java.lang.Object deltaTimeSessionWindowConfiguration;

            /**
             * Sets the value of {@link LateDataRuleConfigurationProperty#getDeltaTimeSessionWindowConfiguration}
             * @param deltaTimeSessionWindowConfiguration The information needed to configure a delta time session window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTimeSessionWindowConfiguration(software.amazon.awscdk.IResolvable deltaTimeSessionWindowConfiguration) {
                this.deltaTimeSessionWindowConfiguration = deltaTimeSessionWindowConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LateDataRuleConfigurationProperty#getDeltaTimeSessionWindowConfiguration}
             * @param deltaTimeSessionWindowConfiguration The information needed to configure a delta time session window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTimeSessionWindowConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.DeltaTimeSessionWindowConfigurationProperty deltaTimeSessionWindowConfiguration) {
                this.deltaTimeSessionWindowConfiguration = deltaTimeSessionWindowConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LateDataRuleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LateDataRuleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LateDataRuleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LateDataRuleConfigurationProperty {
            private final java.lang.Object deltaTimeSessionWindowConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deltaTimeSessionWindowConfiguration = software.amazon.jsii.Kernel.get(this, "deltaTimeSessionWindowConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deltaTimeSessionWindowConfiguration = builder.deltaTimeSessionWindowConfiguration;
            }

            @Override
            public final java.lang.Object getDeltaTimeSessionWindowConfiguration() {
                return this.deltaTimeSessionWindowConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeltaTimeSessionWindowConfiguration() != null) {
                    data.set("deltaTimeSessionWindowConfiguration", om.valueToTree(this.getDeltaTimeSessionWindowConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.LateDataRuleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LateDataRuleConfigurationProperty.Jsii$Proxy that = (LateDataRuleConfigurationProperty.Jsii$Proxy) o;

                return this.deltaTimeSessionWindowConfiguration != null ? this.deltaTimeSessionWindowConfiguration.equals(that.deltaTimeSessionWindowConfiguration) : that.deltaTimeSessionWindowConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deltaTimeSessionWindowConfiguration != null ? this.deltaTimeSessionWindowConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A structure that contains the name and configuration information of a late data rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * LateDataRuleProperty lateDataRuleProperty = LateDataRuleProperty.builder()
     *         .ruleConfiguration(LateDataRuleConfigurationProperty.builder()
     *                 .deltaTimeSessionWindowConfiguration(DeltaTimeSessionWindowConfigurationProperty.builder()
     *                         .timeoutInMinutes(123)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .ruleName("ruleName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.LateDataRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(LateDataRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LateDataRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The information needed to configure the late data rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html#cfn-iotanalytics-dataset-latedatarule-ruleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html#cfn-iotanalytics-dataset-latedatarule-ruleconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRuleConfiguration();

        /**
         * The name of the late data rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html#cfn-iotanalytics-dataset-latedatarule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html#cfn-iotanalytics-dataset-latedatarule-rulename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LateDataRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LateDataRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LateDataRuleProperty> {
            java.lang.Object ruleConfiguration;
            java.lang.String ruleName;

            /**
             * Sets the value of {@link LateDataRuleProperty#getRuleConfiguration}
             * @param ruleConfiguration The information needed to configure the late data rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleConfiguration(software.amazon.awscdk.IResolvable ruleConfiguration) {
                this.ruleConfiguration = ruleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LateDataRuleProperty#getRuleConfiguration}
             * @param ruleConfiguration The information needed to configure the late data rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.LateDataRuleConfigurationProperty ruleConfiguration) {
                this.ruleConfiguration = ruleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LateDataRuleProperty#getRuleName}
             * @param ruleName The name of the late data rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LateDataRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LateDataRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LateDataRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LateDataRuleProperty {
            private final java.lang.Object ruleConfiguration;
            private final java.lang.String ruleName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleConfiguration = software.amazon.jsii.Kernel.get(this, "ruleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleConfiguration = java.util.Objects.requireNonNull(builder.ruleConfiguration, "ruleConfiguration is required");
                this.ruleName = builder.ruleName;
            }

            @Override
            public final java.lang.Object getRuleConfiguration() {
                return this.ruleConfiguration;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleConfiguration", om.valueToTree(this.getRuleConfiguration()));
                if (this.getRuleName() != null) {
                    data.set("ruleName", om.valueToTree(this.getRuleName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.LateDataRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LateDataRuleProperty.Jsii$Proxy that = (LateDataRuleProperty.Jsii$Proxy) o;

                if (!ruleConfiguration.equals(that.ruleConfiguration)) return false;
                return this.ruleName != null ? this.ruleName.equals(that.ruleName) : that.ruleName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleConfiguration.hashCode();
                result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The value of the variable as a structure that specifies an output file URI.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * OutputFileUriValueProperty outputFileUriValueProperty = OutputFileUriValueProperty.builder()
     *         .fileName("fileName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-outputfileurivalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-outputfileurivalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.OutputFileUriValueProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputFileUriValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputFileUriValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-outputfileurivalue.html#cfn-iotanalytics-dataset-outputfileurivalue-filename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-outputfileurivalue.html#cfn-iotanalytics-dataset-outputfileurivalue-filename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileName();

        /**
         * @return a {@link Builder} of {@link OutputFileUriValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputFileUriValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputFileUriValueProperty> {
            java.lang.String fileName;

            /**
             * Sets the value of {@link OutputFileUriValueProperty#getFileName}
             * @param fileName The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileName(java.lang.String fileName) {
                this.fileName = fileName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputFileUriValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputFileUriValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputFileUriValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputFileUriValueProperty {
            private final java.lang.String fileName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileName = software.amazon.jsii.Kernel.get(this, "fileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileName = java.util.Objects.requireNonNull(builder.fileName, "fileName is required");
            }

            @Override
            public final java.lang.String getFileName() {
                return this.fileName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileName", om.valueToTree(this.getFileName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.OutputFileUriValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputFileUriValueProperty.Jsii$Proxy that = (OutputFileUriValueProperty.Jsii$Proxy) o;

                return this.fileName.equals(that.fileName);
            }

            @Override
            public final int hashCode() {
                int result = this.fileName.hashCode();
                return result;
            }
        }
    }
    /**
     * An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * QueryActionProperty queryActionProperty = QueryActionProperty.builder()
     *         .sqlQuery("sqlQuery")
     *         // the properties below are optional
     *         .filters(List.of(FilterProperty.builder()
     *                 .deltaTime(DeltaTimeProperty.builder()
     *                         .offsetSeconds(123)
     *                         .timeExpression("timeExpression")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.QueryActionProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html#cfn-iotanalytics-dataset-queryaction-sqlquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html#cfn-iotanalytics-dataset-queryaction-sqlquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlQuery();

        /**
         * Pre-filters applied to message data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html#cfn-iotanalytics-dataset-queryaction-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html#cfn-iotanalytics-dataset-queryaction-filters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryActionProperty> {
            java.lang.String sqlQuery;
            java.lang.Object filters;

            /**
             * Sets the value of {@link QueryActionProperty#getSqlQuery}
             * @param sqlQuery An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlQuery(java.lang.String sqlQuery) {
                this.sqlQuery = sqlQuery;
                return this;
            }

            /**
             * Sets the value of {@link QueryActionProperty#getFilters}
             * @param filters Pre-filters applied to message data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link QueryActionProperty#getFilters}
             * @param filters Pre-filters applied to message data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryActionProperty {
            private final java.lang.String sqlQuery;
            private final java.lang.Object filters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sqlQuery = software.amazon.jsii.Kernel.get(this, "sqlQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sqlQuery = java.util.Objects.requireNonNull(builder.sqlQuery, "sqlQuery is required");
                this.filters = builder.filters;
            }

            @Override
            public final java.lang.String getSqlQuery() {
                return this.sqlQuery;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sqlQuery", om.valueToTree(this.getSqlQuery()));
                if (this.getFilters() != null) {
                    data.set("filters", om.valueToTree(this.getFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.QueryActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryActionProperty.Jsii$Proxy that = (QueryActionProperty.Jsii$Proxy) o;

                if (!sqlQuery.equals(that.sqlQuery)) return false;
                return this.filters != null ? this.filters.equals(that.filters) : that.filters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sqlQuery.hashCode();
                result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the resource used to execute the <code>containerAction</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ResourceConfigurationProperty resourceConfigurationProperty = ResourceConfigurationProperty.builder()
     *         .computeType("computeType")
     *         .volumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.ResourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the compute resource used to execute the <code>containerAction</code> .
         * <p>
         * Possible values are: <code>ACU_1</code> (vCPU=4, memory=16 GiB) or <code>ACU_2</code> (vCPU=8, memory=32 GiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html#cfn-iotanalytics-dataset-resourceconfiguration-computetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html#cfn-iotanalytics-dataset-resourceconfiguration-computetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComputeType();

        /**
         * The size, in GB, of the persistent storage available to the resource instance used to execute the <code>containerAction</code> (min: 1, max: 50).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html#cfn-iotanalytics-dataset-resourceconfiguration-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html#cfn-iotanalytics-dataset-resourceconfiguration-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

        /**
         * @return a {@link Builder} of {@link ResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceConfigurationProperty> {
            java.lang.String computeType;
            java.lang.Number volumeSizeInGb;

            /**
             * Sets the value of {@link ResourceConfigurationProperty#getComputeType}
             * @param computeType The type of the compute resource used to execute the <code>containerAction</code> . This parameter is required.
             *                    Possible values are: <code>ACU_1</code> (vCPU=4, memory=16 GiB) or <code>ACU_2</code> (vCPU=8, memory=32 GiB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeType(java.lang.String computeType) {
                this.computeType = computeType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceConfigurationProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size, in GB, of the persistent storage available to the resource instance used to execute the <code>containerAction</code> (min: 1, max: 50). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceConfigurationProperty {
            private final java.lang.String computeType;
            private final java.lang.Number volumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeType = java.util.Objects.requireNonNull(builder.computeType, "computeType is required");
                this.volumeSizeInGb = java.util.Objects.requireNonNull(builder.volumeSizeInGb, "volumeSizeInGb is required");
            }

            @Override
            public final java.lang.String getComputeType() {
                return this.computeType;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("computeType", om.valueToTree(this.getComputeType()));
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.ResourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceConfigurationProperty.Jsii$Proxy that = (ResourceConfigurationProperty.Jsii$Proxy) o;

                if (!computeType.equals(that.computeType)) return false;
                return this.volumeSizeInGb.equals(that.volumeSizeInGb);
            }

            @Override
            public final int hashCode() {
                int result = this.computeType.hashCode();
                result = 31 * result + (this.volumeSizeInGb.hashCode());
                return result;
            }
        }
    }
    /**
     * How long, in days, message data is kept.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * RetentionPeriodProperty retentionPeriodProperty = RetentionPeriodProperty.builder()
     *         .numberOfDays(123)
     *         .unlimited(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.RetentionPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days that message data is kept.
         * <p>
         * The <code>unlimited</code> parameter must be false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html#cfn-iotanalytics-dataset-retentionperiod-numberofdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html#cfn-iotanalytics-dataset-retentionperiod-numberofdays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfDays() {
            return null;
        }

        /**
         * If true, message data is kept indefinitely.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html#cfn-iotanalytics-dataset-retentionperiod-unlimited">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html#cfn-iotanalytics-dataset-retentionperiod-unlimited</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnlimited() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionPeriodProperty> {
            java.lang.Number numberOfDays;
            java.lang.Object unlimited;

            /**
             * Sets the value of {@link RetentionPeriodProperty#getNumberOfDays}
             * @param numberOfDays The number of days that message data is kept.
             *                     The <code>unlimited</code> parameter must be false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfDays(java.lang.Number numberOfDays) {
                this.numberOfDays = numberOfDays;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPeriodProperty#getUnlimited}
             * @param unlimited If true, message data is kept indefinitely.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(java.lang.Boolean unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPeriodProperty#getUnlimited}
             * @param unlimited If true, message data is kept indefinitely.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(software.amazon.awscdk.IResolvable unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionPeriodProperty {
            private final java.lang.Number numberOfDays;
            private final java.lang.Object unlimited;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.numberOfDays = software.amazon.jsii.Kernel.get(this, "numberOfDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unlimited = software.amazon.jsii.Kernel.get(this, "unlimited", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.numberOfDays = builder.numberOfDays;
                this.unlimited = builder.unlimited;
            }

            @Override
            public final java.lang.Number getNumberOfDays() {
                return this.numberOfDays;
            }

            @Override
            public final java.lang.Object getUnlimited() {
                return this.unlimited;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNumberOfDays() != null) {
                    data.set("numberOfDays", om.valueToTree(this.getNumberOfDays()));
                }
                if (this.getUnlimited() != null) {
                    data.set("unlimited", om.valueToTree(this.getUnlimited()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.RetentionPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionPeriodProperty.Jsii$Proxy that = (RetentionPeriodProperty.Jsii$Proxy) o;

                if (this.numberOfDays != null ? !this.numberOfDays.equals(that.numberOfDays) : that.numberOfDays != null) return false;
                return this.unlimited != null ? this.unlimited.equals(that.unlimited) : that.unlimited == null;
            }

            @Override
            public final int hashCode() {
                int result = this.numberOfDays != null ? this.numberOfDays.hashCode() : 0;
                result = 31 * result + (this.unlimited != null ? this.unlimited.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration information for delivery of dataset contents to Amazon Simple Storage Service (Amazon S3).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * S3DestinationConfigurationProperty s3DestinationConfigurationProperty = S3DestinationConfigurationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .glueConfiguration(GlueConfigurationProperty.builder()
     *                 .databaseName("databaseName")
     *                 .tableName("tableName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.S3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket to which dataset contents are delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The key of the dataset contents object in an S3 bucket.
         * <p>
         * Each object has a key that is a unique identifier. Each object has exactly one key.
         * <p>
         * You can create a unique key with the following options:
         * <p>
         * <ul>
         * <li>Use <code>!{iotanalytics:scheduleTime}</code> to insert the time of a scheduled SQL query run.</li>
         * <li>Use <code>!{iotanalytics:versionId}</code> to insert a unique hash that identifies a dataset content.</li>
         * <li>Use <code>!{iotanalytics:creationTime}</code> to insert the creation time of a dataset content.</li>
         * </ul>
         * <p>
         * The following example creates a unique key for a CSV file: <code>dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv</code>
         * <p>
         * <blockquote>
         * <p>
         * If you don't use <code>!{iotanalytics:versionId}</code> to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same <code>scheduleTime</code> but different <code>versionId</code> s. This means that one dataset content overwrites the other.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 and AWS Glue resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-glueconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-glueconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationConfigurationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.String roleArn;
            java.lang.Object glueConfiguration;

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBucket}
             * @param bucket The name of the S3 bucket to which dataset contents are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getKey}
             * @param key The key of the dataset contents object in an S3 bucket. This parameter is required.
             *            Each object has a key that is a unique identifier. Each object has exactly one key.
             *            <p>
             *            You can create a unique key with the following options:
             *            <p>
             *            <ul>
             *            <li>Use <code>!{iotanalytics:scheduleTime}</code> to insert the time of a scheduled SQL query run.</li>
             *            <li>Use <code>!{iotanalytics:versionId}</code> to insert a unique hash that identifies a dataset content.</li>
             *            <li>Use <code>!{iotanalytics:creationTime}</code> to insert the creation time of a dataset content.</li>
             *            </ul>
             *            <p>
             *            The following example creates a unique key for a CSV file: <code>dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv</code>
             *            <p>
             *            <blockquote>
             *            <p>
             *            If you don't use <code>!{iotanalytics:versionId}</code> to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same <code>scheduleTime</code> but different <code>versionId</code> s. This means that one dataset content overwrites the other.
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the role that grants AWS IoT Analytics permission to interact with your Amazon S3 and AWS Glue resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getGlueConfiguration}
             * @param glueConfiguration Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConfiguration(software.amazon.awscdk.IResolvable glueConfiguration) {
                this.glueConfiguration = glueConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getGlueConfiguration}
             * @param glueConfiguration Configuration information for coordination with AWS Glue , a fully managed extract, transform and load (ETL) service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDataset.GlueConfigurationProperty glueConfiguration) {
                this.glueConfiguration = glueConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationConfigurationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String roleArn;
            private final java.lang.Object glueConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.glueConfiguration = software.amazon.jsii.Kernel.get(this, "glueConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.glueConfiguration = builder.glueConfiguration;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getGlueConfiguration() {
                return this.glueConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getGlueConfiguration() != null) {
                    data.set("glueConfiguration", om.valueToTree(this.getGlueConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.S3DestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationConfigurationProperty.Jsii$Proxy that = (S3DestinationConfigurationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.glueConfiguration != null ? this.glueConfiguration.equals(that.glueConfiguration) : that.glueConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.glueConfiguration != null ? this.glueConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The schedule for when to trigger an update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The expression that defines when to trigger an update.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the Amazon CloudWatch documentation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html#cfn-iotanalytics-dataset-schedule-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html#cfn-iotanalytics-dataset-schedule-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link ScheduleProperty#getScheduleExpression}
             * @param scheduleExpression The expression that defines when to trigger an update. This parameter is required.
             *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the Amazon CloudWatch documentation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                return this.scheduleExpression.equals(that.scheduleExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                return result;
            }
        }
    }
    /**
     * The "DatasetTrigger" that specifies when the data set is automatically updated.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * TriggerProperty triggerProperty = TriggerProperty.builder()
     *         .schedule(ScheduleProperty.builder()
     *                 .scheduleExpression("scheduleExpression")
     *                 .build())
     *         .triggeringDataset(TriggeringDatasetProperty.builder()
     *                 .datasetName("datasetName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.TriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The "Schedule" when the trigger is initiated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html#cfn-iotanalytics-dataset-trigger-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html#cfn-iotanalytics-dataset-trigger-schedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
            return null;
        }

        /**
         * Information about the data set whose content generation triggers the new data set content generation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html#cfn-iotanalytics-dataset-trigger-triggeringdataset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html#cfn-iotanalytics-dataset-trigger-triggeringdataset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTriggeringDataset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerProperty> {
            java.lang.Object schedule;
            java.lang.Object triggeringDataset;

            /**
             * Sets the value of {@link TriggerProperty#getSchedule}
             * @param schedule The "Schedule" when the trigger is initiated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getSchedule}
             * @param schedule The "Schedule" when the trigger is initiated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(software.amazon.awscdk.services.iotanalytics.CfnDataset.ScheduleProperty schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getTriggeringDataset}
             * @param triggeringDataset Information about the data set whose content generation triggers the new data set content generation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggeringDataset(software.amazon.awscdk.IResolvable triggeringDataset) {
                this.triggeringDataset = triggeringDataset;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getTriggeringDataset}
             * @param triggeringDataset Information about the data set whose content generation triggers the new data set content generation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggeringDataset(software.amazon.awscdk.services.iotanalytics.CfnDataset.TriggeringDatasetProperty triggeringDataset) {
                this.triggeringDataset = triggeringDataset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerProperty {
            private final java.lang.Object schedule;
            private final java.lang.Object triggeringDataset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.triggeringDataset = software.amazon.jsii.Kernel.get(this, "triggeringDataset", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = builder.schedule;
                this.triggeringDataset = builder.triggeringDataset;
            }

            @Override
            public final java.lang.Object getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.Object getTriggeringDataset() {
                return this.triggeringDataset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSchedule() != null) {
                    data.set("schedule", om.valueToTree(this.getSchedule()));
                }
                if (this.getTriggeringDataset() != null) {
                    data.set("triggeringDataset", om.valueToTree(this.getTriggeringDataset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.TriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerProperty.Jsii$Proxy that = (TriggerProperty.Jsii$Proxy) o;

                if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
                return this.triggeringDataset != null ? this.triggeringDataset.equals(that.triggeringDataset) : that.triggeringDataset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule != null ? this.schedule.hashCode() : 0;
                result = 31 * result + (this.triggeringDataset != null ? this.triggeringDataset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the dataset whose content generation triggers the new dataset content generation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * TriggeringDatasetProperty triggeringDatasetProperty = TriggeringDatasetProperty.builder()
     *         .datasetName("datasetName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-triggeringdataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-triggeringdataset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.TriggeringDatasetProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggeringDatasetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggeringDatasetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the data set whose content generation triggers the new data set content generation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-triggeringdataset.html#cfn-iotanalytics-dataset-triggeringdataset-datasetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-triggeringdataset.html#cfn-iotanalytics-dataset-triggeringdataset-datasetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatasetName();

        /**
         * @return a {@link Builder} of {@link TriggeringDatasetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggeringDatasetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggeringDatasetProperty> {
            java.lang.String datasetName;

            /**
             * Sets the value of {@link TriggeringDatasetProperty#getDatasetName}
             * @param datasetName The name of the data set whose content generation triggers the new data set content generation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetName(java.lang.String datasetName) {
                this.datasetName = datasetName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggeringDatasetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggeringDatasetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggeringDatasetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggeringDatasetProperty {
            private final java.lang.String datasetName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datasetName = software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datasetName = java.util.Objects.requireNonNull(builder.datasetName, "datasetName is required");
            }

            @Override
            public final java.lang.String getDatasetName() {
                return this.datasetName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("datasetName", om.valueToTree(this.getDatasetName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.TriggeringDatasetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggeringDatasetProperty.Jsii$Proxy that = (TriggeringDatasetProperty.Jsii$Proxy) o;

                return this.datasetName.equals(that.datasetName);
            }

            @Override
            public final int hashCode() {
                int result = this.datasetName.hashCode();
                return result;
            }
        }
    }
    /**
     * An instance of a variable to be passed to the <code>containerAction</code> execution.
     * <p>
     * Each variable must have a name and a value given by one of <code>stringValue</code> , <code>datasetContentVersionValue</code> , or <code>outputFileUriValue</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * VariableProperty variableProperty = VariableProperty.builder()
     *         .variableName("variableName")
     *         // the properties below are optional
     *         .datasetContentVersionValue(DatasetContentVersionValueProperty.builder()
     *                 .datasetName("datasetName")
     *                 .build())
     *         .doubleValue(123)
     *         .outputFileUriValue(OutputFileUriValueProperty.builder()
     *                 .fileName("fileName")
     *                 .build())
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.VariableProperty")
    @software.amazon.jsii.Jsii.Proxy(VariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-variablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-variablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariableName();

        /**
         * The value of the variable as a structure that specifies a dataset content version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-datasetcontentversionvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-datasetcontentversionvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatasetContentVersionValue() {
            return null;
        }

        /**
         * The value of the variable as a double (numeric).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDoubleValue() {
            return null;
        }

        /**
         * The value of the variable as a structure that specifies an output file URI.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-outputfileurivalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-outputfileurivalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputFileUriValue() {
            return null;
        }

        /**
         * The value of the variable as a string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VariableProperty> {
            java.lang.String variableName;
            java.lang.Object datasetContentVersionValue;
            java.lang.Number doubleValue;
            java.lang.Object outputFileUriValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link VariableProperty#getVariableName}
             * @param variableName The name of the variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableName(java.lang.String variableName) {
                this.variableName = variableName;
                return this;
            }

            /**
             * Sets the value of {@link VariableProperty#getDatasetContentVersionValue}
             * @param datasetContentVersionValue The value of the variable as a structure that specifies a dataset content version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetContentVersionValue(software.amazon.awscdk.IResolvable datasetContentVersionValue) {
                this.datasetContentVersionValue = datasetContentVersionValue;
                return this;
            }

            /**
             * Sets the value of {@link VariableProperty#getDatasetContentVersionValue}
             * @param datasetContentVersionValue The value of the variable as a structure that specifies a dataset content version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetContentVersionValue(software.amazon.awscdk.services.iotanalytics.CfnDataset.DatasetContentVersionValueProperty datasetContentVersionValue) {
                this.datasetContentVersionValue = datasetContentVersionValue;
                return this;
            }

            /**
             * Sets the value of {@link VariableProperty#getDoubleValue}
             * @param doubleValue The value of the variable as a double (numeric).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link VariableProperty#getOutputFileUriValue}
             * @param outputFileUriValue The value of the variable as a structure that specifies an output file URI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFileUriValue(software.amazon.awscdk.IResolvable outputFileUriValue) {
                this.outputFileUriValue = outputFileUriValue;
                return this;
            }

            /**
             * Sets the value of {@link VariableProperty#getOutputFileUriValue}
             * @param outputFileUriValue The value of the variable as a structure that specifies an output file URI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFileUriValue(software.amazon.awscdk.services.iotanalytics.CfnDataset.OutputFileUriValueProperty outputFileUriValue) {
                this.outputFileUriValue = outputFileUriValue;
                return this;
            }

            /**
             * Sets the value of {@link VariableProperty#getStringValue}
             * @param stringValue The value of the variable as a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VariableProperty {
            private final java.lang.String variableName;
            private final java.lang.Object datasetContentVersionValue;
            private final java.lang.Number doubleValue;
            private final java.lang.Object outputFileUriValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variableName = software.amazon.jsii.Kernel.get(this, "variableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datasetContentVersionValue = software.amazon.jsii.Kernel.get(this, "datasetContentVersionValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.outputFileUriValue = software.amazon.jsii.Kernel.get(this, "outputFileUriValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variableName = java.util.Objects.requireNonNull(builder.variableName, "variableName is required");
                this.datasetContentVersionValue = builder.datasetContentVersionValue;
                this.doubleValue = builder.doubleValue;
                this.outputFileUriValue = builder.outputFileUriValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getVariableName() {
                return this.variableName;
            }

            @Override
            public final java.lang.Object getDatasetContentVersionValue() {
                return this.datasetContentVersionValue;
            }

            @Override
            public final java.lang.Number getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.Object getOutputFileUriValue() {
                return this.outputFileUriValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("variableName", om.valueToTree(this.getVariableName()));
                if (this.getDatasetContentVersionValue() != null) {
                    data.set("datasetContentVersionValue", om.valueToTree(this.getDatasetContentVersionValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getOutputFileUriValue() != null) {
                    data.set("outputFileUriValue", om.valueToTree(this.getOutputFileUriValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.VariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VariableProperty.Jsii$Proxy that = (VariableProperty.Jsii$Proxy) o;

                if (!variableName.equals(that.variableName)) return false;
                if (this.datasetContentVersionValue != null ? !this.datasetContentVersionValue.equals(that.datasetContentVersionValue) : that.datasetContentVersionValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.outputFileUriValue != null ? !this.outputFileUriValue.equals(that.outputFileUriValue) : that.outputFileUriValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.variableName.hashCode();
                result = 31 * result + (this.datasetContentVersionValue != null ? this.datasetContentVersionValue.hashCode() : 0);
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.outputFileUriValue != null ? this.outputFileUriValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the versioning of dataset contents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * VersioningConfigurationProperty versioningConfigurationProperty = VersioningConfigurationProperty.builder()
     *         .maxVersions(123)
     *         .unlimited(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDataset.VersioningConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VersioningConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * How many versions of dataset contents are kept.
         * <p>
         * The <code>unlimited</code> parameter must be <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html#cfn-iotanalytics-dataset-versioningconfiguration-maxversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html#cfn-iotanalytics-dataset-versioningconfiguration-maxversions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxVersions() {
            return null;
        }

        /**
         * If true, unlimited versions of dataset contents are kept.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html#cfn-iotanalytics-dataset-versioningconfiguration-unlimited">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html#cfn-iotanalytics-dataset-versioningconfiguration-unlimited</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnlimited() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VersioningConfigurationProperty> {
            java.lang.Number maxVersions;
            java.lang.Object unlimited;

            /**
             * Sets the value of {@link VersioningConfigurationProperty#getMaxVersions}
             * @param maxVersions How many versions of dataset contents are kept.
             *                    The <code>unlimited</code> parameter must be <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxVersions(java.lang.Number maxVersions) {
                this.maxVersions = maxVersions;
                return this;
            }

            /**
             * Sets the value of {@link VersioningConfigurationProperty#getUnlimited}
             * @param unlimited If true, unlimited versions of dataset contents are kept.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(java.lang.Boolean unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Sets the value of {@link VersioningConfigurationProperty#getUnlimited}
             * @param unlimited If true, unlimited versions of dataset contents are kept.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(software.amazon.awscdk.IResolvable unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VersioningConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VersioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersioningConfigurationProperty {
            private final java.lang.Number maxVersions;
            private final java.lang.Object unlimited;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxVersions = software.amazon.jsii.Kernel.get(this, "maxVersions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unlimited = software.amazon.jsii.Kernel.get(this, "unlimited", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxVersions = builder.maxVersions;
                this.unlimited = builder.unlimited;
            }

            @Override
            public final java.lang.Number getMaxVersions() {
                return this.maxVersions;
            }

            @Override
            public final java.lang.Object getUnlimited() {
                return this.unlimited;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxVersions() != null) {
                    data.set("maxVersions", om.valueToTree(this.getMaxVersions()));
                }
                if (this.getUnlimited() != null) {
                    data.set("unlimited", om.valueToTree(this.getUnlimited()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDataset.VersioningConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VersioningConfigurationProperty.Jsii$Proxy that = (VersioningConfigurationProperty.Jsii$Proxy) o;

                if (this.maxVersions != null ? !this.maxVersions.equals(that.maxVersions) : that.maxVersions != null) return false;
                return this.unlimited != null ? this.unlimited.equals(that.unlimited) : that.unlimited == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxVersions != null ? this.maxVersions.hashCode() : 0;
                result = 31 * result + (this.unlimited != null ? this.unlimited.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotanalytics.CfnDataset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotanalytics.CfnDataset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotanalytics.CfnDatasetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotanalytics.CfnDatasetProps.Builder();
        }

        /**
         * The <code>DatasetAction</code> objects that automatically create the dataset contents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions</a>
         * @param actions The <code>DatasetAction</code> objects that automatically create the dataset contents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * The <code>DatasetAction</code> objects that automatically create the dataset contents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions</a>
         * @param actions The <code>DatasetAction</code> objects that automatically create the dataset contents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * When dataset contents are created they are delivered to destinations specified here.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules</a>
         * @param contentDeliveryRules When dataset contents are created they are delivered to destinations specified here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDeliveryRules(final software.amazon.awscdk.IResolvable contentDeliveryRules) {
            this.props.contentDeliveryRules(contentDeliveryRules);
            return this;
        }
        /**
         * When dataset contents are created they are delivered to destinations specified here.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules</a>
         * @param contentDeliveryRules When dataset contents are created they are delivered to destinations specified here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDeliveryRules(final java.util.List<? extends java.lang.Object> contentDeliveryRules) {
            this.props.contentDeliveryRules(contentDeliveryRules);
            return this;
        }

        /**
         * The name of the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-datasetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-datasetname</a>
         * @param datasetName The name of the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetName(final java.lang.String datasetName) {
            this.props.datasetName(datasetName);
            return this;
        }

        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late.
         * <p>
         * To specify <code>lateDataRules</code> , the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules</a>
         * @param lateDataRules A list of data rules that send notifications to CloudWatch, when data arrives late. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lateDataRules(final software.amazon.awscdk.IResolvable lateDataRules) {
            this.props.lateDataRules(lateDataRules);
            return this;
        }
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late.
         * <p>
         * To specify <code>lateDataRules</code> , the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules</a>
         * @param lateDataRules A list of data rules that send notifications to CloudWatch, when data arrives late. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lateDataRules(final java.util.List<? extends java.lang.Object> lateDataRules) {
            this.props.lateDataRules(lateDataRules);
            return this;
        }

        /**
         * Optional.
         * <p>
         * How long, in days, message data is kept for the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod</a>
         * @param retentionPeriod Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.IResolvable retentionPeriod) {
            this.props.retentionPeriod(retentionPeriod);
            return this;
        }
        /**
         * Optional.
         * <p>
         * How long, in days, message data is kept for the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod</a>
         * @param retentionPeriod Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.services.iotanalytics.CfnDataset.RetentionPeriodProperty retentionPeriod) {
            this.props.retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * Metadata which can be used to manage the data set.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-tags</a>
         * @param tags Metadata which can be used to manage the data set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers</a>
         * @param triggers The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }
        /**
         * The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers</a>
         * @param triggers The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final java.util.List<? extends java.lang.Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        /**
         * Optional.
         * <p>
         * How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of AWS IoT Analytics datasets</a> in the <em>AWS IoT Analytics User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration</a>
         * @param versioningConfiguration Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(final software.amazon.awscdk.IResolvable versioningConfiguration) {
            this.props.versioningConfiguration(versioningConfiguration);
            return this;
        }
        /**
         * Optional.
         * <p>
         * How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of AWS IoT Analytics datasets</a> in the <em>AWS IoT Analytics User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration</a>
         * @param versioningConfiguration Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(final software.amazon.awscdk.services.iotanalytics.CfnDataset.VersioningConfigurationProperty versioningConfiguration) {
            this.props.versioningConfiguration(versioningConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotanalytics.CfnDataset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotanalytics.CfnDataset build() {
            return new software.amazon.awscdk.services.iotanalytics.CfnDataset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
