package software.amazon.awscdk.services.iotevents;

/**
 * The AWS::IoTEvents::Input resource creates an input.
 * <p>
 * To monitor your devices and processes, they must have a way to get telemetry data into AWS IoT Events . This is done by sending messages as <em>inputs</em> to AWS IoT Events . For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/how-to-use-iotevents.html">How to Use AWS IoT Events</a> in the <em>AWS IoT Events Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * CfnInput cfnInput = CfnInput.Builder.create(this, "MyCfnInput")
 *         .inputDefinition(InputDefinitionProperty.builder()
 *                 .attributes(List.of(AttributeProperty.builder()
 *                         .jsonPath("jsonPath")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .inputDescription("inputDescription")
 *         .inputName("inputName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.207Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnInput")
public class CfnInput extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotevents.CfnInput.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInput(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnInputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The definition of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputDefinition() {
        return software.amazon.jsii.Kernel.get(this, "inputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The definition of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputDefinition", java.util.Objects.requireNonNull(value, "inputDefinition is required"));
    }

    /**
     * The definition of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnInput.InputDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputDefinition", java.util.Objects.requireNonNull(value, "inputDefinition is required"));
    }

    /**
     * A brief description of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInputDescription() {
        return software.amazon.jsii.Kernel.get(this, "inputDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A brief description of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inputDescription", value);
    }

    /**
     * The name of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInputName() {
        return software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inputName", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The attributes from the JSON payload that are made available by the input.
     * <p>
     * Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code> . Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AttributeProperty attributeProperty = AttributeProperty.builder()
     *         .jsonPath("jsonPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnInput.AttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that specifies an attribute-value pair in a JSON structure.
         * <p>
         * Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events ( <code>BatchPutMessage</code> ). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors.
         * <p>
         * Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html#cfn-iotevents-input-attribute-jsonpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html#cfn-iotevents-input-attribute-jsonpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJsonPath();

        /**
         * @return a {@link Builder} of {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeProperty> {
            java.lang.String jsonPath;

            /**
             * Sets the value of {@link AttributeProperty#getJsonPath}
             * @param jsonPath An expression that specifies an attribute-value pair in a JSON structure. This parameter is required.
             *                 Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events ( <code>BatchPutMessage</code> ). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors.
             *                 <p>
             *                 Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonPath(java.lang.String jsonPath) {
                this.jsonPath = jsonPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeProperty {
            private final java.lang.String jsonPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonPath = software.amazon.jsii.Kernel.get(this, "jsonPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonPath = java.util.Objects.requireNonNull(builder.jsonPath, "jsonPath is required");
            }

            @Override
            public final java.lang.String getJsonPath() {
                return this.jsonPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("jsonPath", om.valueToTree(this.getJsonPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnInput.AttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeProperty.Jsii$Proxy that = (AttributeProperty.Jsii$Proxy) o;

                return this.jsonPath.equals(that.jsonPath);
            }

            @Override
            public final int hashCode() {
                int result = this.jsonPath.hashCode();
                return result;
            }
        }
    }
    /**
     * The definition of the input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * InputDefinitionProperty inputDefinitionProperty = InputDefinitionProperty.builder()
     *         .attributes(List.of(AttributeProperty.builder()
     *                 .jsonPath("jsonPath")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnInput.InputDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(InputDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The attributes from the JSON payload that are made available by the input.
         * <p>
         * Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code> . Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html#cfn-iotevents-input-inputdefinition-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html#cfn-iotevents-input-inputdefinition-attributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAttributes();

        /**
         * @return a {@link Builder} of {@link InputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputDefinitionProperty> {
            java.lang.Object attributes;

            /**
             * Sets the value of {@link InputDefinitionProperty#getAttributes}
             * @param attributes The attributes from the JSON payload that are made available by the input. This parameter is required.
             *                   Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code> . Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link InputDefinitionProperty#getAttributes}
             * @param attributes The attributes from the JSON payload that are made available by the input. This parameter is required.
             *                   Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code> . Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.List<? extends java.lang.Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputDefinitionProperty {
            private final java.lang.Object attributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = java.util.Objects.requireNonNull(builder.attributes, "attributes is required");
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributes", om.valueToTree(this.getAttributes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnInput.InputDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputDefinitionProperty.Jsii$Proxy that = (InputDefinitionProperty.Jsii$Proxy) o;

                return this.attributes.equals(that.attributes);
            }

            @Override
            public final int hashCode() {
                int result = this.attributes.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotevents.CfnInput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotevents.CfnInput> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotevents.CfnInputProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotevents.CfnInputProps.Builder();
        }

        /**
         * The definition of the input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition</a>
         * @param inputDefinition The definition of the input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDefinition(final software.amazon.awscdk.IResolvable inputDefinition) {
            this.props.inputDefinition(inputDefinition);
            return this;
        }
        /**
         * The definition of the input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition</a>
         * @param inputDefinition The definition of the input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDefinition(final software.amazon.awscdk.services.iotevents.CfnInput.InputDefinitionProperty inputDefinition) {
            this.props.inputDefinition(inputDefinition);
            return this;
        }

        /**
         * A brief description of the input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription</a>
         * @param inputDescription A brief description of the input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDescription(final java.lang.String inputDescription) {
            this.props.inputDescription(inputDescription);
            return this;
        }

        /**
         * The name of the input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname</a>
         * @param inputName The name of the input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputName(final java.lang.String inputName) {
            this.props.inputName(inputName);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotevents.CfnInput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotevents.CfnInput build() {
            return new software.amazon.awscdk.services.iotevents.CfnInput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
