package software.amazon.awscdk.services.iotfleetwise;

/**
 * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must be true:.
 * <p>
 * <ul>
 * <li>Every signal decoder has a unique name.</li>
 * <li>Each signal decoder is associated with a network interface.</li>
 * <li>Each network interface has a unique ID.</li>
 * <li>The signal decoders are specified in the model manifest.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/decoder-manifests.html">Decoder manifests</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * Access to certain AWS IoT FleetWise features is currently gated. For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">AWS Region and feature availability</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnDecoderManifest cfnDecoderManifest = CfnDecoderManifest.Builder.create(this, "MyCfnDecoderManifest")
 *         .modelManifestArn("modelManifestArn")
 *         .name("name")
 *         // the properties below are optional
 *         .defaultForUnmappedSignals("defaultForUnmappedSignals")
 *         .description("description")
 *         .networkInterfaces(List.of(NetworkInterfacesItemsProperty.builder()
 *                 .interfaceId("interfaceId")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .canInterface(CanInterfaceProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .protocolName("protocolName")
 *                         .protocolVersion("protocolVersion")
 *                         .build())
 *                 .obdInterface(ObdInterfaceProperty.builder()
 *                         .name("name")
 *                         .requestMessageId("requestMessageId")
 *                         // the properties below are optional
 *                         .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
 *                         .hasTransmissionEcu("hasTransmissionEcu")
 *                         .obdStandard("obdStandard")
 *                         .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
 *                         .useExtendedIds("useExtendedIds")
 *                         .build())
 *                 .build()))
 *         .signalDecoders(List.of(SignalDecodersItemsProperty.builder()
 *                 .fullyQualifiedName("fullyQualifiedName")
 *                 .interfaceId("interfaceId")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .canSignal(CanSignalProperty.builder()
 *                         .factor("factor")
 *                         .isBigEndian("isBigEndian")
 *                         .isSigned("isSigned")
 *                         .length("length")
 *                         .messageId("messageId")
 *                         .offset("offset")
 *                         .startBit("startBit")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .signalValueType("signalValueType")
 *                         .build())
 *                 .obdSignal(ObdSignalProperty.builder()
 *                         .byteLength("byteLength")
 *                         .offset("offset")
 *                         .pid("pid")
 *                         .pidResponseLength("pidResponseLength")
 *                         .scaling("scaling")
 *                         .serviceMode("serviceMode")
 *                         .startByte("startByte")
 *                         // the properties below are optional
 *                         .bitMaskLength("bitMaskLength")
 *                         .bitRightShift("bitRightShift")
 *                         .isSigned("isSigned")
 *                         .signalValueType("signalValueType")
 *                         .build())
 *                 .build()))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.224Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest")
public class CfnDecoderManifest extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDecoderManifest(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDecoderManifest(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDecoderManifest(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn() {
        return software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelManifestArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelManifestArn", java.util.Objects.requireNonNull(value, "modelManifestArn is required"));
    }

    /**
     * The name of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Use default decoders for all unmapped signals in the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultForUnmappedSignals() {
        return software.amazon.jsii.Kernel.get(this, "defaultForUnmappedSignals", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Use default decoders for all unmapped signals in the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultForUnmappedSignals(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultForUnmappedSignals", value);
    }

    /**
     * A brief description of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A brief description of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A list of information about available network interfaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
        return software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of information about available network interfaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * A list of information about available network interfaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * A list of information about signal decoders.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSignalDecoders() {
        return software.amazon.jsii.Kernel.get(this, "signalDecoders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of information about signal decoders.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalDecoders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "signalDecoders", value);
    }

    /**
     * A list of information about signal decoders.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalDecoders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "signalDecoders", value);
    }

    /**
     * The state of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }

    /**
     * Metadata that can be used to manage the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that can be used to manage the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A single controller area network (CAN) device interface.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanInterfaceProperty canInterfaceProperty = CanInterfaceProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .protocolName("protocolName")
     *         .protocolVersion("protocolVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(CanInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique name of the interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the communication protocol for the interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-protocolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-protocolname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolName() {
            return null;
        }

        /**
         * The version of the communication protocol for the interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-protocolversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-protocolversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanInterfaceProperty> {
            java.lang.String name;
            java.lang.String protocolName;
            java.lang.String protocolVersion;

            /**
             * Sets the value of {@link CanInterfaceProperty#getName}
             * @param name The unique name of the interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CanInterfaceProperty#getProtocolName}
             * @param protocolName The name of the communication protocol for the interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolName(java.lang.String protocolName) {
                this.protocolName = protocolName;
                return this;
            }

            /**
             * Sets the value of {@link CanInterfaceProperty#getProtocolVersion}
             * @param protocolVersion The version of the communication protocol for the interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolVersion(java.lang.String protocolVersion) {
                this.protocolVersion = protocolVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.String protocolName;
            private final java.lang.String protocolVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolName = software.amazon.jsii.Kernel.get(this, "protocolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolVersion = software.amazon.jsii.Kernel.get(this, "protocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.protocolName = builder.protocolName;
                this.protocolVersion = builder.protocolVersion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocolName() {
                return this.protocolName;
            }

            @Override
            public final java.lang.String getProtocolVersion() {
                return this.protocolVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getProtocolName() != null) {
                    data.set("protocolName", om.valueToTree(this.getProtocolName()));
                }
                if (this.getProtocolVersion() != null) {
                    data.set("protocolVersion", om.valueToTree(this.getProtocolVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanInterfaceProperty.Jsii$Proxy that = (CanInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.protocolName != null ? !this.protocolName.equals(that.protocolName) : that.protocolName != null) return false;
                return this.protocolVersion != null ? this.protocolVersion.equals(that.protocolVersion) : that.protocolVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.protocolName != null ? this.protocolName.hashCode() : 0);
                result = 31 * result + (this.protocolVersion != null ? this.protocolVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a node and its specifications in an in-vehicle communication network.
     * <p>
     * All signal decoders must be associated with a network node.
     * <p>
     * To return this information about all the network interfaces specified in a decoder manifest, use the <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_ListDecoderManifestNetworkInterfaces.html">ListDecoderManifestNetworkInterfaces</a> in the <em>AWS IoT FleetWise API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanNetworkInterfaceProperty canNetworkInterfaceProperty = CanNetworkInterfaceProperty.builder()
     *         .canInterface(CanInterfaceProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .protocolName("protocolName")
     *                 .protocolVersion("protocolVersion")
     *                 .build())
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanNetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(CanNetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanNetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about a network interface specified by the Controller Area Network (CAN) protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-caninterface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-caninterface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCanInterface();

        /**
         * The ID of the network interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-interfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-interfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * The network protocol for the vehicle.
         * <p>
         * For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link CanNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanNetworkInterfaceProperty> {
            java.lang.Object canInterface;
            java.lang.String interfaceId;
            java.lang.String type;

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getCanInterface}
             * @param canInterface Information about a network interface specified by the Controller Area Network (CAN) protocol. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.IResolvable canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getCanInterface}
             * @param canInterface Information about a network interface specified by the Controller Area Network (CAN) protocol. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanInterfaceProperty canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getInterfaceId}
             * @param interfaceId The ID of the network interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getType}
             * @param type The network protocol for the vehicle. This parameter is required.
             *             For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanNetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanNetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanNetworkInterfaceProperty {
            private final java.lang.Object canInterface;
            private final java.lang.String interfaceId;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.canInterface = software.amazon.jsii.Kernel.get(this, "canInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.canInterface = java.util.Objects.requireNonNull(builder.canInterface, "canInterface is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getCanInterface() {
                return this.canInterface;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("canInterface", om.valueToTree(this.getCanInterface()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanNetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanNetworkInterfaceProperty.Jsii$Proxy that = (CanNetworkInterfaceProperty.Jsii$Proxy) o;

                if (!canInterface.equals(that.canInterface)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.canInterface.hashCode();
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about signal decoder using the Controller Area Network (CAN) protocol.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanSignalDecoderProperty canSignalDecoderProperty = CanSignalDecoderProperty.builder()
     *         .canSignal(CanSignalProperty.builder()
     *                 .factor("factor")
     *                 .isBigEndian("isBigEndian")
     *                 .isSigned("isSigned")
     *                 .length("length")
     *                 .messageId("messageId")
     *                 .offset("offset")
     *                 .startBit("startBit")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .signalValueType("signalValueType")
     *                 .build())
     *         .fullyQualifiedName("fullyQualifiedName")
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalDecoderProperty")
    @software.amazon.jsii.Jsii.Proxy(CanSignalDecoderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanSignalDecoderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about a single controller area network (CAN) signal and the messages it receives and transmits.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-cansignal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-cansignal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCanSignal();

        /**
         * The fully qualified name of a signal decoder as defined in a vehicle model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * The ID of a network interface that specifies what network protocol a vehicle follows.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-interfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-interfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * The network protocol for the vehicle.
         * <p>
         * For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link CanSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanSignalDecoderProperty> {
            java.lang.Object canSignal;
            java.lang.String fullyQualifiedName;
            java.lang.String interfaceId;
            java.lang.String type;

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getCanSignal}
             * @param canSignal Information about a single controller area network (CAN) signal and the messages it receives and transmits. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.IResolvable canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getCanSignal}
             * @param canSignal Information about a single controller area network (CAN) signal and the messages it receives and transmits. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanSignalProperty canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getFullyQualifiedName}
             * @param fullyQualifiedName The fully qualified name of a signal decoder as defined in a vehicle model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getInterfaceId}
             * @param interfaceId The ID of a network interface that specifies what network protocol a vehicle follows. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getType}
             * @param type The network protocol for the vehicle. This parameter is required.
             *             For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanSignalDecoderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanSignalDecoderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanSignalDecoderProperty {
            private final java.lang.Object canSignal;
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String interfaceId;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.canSignal = software.amazon.jsii.Kernel.get(this, "canSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.canSignal = java.util.Objects.requireNonNull(builder.canSignal, "canSignal is required");
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getCanSignal() {
                return this.canSignal;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("canSignal", om.valueToTree(this.getCanSignal()));
                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalDecoderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanSignalDecoderProperty.Jsii$Proxy that = (CanSignalDecoderProperty.Jsii$Proxy) o;

                if (!canSignal.equals(that.canSignal)) return false;
                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.canSignal.hashCode();
                result = 31 * result + (this.fullyQualifiedName.hashCode());
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about a single controller area network (CAN) signal and the messages it receives and transmits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanSignalProperty canSignalProperty = CanSignalProperty.builder()
     *         .factor("factor")
     *         .isBigEndian("isBigEndian")
     *         .isSigned("isSigned")
     *         .length("length")
     *         .messageId("messageId")
     *         .offset("offset")
     *         .startBit("startBit")
     *         // the properties below are optional
     *         .name("name")
     *         .signalValueType("signalValueType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalProperty")
    @software.amazon.jsii.Jsii.Proxy(CanSignalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanSignalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A multiplier used to decode the CAN message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-factor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-factor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFactor();

        /**
         * Whether the byte ordering of a CAN message is big-endian.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-isbigendian">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-isbigendian</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIsBigEndian();

        /**
         * Whether the message data is specified as a signed value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-issigned">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-issigned</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIsSigned();

        /**
         * How many bytes of data are in the message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-length">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-length</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLength();

        /**
         * The ID of the message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-messageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-messageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessageId();

        /**
         * The offset used to calculate the signal value.
         * <p>
         * Combined with factor, the calculation is <code>value = raw_value * factor + offset</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-offset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-offset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOffset();

        /**
         * Indicates the beginning of the CAN message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-startbit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-startbit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartBit();

        /**
         * The name of the signal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value type of the signal.
         * <p>
         * The default value is <code>INTEGER</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-signalvaluetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-signalvaluetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSignalValueType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanSignalProperty> {
            java.lang.String factor;
            java.lang.String isBigEndian;
            java.lang.String isSigned;
            java.lang.String length;
            java.lang.String messageId;
            java.lang.String offset;
            java.lang.String startBit;
            java.lang.String name;
            java.lang.String signalValueType;

            /**
             * Sets the value of {@link CanSignalProperty#getFactor}
             * @param factor A multiplier used to decode the CAN message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder factor(java.lang.String factor) {
                this.factor = factor;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getIsBigEndian}
             * @param isBigEndian Whether the byte ordering of a CAN message is big-endian. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isBigEndian(java.lang.String isBigEndian) {
                this.isBigEndian = isBigEndian;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getIsSigned}
             * @param isSigned Whether the message data is specified as a signed value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSigned(java.lang.String isSigned) {
                this.isSigned = isSigned;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getLength}
             * @param length How many bytes of data are in the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder length(java.lang.String length) {
                this.length = length;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getMessageId}
             * @param messageId The ID of the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageId(java.lang.String messageId) {
                this.messageId = messageId;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getOffset}
             * @param offset The offset used to calculate the signal value. This parameter is required.
             *               Combined with factor, the calculation is <code>value = raw_value * factor + offset</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.String offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getStartBit}
             * @param startBit Indicates the beginning of the CAN message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startBit(java.lang.String startBit) {
                this.startBit = startBit;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getName}
             * @param name The name of the signal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getSignalValueType}
             * @param signalValueType The value type of the signal.
             *                        The default value is <code>INTEGER</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signalValueType(java.lang.String signalValueType) {
                this.signalValueType = signalValueType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanSignalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanSignalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanSignalProperty {
            private final java.lang.String factor;
            private final java.lang.String isBigEndian;
            private final java.lang.String isSigned;
            private final java.lang.String length;
            private final java.lang.String messageId;
            private final java.lang.String offset;
            private final java.lang.String startBit;
            private final java.lang.String name;
            private final java.lang.String signalValueType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.factor = software.amazon.jsii.Kernel.get(this, "factor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isBigEndian = software.amazon.jsii.Kernel.get(this, "isBigEndian", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isSigned = software.amazon.jsii.Kernel.get(this, "isSigned", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.length = software.amazon.jsii.Kernel.get(this, "length", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageId = software.amazon.jsii.Kernel.get(this, "messageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startBit = software.amazon.jsii.Kernel.get(this, "startBit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signalValueType = software.amazon.jsii.Kernel.get(this, "signalValueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.factor = java.util.Objects.requireNonNull(builder.factor, "factor is required");
                this.isBigEndian = java.util.Objects.requireNonNull(builder.isBigEndian, "isBigEndian is required");
                this.isSigned = java.util.Objects.requireNonNull(builder.isSigned, "isSigned is required");
                this.length = java.util.Objects.requireNonNull(builder.length, "length is required");
                this.messageId = java.util.Objects.requireNonNull(builder.messageId, "messageId is required");
                this.offset = java.util.Objects.requireNonNull(builder.offset, "offset is required");
                this.startBit = java.util.Objects.requireNonNull(builder.startBit, "startBit is required");
                this.name = builder.name;
                this.signalValueType = builder.signalValueType;
            }

            @Override
            public final java.lang.String getFactor() {
                return this.factor;
            }

            @Override
            public final java.lang.String getIsBigEndian() {
                return this.isBigEndian;
            }

            @Override
            public final java.lang.String getIsSigned() {
                return this.isSigned;
            }

            @Override
            public final java.lang.String getLength() {
                return this.length;
            }

            @Override
            public final java.lang.String getMessageId() {
                return this.messageId;
            }

            @Override
            public final java.lang.String getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.String getStartBit() {
                return this.startBit;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSignalValueType() {
                return this.signalValueType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("factor", om.valueToTree(this.getFactor()));
                data.set("isBigEndian", om.valueToTree(this.getIsBigEndian()));
                data.set("isSigned", om.valueToTree(this.getIsSigned()));
                data.set("length", om.valueToTree(this.getLength()));
                data.set("messageId", om.valueToTree(this.getMessageId()));
                data.set("offset", om.valueToTree(this.getOffset()));
                data.set("startBit", om.valueToTree(this.getStartBit()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSignalValueType() != null) {
                    data.set("signalValueType", om.valueToTree(this.getSignalValueType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanSignalProperty.Jsii$Proxy that = (CanSignalProperty.Jsii$Proxy) o;

                if (!factor.equals(that.factor)) return false;
                if (!isBigEndian.equals(that.isBigEndian)) return false;
                if (!isSigned.equals(that.isSigned)) return false;
                if (!length.equals(that.length)) return false;
                if (!messageId.equals(that.messageId)) return false;
                if (!offset.equals(that.offset)) return false;
                if (!startBit.equals(that.startBit)) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.signalValueType != null ? this.signalValueType.equals(that.signalValueType) : that.signalValueType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.factor.hashCode();
                result = 31 * result + (this.isBigEndian.hashCode());
                result = 31 * result + (this.isSigned.hashCode());
                result = 31 * result + (this.length.hashCode());
                result = 31 * result + (this.messageId.hashCode());
                result = 31 * result + (this.offset.hashCode());
                result = 31 * result + (this.startBit.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.signalValueType != null ? this.signalValueType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of information about available network interfaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * NetworkInterfacesItemsProperty networkInterfacesItemsProperty = NetworkInterfacesItemsProperty.builder()
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         // the properties below are optional
     *         .canInterface(CanInterfaceProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .protocolName("protocolName")
     *                 .protocolVersion("protocolVersion")
     *                 .build())
     *         .obdInterface(ObdInterfaceProperty.builder()
     *                 .name("name")
     *                 .requestMessageId("requestMessageId")
     *                 // the properties below are optional
     *                 .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
     *                 .hasTransmissionEcu("hasTransmissionEcu")
     *                 .obdStandard("obdStandard")
     *                 .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
     *                 .useExtendedIds("useExtendedIds")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfacesItemsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfacesItemsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-interfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-interfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-caninterface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-caninterface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanInterface() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-obdinterface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-networkinterfacesitems.html#cfn-iotfleetwise-decodermanifest-networkinterfacesitems-obdinterface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getObdInterface() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfacesItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfacesItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfacesItemsProperty> {
            java.lang.String interfaceId;
            java.lang.String type;
            java.lang.Object canInterface;
            java.lang.Object obdInterface;

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getInterfaceId}
             * @param interfaceId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getType}
             * @param type the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getCanInterface}
             * @param canInterface the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.IResolvable canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getCanInterface}
             * @param canInterface the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanInterfaceProperty canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getObdInterface}
             * @param obdInterface the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.IResolvable obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getObdInterface}
             * @param obdInterface the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfacesItemsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfacesItemsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfacesItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfacesItemsProperty {
            private final java.lang.String interfaceId;
            private final java.lang.String type;
            private final java.lang.Object canInterface;
            private final java.lang.Object obdInterface;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.canInterface = software.amazon.jsii.Kernel.get(this, "canInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obdInterface = software.amazon.jsii.Kernel.get(this, "obdInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.canInterface = builder.canInterface;
                this.obdInterface = builder.obdInterface;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getCanInterface() {
                return this.canInterface;
            }

            @Override
            public final java.lang.Object getObdInterface() {
                return this.obdInterface;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCanInterface() != null) {
                    data.set("canInterface", om.valueToTree(this.getCanInterface()));
                }
                if (this.getObdInterface() != null) {
                    data.set("obdInterface", om.valueToTree(this.getObdInterface()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfacesItemsProperty.Jsii$Proxy that = (NetworkInterfacesItemsProperty.Jsii$Proxy) o;

                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!type.equals(that.type)) return false;
                if (this.canInterface != null ? !this.canInterface.equals(that.canInterface) : that.canInterface != null) return false;
                return this.obdInterface != null ? this.obdInterface.equals(that.obdInterface) : that.obdInterface == null;
            }

            @Override
            public final int hashCode() {
                int result = this.interfaceId.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.canInterface != null ? this.canInterface.hashCode() : 0);
                result = 31 * result + (this.obdInterface != null ? this.obdInterface.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A network interface that specifies the On-board diagnostic (OBD) II network protocol.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ObdInterfaceProperty obdInterfaceProperty = ObdInterfaceProperty.builder()
     *         .name("name")
     *         .requestMessageId("requestMessageId")
     *         // the properties below are optional
     *         .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
     *         .hasTransmissionEcu("hasTransmissionEcu")
     *         .obdStandard("obdStandard")
     *         .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
     *         .useExtendedIds("useExtendedIds")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The ID of the message requesting vehicle data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-requestmessageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-requestmessageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRequestMessageId();

        /**
         * The maximum number message requests per diagnostic trouble code per second.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-dtcrequestintervalseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-dtcrequestintervalseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDtcRequestIntervalSeconds() {
            return null;
        }

        /**
         * Whether the vehicle has a transmission control module (TCM).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-hastransmissionecu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-hastransmissionecu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHasTransmissionEcu() {
            return null;
        }

        /**
         * The standard OBD II PID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-obdstandard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-obdstandard</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObdStandard() {
            return null;
        }

        /**
         * The maximum number message requests per second.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-pidrequestintervalseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-pidrequestintervalseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPidRequestIntervalSeconds() {
            return null;
        }

        /**
         * Whether to use extended IDs in the message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-useextendedids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-useextendedids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUseExtendedIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdInterfaceProperty> {
            java.lang.String name;
            java.lang.String requestMessageId;
            java.lang.String dtcRequestIntervalSeconds;
            java.lang.String hasTransmissionEcu;
            java.lang.String obdStandard;
            java.lang.String pidRequestIntervalSeconds;
            java.lang.String useExtendedIds;

            /**
             * Sets the value of {@link ObdInterfaceProperty#getName}
             * @param name The name of the interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getRequestMessageId}
             * @param requestMessageId The ID of the message requesting vehicle data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestMessageId(java.lang.String requestMessageId) {
                this.requestMessageId = requestMessageId;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getDtcRequestIntervalSeconds}
             * @param dtcRequestIntervalSeconds The maximum number message requests per diagnostic trouble code per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dtcRequestIntervalSeconds(java.lang.String dtcRequestIntervalSeconds) {
                this.dtcRequestIntervalSeconds = dtcRequestIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getHasTransmissionEcu}
             * @param hasTransmissionEcu Whether the vehicle has a transmission control module (TCM).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hasTransmissionEcu(java.lang.String hasTransmissionEcu) {
                this.hasTransmissionEcu = hasTransmissionEcu;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getObdStandard}
             * @param obdStandard The standard OBD II PID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdStandard(java.lang.String obdStandard) {
                this.obdStandard = obdStandard;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getPidRequestIntervalSeconds}
             * @param pidRequestIntervalSeconds The maximum number message requests per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidRequestIntervalSeconds(java.lang.String pidRequestIntervalSeconds) {
                this.pidRequestIntervalSeconds = pidRequestIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getUseExtendedIds}
             * @param useExtendedIds Whether to use extended IDs in the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExtendedIds(java.lang.String useExtendedIds) {
                this.useExtendedIds = useExtendedIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.String requestMessageId;
            private final java.lang.String dtcRequestIntervalSeconds;
            private final java.lang.String hasTransmissionEcu;
            private final java.lang.String obdStandard;
            private final java.lang.String pidRequestIntervalSeconds;
            private final java.lang.String useExtendedIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requestMessageId = software.amazon.jsii.Kernel.get(this, "requestMessageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dtcRequestIntervalSeconds = software.amazon.jsii.Kernel.get(this, "dtcRequestIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hasTransmissionEcu = software.amazon.jsii.Kernel.get(this, "hasTransmissionEcu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.obdStandard = software.amazon.jsii.Kernel.get(this, "obdStandard", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pidRequestIntervalSeconds = software.amazon.jsii.Kernel.get(this, "pidRequestIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useExtendedIds = software.amazon.jsii.Kernel.get(this, "useExtendedIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.requestMessageId = java.util.Objects.requireNonNull(builder.requestMessageId, "requestMessageId is required");
                this.dtcRequestIntervalSeconds = builder.dtcRequestIntervalSeconds;
                this.hasTransmissionEcu = builder.hasTransmissionEcu;
                this.obdStandard = builder.obdStandard;
                this.pidRequestIntervalSeconds = builder.pidRequestIntervalSeconds;
                this.useExtendedIds = builder.useExtendedIds;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRequestMessageId() {
                return this.requestMessageId;
            }

            @Override
            public final java.lang.String getDtcRequestIntervalSeconds() {
                return this.dtcRequestIntervalSeconds;
            }

            @Override
            public final java.lang.String getHasTransmissionEcu() {
                return this.hasTransmissionEcu;
            }

            @Override
            public final java.lang.String getObdStandard() {
                return this.obdStandard;
            }

            @Override
            public final java.lang.String getPidRequestIntervalSeconds() {
                return this.pidRequestIntervalSeconds;
            }

            @Override
            public final java.lang.String getUseExtendedIds() {
                return this.useExtendedIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("requestMessageId", om.valueToTree(this.getRequestMessageId()));
                if (this.getDtcRequestIntervalSeconds() != null) {
                    data.set("dtcRequestIntervalSeconds", om.valueToTree(this.getDtcRequestIntervalSeconds()));
                }
                if (this.getHasTransmissionEcu() != null) {
                    data.set("hasTransmissionEcu", om.valueToTree(this.getHasTransmissionEcu()));
                }
                if (this.getObdStandard() != null) {
                    data.set("obdStandard", om.valueToTree(this.getObdStandard()));
                }
                if (this.getPidRequestIntervalSeconds() != null) {
                    data.set("pidRequestIntervalSeconds", om.valueToTree(this.getPidRequestIntervalSeconds()));
                }
                if (this.getUseExtendedIds() != null) {
                    data.set("useExtendedIds", om.valueToTree(this.getUseExtendedIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdInterfaceProperty.Jsii$Proxy that = (ObdInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!requestMessageId.equals(that.requestMessageId)) return false;
                if (this.dtcRequestIntervalSeconds != null ? !this.dtcRequestIntervalSeconds.equals(that.dtcRequestIntervalSeconds) : that.dtcRequestIntervalSeconds != null) return false;
                if (this.hasTransmissionEcu != null ? !this.hasTransmissionEcu.equals(that.hasTransmissionEcu) : that.hasTransmissionEcu != null) return false;
                if (this.obdStandard != null ? !this.obdStandard.equals(that.obdStandard) : that.obdStandard != null) return false;
                if (this.pidRequestIntervalSeconds != null ? !this.pidRequestIntervalSeconds.equals(that.pidRequestIntervalSeconds) : that.pidRequestIntervalSeconds != null) return false;
                return this.useExtendedIds != null ? this.useExtendedIds.equals(that.useExtendedIds) : that.useExtendedIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.requestMessageId.hashCode());
                result = 31 * result + (this.dtcRequestIntervalSeconds != null ? this.dtcRequestIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.hasTransmissionEcu != null ? this.hasTransmissionEcu.hashCode() : 0);
                result = 31 * result + (this.obdStandard != null ? this.obdStandard.hashCode() : 0);
                result = 31 * result + (this.pidRequestIntervalSeconds != null ? this.pidRequestIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.useExtendedIds != null ? this.useExtendedIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a network interface specified by the On-board diagnostic (OBD) II protocol.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ObdNetworkInterfaceProperty obdNetworkInterfaceProperty = ObdNetworkInterfaceProperty.builder()
     *         .interfaceId("interfaceId")
     *         .obdInterface(ObdInterfaceProperty.builder()
     *                 .name("name")
     *                 .requestMessageId("requestMessageId")
     *                 // the properties below are optional
     *                 .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
     *                 .hasTransmissionEcu("hasTransmissionEcu")
     *                 .obdStandard("obdStandard")
     *                 .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
     *                 .useExtendedIds("useExtendedIds")
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdNetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdNetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdNetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the network interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-interfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-interfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * Information about a network interface specified by the On-board diagnostic (OBD) II protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-obdinterface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-obdinterface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getObdInterface();

        /**
         * The network protocol for the vehicle.
         * <p>
         * For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ObdNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdNetworkInterfaceProperty> {
            java.lang.String interfaceId;
            java.lang.Object obdInterface;
            java.lang.String type;

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getInterfaceId}
             * @param interfaceId The ID of the network interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getObdInterface}
             * @param obdInterface Information about a network interface specified by the On-board diagnostic (OBD) II protocol. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.IResolvable obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getObdInterface}
             * @param obdInterface Information about a network interface specified by the On-board diagnostic (OBD) II protocol. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getType}
             * @param type The network protocol for the vehicle. This parameter is required.
             *             For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdNetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdNetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdNetworkInterfaceProperty {
            private final java.lang.String interfaceId;
            private final java.lang.Object obdInterface;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.obdInterface = software.amazon.jsii.Kernel.get(this, "obdInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.obdInterface = java.util.Objects.requireNonNull(builder.obdInterface, "obdInterface is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.Object getObdInterface() {
                return this.obdInterface;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("obdInterface", om.valueToTree(this.getObdInterface()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdNetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdNetworkInterfaceProperty.Jsii$Proxy that = (ObdNetworkInterfaceProperty.Jsii$Proxy) o;

                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!obdInterface.equals(that.obdInterface)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.interfaceId.hashCode();
                result = 31 * result + (this.obdInterface.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of information about signal decoders.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ObdSignalDecoderProperty obdSignalDecoderProperty = ObdSignalDecoderProperty.builder()
     *         .fullyQualifiedName("fullyQualifiedName")
     *         .interfaceId("interfaceId")
     *         .obdSignal(ObdSignalProperty.builder()
     *                 .byteLength("byteLength")
     *                 .offset("offset")
     *                 .pid("pid")
     *                 .pidResponseLength("pidResponseLength")
     *                 .scaling("scaling")
     *                 .serviceMode("serviceMode")
     *                 .startByte("startByte")
     *                 // the properties below are optional
     *                 .bitMaskLength("bitMaskLength")
     *                 .bitRightShift("bitRightShift")
     *                 .isSigned("isSigned")
     *                 .signalValueType("signalValueType")
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalDecoderProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdSignalDecoderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdSignalDecoderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The fully qualified name of a signal decoder as defined in a vehicle model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * The ID of a network interface that specifies what network protocol a vehicle follows.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-interfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-interfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-obdsignal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-obdsignal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getObdSignal();

        /**
         * The network protocol for the vehicle.
         * <p>
         * For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ObdSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdSignalDecoderProperty> {
            java.lang.String fullyQualifiedName;
            java.lang.String interfaceId;
            java.lang.Object obdSignal;
            java.lang.String type;

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getFullyQualifiedName}
             * @param fullyQualifiedName The fully qualified name of a signal decoder as defined in a vehicle model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getInterfaceId}
             * @param interfaceId The ID of a network interface that specifies what network protocol a vehicle follows. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getObdSignal}
             * @param obdSignal Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.IResolvable obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getObdSignal}
             * @param obdSignal Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdSignalProperty obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getType}
             * @param type The network protocol for the vehicle. This parameter is required.
             *             For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdSignalDecoderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdSignalDecoderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdSignalDecoderProperty {
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String interfaceId;
            private final java.lang.Object obdSignal;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.obdSignal = software.amazon.jsii.Kernel.get(this, "obdSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.obdSignal = java.util.Objects.requireNonNull(builder.obdSignal, "obdSignal is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.Object getObdSignal() {
                return this.obdSignal;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("obdSignal", om.valueToTree(this.getObdSignal()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalDecoderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdSignalDecoderProperty.Jsii$Proxy that = (ObdSignalDecoderProperty.Jsii$Proxy) o;

                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!obdSignal.equals(that.obdSignal)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.fullyQualifiedName.hashCode();
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.obdSignal.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ObdSignalProperty obdSignalProperty = ObdSignalProperty.builder()
     *         .byteLength("byteLength")
     *         .offset("offset")
     *         .pid("pid")
     *         .pidResponseLength("pidResponseLength")
     *         .scaling("scaling")
     *         .serviceMode("serviceMode")
     *         .startByte("startByte")
     *         // the properties below are optional
     *         .bitMaskLength("bitMaskLength")
     *         .bitRightShift("bitRightShift")
     *         .isSigned("isSigned")
     *         .signalValueType("signalValueType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdSignalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdSignalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of a message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bytelength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bytelength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getByteLength();

        /**
         * The offset used to calculate the signal value.
         * <p>
         * Combined with scaling, the calculation is <code>value = raw_value * scaling + offset</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-offset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-offset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOffset();

        /**
         * The diagnostic code used to request data from a vehicle for this signal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-pid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-pid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPid();

        /**
         * The length of the requested data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-pidresponselength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-pidresponselength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPidResponseLength();

        /**
         * A multiplier used to decode the message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-scaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-scaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScaling();

        /**
         * The mode of operation (diagnostic service) in a message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-servicemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-servicemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceMode();

        /**
         * Indicates the beginning of the message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-startbyte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-startbyte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartByte();

        /**
         * The number of bits to mask in a message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bitmasklength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bitmasklength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitMaskLength() {
            return null;
        }

        /**
         * The number of positions to shift bits in the message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bitrightshift">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bitrightshift</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitRightShift() {
            return null;
        }

        /**
         * Determines whether the message is signed ( <code>true</code> ) or not ( <code>false</code> ).
         * <p>
         * If it's signed, the message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal type. The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-issigned">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-issigned</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsSigned() {
            return null;
        }

        /**
         * The value type of the signal.
         * <p>
         * The default value is <code>INTEGER</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-signalvaluetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-signalvaluetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSignalValueType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdSignalProperty> {
            java.lang.String byteLength;
            java.lang.String offset;
            java.lang.String pid;
            java.lang.String pidResponseLength;
            java.lang.String scaling;
            java.lang.String serviceMode;
            java.lang.String startByte;
            java.lang.String bitMaskLength;
            java.lang.String bitRightShift;
            java.lang.Object isSigned;
            java.lang.String signalValueType;

            /**
             * Sets the value of {@link ObdSignalProperty#getByteLength}
             * @param byteLength The length of a message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder byteLength(java.lang.String byteLength) {
                this.byteLength = byteLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getOffset}
             * @param offset The offset used to calculate the signal value. This parameter is required.
             *               Combined with scaling, the calculation is <code>value = raw_value * scaling + offset</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.String offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getPid}
             * @param pid The diagnostic code used to request data from a vehicle for this signal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.String pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getPidResponseLength}
             * @param pidResponseLength The length of the requested data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidResponseLength(java.lang.String pidResponseLength) {
                this.pidResponseLength = pidResponseLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getScaling}
             * @param scaling A multiplier used to decode the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaling(java.lang.String scaling) {
                this.scaling = scaling;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getServiceMode}
             * @param serviceMode The mode of operation (diagnostic service) in a message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceMode(java.lang.String serviceMode) {
                this.serviceMode = serviceMode;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getStartByte}
             * @param startByte Indicates the beginning of the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startByte(java.lang.String startByte) {
                this.startByte = startByte;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getBitMaskLength}
             * @param bitMaskLength The number of bits to mask in a message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitMaskLength(java.lang.String bitMaskLength) {
                this.bitMaskLength = bitMaskLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getBitRightShift}
             * @param bitRightShift The number of positions to shift bits in the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitRightShift(java.lang.String bitRightShift) {
                this.bitRightShift = bitRightShift;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getIsSigned}
             * @param isSigned Determines whether the message is signed ( <code>true</code> ) or not ( <code>false</code> ).
             *                 If it's signed, the message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal type. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSigned(java.lang.String isSigned) {
                this.isSigned = isSigned;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getIsSigned}
             * @param isSigned Determines whether the message is signed ( <code>true</code> ) or not ( <code>false</code> ).
             *                 If it's signed, the message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal type. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSigned(java.lang.Boolean isSigned) {
                this.isSigned = isSigned;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getIsSigned}
             * @param isSigned Determines whether the message is signed ( <code>true</code> ) or not ( <code>false</code> ).
             *                 If it's signed, the message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal type. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSigned(software.amazon.awscdk.IResolvable isSigned) {
                this.isSigned = isSigned;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getSignalValueType}
             * @param signalValueType The value type of the signal.
             *                        The default value is <code>INTEGER</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signalValueType(java.lang.String signalValueType) {
                this.signalValueType = signalValueType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdSignalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdSignalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdSignalProperty {
            private final java.lang.String byteLength;
            private final java.lang.String offset;
            private final java.lang.String pid;
            private final java.lang.String pidResponseLength;
            private final java.lang.String scaling;
            private final java.lang.String serviceMode;
            private final java.lang.String startByte;
            private final java.lang.String bitMaskLength;
            private final java.lang.String bitRightShift;
            private final java.lang.Object isSigned;
            private final java.lang.String signalValueType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.byteLength = software.amazon.jsii.Kernel.get(this, "byteLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pidResponseLength = software.amazon.jsii.Kernel.get(this, "pidResponseLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scaling = software.amazon.jsii.Kernel.get(this, "scaling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceMode = software.amazon.jsii.Kernel.get(this, "serviceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startByte = software.amazon.jsii.Kernel.get(this, "startByte", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitMaskLength = software.amazon.jsii.Kernel.get(this, "bitMaskLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitRightShift = software.amazon.jsii.Kernel.get(this, "bitRightShift", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isSigned = software.amazon.jsii.Kernel.get(this, "isSigned", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.signalValueType = software.amazon.jsii.Kernel.get(this, "signalValueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.byteLength = java.util.Objects.requireNonNull(builder.byteLength, "byteLength is required");
                this.offset = java.util.Objects.requireNonNull(builder.offset, "offset is required");
                this.pid = java.util.Objects.requireNonNull(builder.pid, "pid is required");
                this.pidResponseLength = java.util.Objects.requireNonNull(builder.pidResponseLength, "pidResponseLength is required");
                this.scaling = java.util.Objects.requireNonNull(builder.scaling, "scaling is required");
                this.serviceMode = java.util.Objects.requireNonNull(builder.serviceMode, "serviceMode is required");
                this.startByte = java.util.Objects.requireNonNull(builder.startByte, "startByte is required");
                this.bitMaskLength = builder.bitMaskLength;
                this.bitRightShift = builder.bitRightShift;
                this.isSigned = builder.isSigned;
                this.signalValueType = builder.signalValueType;
            }

            @Override
            public final java.lang.String getByteLength() {
                return this.byteLength;
            }

            @Override
            public final java.lang.String getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.String getPid() {
                return this.pid;
            }

            @Override
            public final java.lang.String getPidResponseLength() {
                return this.pidResponseLength;
            }

            @Override
            public final java.lang.String getScaling() {
                return this.scaling;
            }

            @Override
            public final java.lang.String getServiceMode() {
                return this.serviceMode;
            }

            @Override
            public final java.lang.String getStartByte() {
                return this.startByte;
            }

            @Override
            public final java.lang.String getBitMaskLength() {
                return this.bitMaskLength;
            }

            @Override
            public final java.lang.String getBitRightShift() {
                return this.bitRightShift;
            }

            @Override
            public final java.lang.Object getIsSigned() {
                return this.isSigned;
            }

            @Override
            public final java.lang.String getSignalValueType() {
                return this.signalValueType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("byteLength", om.valueToTree(this.getByteLength()));
                data.set("offset", om.valueToTree(this.getOffset()));
                data.set("pid", om.valueToTree(this.getPid()));
                data.set("pidResponseLength", om.valueToTree(this.getPidResponseLength()));
                data.set("scaling", om.valueToTree(this.getScaling()));
                data.set("serviceMode", om.valueToTree(this.getServiceMode()));
                data.set("startByte", om.valueToTree(this.getStartByte()));
                if (this.getBitMaskLength() != null) {
                    data.set("bitMaskLength", om.valueToTree(this.getBitMaskLength()));
                }
                if (this.getBitRightShift() != null) {
                    data.set("bitRightShift", om.valueToTree(this.getBitRightShift()));
                }
                if (this.getIsSigned() != null) {
                    data.set("isSigned", om.valueToTree(this.getIsSigned()));
                }
                if (this.getSignalValueType() != null) {
                    data.set("signalValueType", om.valueToTree(this.getSignalValueType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdSignalProperty.Jsii$Proxy that = (ObdSignalProperty.Jsii$Proxy) o;

                if (!byteLength.equals(that.byteLength)) return false;
                if (!offset.equals(that.offset)) return false;
                if (!pid.equals(that.pid)) return false;
                if (!pidResponseLength.equals(that.pidResponseLength)) return false;
                if (!scaling.equals(that.scaling)) return false;
                if (!serviceMode.equals(that.serviceMode)) return false;
                if (!startByte.equals(that.startByte)) return false;
                if (this.bitMaskLength != null ? !this.bitMaskLength.equals(that.bitMaskLength) : that.bitMaskLength != null) return false;
                if (this.bitRightShift != null ? !this.bitRightShift.equals(that.bitRightShift) : that.bitRightShift != null) return false;
                if (this.isSigned != null ? !this.isSigned.equals(that.isSigned) : that.isSigned != null) return false;
                return this.signalValueType != null ? this.signalValueType.equals(that.signalValueType) : that.signalValueType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.byteLength.hashCode();
                result = 31 * result + (this.offset.hashCode());
                result = 31 * result + (this.pid.hashCode());
                result = 31 * result + (this.pidResponseLength.hashCode());
                result = 31 * result + (this.scaling.hashCode());
                result = 31 * result + (this.serviceMode.hashCode());
                result = 31 * result + (this.startByte.hashCode());
                result = 31 * result + (this.bitMaskLength != null ? this.bitMaskLength.hashCode() : 0);
                result = 31 * result + (this.bitRightShift != null ? this.bitRightShift.hashCode() : 0);
                result = 31 * result + (this.isSigned != null ? this.isSigned.hashCode() : 0);
                result = 31 * result + (this.signalValueType != null ? this.signalValueType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a signal decoder.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * SignalDecodersItemsProperty signalDecodersItemsProperty = SignalDecodersItemsProperty.builder()
     *         .fullyQualifiedName("fullyQualifiedName")
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         // the properties below are optional
     *         .canSignal(CanSignalProperty.builder()
     *                 .factor("factor")
     *                 .isBigEndian("isBigEndian")
     *                 .isSigned("isSigned")
     *                 .length("length")
     *                 .messageId("messageId")
     *                 .offset("offset")
     *                 .startBit("startBit")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .signalValueType("signalValueType")
     *                 .build())
     *         .obdSignal(ObdSignalProperty.builder()
     *                 .byteLength("byteLength")
     *                 .offset("offset")
     *                 .pid("pid")
     *                 .pidResponseLength("pidResponseLength")
     *                 .scaling("scaling")
     *                 .serviceMode("serviceMode")
     *                 .startByte("startByte")
     *                 // the properties below are optional
     *                 .bitMaskLength("bitMaskLength")
     *                 .bitRightShift("bitRightShift")
     *                 .isSigned("isSigned")
     *                 .signalValueType("signalValueType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty")
    @software.amazon.jsii.Jsii.Proxy(SignalDecodersItemsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SignalDecodersItemsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-interfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-interfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-cansignal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-cansignal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanSignal() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-obdsignal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-signaldecodersitems.html#cfn-iotfleetwise-decodermanifest-signaldecodersitems-obdsignal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getObdSignal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SignalDecodersItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SignalDecodersItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SignalDecodersItemsProperty> {
            java.lang.String fullyQualifiedName;
            java.lang.String interfaceId;
            java.lang.String type;
            java.lang.Object canSignal;
            java.lang.Object obdSignal;

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getFullyQualifiedName}
             * @param fullyQualifiedName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getInterfaceId}
             * @param interfaceId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getType}
             * @param type the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getCanSignal}
             * @param canSignal the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.IResolvable canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getCanSignal}
             * @param canSignal the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanSignalProperty canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getObdSignal}
             * @param obdSignal the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.IResolvable obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getObdSignal}
             * @param obdSignal the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdSignalProperty obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SignalDecodersItemsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SignalDecodersItemsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SignalDecodersItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalDecodersItemsProperty {
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String interfaceId;
            private final java.lang.String type;
            private final java.lang.Object canSignal;
            private final java.lang.Object obdSignal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.canSignal = software.amazon.jsii.Kernel.get(this, "canSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obdSignal = software.amazon.jsii.Kernel.get(this, "obdSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.canSignal = builder.canSignal;
                this.obdSignal = builder.obdSignal;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getCanSignal() {
                return this.canSignal;
            }

            @Override
            public final java.lang.Object getObdSignal() {
                return this.obdSignal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCanSignal() != null) {
                    data.set("canSignal", om.valueToTree(this.getCanSignal()));
                }
                if (this.getObdSignal() != null) {
                    data.set("obdSignal", om.valueToTree(this.getObdSignal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SignalDecodersItemsProperty.Jsii$Proxy that = (SignalDecodersItemsProperty.Jsii$Proxy) o;

                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!type.equals(that.type)) return false;
                if (this.canSignal != null ? !this.canSignal.equals(that.canSignal) : that.canSignal != null) return false;
                return this.obdSignal != null ? this.obdSignal.equals(that.obdSignal) : that.obdSignal == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fullyQualifiedName.hashCode();
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.canSignal != null ? this.canSignal.hashCode() : 0);
                result = 31 * result + (this.obdSignal != null ? this.obdSignal.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-modelmanifestarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-modelmanifestarn</a>
         * @param modelManifestArn The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(final java.lang.String modelManifestArn) {
            this.props.modelManifestArn(modelManifestArn);
            return this;
        }

        /**
         * The name of the decoder manifest.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-name</a>
         * @param name The name of the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Use default decoders for all unmapped signals in the model.
         * <p>
         * You don't need to provide any detailed decoding information.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-defaultforunmappedsignals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-defaultforunmappedsignals</a>
         * @param defaultForUnmappedSignals Use default decoders for all unmapped signals in the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultForUnmappedSignals(final java.lang.String defaultForUnmappedSignals) {
            this.props.defaultForUnmappedSignals(defaultForUnmappedSignals);
            return this;
        }

        /**
         * A brief description of the decoder manifest.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-description</a>
         * @param description A brief description of the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A list of information about available network interfaces.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces</a>
         * @param networkInterfaces A list of information about available network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final software.amazon.awscdk.IResolvable networkInterfaces) {
            this.props.networkInterfaces(networkInterfaces);
            return this;
        }
        /**
         * A list of information about available network interfaces.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces</a>
         * @param networkInterfaces A list of information about available network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final java.util.List<? extends java.lang.Object> networkInterfaces) {
            this.props.networkInterfaces(networkInterfaces);
            return this;
        }

        /**
         * A list of information about signal decoders.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders</a>
         * @param signalDecoders A list of information about signal decoders. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(final software.amazon.awscdk.IResolvable signalDecoders) {
            this.props.signalDecoders(signalDecoders);
            return this;
        }
        /**
         * A list of information about signal decoders.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders</a>
         * @param signalDecoders A list of information about signal decoders. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(final java.util.List<? extends java.lang.Object> signalDecoders) {
            this.props.signalDecoders(signalDecoders);
            return this;
        }

        /**
         * The state of the decoder manifest.
         * <p>
         * If the status is <code>ACTIVE</code> , the decoder manifest can't be edited. If the status is marked <code>DRAFT</code> , you can edit the decoder manifest.
         * <p>
         * Default: - "DRAFT"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-status</a>
         * @param status The state of the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * Metadata that can be used to manage the decoder manifest.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-tags</a>
         * @param tags Metadata that can be used to manage the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
