package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a <code>CfnNetworkAnalyzerConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * Object traceContent;
 * CfnNetworkAnalyzerConfigurationProps cfnNetworkAnalyzerConfigurationProps = CfnNetworkAnalyzerConfigurationProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .traceContent(traceContent)
 *         .wirelessDevices(List.of("wirelessDevices"))
 *         .wirelessGateways(List.of("wirelessGateways"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.358Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnNetworkAnalyzerConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkAnalyzerConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkAnalyzerConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the network analyzer configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description of the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The tags to attach to the specified resource.
     * <p>
     * Tags are metadata that you can use to manage a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Trace content for your wireless gateway and wireless device resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-tracecontent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-tracecontent</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTraceContent() {
        return null;
    }

    /**
     * Wireless device resources to add to the network analyzer configuration.
     * <p>
     * Provide the <code>WirelessDeviceId</code> of the resource to add in the input array.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-wirelessdevices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-wirelessdevices</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWirelessDevices() {
        return null;
    }

    /**
     * Wireless gateway resources to add to the network analyzer configuration.
     * <p>
     * Provide the <code>WirelessGatewayId</code> of the resource to add in the input array.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-wirelessgateways">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-networkanalyzerconfiguration.html#cfn-iotwireless-networkanalyzerconfiguration-wirelessgateways</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWirelessGateways() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkAnalyzerConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkAnalyzerConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkAnalyzerConfigurationProps> {
        java.lang.String name;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object traceContent;
        java.util.List<java.lang.String> wirelessDevices;
        java.util.List<java.lang.String> wirelessGateways;

        /**
         * Sets the value of {@link CfnNetworkAnalyzerConfigurationProps#getName}
         * @param name Name of the network analyzer configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkAnalyzerConfigurationProps#getDescription}
         * @param description The description of the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkAnalyzerConfigurationProps#getTags}
         * @param tags The tags to attach to the specified resource.
         *             Tags are metadata that you can use to manage a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkAnalyzerConfigurationProps#getTraceContent}
         * @param traceContent Trace content for your wireless gateway and wireless device resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder traceContent(java.lang.Object traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkAnalyzerConfigurationProps#getWirelessDevices}
         * @param wirelessDevices Wireless device resources to add to the network analyzer configuration.
         *                        Provide the <code>WirelessDeviceId</code> of the resource to add in the input array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wirelessDevices(java.util.List<java.lang.String> wirelessDevices) {
            this.wirelessDevices = wirelessDevices;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkAnalyzerConfigurationProps#getWirelessGateways}
         * @param wirelessGateways Wireless gateway resources to add to the network analyzer configuration.
         *                         Provide the <code>WirelessGatewayId</code> of the resource to add in the input array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wirelessGateways(java.util.List<java.lang.String> wirelessGateways) {
            this.wirelessGateways = wirelessGateways;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkAnalyzerConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkAnalyzerConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkAnalyzerConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkAnalyzerConfigurationProps {
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object traceContent;
        private final java.util.List<java.lang.String> wirelessDevices;
        private final java.util.List<java.lang.String> wirelessGateways;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.traceContent = software.amazon.jsii.Kernel.get(this, "traceContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.wirelessDevices = software.amazon.jsii.Kernel.get(this, "wirelessDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.wirelessGateways = software.amazon.jsii.Kernel.get(this, "wirelessGateways", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.traceContent = builder.traceContent;
            this.wirelessDevices = builder.wirelessDevices;
            this.wirelessGateways = builder.wirelessGateways;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTraceContent() {
            return this.traceContent;
        }

        @Override
        public final java.util.List<java.lang.String> getWirelessDevices() {
            return this.wirelessDevices;
        }

        @Override
        public final java.util.List<java.lang.String> getWirelessGateways() {
            return this.wirelessGateways;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTraceContent() != null) {
                data.set("traceContent", om.valueToTree(this.getTraceContent()));
            }
            if (this.getWirelessDevices() != null) {
                data.set("wirelessDevices", om.valueToTree(this.getWirelessDevices()));
            }
            if (this.getWirelessGateways() != null) {
                data.set("wirelessGateways", om.valueToTree(this.getWirelessGateways()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnNetworkAnalyzerConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkAnalyzerConfigurationProps.Jsii$Proxy that = (CfnNetworkAnalyzerConfigurationProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.traceContent != null ? !this.traceContent.equals(that.traceContent) : that.traceContent != null) return false;
            if (this.wirelessDevices != null ? !this.wirelessDevices.equals(that.wirelessDevices) : that.wirelessDevices != null) return false;
            return this.wirelessGateways != null ? this.wirelessGateways.equals(that.wirelessGateways) : that.wirelessGateways == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.traceContent != null ? this.traceContent.hashCode() : 0);
            result = 31 * result + (this.wirelessDevices != null ? this.wirelessDevices.hashCode() : 0);
            result = 31 * result + (this.wirelessGateways != null ? this.wirelessGateways.hashCode() : 0);
            return result;
        }
    }
}
