package software.amazon.awscdk.services.ivs;

/**
 * Properties for defining a <code>CfnIngestConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivs.*;
 * CfnIngestConfigurationProps cfnIngestConfigurationProps = CfnIngestConfigurationProps.builder()
 *         .ingestProtocol("ingestProtocol")
 *         .insecureIngest(false)
 *         .name("name")
 *         .stageArn("stageArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userId("userId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnIngestConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIngestConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIngestConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of ingest protocol that the user employs for broadcasting.
     * <p>
     * Default: - "RTMPS"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-ingestprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-ingestprotocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIngestProtocol() {
        return null;
    }

    /**
     * Whether the channel allows insecure RTMP ingest.
     * <p>
     * Default: <code>false</code> .
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-insecureingest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-insecureingest</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInsecureIngest() {
        return null;
    }

    /**
     * Ingest name.
     * <p>
     * Default: - "-"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * ARN of the stage with which the IngestConfiguration is associated.
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-stagearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-stagearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageArn() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Customer-assigned name to help identify the participant using the IngestConfiguration;
     * <p>
     * this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <em>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-userid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-ingestconfiguration.html#cfn-ivs-ingestconfiguration-userid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIngestConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIngestConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIngestConfigurationProps> {
        java.lang.String ingestProtocol;
        java.lang.Object insecureIngest;
        java.lang.String name;
        java.lang.String stageArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String userId;

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getIngestProtocol}
         * @param ingestProtocol Type of ingest protocol that the user employs for broadcasting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestProtocol(java.lang.String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getInsecureIngest}
         * @param insecureIngest Whether the channel allows insecure RTMP ingest.
         *                       Default: <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureIngest(java.lang.Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getInsecureIngest}
         * @param insecureIngest Whether the channel allows insecure RTMP ingest.
         *                       Default: <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureIngest(software.amazon.awscdk.IResolvable insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getName}
         * @param name Ingest name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getStageArn}
         * @param stageArn ARN of the stage with which the IngestConfiguration is associated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageArn(java.lang.String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIngestConfigurationProps#getUserId}
         * @param userId Customer-assigned name to help identify the participant using the IngestConfiguration;.
         *               this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <em>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userId(java.lang.String userId) {
            this.userId = userId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIngestConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIngestConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIngestConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIngestConfigurationProps {
        private final java.lang.String ingestProtocol;
        private final java.lang.Object insecureIngest;
        private final java.lang.String name;
        private final java.lang.String stageArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String userId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ingestProtocol = software.amazon.jsii.Kernel.get(this, "ingestProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insecureIngest = software.amazon.jsii.Kernel.get(this, "insecureIngest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stageArn = software.amazon.jsii.Kernel.get(this, "stageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userId = software.amazon.jsii.Kernel.get(this, "userId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ingestProtocol = builder.ingestProtocol;
            this.insecureIngest = builder.insecureIngest;
            this.name = builder.name;
            this.stageArn = builder.stageArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userId = builder.userId;
        }

        @Override
        public final java.lang.String getIngestProtocol() {
            return this.ingestProtocol;
        }

        @Override
        public final java.lang.Object getInsecureIngest() {
            return this.insecureIngest;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStageArn() {
            return this.stageArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUserId() {
            return this.userId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIngestProtocol() != null) {
                data.set("ingestProtocol", om.valueToTree(this.getIngestProtocol()));
            }
            if (this.getInsecureIngest() != null) {
                data.set("insecureIngest", om.valueToTree(this.getInsecureIngest()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getStageArn() != null) {
                data.set("stageArn", om.valueToTree(this.getStageArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserId() != null) {
                data.set("userId", om.valueToTree(this.getUserId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnIngestConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIngestConfigurationProps.Jsii$Proxy that = (CfnIngestConfigurationProps.Jsii$Proxy) o;

            if (this.ingestProtocol != null ? !this.ingestProtocol.equals(that.ingestProtocol) : that.ingestProtocol != null) return false;
            if (this.insecureIngest != null ? !this.insecureIngest.equals(that.insecureIngest) : that.insecureIngest != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.stageArn != null ? !this.stageArn.equals(that.stageArn) : that.stageArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.userId != null ? this.userId.equals(that.userId) : that.userId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ingestProtocol != null ? this.ingestProtocol.hashCode() : 0;
            result = 31 * result + (this.insecureIngest != null ? this.insecureIngest.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.stageArn != null ? this.stageArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
            return result;
        }
    }
}
