package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Properties for defining an S3 backup destination.
 * <p>
 * S3 backup is available for all destinations, regardless of whether the final destination is S3 or not.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Enable backup of all source records (to an S3 bucket created by CDK).
 * Bucket bucket;
 * // Explicitly provide an S3 bucket to which all source records will be backed up.
 * Bucket backupBucket;
 * DeliveryStream.Builder.create(this, "Delivery Stream Backup All")
 *         .destination(
 *         S3Bucket.Builder.create(bucket)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .build())
 *                 .build())
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream Backup All Explicit Bucket")
 *         .destination(
 *         S3Bucket.Builder.create(bucket)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .bucket(backupBucket)
 *                         .build())
 *                 .build())
 *         .build();
 * // Explicitly provide an S3 prefix under which all source records will be backed up.
 * // Explicitly provide an S3 prefix under which all source records will be backed up.
 * DeliveryStream.Builder.create(this, "Delivery Stream Backup All Explicit Prefix")
 *         .destination(
 *         S3Bucket.Builder.create(bucket)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .dataOutputPrefix("mybackup")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:20.735Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DestinationS3BackupProps")
@software.amazon.jsii.Jsii.Proxy(DestinationS3BackupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DestinationS3BackupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.kinesisfirehose.CommonDestinationS3Props {

    /**
     * The S3 bucket that will store data and failed records.
     * <p>
     * Default: - If `mode` is set to `BackupMode.ALL` or `BackupMode.FAILED`, a bucket will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return null;
    }

    /**
     * Configuration that determines whether to log errors during data transformation or delivery failures, and specifies the CloudWatch log group for storing error logs.
     * <p>
     * Default: - errors will be logged and a log group will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig getLoggingConfig() {
        return null;
    }

    /**
     * Indicates the mode by which incoming records should be backed up to S3, if any.
     * <p>
     * If <code>bucket</code> is provided, this will be implicitly set to <code>BackupMode.ALL</code>.
     * <p>
     * Default: - If `bucket` is provided, the default will be `BackupMode.ALL`. Otherwise,
     * source records are not backed up to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.BackupMode getMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DestinationS3BackupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DestinationS3BackupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DestinationS3BackupProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig;
        software.amazon.awscdk.services.kinesisfirehose.BackupMode mode;
        software.amazon.awscdk.Duration bufferingInterval;
        software.amazon.awscdk.Size bufferingSize;
        software.amazon.awscdk.services.kinesisfirehose.Compression compression;
        java.lang.String dataOutputPrefix;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String errorOutputPrefix;

        /**
         * Sets the value of {@link DestinationS3BackupProps#getBucket}
         * @param bucket The S3 bucket that will store data and failed records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getLoggingConfig}
         * @param loggingConfig Configuration that determines whether to log errors during data transformation or delivery failures, and specifies the CloudWatch log group for storing error logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getMode}
         * @param mode Indicates the mode by which incoming records should be backed up to S3, if any.
         *             If <code>bucket</code> is provided, this will be implicitly set to <code>BackupMode.ALL</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(software.amazon.awscdk.services.kinesisfirehose.BackupMode mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getBufferingInterval}
         * @param bufferingInterval The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
         *                          Minimum: Duration.seconds(0)
         *                          Maximum: Duration.seconds(900)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingInterval(software.amazon.awscdk.Duration bufferingInterval) {
            this.bufferingInterval = bufferingInterval;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getBufferingSize}
         * @param bufferingSize The size of the buffer that Amazon Data Firehose uses for incoming data before delivering it to the S3 bucket.
         *                      Minimum: Size.mebibytes(1)
         *                      Maximum: Size.mebibytes(128)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingSize(software.amazon.awscdk.Size bufferingSize) {
            this.bufferingSize = bufferingSize;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getCompression}
         * @param compression The type of compression that Amazon Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         *                    The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
         *                    destinations because they are not supported by the Amazon Redshift COPY operation
         *                    that reads from the S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(software.amazon.awscdk.services.kinesisfirehose.Compression compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getDataOutputPrefix}
         * @param dataOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to records before writing them to S3.
         *                         This prefix appears immediately following the bucket name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataOutputPrefix(java.lang.String dataOutputPrefix) {
            this.dataOutputPrefix = dataOutputPrefix;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getEncryptionKey}
         * @param encryptionKey The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DestinationS3BackupProps#getErrorOutputPrefix}
         * @param errorOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to failed records before writing them to S3.
         *                          This prefix appears immediately following the bucket name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DestinationS3BackupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DestinationS3BackupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DestinationS3BackupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationS3BackupProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig;
        private final software.amazon.awscdk.services.kinesisfirehose.BackupMode mode;
        private final software.amazon.awscdk.Duration bufferingInterval;
        private final software.amazon.awscdk.Size bufferingSize;
        private final software.amazon.awscdk.services.kinesisfirehose.Compression compression;
        private final java.lang.String dataOutputPrefix;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String errorOutputPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.loggingConfig = software.amazon.jsii.Kernel.get(this, "loggingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.BackupMode.class));
            this.bufferingInterval = software.amazon.jsii.Kernel.get(this, "bufferingInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.bufferingSize = software.amazon.jsii.Kernel.get(this, "bufferingSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
            this.dataOutputPrefix = software.amazon.jsii.Kernel.get(this, "dataOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = builder.bucket;
            this.loggingConfig = builder.loggingConfig;
            this.mode = builder.mode;
            this.bufferingInterval = builder.bufferingInterval;
            this.bufferingSize = builder.bufferingSize;
            this.compression = builder.compression;
            this.dataOutputPrefix = builder.dataOutputPrefix;
            this.encryptionKey = builder.encryptionKey;
            this.errorOutputPrefix = builder.errorOutputPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig getLoggingConfig() {
            return this.loggingConfig;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.BackupMode getMode() {
            return this.mode;
        }

        @Override
        public final software.amazon.awscdk.Duration getBufferingInterval() {
            return this.bufferingInterval;
        }

        @Override
        public final software.amazon.awscdk.Size getBufferingSize() {
            return this.bufferingSize;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.Compression getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.String getDataOutputPrefix() {
            return this.dataOutputPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getErrorOutputPrefix() {
            return this.errorOutputPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getLoggingConfig() != null) {
                data.set("loggingConfig", om.valueToTree(this.getLoggingConfig()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getBufferingInterval() != null) {
                data.set("bufferingInterval", om.valueToTree(this.getBufferingInterval()));
            }
            if (this.getBufferingSize() != null) {
                data.set("bufferingSize", om.valueToTree(this.getBufferingSize()));
            }
            if (this.getCompression() != null) {
                data.set("compression", om.valueToTree(this.getCompression()));
            }
            if (this.getDataOutputPrefix() != null) {
                data.set("dataOutputPrefix", om.valueToTree(this.getDataOutputPrefix()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getErrorOutputPrefix() != null) {
                data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DestinationS3BackupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DestinationS3BackupProps.Jsii$Proxy that = (DestinationS3BackupProps.Jsii$Proxy) o;

            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.loggingConfig != null ? !this.loggingConfig.equals(that.loggingConfig) : that.loggingConfig != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.bufferingInterval != null ? !this.bufferingInterval.equals(that.bufferingInterval) : that.bufferingInterval != null) return false;
            if (this.bufferingSize != null ? !this.bufferingSize.equals(that.bufferingSize) : that.bufferingSize != null) return false;
            if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
            if (this.dataOutputPrefix != null ? !this.dataOutputPrefix.equals(that.dataOutputPrefix) : that.dataOutputPrefix != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            return this.errorOutputPrefix != null ? this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket != null ? this.bucket.hashCode() : 0;
            result = 31 * result + (this.loggingConfig != null ? this.loggingConfig.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.bufferingInterval != null ? this.bufferingInterval.hashCode() : 0);
            result = 31 * result + (this.bufferingSize != null ? this.bufferingSize.hashCode() : 0);
            result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
            result = 31 * result + (this.dataOutputPrefix != null ? this.dataOutputPrefix.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
            return result;
        }
    }
}
