package software.amazon.awscdk.services.logs;

/**
 * Construction properties for a LogRetention.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * Role role;
 * LogRetentionProps logRetentionProps = LogRetentionProps.builder()
 *         .logGroupName("logGroupName")
 *         .retention(RetentionDays.ONE_DAY)
 *         // the properties below are optional
 *         .logGroupRegion("logGroupRegion")
 *         .logRetentionRetryOptions(LogRetentionRetryOptions.builder()
 *                 .base(Duration.minutes(30))
 *                 .maxRetries(123)
 *                 .build())
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:21.369Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogRetentionProps")
@software.amazon.jsii.Jsii.Proxy(LogRetentionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogRetentionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

    /**
     * The number of days log events are kept in CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.RetentionDays getRetention();

    /**
     * The region where the log group should be created.
     * <p>
     * Default: - same region as the stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupRegion() {
        return null;
    }

    /**
     * Retry options for all AWS API calls.
     * <p>
     * Default: - AWS SDK default retry options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogRetentionRetryOptions getLogRetentionRetryOptions() {
        return null;
    }

    /**
     * The removalPolicy for the log group when the stack is deleted.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource.
     * <p>
     * Default: - A new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogRetentionProps> {
        java.lang.String logGroupName;
        software.amazon.awscdk.services.logs.RetentionDays retention;
        java.lang.String logGroupRegion;
        software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link LogRetentionProps#getLogGroupName}
         * @param logGroupName The log group name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link LogRetentionProps#getRetention}
         * @param retention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Sets the value of {@link LogRetentionProps#getLogGroupRegion}
         * @param logGroupRegion The region where the log group should be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupRegion(java.lang.String logGroupRegion) {
            this.logGroupRegion = logGroupRegion;
            return this;
        }

        /**
         * Sets the value of {@link LogRetentionProps#getLogRetentionRetryOptions}
         * @param logRetentionRetryOptions Retry options for all AWS API calls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.logRetentionRetryOptions = logRetentionRetryOptions;
            return this;
        }

        /**
         * Sets the value of {@link LogRetentionProps#getRemovalPolicy}
         * @param removalPolicy The removalPolicy for the log group when the stack is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LogRetentionProps#getRole}
         * @param role The IAM role for the Lambda function associated with the custom resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogRetentionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogRetentionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogRetentionProps {
        private final java.lang.String logGroupName;
        private final software.amazon.awscdk.services.logs.RetentionDays retention;
        private final java.lang.String logGroupRegion;
        private final software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.logGroupRegion = software.amazon.jsii.Kernel.get(this, "logGroupRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logRetentionRetryOptions = software.amazon.jsii.Kernel.get(this, "logRetentionRetryOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogRetentionRetryOptions.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            this.retention = java.util.Objects.requireNonNull(builder.retention, "retention is required");
            this.logGroupRegion = builder.logGroupRegion;
            this.logRetentionRetryOptions = builder.logRetentionRetryOptions;
            this.removalPolicy = builder.removalPolicy;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.retention;
        }

        @Override
        public final java.lang.String getLogGroupRegion() {
            return this.logGroupRegion;
        }

        @Override
        public final software.amazon.awscdk.services.logs.LogRetentionRetryOptions getLogRetentionRetryOptions() {
            return this.logRetentionRetryOptions;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            data.set("retention", om.valueToTree(this.getRetention()));
            if (this.getLogGroupRegion() != null) {
                data.set("logGroupRegion", om.valueToTree(this.getLogGroupRegion()));
            }
            if (this.getLogRetentionRetryOptions() != null) {
                data.set("logRetentionRetryOptions", om.valueToTree(this.getLogRetentionRetryOptions()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.LogRetentionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogRetentionProps.Jsii$Proxy that = (LogRetentionProps.Jsii$Proxy) o;

            if (!logGroupName.equals(that.logGroupName)) return false;
            if (!retention.equals(that.retention)) return false;
            if (this.logGroupRegion != null ? !this.logGroupRegion.equals(that.logGroupRegion) : that.logGroupRegion != null) return false;
            if (this.logRetentionRetryOptions != null ? !this.logRetentionRetryOptions.equals(that.logRetentionRetryOptions) : that.logRetentionRetryOptions != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logGroupName.hashCode();
            result = 31 * result + (this.retention.hashCode());
            result = 31 * result + (this.logGroupRegion != null ? this.logGroupRegion.hashCode() : 0);
            result = 31 * result + (this.logRetentionRetryOptions != null ? this.logRetentionRetryOptions.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
