package software.amazon.awscdk.services.medialive;

/**
 * Properties for defining a <code>CfnChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:21.669Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-anywheresettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-anywheresettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAnywhereSettings() {
        return null;
    }

    /**
     * Specification of CDI inputs for this channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCdiInputSpecification() {
        return null;
    }

    /**
     * The class for this channel.
     * <p>
     * For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChannelClass() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelengineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChannelEngineVersion() {
        return null;
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-dryrun">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-dryrun</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDryRun() {
        return null;
    }

    /**
     * The encoding configuration for the output content.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncoderSettings() {
        return null;
    }

    /**
     * The list of input attachments for the channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputAttachments() {
        return null;
    }

    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputSpecification() {
        return null;
    }

    /**
     * The verbosity for logging activity for this channel.
     * <p>
     * Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
        return null;
    }

    /**
     * Maintenance settings for this channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-maintenance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-maintenance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenance() {
        return null;
    }

    /**
     * A name for this audio selector.
     * <p>
     * The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The IAM role for MediaLive to assume when running this channel.
     * <p>
     * The role is identified by its ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * A collection of tags for this channel.
     * <p>
     * Each tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-vpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-vpc</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.Object anywhereSettings;
        java.lang.Object cdiInputSpecification;
        java.lang.String channelClass;
        java.lang.Object channelEngineVersion;
        java.lang.Object destinations;
        java.lang.Object dryRun;
        java.lang.Object encoderSettings;
        java.lang.Object inputAttachments;
        java.lang.Object inputSpecification;
        java.lang.String logLevel;
        java.lang.Object maintenance;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.Object tags;
        java.lang.Object vpc;

        /**
         * Sets the value of {@link CfnChannelProps#getAnywhereSettings}
         * @param anywhereSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anywhereSettings(software.amazon.awscdk.IResolvable anywhereSettings) {
            this.anywhereSettings = anywhereSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getAnywhereSettings}
         * @param anywhereSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anywhereSettings(software.amazon.awscdk.services.medialive.CfnChannel.AnywhereSettingsProperty anywhereSettings) {
            this.anywhereSettings = anywhereSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getCdiInputSpecification}
         * @param cdiInputSpecification Specification of CDI inputs for this channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdiInputSpecification(software.amazon.awscdk.IResolvable cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getCdiInputSpecification}
         * @param cdiInputSpecification Specification of CDI inputs for this channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdiInputSpecification(software.amazon.awscdk.services.medialive.CfnChannel.CdiInputSpecificationProperty cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getChannelClass}
         * @param channelClass The class for this channel.
         *                     For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelClass(java.lang.String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getChannelEngineVersion}
         * @param channelEngineVersion the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelEngineVersion(software.amazon.awscdk.IResolvable channelEngineVersion) {
            this.channelEngineVersion = channelEngineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getChannelEngineVersion}
         * @param channelEngineVersion the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelEngineVersion(software.amazon.awscdk.services.medialive.CfnChannel.ChannelEngineVersionRequestProperty channelEngineVersion) {
            this.channelEngineVersion = channelEngineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDestinations}
         * @param destinations The settings that identify the destination for the outputs in this MediaLive output package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDestinations}
         * @param destinations The settings that identify the destination for the outputs in this MediaLive output package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDryRun}
         * @param dryRun the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dryRun(java.lang.Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDryRun}
         * @param dryRun the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dryRun(software.amazon.awscdk.IResolvable dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getEncoderSettings}
         * @param encoderSettings The encoding configuration for the output content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encoderSettings(software.amazon.awscdk.IResolvable encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getEncoderSettings}
         * @param encoderSettings The encoding configuration for the output content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encoderSettings(software.amazon.awscdk.services.medialive.CfnChannel.EncoderSettingsProperty encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputAttachments}
         * @param inputAttachments The list of input attachments for the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputAttachments(software.amazon.awscdk.IResolvable inputAttachments) {
            this.inputAttachments = inputAttachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputAttachments}
         * @param inputAttachments The list of input attachments for the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputAttachments(java.util.List<? extends java.lang.Object> inputAttachments) {
            this.inputAttachments = inputAttachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputSpecification}
         * @param inputSpecification The input specification for this channel.
         *                           It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSpecification(software.amazon.awscdk.IResolvable inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputSpecification}
         * @param inputSpecification The input specification for this channel.
         *                           It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSpecification(software.amazon.awscdk.services.medialive.CfnChannel.InputSpecificationProperty inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLogLevel}
         * @param logLevel The verbosity for logging activity for this channel.
         *                 Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logLevel(java.lang.String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getMaintenance}
         * @param maintenance Maintenance settings for this channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenance(software.amazon.awscdk.IResolvable maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getMaintenance}
         * @param maintenance Maintenance settings for this channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenance(software.amazon.awscdk.services.medialive.CfnChannel.MaintenanceCreateSettingsProperty maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getName}
         * @param name A name for this audio selector.
         *             The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRoleArn}
         * @param roleArn The IAM role for MediaLive to assume when running this channel.
         *                The role is identified by its ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags A collection of tags for this channel.
         *             Each tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getVpc}
         * @param vpc Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.IResolvable vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getVpc}
         * @param vpc Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.medialive.CfnChannel.VpcOutputSettingsProperty vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.Object anywhereSettings;
        private final java.lang.Object cdiInputSpecification;
        private final java.lang.String channelClass;
        private final java.lang.Object channelEngineVersion;
        private final java.lang.Object destinations;
        private final java.lang.Object dryRun;
        private final java.lang.Object encoderSettings;
        private final java.lang.Object inputAttachments;
        private final java.lang.Object inputSpecification;
        private final java.lang.String logLevel;
        private final java.lang.Object maintenance;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.Object tags;
        private final java.lang.Object vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.anywhereSettings = software.amazon.jsii.Kernel.get(this, "anywhereSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cdiInputSpecification = software.amazon.jsii.Kernel.get(this, "cdiInputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.channelClass = software.amazon.jsii.Kernel.get(this, "channelClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelEngineVersion = software.amazon.jsii.Kernel.get(this, "channelEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dryRun = software.amazon.jsii.Kernel.get(this, "dryRun", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encoderSettings = software.amazon.jsii.Kernel.get(this, "encoderSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputAttachments = software.amazon.jsii.Kernel.get(this, "inputAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputSpecification = software.amazon.jsii.Kernel.get(this, "inputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenance = software.amazon.jsii.Kernel.get(this, "maintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.anywhereSettings = builder.anywhereSettings;
            this.cdiInputSpecification = builder.cdiInputSpecification;
            this.channelClass = builder.channelClass;
            this.channelEngineVersion = builder.channelEngineVersion;
            this.destinations = builder.destinations;
            this.dryRun = builder.dryRun;
            this.encoderSettings = builder.encoderSettings;
            this.inputAttachments = builder.inputAttachments;
            this.inputSpecification = builder.inputSpecification;
            this.logLevel = builder.logLevel;
            this.maintenance = builder.maintenance;
            this.name = builder.name;
            this.roleArn = builder.roleArn;
            this.tags = builder.tags;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.Object getAnywhereSettings() {
            return this.anywhereSettings;
        }

        @Override
        public final java.lang.Object getCdiInputSpecification() {
            return this.cdiInputSpecification;
        }

        @Override
        public final java.lang.String getChannelClass() {
            return this.channelClass;
        }

        @Override
        public final java.lang.Object getChannelEngineVersion() {
            return this.channelEngineVersion;
        }

        @Override
        public final java.lang.Object getDestinations() {
            return this.destinations;
        }

        @Override
        public final java.lang.Object getDryRun() {
            return this.dryRun;
        }

        @Override
        public final java.lang.Object getEncoderSettings() {
            return this.encoderSettings;
        }

        @Override
        public final java.lang.Object getInputAttachments() {
            return this.inputAttachments;
        }

        @Override
        public final java.lang.Object getInputSpecification() {
            return this.inputSpecification;
        }

        @Override
        public final java.lang.String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final java.lang.Object getMaintenance() {
            return this.maintenance;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAnywhereSettings() != null) {
                data.set("anywhereSettings", om.valueToTree(this.getAnywhereSettings()));
            }
            if (this.getCdiInputSpecification() != null) {
                data.set("cdiInputSpecification", om.valueToTree(this.getCdiInputSpecification()));
            }
            if (this.getChannelClass() != null) {
                data.set("channelClass", om.valueToTree(this.getChannelClass()));
            }
            if (this.getChannelEngineVersion() != null) {
                data.set("channelEngineVersion", om.valueToTree(this.getChannelEngineVersion()));
            }
            if (this.getDestinations() != null) {
                data.set("destinations", om.valueToTree(this.getDestinations()));
            }
            if (this.getDryRun() != null) {
                data.set("dryRun", om.valueToTree(this.getDryRun()));
            }
            if (this.getEncoderSettings() != null) {
                data.set("encoderSettings", om.valueToTree(this.getEncoderSettings()));
            }
            if (this.getInputAttachments() != null) {
                data.set("inputAttachments", om.valueToTree(this.getInputAttachments()));
            }
            if (this.getInputSpecification() != null) {
                data.set("inputSpecification", om.valueToTree(this.getInputSpecification()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getMaintenance() != null) {
                data.set("maintenance", om.valueToTree(this.getMaintenance()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (this.anywhereSettings != null ? !this.anywhereSettings.equals(that.anywhereSettings) : that.anywhereSettings != null) return false;
            if (this.cdiInputSpecification != null ? !this.cdiInputSpecification.equals(that.cdiInputSpecification) : that.cdiInputSpecification != null) return false;
            if (this.channelClass != null ? !this.channelClass.equals(that.channelClass) : that.channelClass != null) return false;
            if (this.channelEngineVersion != null ? !this.channelEngineVersion.equals(that.channelEngineVersion) : that.channelEngineVersion != null) return false;
            if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
            if (this.dryRun != null ? !this.dryRun.equals(that.dryRun) : that.dryRun != null) return false;
            if (this.encoderSettings != null ? !this.encoderSettings.equals(that.encoderSettings) : that.encoderSettings != null) return false;
            if (this.inputAttachments != null ? !this.inputAttachments.equals(that.inputAttachments) : that.inputAttachments != null) return false;
            if (this.inputSpecification != null ? !this.inputSpecification.equals(that.inputSpecification) : that.inputSpecification != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.maintenance != null ? !this.maintenance.equals(that.maintenance) : that.maintenance != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.anywhereSettings != null ? this.anywhereSettings.hashCode() : 0;
            result = 31 * result + (this.cdiInputSpecification != null ? this.cdiInputSpecification.hashCode() : 0);
            result = 31 * result + (this.channelClass != null ? this.channelClass.hashCode() : 0);
            result = 31 * result + (this.channelEngineVersion != null ? this.channelEngineVersion.hashCode() : 0);
            result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
            result = 31 * result + (this.dryRun != null ? this.dryRun.hashCode() : 0);
            result = 31 * result + (this.encoderSettings != null ? this.encoderSettings.hashCode() : 0);
            result = 31 * result + (this.inputAttachments != null ? this.inputAttachments.hashCode() : 0);
            result = 31 * result + (this.inputSpecification != null ? this.inputSpecification.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.maintenance != null ? this.maintenance.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
