package software.amazon.awscdk.services.omics;

/**
 * Properties for defining a <code>CfnSequenceStore</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * Object s3AccessPolicy;
 * CfnSequenceStoreProps cfnSequenceStoreProps = CfnSequenceStoreProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .accessLogLocation("accessLogLocation")
 *         .description("description")
 *         .eTagAlgorithmFamily("eTagAlgorithmFamily")
 *         .fallbackLocation("fallbackLocation")
 *         .propagatedSetLevelTags(List.of("propagatedSetLevelTags"))
 *         .s3AccessPolicy(s3AccessPolicy)
 *         .sseConfig(SseConfigProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .keyArn("keyArn")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:22.083Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnSequenceStoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnSequenceStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSequenceStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Location of the access logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-accessloglocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-accessloglocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessLogLocation() {
        return null;
    }

    /**
     * A description for the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The algorithm family of the ETag.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-etagalgorithmfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-etagalgorithmfamily</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getETagAlgorithmFamily() {
        return null;
    }

    /**
     * An S3 location that is used to store files that have failed a direct upload.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-fallbacklocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-fallbacklocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFallbackLocation() {
        return null;
    }

    /**
     * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-propagatedsetleveltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-propagatedsetleveltags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPropagatedSetLevelTags() {
        return null;
    }

    /**
     * The resource policy that controls S3 access on the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-s3accesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-s3accesspolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3AccessPolicy() {
        return null;
    }

    /**
     * Server-side encryption (SSE) settings for the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-sseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-sseconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseConfig() {
        return null;
    }

    /**
     * Tags for the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSequenceStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSequenceStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSequenceStoreProps> {
        java.lang.String name;
        java.lang.String accessLogLocation;
        java.lang.String description;
        java.lang.String eTagAlgorithmFamily;
        java.lang.String fallbackLocation;
        java.util.List<java.lang.String> propagatedSetLevelTags;
        java.lang.Object s3AccessPolicy;
        java.lang.Object sseConfig;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getName}
         * @param name A name for the store. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getAccessLogLocation}
         * @param accessLogLocation Location of the access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogLocation(java.lang.String accessLogLocation) {
            this.accessLogLocation = accessLogLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getDescription}
         * @param description A description for the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getETagAlgorithmFamily}
         * @param eTagAlgorithmFamily The algorithm family of the ETag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eTagAlgorithmFamily(java.lang.String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getFallbackLocation}
         * @param fallbackLocation An S3 location that is used to store files that have failed a direct upload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fallbackLocation(java.lang.String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getPropagatedSetLevelTags}
         * @param propagatedSetLevelTags The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagatedSetLevelTags(java.util.List<java.lang.String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = propagatedSetLevelTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getS3AccessPolicy}
         * @param s3AccessPolicy The resource policy that controls S3 access on the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3AccessPolicy(java.lang.Object s3AccessPolicy) {
            this.s3AccessPolicy = s3AccessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getSseConfig}
         * @param sseConfig Server-side encryption (SSE) settings for the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfig(software.amazon.awscdk.IResolvable sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getSseConfig}
         * @param sseConfig Server-side encryption (SSE) settings for the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfig(software.amazon.awscdk.services.omics.CfnSequenceStore.SseConfigProperty sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSequenceStoreProps#getTags}
         * @param tags Tags for the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSequenceStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSequenceStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSequenceStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSequenceStoreProps {
        private final java.lang.String name;
        private final java.lang.String accessLogLocation;
        private final java.lang.String description;
        private final java.lang.String eTagAlgorithmFamily;
        private final java.lang.String fallbackLocation;
        private final java.util.List<java.lang.String> propagatedSetLevelTags;
        private final java.lang.Object s3AccessPolicy;
        private final java.lang.Object sseConfig;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessLogLocation = software.amazon.jsii.Kernel.get(this, "accessLogLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eTagAlgorithmFamily = software.amazon.jsii.Kernel.get(this, "eTagAlgorithmFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fallbackLocation = software.amazon.jsii.Kernel.get(this, "fallbackLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.propagatedSetLevelTags = software.amazon.jsii.Kernel.get(this, "propagatedSetLevelTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.s3AccessPolicy = software.amazon.jsii.Kernel.get(this, "s3AccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseConfig = software.amazon.jsii.Kernel.get(this, "sseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.accessLogLocation = builder.accessLogLocation;
            this.description = builder.description;
            this.eTagAlgorithmFamily = builder.eTagAlgorithmFamily;
            this.fallbackLocation = builder.fallbackLocation;
            this.propagatedSetLevelTags = builder.propagatedSetLevelTags;
            this.s3AccessPolicy = builder.s3AccessPolicy;
            this.sseConfig = builder.sseConfig;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAccessLogLocation() {
            return this.accessLogLocation;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getETagAlgorithmFamily() {
            return this.eTagAlgorithmFamily;
        }

        @Override
        public final java.lang.String getFallbackLocation() {
            return this.fallbackLocation;
        }

        @Override
        public final java.util.List<java.lang.String> getPropagatedSetLevelTags() {
            return this.propagatedSetLevelTags;
        }

        @Override
        public final java.lang.Object getS3AccessPolicy() {
            return this.s3AccessPolicy;
        }

        @Override
        public final java.lang.Object getSseConfig() {
            return this.sseConfig;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAccessLogLocation() != null) {
                data.set("accessLogLocation", om.valueToTree(this.getAccessLogLocation()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getETagAlgorithmFamily() != null) {
                data.set("eTagAlgorithmFamily", om.valueToTree(this.getETagAlgorithmFamily()));
            }
            if (this.getFallbackLocation() != null) {
                data.set("fallbackLocation", om.valueToTree(this.getFallbackLocation()));
            }
            if (this.getPropagatedSetLevelTags() != null) {
                data.set("propagatedSetLevelTags", om.valueToTree(this.getPropagatedSetLevelTags()));
            }
            if (this.getS3AccessPolicy() != null) {
                data.set("s3AccessPolicy", om.valueToTree(this.getS3AccessPolicy()));
            }
            if (this.getSseConfig() != null) {
                data.set("sseConfig", om.valueToTree(this.getSseConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnSequenceStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSequenceStoreProps.Jsii$Proxy that = (CfnSequenceStoreProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.accessLogLocation != null ? !this.accessLogLocation.equals(that.accessLogLocation) : that.accessLogLocation != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eTagAlgorithmFamily != null ? !this.eTagAlgorithmFamily.equals(that.eTagAlgorithmFamily) : that.eTagAlgorithmFamily != null) return false;
            if (this.fallbackLocation != null ? !this.fallbackLocation.equals(that.fallbackLocation) : that.fallbackLocation != null) return false;
            if (this.propagatedSetLevelTags != null ? !this.propagatedSetLevelTags.equals(that.propagatedSetLevelTags) : that.propagatedSetLevelTags != null) return false;
            if (this.s3AccessPolicy != null ? !this.s3AccessPolicy.equals(that.s3AccessPolicy) : that.s3AccessPolicy != null) return false;
            if (this.sseConfig != null ? !this.sseConfig.equals(that.sseConfig) : that.sseConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.accessLogLocation != null ? this.accessLogLocation.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eTagAlgorithmFamily != null ? this.eTagAlgorithmFamily.hashCode() : 0);
            result = 31 * result + (this.fallbackLocation != null ? this.fallbackLocation.hashCode() : 0);
            result = 31 * result + (this.propagatedSetLevelTags != null ? this.propagatedSetLevelTags.hashCode() : 0);
            result = 31 * result + (this.s3AccessPolicy != null ? this.s3AccessPolicy.hashCode() : 0);
            result = 31 * result + (this.sseConfig != null ? this.sseConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
