package software.amazon.awscdk.services.opensearchserverless;

/**
 * An OpenSearch Serverless index resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchserverless.*;
 * PropertyMappingProperty propertyMappingProperty_;
 * CfnIndex cfnIndex = CfnIndex.Builder.create(this, "MyCfnIndex")
 *         .collectionEndpoint("collectionEndpoint")
 *         .indexName("indexName")
 *         // the properties below are optional
 *         .mappings(MappingsProperty.builder()
 *                 .properties(Map.of(
 *                         "propertiesKey", PropertyMappingProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .dimension(123)
 *                                 .index(false)
 *                                 .method(MethodProperty.builder()
 *                                         .engine("engine")
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .parameters(ParametersProperty.builder()
 *                                                 .efConstruction(123)
 *                                                 .m(123)
 *                                                 .build())
 *                                         .spaceType("spaceType")
 *                                         .build())
 *                                 .properties(Map.of(
 *                                         "propertiesKey", propertyMappingProperty_))
 *                                 .value("value")
 *                                 .build()))
 *                 .build())
 *         .settings(IndexSettingsProperty.builder()
 *                 .index(IndexProperty.builder()
 *                         .knn(false)
 *                         .knnAlgoParamEfSearch(123)
 *                         .refreshInterval("refreshInterval")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:22.106Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex")
public class CfnIndex extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIndex(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIndex(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchserverless.CfnIndex.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIndex(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchserverless.CfnIndexProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUuid() {
        return software.amazon.jsii.Kernel.get(this, "attrUuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The endpoint for the collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCollectionEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "collectionEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint for the collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionEndpoint(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "collectionEndpoint", java.util.Objects.requireNonNull(value, "collectionEndpoint is required"));
    }

    /**
     * The name of the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIndexName() {
        return software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIndexName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
    }

    /**
     * Index mappings for the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMappings() {
        return software.amazon.jsii.Kernel.get(this, "mappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Index mappings for the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mappings", value);
    }

    /**
     * Index mappings for the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchserverless.CfnIndex.MappingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mappings", value);
    }

    /**
     * Index settings for the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Index settings for the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }

    /**
     * Index settings for the OpenSearch Serverless index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchserverless.CfnIndex.IndexSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }
    /**
     * An OpenSearch Serverless index resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchserverless.*;
     * IndexProperty indexProperty = IndexProperty.builder()
     *         .knn(false)
     *         .knnAlgoParamEfSearch(123)
     *         .refreshInterval("refreshInterval")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex.IndexProperty")
    @software.amazon.jsii.Jsii.Proxy(IndexProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enable or disable k-nearest neighbor search capability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html#cfn-opensearchserverless-index-index-knn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html#cfn-opensearchserverless-index-index-knn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKnn() {
            return null;
        }

        /**
         * The size of the dynamic list for the nearest neighbors.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html#cfn-opensearchserverless-index-index-knnalgoparamefsearch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html#cfn-opensearchserverless-index-index-knnalgoparamefsearch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getKnnAlgoParamEfSearch() {
            return null;
        }

        /**
         * How often to perform a refresh operation.
         * <p>
         * For example, 1s or 5s.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html#cfn-opensearchserverless-index-index-refreshinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-index.html#cfn-opensearchserverless-index-index-refreshinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IndexProperty> {
            java.lang.Object knn;
            java.lang.Number knnAlgoParamEfSearch;
            java.lang.String refreshInterval;

            /**
             * Sets the value of {@link IndexProperty#getKnn}
             * @param knn Enable or disable k-nearest neighbor search capability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knn(java.lang.Boolean knn) {
                this.knn = knn;
                return this;
            }

            /**
             * Sets the value of {@link IndexProperty#getKnn}
             * @param knn Enable or disable k-nearest neighbor search capability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knn(software.amazon.awscdk.IResolvable knn) {
                this.knn = knn;
                return this;
            }

            /**
             * Sets the value of {@link IndexProperty#getKnnAlgoParamEfSearch}
             * @param knnAlgoParamEfSearch The size of the dynamic list for the nearest neighbors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knnAlgoParamEfSearch(java.lang.Number knnAlgoParamEfSearch) {
                this.knnAlgoParamEfSearch = knnAlgoParamEfSearch;
                return this;
            }

            /**
             * Sets the value of {@link IndexProperty#getRefreshInterval}
             * @param refreshInterval How often to perform a refresh operation.
             *                        For example, 1s or 5s.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshInterval(java.lang.String refreshInterval) {
                this.refreshInterval = refreshInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IndexProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IndexProperty {
            private final java.lang.Object knn;
            private final java.lang.Number knnAlgoParamEfSearch;
            private final java.lang.String refreshInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.knn = software.amazon.jsii.Kernel.get(this, "knn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.knnAlgoParamEfSearch = software.amazon.jsii.Kernel.get(this, "knnAlgoParamEfSearch", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.refreshInterval = software.amazon.jsii.Kernel.get(this, "refreshInterval", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.knn = builder.knn;
                this.knnAlgoParamEfSearch = builder.knnAlgoParamEfSearch;
                this.refreshInterval = builder.refreshInterval;
            }

            @Override
            public final java.lang.Object getKnn() {
                return this.knn;
            }

            @Override
            public final java.lang.Number getKnnAlgoParamEfSearch() {
                return this.knnAlgoParamEfSearch;
            }

            @Override
            public final java.lang.String getRefreshInterval() {
                return this.refreshInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKnn() != null) {
                    data.set("knn", om.valueToTree(this.getKnn()));
                }
                if (this.getKnnAlgoParamEfSearch() != null) {
                    data.set("knnAlgoParamEfSearch", om.valueToTree(this.getKnnAlgoParamEfSearch()));
                }
                if (this.getRefreshInterval() != null) {
                    data.set("refreshInterval", om.valueToTree(this.getRefreshInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndex.IndexProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IndexProperty.Jsii$Proxy that = (IndexProperty.Jsii$Proxy) o;

                if (this.knn != null ? !this.knn.equals(that.knn) : that.knn != null) return false;
                if (this.knnAlgoParamEfSearch != null ? !this.knnAlgoParamEfSearch.equals(that.knnAlgoParamEfSearch) : that.knnAlgoParamEfSearch != null) return false;
                return this.refreshInterval != null ? this.refreshInterval.equals(that.refreshInterval) : that.refreshInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.knn != null ? this.knn.hashCode() : 0;
                result = 31 * result + (this.knnAlgoParamEfSearch != null ? this.knnAlgoParamEfSearch.hashCode() : 0);
                result = 31 * result + (this.refreshInterval != null ? this.refreshInterval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Index settings for the OpenSearch Serverless index.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchserverless.*;
     * IndexSettingsProperty indexSettingsProperty = IndexSettingsProperty.builder()
     *         .index(IndexProperty.builder()
     *                 .knn(false)
     *                 .knnAlgoParamEfSearch(123)
     *                 .refreshInterval("refreshInterval")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-indexsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-indexsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex.IndexSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(IndexSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IndexSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Index settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-indexsettings.html#cfn-opensearchserverless-index-indexsettings-index">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-indexsettings.html#cfn-opensearchserverless-index-indexsettings-index</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIndex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IndexSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IndexSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IndexSettingsProperty> {
            java.lang.Object index;

            /**
             * Sets the value of {@link IndexSettingsProperty#getIndex}
             * @param index Index settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder index(software.amazon.awscdk.IResolvable index) {
                this.index = index;
                return this;
            }

            /**
             * Sets the value of {@link IndexSettingsProperty#getIndex}
             * @param index Index settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder index(software.amazon.awscdk.services.opensearchserverless.CfnIndex.IndexProperty index) {
                this.index = index;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IndexSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IndexSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IndexSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IndexSettingsProperty {
            private final java.lang.Object index;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.index = software.amazon.jsii.Kernel.get(this, "index", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.index = builder.index;
            }

            @Override
            public final java.lang.Object getIndex() {
                return this.index;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIndex() != null) {
                    data.set("index", om.valueToTree(this.getIndex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndex.IndexSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IndexSettingsProperty.Jsii$Proxy that = (IndexSettingsProperty.Jsii$Proxy) o;

                return this.index != null ? this.index.equals(that.index) : that.index == null;
            }

            @Override
            public final int hashCode() {
                int result = this.index != null ? this.index.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Index mappings for the OpenSearch Serverless index.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchserverless.*;
     * PropertyMappingProperty propertyMappingProperty_;
     * MappingsProperty mappingsProperty = MappingsProperty.builder()
     *         .properties(Map.of(
     *                 "propertiesKey", PropertyMappingProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .dimension(123)
     *                         .index(false)
     *                         .method(MethodProperty.builder()
     *                                 .engine("engine")
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .parameters(ParametersProperty.builder()
     *                                         .efConstruction(123)
     *                                         .m(123)
     *                                         .build())
     *                                 .spaceType("spaceType")
     *                                 .build())
     *                         .properties(Map.of(
     *                                 "propertiesKey", propertyMappingProperty_))
     *                         .value("value")
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-mappings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-mappings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex.MappingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Nested fields within an object or nested field type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-mappings.html#cfn-opensearchserverless-index-mappings-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-mappings.html#cfn-opensearchserverless-index-mappings-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingsProperty> {
            java.lang.Object properties;

            /**
             * Sets the value of {@link MappingsProperty#getProperties}
             * @param properties Nested fields within an object or nested field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link MappingsProperty#getProperties}
             * @param properties Nested fields within an object or nested field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingsProperty {
            private final java.lang.Object properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.properties = builder.properties;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndex.MappingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingsProperty.Jsii$Proxy that = (MappingsProperty.Jsii$Proxy) o;

                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.properties != null ? this.properties.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration for k-NN search method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchserverless.*;
     * MethodProperty methodProperty = MethodProperty.builder()
     *         .engine("engine")
     *         .name("name")
     *         // the properties below are optional
     *         .parameters(ParametersProperty.builder()
     *                 .efConstruction(123)
     *                 .m(123)
     *                 .build())
     *         .spaceType("spaceType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex.MethodProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MethodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The k-NN search engine to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-engine</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEngine();

        /**
         * The algorithm name for k-NN search.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Additional parameters for the k-NN algorithm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The distance function used for k-NN search.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-spacetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-method.html#cfn-opensearchserverless-index-method-spacetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpaceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MethodProperty> {
            java.lang.String engine;
            java.lang.String name;
            java.lang.Object parameters;
            java.lang.String spaceType;

            /**
             * Sets the value of {@link MethodProperty#getEngine}
             * @param engine The k-NN search engine to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engine(java.lang.String engine) {
                this.engine = engine;
                return this;
            }

            /**
             * Sets the value of {@link MethodProperty#getName}
             * @param name The algorithm name for k-NN search. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MethodProperty#getParameters}
             * @param parameters Additional parameters for the k-NN algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link MethodProperty#getParameters}
             * @param parameters Additional parameters for the k-NN algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.services.opensearchserverless.CfnIndex.ParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link MethodProperty#getSpaceType}
             * @param spaceType The distance function used for k-NN search.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceType(java.lang.String spaceType) {
                this.spaceType = spaceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MethodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodProperty {
            private final java.lang.String engine;
            private final java.lang.String name;
            private final java.lang.Object parameters;
            private final java.lang.String spaceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spaceType = software.amazon.jsii.Kernel.get(this, "spaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.parameters = builder.parameters;
                this.spaceType = builder.spaceType;
            }

            @Override
            public final java.lang.String getEngine() {
                return this.engine;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getSpaceType() {
                return this.spaceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("engine", om.valueToTree(this.getEngine()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getSpaceType() != null) {
                    data.set("spaceType", om.valueToTree(this.getSpaceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndex.MethodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodProperty.Jsii$Proxy that = (MethodProperty.Jsii$Proxy) o;

                if (!engine.equals(that.engine)) return false;
                if (!name.equals(that.name)) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.spaceType != null ? this.spaceType.equals(that.spaceType) : that.spaceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.engine.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.spaceType != null ? this.spaceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Additional parameters for the k-NN algorithm.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchserverless.*;
     * ParametersProperty parametersProperty = ParametersProperty.builder()
     *         .efConstruction(123)
     *         .m(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-parameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-parameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex.ParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size of the dynamic list used during k-NN graph creation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-parameters.html#cfn-opensearchserverless-index-parameters-efconstruction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-parameters.html#cfn-opensearchserverless-index-parameters-efconstruction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEfConstruction() {
            return null;
        }

        /**
         * Number of neighbors to consider during k-NN search.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-parameters.html#cfn-opensearchserverless-index-parameters-m">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-parameters.html#cfn-opensearchserverless-index-parameters-m</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getM() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersProperty> {
            java.lang.Number efConstruction;
            java.lang.Number m;

            /**
             * Sets the value of {@link ParametersProperty#getEfConstruction}
             * @param efConstruction The size of the dynamic list used during k-NN graph creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efConstruction(java.lang.Number efConstruction) {
                this.efConstruction = efConstruction;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getM}
             * @param m Number of neighbors to consider during k-NN search.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m(java.lang.Number m) {
                this.m = m;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersProperty {
            private final java.lang.Number efConstruction;
            private final java.lang.Number m;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efConstruction = software.amazon.jsii.Kernel.get(this, "efConstruction", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.m = software.amazon.jsii.Kernel.get(this, "m", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efConstruction = builder.efConstruction;
                this.m = builder.m;
            }

            @Override
            public final java.lang.Number getEfConstruction() {
                return this.efConstruction;
            }

            @Override
            public final java.lang.Number getM() {
                return this.m;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfConstruction() != null) {
                    data.set("efConstruction", om.valueToTree(this.getEfConstruction()));
                }
                if (this.getM() != null) {
                    data.set("m", om.valueToTree(this.getM()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndex.ParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersProperty.Jsii$Proxy that = (ParametersProperty.Jsii$Proxy) o;

                if (this.efConstruction != null ? !this.efConstruction.equals(that.efConstruction) : that.efConstruction != null) return false;
                return this.m != null ? this.m.equals(that.m) : that.m == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efConstruction != null ? this.efConstruction.hashCode() : 0;
                result = 31 * result + (this.m != null ? this.m.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Property mappings for the OpenSearch Serverless index.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchserverless.*;
     * PropertyMappingProperty propertyMappingProperty_;
     * PropertyMappingProperty propertyMappingProperty = PropertyMappingProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .dimension(123)
     *         .index(false)
     *         .method(MethodProperty.builder()
     *                 .engine("engine")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .parameters(ParametersProperty.builder()
     *                         .efConstruction(123)
     *                         .m(123)
     *                         .build())
     *                 .spaceType("spaceType")
     *                 .build())
     *         .properties(Map.of(
     *                 "propertiesKey", propertyMappingProperty_))
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndex.PropertyMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field data type.
         * <p>
         * Must be a valid OpenSearch field type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Dimension size for vector fields, defines the number of dimensions in the vector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-dimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-dimension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDimension() {
            return null;
        }

        /**
         * Whether a field should be indexed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-index">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-index</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIndex() {
            return null;
        }

        /**
         * Configuration for k-NN search method.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethod() {
            return null;
        }

        /**
         * Defines the fields within the mapping, including their types and configurations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * Default value for the field when not specified in a document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchserverless-index-propertymapping.html#cfn-opensearchserverless-index-propertymapping-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyMappingProperty> {
            java.lang.String type;
            java.lang.Number dimension;
            java.lang.Object index;
            java.lang.Object method;
            java.lang.Object properties;
            java.lang.String value;

            /**
             * Sets the value of {@link PropertyMappingProperty#getType}
             * @param type The field data type. This parameter is required.
             *             Must be a valid OpenSearch field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getDimension}
             * @param dimension Dimension size for vector fields, defines the number of dimensions in the vector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimension(java.lang.Number dimension) {
                this.dimension = dimension;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getIndex}
             * @param index Whether a field should be indexed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder index(java.lang.Boolean index) {
                this.index = index;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getIndex}
             * @param index Whether a field should be indexed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder index(software.amazon.awscdk.IResolvable index) {
                this.index = index;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getMethod}
             * @param method Configuration for k-NN search method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(software.amazon.awscdk.IResolvable method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getMethod}
             * @param method Configuration for k-NN search method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(software.amazon.awscdk.services.opensearchserverless.CfnIndex.MethodProperty method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getProperties}
             * @param properties Defines the fields within the mapping, including their types and configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getProperties}
             * @param properties Defines the fields within the mapping, including their types and configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link PropertyMappingProperty#getValue}
             * @param value Default value for the field when not specified in a document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyMappingProperty {
            private final java.lang.String type;
            private final java.lang.Number dimension;
            private final java.lang.Object index;
            private final java.lang.Object method;
            private final java.lang.Object properties;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimension = software.amazon.jsii.Kernel.get(this, "dimension", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.index = software.amazon.jsii.Kernel.get(this, "index", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.dimension = builder.dimension;
                this.index = builder.index;
                this.method = builder.method;
                this.properties = builder.properties;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getDimension() {
                return this.dimension;
            }

            @Override
            public final java.lang.Object getIndex() {
                return this.index;
            }

            @Override
            public final java.lang.Object getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getDimension() != null) {
                    data.set("dimension", om.valueToTree(this.getDimension()));
                }
                if (this.getIndex() != null) {
                    data.set("index", om.valueToTree(this.getIndex()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndex.PropertyMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyMappingProperty.Jsii$Proxy that = (PropertyMappingProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) return false;
                if (this.index != null ? !this.index.equals(that.index) : that.index != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.dimension != null ? this.dimension.hashCode() : 0);
                result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opensearchserverless.CfnIndex}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opensearchserverless.CfnIndex> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.opensearchserverless.CfnIndexProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.opensearchserverless.CfnIndexProps.Builder();
        }

        /**
         * The endpoint for the collection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-collectionendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-collectionendpoint</a>
         * @param collectionEndpoint The endpoint for the collection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionEndpoint(final java.lang.String collectionEndpoint) {
            this.props.collectionEndpoint(collectionEndpoint);
            return this;
        }

        /**
         * The name of the OpenSearch Serverless index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-indexname</a>
         * @param indexName The name of the OpenSearch Serverless index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(final java.lang.String indexName) {
            this.props.indexName(indexName);
            return this;
        }

        /**
         * Index mappings for the OpenSearch Serverless index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-mappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-mappings</a>
         * @param mappings Index mappings for the OpenSearch Serverless index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappings(final software.amazon.awscdk.IResolvable mappings) {
            this.props.mappings(mappings);
            return this;
        }
        /**
         * Index mappings for the OpenSearch Serverless index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-mappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-mappings</a>
         * @param mappings Index mappings for the OpenSearch Serverless index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappings(final software.amazon.awscdk.services.opensearchserverless.CfnIndex.MappingsProperty mappings) {
            this.props.mappings(mappings);
            return this;
        }

        /**
         * Index settings for the OpenSearch Serverless index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-settings</a>
         * @param settings Index settings for the OpenSearch Serverless index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.IResolvable settings) {
            this.props.settings(settings);
            return this;
        }
        /**
         * Index settings for the OpenSearch Serverless index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-settings</a>
         * @param settings Index settings for the OpenSearch Serverless index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.services.opensearchserverless.CfnIndex.IndexSettingsProperty settings) {
            this.props.settings(settings);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.opensearchserverless.CfnIndex}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opensearchserverless.CfnIndex build() {
            return new software.amazon.awscdk.services.opensearchserverless.CfnIndex(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
