package software.amazon.awscdk.services.osis;

/**
 * Properties for defining a <code>CfnPipeline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.osis.*;
 * CfnPipelineProps cfnPipelineProps = CfnPipelineProps.builder()
 *         .maxUnits(123)
 *         .minUnits(123)
 *         .pipelineConfigurationBody("pipelineConfigurationBody")
 *         .pipelineName("pipelineName")
 *         // the properties below are optional
 *         .bufferOptions(BufferOptionsProperty.builder()
 *                 .persistentBufferEnabled(false)
 *                 .build())
 *         .encryptionAtRestOptions(EncryptionAtRestOptionsProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .logPublishingOptions(LogPublishingOptionsProperty.builder()
 *                 .cloudWatchLogDestination(CloudWatchLogDestinationProperty.builder()
 *                         .logGroup("logGroup")
 *                         .build())
 *                 .isLoggingEnabled(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcOptions(VpcOptionsProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .vpcAttachmentOptions(VpcAttachmentOptionsProperty.builder()
 *                         .attachToVpc(false)
 *                         .cidrBlock("cidrBlock")
 *                         .build())
 *                 .vpcEndpointManagement("vpcEndpointManagement")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:22.270Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-maxunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-maxunits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxUnits();

    /**
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-minunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-minunits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinUnits();

    /**
     * The Data Prepper pipeline configuration in YAML format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelineconfigurationbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelineconfigurationbody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipelineConfigurationBody();

    /**
     * The name of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelinename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelinename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipelineName();

    /**
     * Options that specify the configuration of a persistent buffer.
     * <p>
     * To configure how OpenSearch Ingestion encrypts this data, set the <code>EncryptionAtRestOptions</code> . For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering">Persistent buffering</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-bufferoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-bufferoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBufferOptions() {
        return null;
    }

    /**
     * Options to control how OpenSearch encrypts buffer data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-encryptionatrestoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return null;
    }

    /**
     * Key-value pairs that represent log publishing settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return null;
    }

    /**
     * List of tags to add to the pipeline upon creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipelineProps> {
        java.lang.Number maxUnits;
        java.lang.Number minUnits;
        java.lang.String pipelineConfigurationBody;
        java.lang.String pipelineName;
        java.lang.Object bufferOptions;
        java.lang.Object encryptionAtRestOptions;
        java.lang.Object logPublishingOptions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vpcOptions;

        /**
         * Sets the value of {@link CfnPipelineProps#getMaxUnits}
         * @param maxUnits The maximum pipeline capacity, in Ingestion Compute Units (ICUs). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnits(java.lang.Number maxUnits) {
            this.maxUnits = maxUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getMinUnits}
         * @param minUnits The minimum pipeline capacity, in Ingestion Compute Units (ICUs). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minUnits(java.lang.Number minUnits) {
            this.minUnits = minUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineConfigurationBody}
         * @param pipelineConfigurationBody The Data Prepper pipeline configuration in YAML format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineConfigurationBody(java.lang.String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineName}
         * @param pipelineName The name of the pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getBufferOptions}
         * @param bufferOptions Options that specify the configuration of a persistent buffer.
         *                      To configure how OpenSearch Ingestion encrypts this data, set the <code>EncryptionAtRestOptions</code> . For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering">Persistent buffering</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferOptions(software.amazon.awscdk.IResolvable bufferOptions) {
            this.bufferOptions = bufferOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getBufferOptions}
         * @param bufferOptions Options that specify the configuration of a persistent buffer.
         *                      To configure how OpenSearch Ingestion encrypts this data, set the <code>EncryptionAtRestOptions</code> . For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering">Persistent buffering</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferOptions(software.amazon.awscdk.services.osis.CfnPipeline.BufferOptionsProperty bufferOptions) {
            this.bufferOptions = bufferOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getEncryptionAtRestOptions}
         * @param encryptionAtRestOptions Options to control how OpenSearch encrypts buffer data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(software.amazon.awscdk.IResolvable encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getEncryptionAtRestOptions}
         * @param encryptionAtRestOptions Options to control how OpenSearch encrypts buffer data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(software.amazon.awscdk.services.osis.CfnPipeline.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getLogPublishingOptions}
         * @param logPublishingOptions Key-value pairs that represent log publishing settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(software.amazon.awscdk.IResolvable logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getLogPublishingOptions}
         * @param logPublishingOptions Key-value pairs that represent log publishing settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(software.amazon.awscdk.services.osis.CfnPipeline.LogPublishingOptionsProperty logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTags}
         * @param tags List of tags to add to the pipeline upon creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getVpcOptions}
         * @param vpcOptions Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(software.amazon.awscdk.IResolvable vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getVpcOptions}
         * @param vpcOptions Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(software.amazon.awscdk.services.osis.CfnPipeline.VpcOptionsProperty vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipelineProps {
        private final java.lang.Number maxUnits;
        private final java.lang.Number minUnits;
        private final java.lang.String pipelineConfigurationBody;
        private final java.lang.String pipelineName;
        private final java.lang.Object bufferOptions;
        private final java.lang.Object encryptionAtRestOptions;
        private final java.lang.Object logPublishingOptions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vpcOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxUnits = software.amazon.jsii.Kernel.get(this, "maxUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minUnits = software.amazon.jsii.Kernel.get(this, "minUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pipelineConfigurationBody = software.amazon.jsii.Kernel.get(this, "pipelineConfigurationBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bufferOptions = software.amazon.jsii.Kernel.get(this, "bufferOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionAtRestOptions = software.amazon.jsii.Kernel.get(this, "encryptionAtRestOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logPublishingOptions = software.amazon.jsii.Kernel.get(this, "logPublishingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcOptions = software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxUnits = java.util.Objects.requireNonNull(builder.maxUnits, "maxUnits is required");
            this.minUnits = java.util.Objects.requireNonNull(builder.minUnits, "minUnits is required");
            this.pipelineConfigurationBody = java.util.Objects.requireNonNull(builder.pipelineConfigurationBody, "pipelineConfigurationBody is required");
            this.pipelineName = java.util.Objects.requireNonNull(builder.pipelineName, "pipelineName is required");
            this.bufferOptions = builder.bufferOptions;
            this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
            this.logPublishingOptions = builder.logPublishingOptions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcOptions = builder.vpcOptions;
        }

        @Override
        public final java.lang.Number getMaxUnits() {
            return this.maxUnits;
        }

        @Override
        public final java.lang.Number getMinUnits() {
            return this.minUnits;
        }

        @Override
        public final java.lang.String getPipelineConfigurationBody() {
            return this.pipelineConfigurationBody;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.lang.Object getBufferOptions() {
            return this.bufferOptions;
        }

        @Override
        public final java.lang.Object getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions;
        }

        @Override
        public final java.lang.Object getLogPublishingOptions() {
            return this.logPublishingOptions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpcOptions() {
            return this.vpcOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxUnits", om.valueToTree(this.getMaxUnits()));
            data.set("minUnits", om.valueToTree(this.getMinUnits()));
            data.set("pipelineConfigurationBody", om.valueToTree(this.getPipelineConfigurationBody()));
            data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            if (this.getBufferOptions() != null) {
                data.set("bufferOptions", om.valueToTree(this.getBufferOptions()));
            }
            if (this.getEncryptionAtRestOptions() != null) {
                data.set("encryptionAtRestOptions", om.valueToTree(this.getEncryptionAtRestOptions()));
            }
            if (this.getLogPublishingOptions() != null) {
                data.set("logPublishingOptions", om.valueToTree(this.getLogPublishingOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcOptions() != null) {
                data.set("vpcOptions", om.valueToTree(this.getVpcOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipelineProps.Jsii$Proxy that = (CfnPipelineProps.Jsii$Proxy) o;

            if (!maxUnits.equals(that.maxUnits)) return false;
            if (!minUnits.equals(that.minUnits)) return false;
            if (!pipelineConfigurationBody.equals(that.pipelineConfigurationBody)) return false;
            if (!pipelineName.equals(that.pipelineName)) return false;
            if (this.bufferOptions != null ? !this.bufferOptions.equals(that.bufferOptions) : that.bufferOptions != null) return false;
            if (this.encryptionAtRestOptions != null ? !this.encryptionAtRestOptions.equals(that.encryptionAtRestOptions) : that.encryptionAtRestOptions != null) return false;
            if (this.logPublishingOptions != null ? !this.logPublishingOptions.equals(that.logPublishingOptions) : that.logPublishingOptions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcOptions != null ? this.vpcOptions.equals(that.vpcOptions) : that.vpcOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxUnits.hashCode();
            result = 31 * result + (this.minUnits.hashCode());
            result = 31 * result + (this.pipelineConfigurationBody.hashCode());
            result = 31 * result + (this.pipelineName.hashCode());
            result = 31 * result + (this.bufferOptions != null ? this.bufferOptions.hashCode() : 0);
            result = 31 * result + (this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.hashCode() : 0);
            result = 31 * result + (this.logPublishingOptions != null ? this.logPublishingOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcOptions != null ? this.vpcOptions.hashCode() : 0);
            return result;
        }
    }
}
