package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a <code>CfnApplicationSettings</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * CfnApplicationSettingsProps cfnApplicationSettingsProps = CfnApplicationSettingsProps.builder()
 *         .applicationId("applicationId")
 *         // the properties below are optional
 *         .campaignHook(CampaignHookProperty.builder()
 *                 .lambdaFunctionName("lambdaFunctionName")
 *                 .mode("mode")
 *                 .webUrl("webUrl")
 *                 .build())
 *         .cloudWatchMetricsEnabled(false)
 *         .limits(LimitsProperty.builder()
 *                 .daily(123)
 *                 .maximumDuration(123)
 *                 .messagesPerSecond(123)
 *                 .total(123)
 *                 .build())
 *         .quietTime(QuietTimeProperty.builder()
 *                 .end("end")
 *                 .start("start")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:22.377Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnApplicationSettingsProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationSettingsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationSettingsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier for the Amazon Pinpoint application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The settings for the Lambda function to use by default as a code hook for campaigns in the application.
     * <p>
     * To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCampaignHook() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchMetricsEnabled() {
        return null;
    }

    /**
     * The default sending limits for campaigns in the application.
     * <p>
     * To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLimits() {
        return null;
    }

    /**
     * The default quiet time for campaigns in the application.
     * <p>
     * Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
     * <p>
     * <ul>
     * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
     * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
     * <p>
     * To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQuietTime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationSettingsProps> {
        java.lang.String applicationId;
        java.lang.Object campaignHook;
        java.lang.Object cloudWatchMetricsEnabled;
        java.lang.Object limits;
        java.lang.Object quietTime;

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getApplicationId}
         * @param applicationId The unique identifier for the Amazon Pinpoint application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getCampaignHook}
         * @param campaignHook The settings for the Lambda function to use by default as a code hook for campaigns in the application.
         *                     To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(software.amazon.awscdk.IResolvable campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getCampaignHook}
         * @param campaignHook The settings for the Lambda function to use by default as a code hook for campaigns in the application.
         *                     To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.CampaignHookProperty campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getCloudWatchMetricsEnabled}
         * @param cloudWatchMetricsEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchMetricsEnabled(java.lang.Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getCloudWatchMetricsEnabled}
         * @param cloudWatchMetricsEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getLimits}
         * @param limits The default sending limits for campaigns in the application.
         *               To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(software.amazon.awscdk.IResolvable limits) {
            this.limits = limits;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getLimits}
         * @param limits The default sending limits for campaigns in the application.
         *               To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.LimitsProperty limits) {
            this.limits = limits;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getQuietTime}
         * @param quietTime The default quiet time for campaigns in the application.
         *                  Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
         *                  <p>
         *                  <ul>
         *                  <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
         *                  <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
         *                  <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
         *                  </ul>
         *                  <p>
         *                  If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
         *                  <p>
         *                  To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quietTime(software.amazon.awscdk.IResolvable quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationSettingsProps#getQuietTime}
         * @param quietTime The default quiet time for campaigns in the application.
         *                  Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
         *                  <p>
         *                  <ul>
         *                  <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
         *                  <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
         *                  <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
         *                  </ul>
         *                  <p>
         *                  If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
         *                  <p>
         *                  To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quietTime(software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.QuietTimeProperty quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationSettingsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationSettingsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationSettingsProps {
        private final java.lang.String applicationId;
        private final java.lang.Object campaignHook;
        private final java.lang.Object cloudWatchMetricsEnabled;
        private final java.lang.Object limits;
        private final java.lang.Object quietTime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.campaignHook = software.amazon.jsii.Kernel.get(this, "campaignHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.limits = software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.quietTime = software.amazon.jsii.Kernel.get(this, "quietTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.campaignHook = builder.campaignHook;
            this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
            this.limits = builder.limits;
            this.quietTime = builder.quietTime;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.Object getCampaignHook() {
            return this.campaignHook;
        }

        @Override
        public final java.lang.Object getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        @Override
        public final java.lang.Object getLimits() {
            return this.limits;
        }

        @Override
        public final java.lang.Object getQuietTime() {
            return this.quietTime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            if (this.getCampaignHook() != null) {
                data.set("campaignHook", om.valueToTree(this.getCampaignHook()));
            }
            if (this.getCloudWatchMetricsEnabled() != null) {
                data.set("cloudWatchMetricsEnabled", om.valueToTree(this.getCloudWatchMetricsEnabled()));
            }
            if (this.getLimits() != null) {
                data.set("limits", om.valueToTree(this.getLimits()));
            }
            if (this.getQuietTime() != null) {
                data.set("quietTime", om.valueToTree(this.getQuietTime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnApplicationSettingsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationSettingsProps.Jsii$Proxy that = (CfnApplicationSettingsProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (this.campaignHook != null ? !this.campaignHook.equals(that.campaignHook) : that.campaignHook != null) return false;
            if (this.cloudWatchMetricsEnabled != null ? !this.cloudWatchMetricsEnabled.equals(that.cloudWatchMetricsEnabled) : that.cloudWatchMetricsEnabled != null) return false;
            if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) return false;
            return this.quietTime != null ? this.quietTime.equals(that.quietTime) : that.quietTime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.campaignHook != null ? this.campaignHook.hashCode() : 0);
            result = 31 * result + (this.cloudWatchMetricsEnabled != null ? this.cloudWatchMetricsEnabled.hashCode() : 0);
            result = 31 * result + (this.limits != null ? this.limits.hashCode() : 0);
            result = 31 * result + (this.quietTime != null ? this.quietTime.hashCode() : 0);
            return result;
        }
    }
}
