package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a <code>CfnRefreshSchedule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnRefreshScheduleProps cfnRefreshScheduleProps = CfnRefreshScheduleProps.builder()
 *         .awsAccountId("awsAccountId")
 *         .dataSetId("dataSetId")
 *         .schedule(RefreshScheduleMapProperty.builder()
 *                 .refreshType("refreshType")
 *                 .scheduleFrequency(ScheduleFrequencyProperty.builder()
 *                         .interval("interval")
 *                         .refreshOnDay(RefreshOnDayProperty.builder()
 *                                 .dayOfMonth("dayOfMonth")
 *                                 .dayOfWeek("dayOfWeek")
 *                                 .build())
 *                         .timeOfTheDay("timeOfTheDay")
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .scheduleId("scheduleId")
 *                 .startAfterDateTime("startAfterDateTime")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:23.748Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnRefreshScheduleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRefreshScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRefreshScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID of the account that you are creating a schedule in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-awsaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return null;
    }

    /**
     * The ID of the dataset that you are creating a refresh schedule for.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-datasetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-datasetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataSetId() {
        return null;
    }

    /**
     * The refresh schedule of a dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRefreshScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRefreshScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRefreshScheduleProps> {
        java.lang.String awsAccountId;
        java.lang.String dataSetId;
        java.lang.Object schedule;

        /**
         * Sets the value of {@link CfnRefreshScheduleProps#getAwsAccountId}
         * @param awsAccountId The AWS account ID of the account that you are creating a schedule in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRefreshScheduleProps#getDataSetId}
         * @param dataSetId The ID of the dataset that you are creating a refresh schedule for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetId(java.lang.String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRefreshScheduleProps#getSchedule}
         * @param schedule The refresh schedule of a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnRefreshScheduleProps#getSchedule}
         * @param schedule The refresh schedule of a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.quicksight.CfnRefreshSchedule.RefreshScheduleMapProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRefreshScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRefreshScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRefreshScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRefreshScheduleProps {
        private final java.lang.String awsAccountId;
        private final java.lang.String dataSetId;
        private final java.lang.Object schedule;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSetId = software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = builder.awsAccountId;
            this.dataSetId = builder.dataSetId;
            this.schedule = builder.schedule;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAwsAccountId() != null) {
                data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            }
            if (this.getDataSetId() != null) {
                data.set("dataSetId", om.valueToTree(this.getDataSetId()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnRefreshScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRefreshScheduleProps.Jsii$Proxy that = (CfnRefreshScheduleProps.Jsii$Proxy) o;

            if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
            if (this.dataSetId != null ? !this.dataSetId.equals(that.dataSetId) : that.dataSetId != null) return false;
            return this.schedule != null ? this.schedule.equals(that.schedule) : that.schedule == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId != null ? this.awsAccountId.hashCode() : 0;
            result = 31 * result + (this.dataSetId != null ? this.dataSetId.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return result;
        }
    }
}
