package software.amazon.awscdk.services.rds;

/**
 * A database instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance iopsInstance = DatabaseInstance.Builder.create(this, "IopsInstance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_39).build()))
 *         .vpc(vpc)
 *         .storageType(StorageType.IO1)
 *         .iops(5000)
 *         .build();
 * DatabaseInstance gp3Instance = DatabaseInstance.Builder.create(this, "Gp3Instance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_39).build()))
 *         .vpc(vpc)
 *         .allocatedStorage(500)
 *         .storageType(StorageType.GP3)
 *         .storageThroughput(500)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:24.528Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstance")
public class DatabaseInstance extends software.amazon.awscdk.services.rds.DatabaseInstanceBase implements software.amazon.awscdk.services.rds.IDatabaseInstance {

    protected DatabaseInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds the multi user rotation to this instance.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationMultiUser(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.RotationMultiUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationMultiUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds the single user rotation of the master password to this instance.
     * <p>
     * @param options the options for the rotation, if you want to override the defaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.RotationSingleUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { options });
    }

    /**
     * Adds the single user rotation of the master password to this instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser() {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class));
    }

    /**
     * Grant the given identity connection access to the database.
     * <p>
     * @param grantee the Principal to grant the permissions to. This parameter is required.
     * @param dbUser the name of the database user to allow connecting as to the db instance, or the default database user, obtained from the Secret, if not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.lang.String dbUser) {
        return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), dbUser });
    }

    /**
     * Grant the given identity connection access to the database.
     * <p>
     * @param grantee the Principal to grant the permissions to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setLogRetention() {
        software.amazon.jsii.Kernel.call(this, "setLogRetention", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * The log group is created when <code>cloudwatchLogsExports</code> is set.
     * <p>
     * Each export value will create a separate log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.logs.ILogGroup> getCloudwatchLogGroups() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cloudwatchLogGroups", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class))));
    }

    /**
     * Access to network connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The instance endpoint address.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance endpoint port.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getInstanceEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "instanceEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * The instance identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBInstanceProps getNewCfnProps() {
        return software.amazon.jsii.Kernel.get(this, "newCfnProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBInstanceProps.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBInstanceProps getSourceCfnProps() {
        return software.amazon.jsii.Kernel.get(this, "sourceCfnProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBInstanceProps.class));
    }

    /**
     * The VPC where this database instance is deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * The engine of this database Instance.
     * <p>
     * May be not known for imported Instances if it wasn't provided explicitly,
     * or for read replicas.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IInstanceEngine getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
    }

    /**
     * The AWS Region-unique, immutable identifier for the DB instance.
     * <p>
     * This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceResourceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Secrets Manager secret attached to the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcPlacement() {
        return software.amazon.jsii.Kernel.get(this, "vpcPlacement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableIamAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setEnableIamAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamAuthentication", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseInstanceProps.Builder();
        }

        /**
         * The VPC network where the DB subnet group should be created.
         * <p>
         * @return {@code this}
         * @param vpc The VPC network where the DB subnet group should be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>preferredMaintenanceWindow</code> setting.
         * <p>
         * If set to <code>false</code>, changes are applied during the next maintenance window.
         * <p>
         * Until RDS applies the changes, the DB instance remains in a drift state.
         * As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         * <p>
         * This property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         * <p>
         * Default: - Changes will be applied immediately
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html</a>
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>preferredMaintenanceWindow</code> setting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(final java.lang.Boolean applyImmediately) {
            this.props.applyImmediately(applyImmediately);
            return this;
        }

        /**
         * Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * The name of the Availability Zone where the DB instance will be located.
         * <p>
         * Default: - no preference
         * <p>
         * @return {@code this}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The number of days during which automatic DB snapshots are retained.
         * <p>
         * Set to zero to disable backups.
         * When creating a read replica, you must enable automatic backups on the source
         * database instance by setting the backup retention to a value other than zero.
         * <p>
         * Default: - Duration.days(1) for source instances, disabled for read replicas
         * <p>
         * @return {@code this}
         * @param backupRetention The number of days during which automatic DB snapshots are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(final software.amazon.awscdk.Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        /**
         * The identifier of the CA certificate for this DB instance.
         * <p>
         * Specifying or updating this property triggers a reboot.
         * <p>
         * For RDS DB engines:
         * <p>
         * Default: - RDS will choose a certificate authority
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html</a>
         * @param caCertificate The identifier of the CA certificate for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificate(final software.amazon.awscdk.services.rds.CaCertificate caCertificate) {
            this.props.caCertificate(caCertificate);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * Default: - no log exports
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsExports(final java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>Infinity</code>.
         * <p>
         * Default: - logs never expire
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetention(final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - a new role is created.
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetentionRole(final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        /**
         * Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * Indicates whether automated backups should be deleted or retained when you delete a DB instance.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param deleteAutomatedBackups Indicates whether automated backups should be deleted or retained when you delete a DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(final java.lang.Boolean deleteAutomatedBackups) {
            this.props.deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        /**
         * Indicates whether the DB instance should have deletion protection enabled.
         * <p>
         * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether the DB instance should have deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The Active Directory directory ID to create the DB instance in.
         * <p>
         * Default: - Do not join domain
         * <p>
         * @return {@code this}
         * @param domain The Active Directory directory ID to create the DB instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props.domain(domain);
            return this;
        }

        /**
         * The IAM role to be used when making API calls to the Directory Service.
         * <p>
         * The role needs the AWS-managed policy
         * AmazonRDSDirectoryServiceAccess or equivalent.
         * <p>
         * Default: - The role will be created for you if `DatabaseInstanceNewProps#domain` is specified
         * <p>
         * @return {@code this}
         * @param domainRole The IAM role to be used when making API calls to the Directory Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainRole(final software.amazon.awscdk.services.iam.IRole domainRole) {
            this.props.domainRole(domainRole);
            return this;
        }

        /**
         * Whether to enable Performance Insights for the DB instance.
         * <p>
         * Default: - false, unless ``performanceInsightRetention`` or ``performanceInsightEncryptionKey`` is set.
         * <p>
         * @return {@code this}
         * @param enablePerformanceInsights Whether to enable Performance Insights for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final java.lang.Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        /**
         * Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthentication(final java.lang.Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        /**
         * A name for the DB instance.
         * <p>
         * If you specify a name, AWS CloudFormation
         * converts it to lowercase.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param instanceIdentifier A name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifier(final java.lang.String instanceIdentifier) {
            this.props.instanceIdentifier(instanceIdentifier);
            return this;
        }

        /**
         * The number of I/O operations per second (IOPS) that the database provisions.
         * <p>
         * The value must be equal to or greater than 1000.
         * <p>
         * Default: - no provisioned iops if storage type is not specified. For GP3: 3,000 IOPS if allocated
         * storage is less than 400 GiB for MariaDB, MySQL, and PostgreSQL, less than 200 GiB for Oracle and
         * less than 20 GiB for SQL Server. 12,000 IOPS otherwise (except for SQL Server where the default is
         * always 3,000 IOPS).
         * <p>
         * @return {@code this}
         * @param iops The number of I/O operations per second (IOPS) that the database provisions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(final java.lang.Number iops) {
            this.props.iops(iops);
            return this;
        }

        /**
         * Upper limit to which RDS can scale the storage in GiB(Gibibyte).
         * <p>
         * Default: - No autoscaling of RDS instance
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling</a>
         * @param maxAllocatedStorage Upper limit to which RDS can scale the storage in GiB(Gibibyte). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAllocatedStorage(final java.lang.Number maxAllocatedStorage) {
            this.props.maxAllocatedStorage(maxAllocatedStorage);
            return this;
        }

        /**
         * The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instance.
         * <p>
         * Default: - no enhanced monitoring
         * <p>
         * @return {@code this}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(final software.amazon.awscdk.Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        /**
         * Role that will be used to manage DB instance monitoring.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param monitoringRole Role that will be used to manage DB instance monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRole(final software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        /**
         * Specifies if the database instance is a multiple Availability Zone deployment.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param multiAz Specifies if the database instance is a multiple Availability Zone deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(final java.lang.Boolean multiAz) {
            this.props.multiAz(multiAz);
            return this;
        }

        /**
         * The network type of the DB instance.
         * <p>
         * Default: - IPV4
         * <p>
         * @return {@code this}
         * @param networkType The network type of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(final software.amazon.awscdk.services.rds.NetworkType networkType) {
            this.props.networkType(networkType);
            return this;
        }

        /**
         * The option group to associate with the instance.
         * <p>
         * Default: - no option group
         * <p>
         * @return {@code this}
         * @param optionGroup The option group to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroup(final software.amazon.awscdk.services.rds.IOptionGroup optionGroup) {
            this.props.optionGroup(optionGroup);
            return this;
        }

        /**
         * The DB parameter group to associate with the instance.
         * <p>
         * Default: - no parameter group
         * <p>
         * @return {@code this}
         * @param parameterGroup The DB parameter group to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * The AWS KMS key for encryption of Performance Insights data.
         * <p>
         * Default: - default master key
         * <p>
         * @return {@code this}
         * @param performanceInsightEncryptionKey The AWS KMS key for encryption of Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightEncryptionKey(final software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey) {
            this.props.performanceInsightEncryptionKey(performanceInsightEncryptionKey);
            return this;
        }

        /**
         * The amount of time, in days, to retain Performance Insights data.
         * <p>
         * Default: 7 this is the free tier
         * <p>
         * @return {@code this}
         * @param performanceInsightRetention The amount of time, in days, to retain Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightRetention(final software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention) {
            this.props.performanceInsightRetention(performanceInsightRetention);
            return this;
        }

        /**
         * The port for the instance.
         * <p>
         * Default: - the default port for the chosen engine.
         * <p>
         * @return {@code this}
         * @param port The port for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The daily time range during which automated backups are performed.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li>
         * <li>Must be in Universal Coordinated Time (UTC).</li>
         * <li>Must not conflict with the preferred maintenance window.</li>
         * <li>Must be at least 30 minutes.</li>
         * </ul>
         * <p>
         * Default: - a 30-minute window selected at random from an 8-hour block of
         * time for each AWS Region. To see the time blocks available, see
         * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow The daily time range during which automated backups are performed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range (in UTC) during which system maintenance can occur.
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * Constraint: Minimum 30-minute window
         * <p>
         * Default: - a 30-minute window selected at random from an 8-hour block of
         * time for each AWS Region, occurring on a random day of the week. To see
         * the time blocks available, see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can occur. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The number of CPU cores and the number of threads per core.
         * <p>
         * Default: - the default number of CPU cores and threads per core for the
         * chosen instance class.
         * See https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor
         * <p>
         * @return {@code this}
         * @param processorFeatures The number of CPU cores and the number of threads per core. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(final software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures) {
            this.props.processorFeatures(processorFeatures);
            return this;
        }

        /**
         * Indicates whether the DB instance is an internet-facing instance.
         * <p>
         * If not specified,
         * the instance's vpcSubnets will be used to determine if the instance is internet-facing
         * or not.
         * <p>
         * Default: - `true` if the instance's `vpcSubnets` is `subnetType: SubnetType.PUBLIC`, `false` otherwise
         * <p>
         * @return {@code this}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * <p>
         * Default: - RemovalPolicy.SNAPSHOT (remove the resource, but retain a snapshot of the data)
         * <p>
         * @return {@code this}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * S3 buckets that you want to load data into.
         * <p>
         * This property must not be used if <code>s3ExportRole</code> is used.
         * <p>
         * For Microsoft SQL Server:
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html</a>
         * @param s3ExportBuckets S3 buckets that you want to load data into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportBuckets(final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.props.s3ExportBuckets(s3ExportBuckets);
            return this;
        }

        /**
         * Role that will be associated with this DB instance to enable S3 export.
         * <p>
         * This property must not be used if <code>s3ExportBuckets</code> is used.
         * <p>
         * For Microsoft SQL Server:
         * <p>
         * Default: - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html</a>
         * @param s3ExportRole Role that will be associated with this DB instance to enable S3 export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportRole(final software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.props.s3ExportRole(s3ExportRole);
            return this;
        }

        /**
         * S3 buckets that you want to load data from.
         * <p>
         * This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
         * <p>
         * This property must not be used if <code>s3ImportRole</code> is used.
         * <p>
         * For Microsoft SQL Server:
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html</a>
         * @param s3ImportBuckets S3 buckets that you want to load data from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportBuckets(final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.props.s3ImportBuckets(s3ImportBuckets);
            return this;
        }

        /**
         * Role that will be associated with this DB instance to enable S3 import.
         * <p>
         * This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
         * <p>
         * This property must not be used if <code>s3ImportBuckets</code> is used.
         * <p>
         * For Microsoft SQL Server:
         * <p>
         * Default: - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html</a>
         * @param s3ImportRole Role that will be associated with this DB instance to enable S3 import. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportRole(final software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.props.s3ImportRole(s3ImportRole);
            return this;
        }

        /**
         * The security groups to assign to the DB instance.
         * <p>
         * Default: - a new security group is created
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The storage throughput, specified in mebibytes per second (MiBps).
         * <p>
         * Only applicable for GP3.
         * <p>
         * Default: - 125 MiBps if allocated storage is less than 400 GiB for MariaDB, MySQL, and PostgreSQL,
         * less than 200 GiB for Oracle and less than 20 GiB for SQL Server. 500 MiBps otherwise (except for
         * SQL Server where the default is always 125 MiBps).
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com//AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage">https://docs.aws.amazon.com//AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage</a>
         * @param storageThroughput The storage throughput, specified in mebibytes per second (MiBps). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageThroughput(final java.lang.Number storageThroughput) {
            this.props.storageThroughput(storageThroughput);
            return this;
        }

        /**
         * The storage type.
         * <p>
         * Storage types supported are gp2, io1, standard.
         * <p>
         * Default: GP2
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#Concepts.Storage.GeneralSSD">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#Concepts.Storage.GeneralSSD</a>
         * @param storageType The storage type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final software.amazon.awscdk.services.rds.StorageType storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * Existing subnet group for the instance.
         * <p>
         * Default: - a new subnet group will be created.
         * <p>
         * @return {@code this}
         * @param subnetGroup Existing subnet group for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        /**
         * The type of subnets to add to the created DB subnet group.
         * <p>
         * Default: - private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets The type of subnets to add to the created DB subnet group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The database engine.
         * <p>
         * @return {@code this}
         * @param engine The database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final software.amazon.awscdk.services.rds.IInstanceEngine engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The allocated storage size, specified in gibibytes (GiB).
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param allocatedStorage The allocated storage size, specified in gibibytes (GiB). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedStorage(final java.lang.Number allocatedStorage) {
            this.props.allocatedStorage(allocatedStorage);
            return this;
        }

        /**
         * Whether to allow major version upgrades.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param allowMajorVersionUpgrade Whether to allow major version upgrades. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(final java.lang.Boolean allowMajorVersionUpgrade) {
            this.props.allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        /**
         * The name of the database.
         * <p>
         * Default: - no name
         * <p>
         * @return {@code this}
         * @param databaseName The name of the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * The name of the compute and memory capacity for the instance.
         * <p>
         * Default: - m5.large (or, more specifically, db.m5.large)
         * <p>
         * @return {@code this}
         * @param instanceType The name of the compute and memory capacity for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * The license model.
         * <p>
         * Default: - RDS default license model
         * <p>
         * @return {@code this}
         * @param licenseModel The license model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(final software.amazon.awscdk.services.rds.LicenseModel licenseModel) {
            this.props.licenseModel(licenseModel);
            return this;
        }

        /**
         * The parameters in the DBParameterGroup to create automatically.
         * <p>
         * You can only specify parameterGroup or parameters but not both.
         * You need to use a versioned engine to auto-generate a DBParameterGroup.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param parameters The parameters in the DBParameterGroup to create automatically. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The time zone of the instance.
         * <p>
         * This is currently supported only by Microsoft Sql Server.
         * <p>
         * Default: - RDS default timezone
         * <p>
         * @return {@code this}
         * @param timezone The time zone of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(final java.lang.String timezone) {
            this.props.timezone(timezone);
            return this;
        }

        /**
         * For supported engines, specifies the character set to associate with the DB instance.
         * <p>
         * Default: - RDS default character set name
         * <p>
         * @return {@code this}
         * @param characterSetName For supported engines, specifies the character set to associate with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder characterSetName(final java.lang.String characterSetName) {
            this.props.characterSetName(characterSetName);
            return this;
        }

        /**
         * Credentials for the administrative user.
         * <p>
         * Default: - A username of 'admin' (or 'postgres' for PostgreSQL) and SecretsManager-generated password
         * <p>
         * @return {@code this}
         * @param credentials Credentials for the administrative user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.rds.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * Indicates whether the DB instance is encrypted.
         * <p>
         * Default: - true if storageEncryptionKey has been provided, false otherwise
         * <p>
         * @return {@code this}
         * @param storageEncrypted Indicates whether the DB instance is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * The KMS key that's used to encrypt the DB instance.
         * <p>
         * Default: - default master key if storageEncrypted is true, no key otherwise
         * <p>
         * @return {@code this}
         * @param storageEncryptionKey The KMS key that's used to encrypt the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncryptionKey(final software.amazon.awscdk.services.kms.IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseInstance build() {
            return new software.amazon.awscdk.services.rds.DatabaseInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
