package software.amazon.awscdk.services.rds;

/**
 * An option group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Set open cursors with parameter group
 * ParameterGroup parameterGroup = ParameterGroup.Builder.create(this, "ParameterGroup")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         .parameters(Map.of(
 *                 "open_cursors", "2500"))
 *         .build();
 * OptionGroup optionGroup = OptionGroup.Builder.create(this, "OptionGroup")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         .configurations(List.of(OptionConfiguration.builder()
 *                 .name("LOCATOR")
 *                 .build(), OptionConfiguration.builder()
 *                 .name("OEM")
 *                 .port(1158)
 *                 .vpc(vpc)
 *                 .build()))
 *         .build();
 * // Allow connections to OEM
 * optionGroup.optionConnections.OEM.connections.allowDefaultPortFromAnyIpv4();
 * // Database instance with production values
 * DatabaseInstance instance = DatabaseInstance.Builder.create(this, "Instance")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         .licenseModel(LicenseModel.BRING_YOUR_OWN_LICENSE)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.MEDIUM))
 *         .multiAz(true)
 *         .storageType(StorageType.IO1)
 *         .credentials(Credentials.fromUsername("syscdk"))
 *         .vpc(vpc)
 *         .databaseName("ORCL")
 *         .storageEncrypted(true)
 *         .backupRetention(Duration.days(7))
 *         .monitoringInterval(Duration.seconds(60))
 *         .enablePerformanceInsights(true)
 *         .cloudwatchLogsExports(List.of("trace", "audit", "alert", "listener"))
 *         .cloudwatchLogsRetention(RetentionDays.ONE_MONTH)
 *         .autoMinorVersionUpgrade(true) // required to be true if LOCATOR is used in the option group
 *         .optionGroup(optionGroup)
 *         .parameterGroup(parameterGroup)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * // Allow connections on default port from any IPV4
 * instance.connections.allowDefaultPortFromAnyIpv4();
 * // Rotate the master user password every 30 days
 * instance.addRotationSingleUser();
 * // Add alarm for high CPU
 * // Add alarm for high CPU
 * Alarm.Builder.create(this, "HighCPU")
 *         .metric(instance.metricCPUUtilization())
 *         .threshold(90)
 *         .evaluationPeriods(1)
 *         .build();
 * // Trigger Lambda function on instance availability events
 * Function fn = Function.Builder.create(this, "Function")
 *         .code(Code.fromInline("exports.handler = (event) =&gt; console.log(event);"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .build();
 * Rule availabilityRule = instance.onEvent("Availability", OnEventOptions.builder().target(new LambdaFunction(fn)).build());
 * availabilityRule.addEventPattern(EventPattern.builder()
 *         .detail(Map.of(
 *                 "EventCategories", List.of("availability")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:24.603Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.OptionGroup")
public class OptionGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.rds.IOptionGroup {

    protected OptionGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OptionGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OptionGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OptionGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing option group.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param optionGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IOptionGroup fromOptionGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String optionGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.OptionGroup.class, "fromOptionGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IOptionGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(optionGroupName, "optionGroupName is required") });
    }

    /**
     * Adds a configuration to this OptionGroup.
     * <p>
     * This method is a no-op for an imported OptionGroup.
     * <p>
     * @param configuration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OptionConfiguration configuration) {
        return software.amazon.jsii.Kernel.call(this, "addConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(configuration, "configuration is required") });
    }

    /**
     * The connections object for the options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.Connections> getOptionConnections() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "optionConnections", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class))));
    }

    /**
     * The name of the option group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOptionGroupName() {
        return software.amazon.jsii.Kernel.get(this, "optionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.OptionGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.OptionGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.OptionGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.OptionGroupProps.Builder();
        }

        /**
         * The configurations for this option group.
         * <p>
         * @return {@code this}
         * @param configurations The configurations for this option group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(final java.util.List<? extends software.amazon.awscdk.services.rds.OptionConfiguration> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        /**
         * The database engine that this option group is associated with.
         * <p>
         * @return {@code this}
         * @param engine The database engine that this option group is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final software.amazon.awscdk.services.rds.IInstanceEngine engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * A description of the option group.
         * <p>
         * Default: a CDK generated description
         * <p>
         * @return {@code this}
         * @param description A description of the option group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.OptionGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.OptionGroup build() {
            return new software.amazon.awscdk.services.rds.OptionGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
