package software.amazon.awscdk.services.rds;

/**
 * The retention period for Performance Insight data, in days.
 * <p>
 * Per https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
 * This must be either
 * <p>
 * <ul>
 * <li>7 days (the default, free tier)</li>
 * <li>month * 31, where month is a number of months from 1-23</li>
 * <li>731 (2 years)</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Key kmsKey;
 * DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.AURORA)
 *         .vpc(vpc)
 *         .enablePerformanceInsights(true)
 *         .performanceInsightRetention(PerformanceInsightRetention.LONG_TERM)
 *         .performanceInsightEncryptionKey(kmsKey)
 *         .writer(ClusterInstance.provisioned("Writer", ProvisionedClusterInstanceProps.builder()
 *                 .instanceType(InstanceType.of(InstanceClass.R7G, InstanceSize.LARGE))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:24.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.PerformanceInsightRetention")
public enum PerformanceInsightRetention {
    /**
     * Default retention period of 7 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_1,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_2,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_3,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_4,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_5,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_6,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_7,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_8,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_9,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_10,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_11,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_12,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_13,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_14,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_15,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_16,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_17,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_18,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_19,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_20,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_21,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_22,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTHS_23,
    /**
     * Long term retention period of 2 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LONG_TERM,
}
