package software.amazon.awscdk.services.route53;

/**
 * A DNS A record.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * HostedZone zone;
 * ApplicationLoadBalancer lb;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(
 *         new LoadBalancerTarget(lb, Map.of(
 *                 "evaluateTargetHealth", true))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:24.817Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.ARecord")
public class ARecord extends software.amazon.awscdk.services.route53.RecordSet {

    protected ARecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ARecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ARecord(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.ARecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates new A record of type alias with target set to an existing A Record DNS.
     * <p>
     * Use when the target A record is created outside of CDK
     * For records created as part of CDK use
     * <p>
     * @return AWS::Route53::RecordSet of type A with target alias set to existing A record
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id Logical Id of the resource. This parameter is required.
     * @param attrs the ARecordAttributes (Target Arecord DNS name and HostedZone). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.ARecord fromARecordAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.ARecordAttrs attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.ARecord.class, "fromARecordAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.ARecord.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.ARecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.ARecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.ARecordProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.ARecordProps.Builder();
        }

        /**
         * The hosted zone in which to define the new record.
         * <p>
         * @return {@code this}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(final software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.props.zone(zone);
            return this;
        }

        /**
         * A comment to add on the record.
         * <p>
         * Default: no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to add on the record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Whether to delete the same record set in the hosted zone if it already exists (dangerous!).
         * <p>
         * This allows to deploy a new record set while minimizing the downtime because the
         * new record set will be created immediately after the existing one is deleted. It
         * also avoids "manual" actions to delete existing record sets.
         * <p>
         * <blockquote>
         * <p>
         * <strong>N.B.:</strong> this feature is dangerous, use with caution! It can only be used safely when
         * <code>deleteExisting</code> is set to <code>true</code> as soon as the resource is added to the stack. Changing
         * an existing Record Set's <code>deleteExisting</code> property from <code>false -&gt; true</code> after deployment
         * will delete the record!
         * <p>
         * </blockquote>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deleteExisting Whether to delete the same record set in the hosted zone if it already exists (dangerous!). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteExisting(final java.lang.Boolean deleteExisting) {
            this.props.deleteExisting(deleteExisting);
            return this;
        }

        /**
         * The geographical origin for this record to return DNS records based on the user's location.
         * <p>
         * @return {@code this}
         * @param geoLocation The geographical origin for this record to return DNS records based on the user's location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(final software.amazon.awscdk.services.route53.GeoLocation geoLocation) {
            this.props.geoLocation(geoLocation);
            return this;
        }

        /**
         * The health check to associate with the record set.
         * <p>
         * Route53 will return this record set in response to DNS queries only if the health check is passing.
         * <p>
         * Default: - No health check configured
         * <p>
         * @return {@code this}
         * @param healthCheck The health check to associate with the record set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.route53.IHealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * Whether to return multiple values, such as IP addresses for your web servers, in response to DNS queries.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param multiValueAnswer Whether to return multiple values, such as IP addresses for your web servers, in response to DNS queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(final java.lang.Boolean multiValueAnswer) {
            this.props.multiValueAnswer(multiValueAnswer);
            return this;
        }

        /**
         * The subdomain name for this record. This should be relative to the zone root name.
         * <p>
         * For example, if you want to create a record for acme.example.com, specify
         * "acme".
         * <p>
         * You can also specify the fully qualified domain name which terminates with a
         * ".". For example, "acme.example.com.".
         * <p>
         * Default: zone root
         * <p>
         * @return {@code this}
         * @param recordName The subdomain name for this record. This should be relative to the zone root name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(final java.lang.String recordName) {
            this.props.recordName(recordName);
            return this;
        }

        /**
         * The Amazon EC2 Region where you created the resource that this resource record set refers to.
         * <p>
         * The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer,
         * and is referred to by an IP address or a DNS domain name, depending on the record type.
         * <p>
         * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets,
         * Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region.
         * Route 53 then returns the value that is associated with the selected resource record set.
         * <p>
         * Default: - Do not set latency based routing
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-region">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-region</a>
         * @param region The Amazon EC2 Region where you created the resource that this resource record set refers to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * A string used to distinguish between different records with the same combination of DNS name and type.
         * <p>
         * It can only be set when either weight or geoLocation is defined.
         * <p>
         * This parameter must be between 1 and 128 characters in length.
         * <p>
         * Default: - Auto generated string
         * <p>
         * @return {@code this}
         * @param setIdentifier A string used to distinguish between different records with the same combination of DNS name and type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setIdentifier(final java.lang.String setIdentifier) {
            this.props.setIdentifier(setIdentifier);
            return this;
        }

        /**
         * The resource record cache time to live (TTL).
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final software.amazon.awscdk.Duration ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
         * <p>
         * Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type.
         * Route 53 then responds to queries based on the ratio of a resource's weight to the total.
         * <p>
         * This value can be a number between 0 and 255.
         * <p>
         * Default: - Do not set weighted routing
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-weighted.html">https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-weighted.html</a>
         * @param weight Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.props.weight(weight);
            return this;
        }

        /**
         * The target.
         * <p>
         * @return {@code this}
         * @param target The target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.route53.RecordTarget target) {
            this.props.target(target);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53.ARecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.ARecord build() {
            return new software.amazon.awscdk.services.route53.ARecord(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
