package software.amazon.awscdk.services.s3;

/**
 * What kind of server-side encryption to apply to this bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.BucketEncryption;
 * App app = App.Builder.create()
 *         .defaultStackSynthesizer(AppStagingSynthesizer.defaultResources(DefaultResourcesOptions.builder()
 *                 .appId("my-app-id")
 *                 .stagingBucketEncryption(BucketEncryption.S3_MANAGED)
 *                 .fileAssetPublishingRole(BootstrapRole.fromRoleArn("arn:aws:iam::123456789012:role/S3Access"))
 *                 .imageAssetPublishingRole(BootstrapRole.fromRoleArn("arn:aws:iam::123456789012:role/ECRAccess"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:25.059Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.BucketEncryption")
public enum BucketEncryption {
    /**
     * (deprecated) Previous option.
     * <p>
     * Buckets can not be unencrypted now.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/serv-side-encryption.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/serv-side-encryption.html</a>
     * @deprecated S3 applies server-side encryption with SSE-S3 for every bucket
     * that default encryption is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    UNENCRYPTED,
    /**
     * Server-side KMS encryption with a master key managed by KMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS_MANAGED,
    /**
     * Server-side encryption with a master key managed by S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_MANAGED,
    /**
     * Server-side encryption with a KMS key managed by the user.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
    /**
     * Double server-side KMS encryption with a master key managed by KMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DSSE_MANAGED,
    /**
     * Double server-side encryption with a KMS key managed by the user.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DSSE,
}
