package software.amazon.awscdk.services.s3.deployment;

/**
 * <code>DeployTimeSubstitutedFile</code> is an extension of <code>BucketDeployment</code> that allows users to upload individual files and specify to make substitutions in the file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function myLambdaFunction;
 * Bucket destinationBucket;
 * //(Optional) if provided, the resulting processed file would be uploaded to the destinationBucket under the destinationKey name.
 * String destinationKey;
 * Role role;
 * DeployTimeSubstitutedFile.Builder.create(this, "MyFile")
 *         .source("my-file.yaml")
 *         .destinationKey(destinationKey)
 *         .destinationBucket(destinationBucket)
 *         .substitutions(Map.of(
 *                 "variableName", myLambdaFunction.getFunctionName()))
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:25.223Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.DeployTimeSubstitutedFile")
public class DeployTimeSubstitutedFile extends software.amazon.awscdk.services.s3.deployment.BucketDeployment {

    protected DeployTimeSubstitutedFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeployTimeSubstitutedFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DeployTimeSubstitutedFile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getObjectKey() {
        return software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFileProps.Builder();
        }

        /**
         * The S3 bucket to sync the contents of the zip file to.
         * <p>
         * @return {@code this}
         * @param destinationBucket The S3 bucket to sync the contents of the zip file to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationBucket(final software.amazon.awscdk.services.s3.IBucket destinationBucket) {
            this.props.destinationBucket(destinationBucket);
            return this;
        }

        /**
         * Path to the user's local file.
         * <p>
         * @return {@code this}
         * @param source Path to the user's local file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final java.lang.String source) {
            this.props.source(source);
            return this;
        }

        /**
         * User-defined substitutions to make in the file.
         * <p>
         * Placeholders in the user's local file must be specified with double curly
         * brackets and spaces. For example, if you use the key 'xxxx' in the file,
         * it must be written as: {{ xxxx }} to be recognized by the construct as a
         * substitution.
         * <p>
         * @return {@code this}
         * @param substitutions User-defined substitutions to make in the file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder substitutions(final java.util.Map<java.lang.String, java.lang.String> substitutions) {
            this.props.substitutions(substitutions);
            return this;
        }

        /**
         * The object key in the destination bucket where the processed file would be written to.
         * <p>
         * Default: - Fingerprint of the file content would be used as object key
         * <p>
         * @return {@code this}
         * @param destinationKey The object key in the destination bucket where the processed file would be written to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationKey(final java.lang.String destinationKey) {
            this.props.destinationKey(destinationKey);
            return this;
        }

        /**
         * Execution role associated with this function.
         * <p>
         * Default: - A role is automatically created
         * <p>
         * @return {@code this}
         * @param role Execution role associated with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFile build() {
            return new software.amazon.awscdk.services.s3.deployment.DeployTimeSubstitutedFile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
