package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnSpace</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnSpaceProps cfnSpaceProps = CfnSpaceProps.builder()
 *         .domainId("domainId")
 *         .spaceName("spaceName")
 *         // the properties below are optional
 *         .ownershipSettings(OwnershipSettingsProperty.builder()
 *                 .ownerUserProfileName("ownerUserProfileName")
 *                 .build())
 *         .spaceDisplayName("spaceDisplayName")
 *         .spaceSettings(SpaceSettingsProperty.builder()
 *                 .appType("appType")
 *                 .codeEditorAppSettings(SpaceCodeEditorAppSettingsProperty.builder()
 *                         .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
 *                                 .idleSettings(SpaceIdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .customFileSystems(List.of(CustomFileSystemProperty.builder()
 *                         .efsFileSystem(EFSFileSystemProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 .build())
 *                         .fSxLustreFileSystem(FSxLustreFileSystemProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 .build())
 *                         .build()))
 *                 .jupyterLabAppSettings(SpaceJupyterLabAppSettingsProperty.builder()
 *                         .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
 *                                 .idleSettings(SpaceIdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .spaceStorageSettings(SpaceStorageSettingsProperty.builder()
 *                         .ebsStorageSettings(EbsStorageSettingsProperty.builder()
 *                                 .ebsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .spaceSharingSettings(SpaceSharingSettingsProperty.builder()
 *                 .sharingType("sharingType")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:25.576Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnSpaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSpaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the associated domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-domainid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-domainid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainId();

    /**
     * The name of the space.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSpaceName();

    /**
     * The collection of ownership settings for a space.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-ownershipsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-ownershipsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOwnershipSettings() {
        return null;
    }

    /**
     * The name of the space that appears in the Studio UI.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacedisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacedisplayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpaceDisplayName() {
        return null;
    }

    /**
     * A collection of space settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceSettings() {
        return null;
    }

    /**
     * A collection of space sharing settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesharingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesharingsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceSharingSettings() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSpaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSpaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSpaceProps> {
        java.lang.String domainId;
        java.lang.String spaceName;
        java.lang.Object ownershipSettings;
        java.lang.String spaceDisplayName;
        java.lang.Object spaceSettings;
        java.lang.Object spaceSharingSettings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSpaceProps#getDomainId}
         * @param domainId The ID of the associated domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(java.lang.String domainId) {
            this.domainId = domainId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getSpaceName}
         * @param spaceName The name of the space. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceName(java.lang.String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getOwnershipSettings}
         * @param ownershipSettings The collection of ownership settings for a space.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipSettings(software.amazon.awscdk.IResolvable ownershipSettings) {
            this.ownershipSettings = ownershipSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getOwnershipSettings}
         * @param ownershipSettings The collection of ownership settings for a space.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.OwnershipSettingsProperty ownershipSettings) {
            this.ownershipSettings = ownershipSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getSpaceDisplayName}
         * @param spaceDisplayName The name of the space that appears in the Studio UI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceDisplayName(java.lang.String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getSpaceSettings}
         * @param spaceSettings A collection of space settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSettings(software.amazon.awscdk.IResolvable spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getSpaceSettings}
         * @param spaceSettings A collection of space settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSettingsProperty spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getSpaceSharingSettings}
         * @param spaceSharingSettings A collection of space sharing settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSharingSettings(software.amazon.awscdk.IResolvable spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getSpaceSharingSettings}
         * @param spaceSharingSettings A collection of space sharing settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSharingSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSharingSettingsProperty spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpaceProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSpaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSpaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSpaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSpaceProps {
        private final java.lang.String domainId;
        private final java.lang.String spaceName;
        private final java.lang.Object ownershipSettings;
        private final java.lang.String spaceDisplayName;
        private final java.lang.Object spaceSettings;
        private final java.lang.Object spaceSharingSettings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainId = software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spaceName = software.amazon.jsii.Kernel.get(this, "spaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ownershipSettings = software.amazon.jsii.Kernel.get(this, "ownershipSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.spaceDisplayName = software.amazon.jsii.Kernel.get(this, "spaceDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spaceSettings = software.amazon.jsii.Kernel.get(this, "spaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.spaceSharingSettings = software.amazon.jsii.Kernel.get(this, "spaceSharingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainId = java.util.Objects.requireNonNull(builder.domainId, "domainId is required");
            this.spaceName = java.util.Objects.requireNonNull(builder.spaceName, "spaceName is required");
            this.ownershipSettings = builder.ownershipSettings;
            this.spaceDisplayName = builder.spaceDisplayName;
            this.spaceSettings = builder.spaceSettings;
            this.spaceSharingSettings = builder.spaceSharingSettings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDomainId() {
            return this.domainId;
        }

        @Override
        public final java.lang.String getSpaceName() {
            return this.spaceName;
        }

        @Override
        public final java.lang.Object getOwnershipSettings() {
            return this.ownershipSettings;
        }

        @Override
        public final java.lang.String getSpaceDisplayName() {
            return this.spaceDisplayName;
        }

        @Override
        public final java.lang.Object getSpaceSettings() {
            return this.spaceSettings;
        }

        @Override
        public final java.lang.Object getSpaceSharingSettings() {
            return this.spaceSharingSettings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainId", om.valueToTree(this.getDomainId()));
            data.set("spaceName", om.valueToTree(this.getSpaceName()));
            if (this.getOwnershipSettings() != null) {
                data.set("ownershipSettings", om.valueToTree(this.getOwnershipSettings()));
            }
            if (this.getSpaceDisplayName() != null) {
                data.set("spaceDisplayName", om.valueToTree(this.getSpaceDisplayName()));
            }
            if (this.getSpaceSettings() != null) {
                data.set("spaceSettings", om.valueToTree(this.getSpaceSettings()));
            }
            if (this.getSpaceSharingSettings() != null) {
                data.set("spaceSharingSettings", om.valueToTree(this.getSpaceSharingSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSpaceProps.Jsii$Proxy that = (CfnSpaceProps.Jsii$Proxy) o;

            if (!domainId.equals(that.domainId)) return false;
            if (!spaceName.equals(that.spaceName)) return false;
            if (this.ownershipSettings != null ? !this.ownershipSettings.equals(that.ownershipSettings) : that.ownershipSettings != null) return false;
            if (this.spaceDisplayName != null ? !this.spaceDisplayName.equals(that.spaceDisplayName) : that.spaceDisplayName != null) return false;
            if (this.spaceSettings != null ? !this.spaceSettings.equals(that.spaceSettings) : that.spaceSettings != null) return false;
            if (this.spaceSharingSettings != null ? !this.spaceSharingSettings.equals(that.spaceSharingSettings) : that.spaceSharingSettings != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainId.hashCode();
            result = 31 * result + (this.spaceName.hashCode());
            result = 31 * result + (this.ownershipSettings != null ? this.ownershipSettings.hashCode() : 0);
            result = 31 * result + (this.spaceDisplayName != null ? this.spaceDisplayName.hashCode() : 0);
            result = 31 * result + (this.spaceSettings != null ? this.spaceSettings.hashCode() : 0);
            result = 31 * result + (this.spaceSharingSettings != null ? this.spaceSharingSettings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
